/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.util.jsonld;

import be.iminds.ilabt.util.jsonld.JsonLdObjectsMetaData;
import be.iminds.ilabt.util.jsonld.iface.JsonLdObjectWithId;
import be.iminds.ilabt.util.jsonld.impl.PrimaryIdObject;
import be.iminds.ilabt.util.jsonld.impl.PrimaryIdObjectBuilder;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.dropwizard.jackson.Jackson;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JsonLdObjectLinkDeserializer<I, T extends PrimaryIdObject<I>, B extends PrimaryIdObjectBuilder<I, T, B>, X>
extends JsonDeserializer<X> {
    private static final Logger LOG = LoggerFactory.getLogger(JsonLdObjectLinkDeserializer.class);
    private final Class<I> idClass;
    private final Class<T> objectClass;
    private final Class<B> builderClass;
    private final String pathClass;
    private final String typeClass;
    private final JsonLdObjectsMetaData jsonLdObjectsMetaData;

    public JsonLdObjectLinkDeserializer(JsonLdObjectsMetaData jsonLdObjectsMetaData, Class<I> idClass, Class<T> objectClass, Class<B> builderClass, String pathClass, String typeClass) {
        this.idClass = idClass;
        this.objectClass = objectClass;
        this.builderClass = builderClass;
        this.pathClass = pathClass;
        this.typeClass = typeClass;
        this.jsonLdObjectsMetaData = jsonLdObjectsMetaData;
    }

    private B getNewBuilder() throws IOException {
        try {
            return (B)((PrimaryIdObjectBuilder)this.builderClass.newInstance());
        }
        catch (Exception e) {
            throw new IOException("Exception building new " + this.typeClass + " during parsing", e);
        }
    }

    @Nonnull
    private I extractId(String text) {
        return JsonLdObjectLinkDeserializer.extractId(text, this.idClass);
    }

    @Nonnull
    private static <I> I extractId(@Nonnull String text, @Nonnull Class idClass) {
        if (idClass.equals(Integer.class)) {
            return (I)Integer.valueOf(Integer.parseInt(text));
        }
        if (idClass.equals(Long.class)) {
            return (I)Long.valueOf(Long.parseLong(text));
        }
        if (idClass.equals(String.class)) {
            return (I)text;
        }
        throw new RuntimeException("Unsupported ID type: " + idClass.getName());
    }

    private I extractId(JsonNode node) {
        if (this.idClass.equals(Integer.class)) {
            return (I)Integer.valueOf(node.asInt());
        }
        if (this.idClass.equals(Long.class)) {
            return (I)Long.valueOf(node.asLong());
        }
        if (this.idClass.equals(String.class)) {
            return (I)node.asText();
        }
        throw new RuntimeException("Unsupported ID type: " + this.idClass.getName());
    }

    public List<T> deserializeList(JsonNode node, JsonParser parentJsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        assert (node != null);
        if (!node.isArray()) {
            throw new IOException("Unexpected child. type=" + node.getNodeType());
        }
        ArrayList<T> res = new ArrayList<T>();
        for (int i = 0; i < node.size(); ++i) {
            JsonNode arrayElement = node.get(i);
            assert (arrayElement != null);
            T resourceClass = this.deserializeSingle(arrayElement, parentJsonParser, deserializationContext);
            assert (resourceClass != null);
            res.add(resourceClass);
        }
        return res;
    }

    @Nonnull
    public static <I> I uriToId(@Nonnull String uriStr, @Nonnull Class<I> idClass, @Nonnull String pathClass) throws URISyntaxException {
        Pattern uriPattern = Pattern.compile(".*/" + pathClass + "/([A-Za-z0-9_.-]*)");
        Matcher matcher = uriPattern.matcher(uriStr);
        if (matcher.matches()) {
            String idString = matcher.group(1);
            if (idString.trim().isEmpty()) {
                throw new URISyntaxException(uriStr, "No ID in uri \"" + uriStr + "\"");
            }
            I id = JsonLdObjectLinkDeserializer.extractId(idString, idClass);
            return id;
        }
        throw new URISyntaxException(uriStr, "Unrecognized URI format \"" + uriStr + "\"  (pathClass=" + pathClass + "  uriPattern=" + uriPattern.pattern() + ")");
    }

    public T deserializeSingle(JsonNode node, JsonParser parentJsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        assert (node != null);
        if (node.isTextual()) {
            String uriStr = node.asText();
            try {
                I id = JsonLdObjectLinkDeserializer.uriToId(uriStr, this.idClass, this.pathClass);
                JsonLdObjectWithId res = ((PrimaryIdObjectBuilder)((PrimaryIdObjectBuilder)((PrimaryIdObjectBuilder)this.getNewBuilder()).setId(id)).setUri(new URI(uriStr))).createMinimized(JsonLdObjectsMetaData.Minimization.MINIMAL_ID_ONLY);
                assert (!((PrimaryIdObject)res).getSerializeAsEmbeddedObject());
                return (T)res;
            }
            catch (URISyntaxException e) {
                throw new IOException("Unrecognized URI format \"" + uriStr + "\"", e);
            }
        }
        if (node.isObject()) {
            JsonNode typeField = node.get("@type");
            if (typeField == null || !typeField.isTextual()) {
                throw new IOException("Unrecognized child object with typeField=" + typeField + " in " + node);
            }
            if (!typeField.asText().equals(this.typeClass)) {
                throw new IOException("Unexpected child object type \"" + typeField.asText() + "\" (expected \"" + this.typeClass + "\")");
            }
            ObjectMapper mapperMatchingToplevel = Jackson.newObjectMapper();
            mapperMatchingToplevel.setConfig(deserializationContext.getConfig());
            PrimaryIdObject res = (PrimaryIdObject)mapperMatchingToplevel.convertValue((Object)node, this.objectClass);
            assert (res.getSerializeAsEmbeddedObject());
            return (T)res;
        }
        throw new IOException("Unexpected child. type=" + node.getNodeType() + " toString=" + node.toString());
    }

    public static abstract class AnyObjectDeserializer
    extends JsonDeserializer<Object> {
        private JsonLdObjectsMetaData jsonLdObjectsMetaData;

        public AnyObjectDeserializer(JsonLdObjectsMetaData jsonLdObjectsMetaData) {
            this.jsonLdObjectsMetaData = jsonLdObjectsMetaData;
        }

        public Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            assert (jsonParser != null);
            ObjectCodec objectCodec = jsonParser.getCodec();
            assert (objectCodec != null);
            JsonNode node = (JsonNode)objectCodec.readTree(jsonParser);
            if (node == null) {
                return null;
            }
            ObjectMapper mapperMatchingToplevel = Jackson.newObjectMapper();
            mapperMatchingToplevel.setConfig(deserializationContext.getConfig());
            if (node.isObject() && node.hasNonNull("@type") && node.get("@type").isTextual()) {
                String atType = node.get("@type").asText();
                Class clazz = this.jsonLdObjectsMetaData.getObjectClassFromAtType(atType);
                return mapperMatchingToplevel.convertValue((Object)node, clazz);
            }
            return mapperMatchingToplevel.convertValue((Object)node, Object.class);
        }
    }

    public static abstract class LinkDeserializer<I, T extends PrimaryIdObject<I>, B extends PrimaryIdObjectBuilder<I, T, B>>
    extends JsonLdObjectLinkDeserializer<I, T, B, T> {
        public LinkDeserializer(JsonLdObjectsMetaData jsonLdObjectsMetaData, Class<I> idClass, Class<T> objectClass, Class<B> builderClass, String pathClass, String typeClass) {
            super(jsonLdObjectsMetaData, idClass, objectClass, builderClass, pathClass, typeClass);
        }

        public T deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            assert (jsonParser != null);
            ObjectCodec objectCodec = jsonParser.getCodec();
            assert (objectCodec != null);
            JsonNode node = (JsonNode)objectCodec.readTree(jsonParser);
            if (node == null) {
                return null;
            }
            return this.deserializeSingle(node, jsonParser, deserializationContext);
        }
    }

    public static abstract class LinkListDeserializer<I, T extends PrimaryIdObject<I>, B extends PrimaryIdObjectBuilder<I, T, B>>
    extends JsonLdObjectLinkDeserializer<I, T, B, List<T>> {
        public LinkListDeserializer(JsonLdObjectsMetaData jsonLdObjectsMetaData, Class<I> idClass, Class<T> objectClass, Class<B> builderClass, String pathClass, String typeClass) {
            super(jsonLdObjectsMetaData, idClass, objectClass, builderClass, pathClass, typeClass);
        }

        public List<T> deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            if (node == null) {
                return null;
            }
            return this.deserializeList(node, jsonParser, deserializationContext);
        }
    }
}

