/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.dao;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Graph;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.GraphBuilder;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.Handle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphDao {
    private static final Logger LOG = LoggerFactory.getLogger(GraphDao.class);
    private final DBI jdbi;
    private final Handle handle;

    public GraphDao(DBI jdbi) {
        this.jdbi = jdbi;
        this.handle = jdbi.open();
    }

    public void close() {
        this.handle.close();
    }

    private Graph resultSetToGraph(ResultSet rs) throws SQLException {
        GraphBuilder graphBuilder = new GraphBuilder();
        graphBuilder.setId(rs.getString("id"));
        assert (!rs.wasNull());
        graphBuilder.setGraphDefinitionId(rs.getString("graph_definition_id"));
        if (rs.wasNull()) {
            graphBuilder.setGraphDefinitionId(null);
        }
        graphBuilder.setSubType(rs.getString("sub_type"));
        if (rs.wasNull()) {
            graphBuilder.setSubType(null);
        }
        graphBuilder.setPeriodString(rs.getString("period_pretty"));
        if (rs.wasNull()) {
            graphBuilder.setPeriodString(null);
        }
        graphBuilder.setDescription(rs.getString("description"));
        if (rs.wasNull()) {
            graphBuilder.setDescription(null);
        }
        graphBuilder.setPeriodInSeconds(Long.valueOf(rs.getLong("period_in_seconds")));
        if (rs.wasNull()) {
            graphBuilder.setPeriodInSeconds(null);
        }
        graphBuilder.setTestInstanceId(Integer.valueOf(rs.getInt("test_instance_id")));
        if (rs.wasNull()) {
            graphBuilder.setTestInstanceId(null);
        }
        graphBuilder.setTestDefinitionId(rs.getString("test_definition_id"));
        if (rs.wasNull()) {
            graphBuilder.setTestDefinitionId(null);
        }
        graphBuilder.setGraphStartTime(rs.getTimestamp("graph_start_time"));
        if (rs.wasNull()) {
            graphBuilder.setGraphStartTime(null);
        }
        graphBuilder.setGraphEndTime(rs.getTimestamp("graph_end_time"));
        if (rs.wasNull()) {
            graphBuilder.setGraphEndTime(null);
        }
        graphBuilder.setExpire(rs.getTimestamp("expire"));
        if (rs.wasNull()) {
            graphBuilder.setExpire(null);
        }
        return graphBuilder.create();
    }

    public Graph getById(String id) throws SQLException {
        Connection connection = this.handle.getConnection();
        PreparedStatement ps = connection.prepareStatement("SELECT id,     graph_definition_id,     sub_type,     period_pretty,     description,     period_in_seconds,     test_instance_id,     test_definition_id,     graph_start_time,     graph_end_time,     expire,     image_data FROM graph WHERE id=?");
        ps.setString(1, id);
        ResultSet rs = ps.executeQuery();
        boolean hasNext = rs.next();
        Graph res = hasNext ? this.resultSetToGraph(rs) : null;
        ps.close();
        return res;
    }

    @Nonnull
    public List<Graph> getByTestInstanceId(@Nonnull Integer testInstanceId) throws SQLException {
        assert (testInstanceId != null);
        Connection connection = this.handle.getConnection();
        PreparedStatement ps = connection.prepareStatement("SELECT id,     graph_definition_id,     sub_type,     period_pretty,     description,     period_in_seconds,     test_instance_id,     test_definition_id,     graph_start_time,     graph_end_time,     expire,     image_data FROM graph  WHERE test_instance_id=?");
        assert (ps != null);
        ps.setInt(1, testInstanceId);
        ResultSet rs = ps.executeQuery();
        ArrayList<Graph> res = new ArrayList<Graph>();
        while (rs.next()) {
            Graph g = this.resultSetToGraph(rs);
            res.add(g);
        }
        ps.close();
        return res;
    }

    public byte[] getImageDataById(String id) throws SQLException {
        byte[] res;
        Connection connection = this.handle.getConnection();
        PreparedStatement ps = connection.prepareStatement("SELECT image_data FROM graph WHERE id=?");
        ps.setString(1, id);
        ResultSet rs = ps.executeQuery();
        boolean hasNext = rs.next();
        if (!hasNext) {
            res = null;
        } else {
            res = rs.getBytes("image_data");
            if (res == null) {
                res = new byte[]{};
            }
        }
        ps.close();
        return res;
    }

    public int updateImageData(String id, InputStream content) throws SQLException {
        Connection connection = this.handle.getConnection();
        PreparedStatement ps = connection.prepareStatement("UPDATE graph SET image_data=?  WHERE id=?");
        if (content == null) {
            ps.setNull(1, -2);
        } else {
            ps.setBinaryStream(1, content);
        }
        ps.setString(2, id);
        int res = ps.executeUpdate();
        ps.close();
        return res;
    }

    public int upsertFields(Graph graph) throws SQLException {
        return this.upsertFields((String)graph.getId(), graph.getGraphDefinitionId(), graph.getSubType(), graph.getPeriodString(), graph.getDescription(), graph.getPeriodInSeconds(), graph.getTestInstanceId(), graph.getTestDefinitionId(), graph.getGraphStartTime() == null ? null : new Timestamp(graph.getGraphStartTime().getTime()), graph.getGraphEndTime() == null ? null : new Timestamp(graph.getGraphEndTime().getTime()), graph.getExpire() == null ? null : new Timestamp(graph.getExpire().getTime()));
    }

    public int upsertFields(String id, String graphDefinitionId, String subType, String periodString, String description, Long periodInSeconds, Integer testInstanceId, String testDefinitionId, Timestamp graphStartTime, Timestamp graphEndTime, Timestamp expire) throws SQLException {
        Connection connection = this.handle.getConnection();
        PreparedStatement ps = connection.prepareStatement("INSERT INTO graph (id,  graph_definition_id, sub_type, period_pretty,  description, period_in_seconds,  test_instance_id, test_definition_id,  graph_start_time, graph_end_time,  expire) VALUES  (?,  ?,?,?,  ?,?,  ?,?,  ?,?,  ?) ON CONFLICT (id) DO UPDATE SET   graph_definition_id=EXCLUDED.graph_definition_id,   sub_type=EXCLUDED.sub_type,   period_pretty=EXCLUDED.period_pretty,   description=EXCLUDED.description,   period_in_seconds=EXCLUDED.period_in_seconds,   test_instance_id=EXCLUDED.test_instance_id,   test_definition_id=EXCLUDED.test_definition_id,   graph_start_time=EXCLUDED.graph_start_time,   graph_end_time=EXCLUDED.graph_end_time,   expire=EXCLUDED.expire ");
        assert (id != null);
        ps.setString(1, id);
        if (graphDefinitionId == null) {
            ps.setNull(2, 12);
        } else {
            ps.setString(2, graphDefinitionId);
        }
        if (subType == null) {
            ps.setNull(3, 12);
        } else {
            ps.setString(3, subType);
        }
        if (periodString == null) {
            ps.setNull(4, 12);
        } else {
            ps.setString(4, periodString);
        }
        if (description == null) {
            ps.setNull(5, 12);
        } else {
            ps.setString(5, description);
        }
        if (periodInSeconds == null) {
            ps.setNull(6, 3);
        } else {
            ps.setLong(6, periodInSeconds);
        }
        if (testInstanceId == null) {
            ps.setNull(7, 3);
        } else {
            ps.setInt(7, testInstanceId);
        }
        if (testDefinitionId == null) {
            ps.setNull(8, 12);
        } else {
            ps.setString(8, testDefinitionId);
        }
        if (graphStartTime == null) {
            ps.setNull(9, 93);
        } else {
            ps.setTimestamp(9, graphStartTime);
        }
        if (graphEndTime == null) {
            ps.setNull(10, 93);
        } else {
            ps.setTimestamp(10, graphEndTime);
        }
        if (expire == null) {
            ps.setNull(11, 93);
        } else {
            ps.setTimestamp(11, expire);
        }
        int res = ps.executeUpdate();
        ps.close();
        return res;
    }
}

