/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.dao;

import be.iminds.ilabt.jfed.fedmon.webapi.service.dao.JFedUserStatisticsDao;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.UserInfo;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.dropwizard.jackson.Jackson;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Instant;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.ResultSetMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JFedUserStatisticsMapper
implements ResultSetMapper<JFedUserStatisticsDao.JFedUserStatistic> {
    private static final Logger LOG = LoggerFactory.getLogger(JFedUserStatisticsMapper.class);
    private static final ObjectMapper mapper = Jackson.newObjectMapper();

    public JFedUserStatisticsDao.JFedUserStatistic map(int index, ResultSet r, StatementContext ctx) throws SQLException {
        UserInfo userInfo;
        String userInfoJsonStr = r.getString("stats_jsonstr");
        if (userInfoJsonStr == null) {
            throw new IllegalStateException("DB contains null for stats/stats_jsonstr");
        }
        try {
            userInfo = (UserInfo)mapper.readValue(userInfoJsonStr, UserInfo.class);
        }
        catch (IOException e) {
            LOG.debug("Bad JSON: " + userInfoJsonStr);
            throw new RuntimeException("Failed to convert JSON for \"stats\" in DB to UserInfo", e);
        }
        Instant login = r.getTimestamp("login").toInstant();
        return new JFedUserStatisticsDao.JFedUserStatistic(login, userInfo);
    }
}

