/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.dao;

import be.iminds.ilabt.jfed.fedmon.util.Clock;
import be.iminds.ilabt.jfed.fedmon.webapi.base.dao.DaoCommon;
import be.iminds.ilabt.jfed.fedmon.webapi.service.dao.ResultMapper;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Result;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.HashPrefixStatementRewriter;
import org.skife.jdbi.v2.Query;
import org.skife.jdbi.v2.sqlobject.Bind;
import org.skife.jdbi.v2.sqlobject.BindBean;
import org.skife.jdbi.v2.sqlobject.SqlQuery;
import org.skife.jdbi.v2.sqlobject.SqlUpdate;
import org.skife.jdbi.v2.sqlobject.Transaction;
import org.skife.jdbi.v2.sqlobject.customizers.RegisterMapper;
import org.skife.jdbi.v2.sqlobject.mixins.GetHandle;
import org.skife.jdbi.v2.tweak.ResultSetMapper;
import org.skife.jdbi.v2.tweak.StatementRewriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RegisterMapper(value={ResultMapper.class})
public abstract class ResultDao
implements GetHandle {
    private static final Logger LOG = LoggerFactory.getLogger(ResultDao.class);
    public static int MAX_HISTORY = 500;

    @SqlQuery(value="INSERT INTO result (testinstance_id,created,log_file,log_url,summary,expire,details,prev_result_id) \nSELECT :testInstanceId,:created,:logFile,:logUrl,CAST(:summary AS resultstatus),CAST(COALESCE(:overrideExpire,:expire) AS timestamp),CAST(:resultsAsJsonString AS jsonb), ti.last_result_id FROM testinstance ti WHERE ti.id = :testInstanceId \nRETURNING result.id")
    protected abstract Long insertResult(@BindBean Result var1, @Bind(value="overrideExpire") Timestamp var2);

    @SqlUpdate(value="UPDATE testinstance \nSET last_result_id=:lastResultId,\n    last_result_id_excluding_cancelled=:lastResultId,\n    last_run=:lastRun,\n    next_run=:nextRun\nWHERE id=:testInstanceId")
    protected abstract void updateTestInstanceForResult(@Bind(value="testInstanceId") Integer var1, @Bind(value="lastResultId") Long var2, @Bind(value="lastRun") Timestamp var3, @Bind(value="nextRun") Timestamp var4);

    @SqlUpdate(value="UPDATE testinstance \nSET last_result_id=:lastResultId,\n    last_run=:lastRun,\n    next_run=:nextRun\nWHERE id=:testInstanceId")
    protected abstract void updateTestInstanceForCancelledResult(@Bind(value="testInstanceId") Integer var1, @Bind(value="lastResultId") Long var2, @Bind(value="lastRun") Timestamp var3, @Bind(value="nextRun") Timestamp var4);

    @SqlUpdate(value="UPDATE task SET state='FINISHED',result_id=:resultId,stop=:stop WHERE id=:id AND state = 'RUNNING' AND deadline > :now")
    protected abstract int finishTask(@Bind(value="id") Long var1, @Bind(value="resultId") Long var2, @Bind(value="stop") Timestamp var3, @Bind(value="now") Timestamp var4);

    @SqlUpdate(value="UPDATE task SET state='CANCELLED',stop=LEAST(:now,deadline) WHERE id=:id AND state='CANCELLING'")
    protected abstract int cancelIfCancelling(@Bind(value="id") Long var1, @Bind(value="now") Timestamp var2);

    @Transaction
    public Long insert(@BindBean Result result, Timestamp expire, Timestamp nextRun) throws ResultInsertException {
        boolean cancelled;
        int rowsChangedByFinishTask;
        int rowsChangedByCancel;
        if (result.getTaskId() != null && (rowsChangedByCancel = this.cancelIfCancelling(result.getTaskId(), Clock.nowTimestamp())) > 0) {
            LOG.info("Insert Result Cancelled: Succeeded in setting CANCELLING Task to CANCELLED. Will not insert result.");
            return null;
        }
        Long resultId = this.insertResult(result, expire);
        if (result.getTaskId() != null && (rowsChangedByFinishTask = this.finishTask(result.getTaskId(), resultId, result.getCreated(), Clock.nowTimestamp())) != 1) {
            LOG.error("Task referred to by result (id=" + result.getTaskId() + ") did not exist, or was not running.");
            throw new ResultInsertException("Task referred to by result (id=" + result.getTaskId() + ") did not exist, or was not running.");
        }
        boolean bl = cancelled = result.getSummary() != null && result.getSummary().equalsIgnoreCase("CANCELLED");
        if (cancelled) {
            this.updateTestInstanceForCancelledResult(result.getTestInstanceId(), resultId, result.getCreated(), nextRun);
        } else {
            this.updateTestInstanceForResult(result.getTestInstanceId(), resultId, result.getCreated(), nextRun);
        }
        return resultId;
    }

    @SqlQuery(value="SELECT r.id,log_file,created,log_url,summary,expire,r.testinstance_id,CAST(r.details AS text) AS details_json_text \n,ti.testdefinition_id AS testdefinition_id\n FROM result r \nLEFT JOIN testinstance ti ON ti.id = r.testinstance_id \nWHERE r.id=:id")
    public abstract Result findById(@Bind(value="id") Long var1);

    public List<Result> searchHistory(Integer testInstanceId, Integer limit, Date after, Date before) {
        List res;
        ArrayList<String> whereParts = new ArrayList<String>();
        if (limit == null) {
            limit = MAX_HISTORY;
        }
        if (limit > MAX_HISTORY) {
            throw new RuntimeException("Too many results requested at once (" + MAX_HISTORY + " maximum).");
        }
        if (after != null) {
            whereParts.add("rr.created >= #after");
        }
        if (before != null) {
            whereParts.add("rr.created <= #before");
        }
        Object where = "";
        if (!whereParts.isEmpty()) {
            where = (String)where + " WHERE ";
            boolean first = true;
            for (String wherePart : whereParts) {
                if (!first) {
                    where = (String)where + " AND ";
                }
                where = (String)where + "(" + wherePart + ")";
                first = false;
            }
            where = (String)where + " ";
        }
        String queryString = "SELECT rr.id,       rr.log_file,       rr.created,       rr.log_url,       rr.summary,       rr.expire,       CAST(rr.details AS text) AS details_json_text,       rr.testinstance_id \n       ,ti.testdefinition_id AS testdefinition_id  FROM (SELECT r.id,log_file,r.created,log_url,r.summary,r.expire,\n             r.testinstance_id,r.details\n      FROM result r \n      WHERE testinstance_id=#testInstanceId\n      ORDER BY created DESC\n      LIMIT " + limit + " \n      ) rr\n LEFT JOIN testinstance ti ON ti.id = rr.testinstance_id \n " + (String)where + "\n ORDER BY created DESC";
        LOG.debug("searchHistory() queryString=\"" + queryString + "\"");
        Handle h = this.getHandle();
        h.registerMapper((ResultSetMapper)new ResultMapper());
        Query query = h.createQuery(queryString);
        query.setStatementRewriter((StatementRewriter)new HashPrefixStatementRewriter());
        query = (Query)query.bind("testInstanceId", testInstanceId);
        if (after != null) {
            query = (Query)query.bind("after", after);
        }
        if (before != null) {
            query = (Query)query.bind("before", before);
        }
        if ((res = query.mapTo(Result.class).list()).isEmpty()) {
            return Collections.emptyList();
        }
        return res;
    }

    public List<Result> searchLast(List<String> versionNameFilter, List<String> testInstanceNameFilter, List<String> testDefinitionNameFilter, List<Integer> testInstanceIdFilter, List<String> testbedCategoryFilter, List<String> testbedGeniNameFilter, List<String> testbedUrnFilter, List<String> testbedNameFilter, List<Integer> serverIdFilter, Boolean disabled, CancelledTestResultIncluded cancelledIncluded, Boolean expired) {
        List res;
        assert (cancelledIncluded != null);
        boolean hasTestbedFilter = false;
        ArrayList<Object> whereTiTdParts = new ArrayList<Object>();
        if (versionNameFilter != null && !versionNameFilter.isEmpty()) {
            whereTiTdParts.add(DaoCommon.makeWherePart((String)"ti.test_version_name", (String)"ver", (int)versionNameFilter.size()));
        }
        if (testInstanceNameFilter != null && !testInstanceNameFilter.isEmpty()) {
            whereTiTdParts.add(DaoCommon.makeWherePart((String)"ti.name", (String)"name", (int)testInstanceNameFilter.size()));
        }
        if (testDefinitionNameFilter != null && !testDefinitionNameFilter.isEmpty()) {
            whereTiTdParts.add(DaoCommon.makeWherePart((String)"ti.testdefinition_id", (String)"td", (int)testDefinitionNameFilter.size()));
        }
        if (testInstanceIdFilter != null && !testInstanceIdFilter.isEmpty()) {
            whereTiTdParts.add(DaoCommon.makeWherePart((String)"ti.id", (String)"id", (int)testInstanceIdFilter.size()));
        }
        if (testbedCategoryFilter != null && !testbedCategoryFilter.isEmpty()) {
            whereTiTdParts.add("ARRAY[" + DaoCommon.makeWherePartList((String)"tbcat", (int)testbedCategoryFilter.size()) + "]::varchar[] && ti.\"testbed_categories\"");
            hasTestbedFilter = true;
        }
        if (testbedGeniNameFilter != null && !testbedGeniNameFilter.isEmpty()) {
            whereTiTdParts.add(DaoCommon.makeWherePart((String)"ti.\"testbed_geni_id\"", (String)"tbgeni", (int)testbedGeniNameFilter.size()));
            hasTestbedFilter = true;
        }
        if (testbedUrnFilter != null && !testbedUrnFilter.isEmpty()) {
            whereTiTdParts.add(DaoCommon.makeWherePart((String)"ti.\"testbed_default_urn\"", (String)"tburn", (int)testbedUrnFilter.size()));
            hasTestbedFilter = true;
        }
        if (testbedNameFilter != null && !testbedNameFilter.isEmpty()) {
            whereTiTdParts.add(DaoCommon.makeWherePart((String)"ti.testbed_id", (String)"tb", (int)testbedNameFilter.size()));
            hasTestbedFilter = true;
        }
        if (serverIdFilter != null && !serverIdFilter.isEmpty()) {
            whereTiTdParts.add(DaoCommon.makeWherePart((String)"ti.server_parameter_value", (String)"srv", (int)serverIdFilter.size()));
            hasTestbedFilter = true;
        }
        if (disabled != null) {
            if (disabled.booleanValue()) {
                whereTiTdParts.add("ti.enabled = FALSE");
            } else {
                whereTiTdParts.add("ti.enabled = TRUE");
            }
        }
        String whereTiTd = DaoCommon.joinWhereParts(whereTiTdParts);
        ArrayList<String> whereResultParts = new ArrayList<String>();
        if (expired != null) {
            if (expired.booleanValue()) {
                whereResultParts.add("rr.expire < #now");
            } else {
                whereResultParts.add("rr.expire >= #now");
            }
        }
        String whereResult = DaoCommon.joinWhereParts(whereResultParts);
        String queryString = "SELECT rr.id,rr.log_file,rr.created,rr.log_url,rr.summary,rr.expire,CAST(rr.details AS text) AS details_json_text \n       ,rr.testinstance_id ,rr.testdefinition_id AS testdefinition_id\n FROM (SELECT r.id,log_file,r.created,log_url,r.summary,r.expire,r.details,\n             ti.id AS testinstance_id, ti.testdefinition_id AS testdefinition_id,ti.server_id AS server_id,ti.testbed_id AS testbed_id,ti.name AS testinstance_name\n       FROM result r \n       INNER JOIN testinstance_with_testbed ti ON ti." + (cancelledIncluded == CancelledTestResultIncluded.INCLUDED ? "last_result_id" : "last_result_id_excluding_cancelled") + "=r.id\n      " + whereTiTd + " LIMIT 500 \n      ) rr\n " + whereResult;
        LOG.debug("search() queryString=\"" + queryString + "\"");
        Handle h = this.getHandle();
        h.registerMapper((ResultSetMapper)new ResultMapper());
        Query query = h.createQuery(queryString);
        query.setStatementRewriter((StatementRewriter)new HashPrefixStatementRewriter());
        if (versionNameFilter != null && !versionNameFilter.isEmpty()) {
            query = DaoCommon.setVars((Query)query, (String)"ver", versionNameFilter);
        }
        if (testInstanceNameFilter != null && !testInstanceNameFilter.isEmpty()) {
            query = DaoCommon.setVars((Query)query, (String)"name", testInstanceNameFilter);
        }
        if (testDefinitionNameFilter != null && !testDefinitionNameFilter.isEmpty()) {
            query = DaoCommon.setVars((Query)query, (String)"td", testDefinitionNameFilter);
        }
        if (testInstanceIdFilter != null && !testInstanceIdFilter.isEmpty()) {
            query = DaoCommon.setVars((Query)query, (String)"id", testInstanceIdFilter);
        }
        if (testbedCategoryFilter != null && !testbedCategoryFilter.isEmpty()) {
            query = DaoCommon.setVars((Query)query, (String)"tbcat", testbedCategoryFilter);
        }
        if (testbedGeniNameFilter != null && !testbedGeniNameFilter.isEmpty()) {
            query = DaoCommon.setVars((Query)query, (String)"tbgeni", testbedGeniNameFilter);
        }
        if (testbedUrnFilter != null && !testbedUrnFilter.isEmpty()) {
            query = DaoCommon.setVars((Query)query, (String)"tburn", testbedUrnFilter);
        }
        if (testbedNameFilter != null && !testbedNameFilter.isEmpty()) {
            query = DaoCommon.setVars((Query)query, (String)"tb", testbedNameFilter);
        }
        if (serverIdFilter != null && !serverIdFilter.isEmpty()) {
            query = DaoCommon.setVars((Query)query, (String)"srv", serverIdFilter);
        }
        if (expired != null) {
            query = (Query)query.bind("now", Clock.nowTimestamp());
        }
        if ((res = query.mapTo(Result.class).list()).isEmpty()) {
            return Collections.emptyList();
        }
        return res;
    }

    public List<Result> searchLastSummaryFiltered(Integer testInstanceIdFilter, Boolean expired, List<String> summary) {
        List res;
        ArrayList<String> whereResultParts = new ArrayList<String>();
        if (testInstanceIdFilter != null) {
            whereResultParts.add("r.testinstance_id = #tid");
        }
        if (expired != null) {
            if (expired.booleanValue()) {
                whereResultParts.add("r.expire < #now");
            } else {
                whereResultParts.add("r.expire >= #now");
            }
        }
        if (summary != null && !summary.isEmpty()) {
            whereResultParts.add(DaoCommon.makeCastWherePart((String)"r.\"summary\"", (String)"sum", (int)summary.size(), (String)"resultstatus"));
        }
        String whereResult = DaoCommon.joinWhereParts(whereResultParts);
        String queryString = "SELECT r.id,r.log_file,r.created,r.log_url,r.summary,r.expire,\n       CAST(r.details AS text) AS details_json_text,\n       r.testinstance_id, t.testdefinition_id AS testdefinition_id\n FROM result r\n JOIN testinstance t on r.testinstance_id = t.id\n " + whereResult + "\n ORDER BY created DESC\n LIMIT 1";
        LOG.debug("search() queryString=\"" + queryString + "\"");
        Handle h = this.getHandle();
        h.registerMapper((ResultSetMapper)new ResultMapper());
        Query query = h.createQuery(queryString);
        query.setStatementRewriter((StatementRewriter)new HashPrefixStatementRewriter());
        if (testInstanceIdFilter != null) {
            query = (Query)query.bind("tid", testInstanceIdFilter);
        }
        if (summary != null && !summary.isEmpty()) {
            query = DaoCommon.setVars((Query)query, (String)"sum", summary);
        }
        if (expired != null) {
            query = (Query)query.bind("now", Clock.nowTimestamp());
        }
        if ((res = query.mapTo(Result.class).list()).isEmpty()) {
            return Collections.emptyList();
        }
        return res;
    }

    public static class ResultInsertException
    extends Exception {
        public ResultInsertException() {
        }

        public ResultInsertException(String message) {
            super(message);
        }

        public ResultInsertException(String message, Throwable cause) {
            super(message, cause);
        }

        public ResultInsertException(Throwable cause) {
            super(cause);
        }

        public ResultInsertException(String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace) {
            super(message, cause, enableSuppression, writableStackTrace);
        }
    }

    public static enum CancelledTestResultIncluded {
        EXCLUDED,
        INCLUDED;

    }
}

