/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.dao;

import be.iminds.ilabt.jfed.fedmon.webapi.base.dao.DaoCommon;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.MaintenanceInfo;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ServerBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ServerGlimpse;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ServerGlimpseBuilder;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.dropwizard.jackson.Jackson;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.ResultSetMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerGlimpseMapper
implements ResultSetMapper<ServerGlimpseBuilder> {
    private static final Logger LOG = LoggerFactory.getLogger(ServerGlimpseMapper.class);
    private static final ObjectMapper MAPPER = Jackson.newObjectMapper();

    public ServerGlimpseBuilder map(int index, ResultSet r, StatementContext ctx) throws SQLException {
        ServerGlimpseBuilder builder = new ServerGlimpseBuilder();
        ServerGlimpse.AdvertisementInfo advertisementInfo = ServerGlimpseMapper.advertisementInfoFromJson(r.getString("advertisement_info_json_text"));
        ServerGlimpse.HealthInfo healthInfo = ServerGlimpseMapper.healthInfoFromJson(r.getString("health_info_json_text"));
        builder.setAdvertisementInfo(advertisementInfo);
        builder.setHealthInfo(healthInfo);
        builder.setServerBuilder((ServerBuilder)new ServerBuilder().setId((Object)r.getInt("server_id")));
        builder.setReputation(DaoCommon.rowInteger((ResultSet)r, (String)"reputation"));
        builder.setMaintenance(ServerGlimpseMapper.maintenanceFromJson(r.getString("maintenance_json_text")));
        return builder;
    }

    public static ServerGlimpse.AdvertisementInfo advertisementInfoFromJson(String json) {
        if (json == null) {
            return null;
        }
        try {
            return (ServerGlimpse.AdvertisementInfo)MAPPER.readValue(json, ServerGlimpse.AdvertisementInfo.class);
        }
        catch (JsonProcessingException e) {
            throw new WebApplicationException("Error converting AdvertisementInfo from JSON", (Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (IOException e) {
            throw new WebApplicationException("IOException converting AdvertisementInfo from JSON", (Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private static ServerGlimpse.HealthInfo healthInfoFromJson(String json) {
        if (json == null) {
            return null;
        }
        try {
            return (ServerGlimpse.HealthInfo)MAPPER.readValue(json, ServerGlimpse.HealthInfo.class);
        }
        catch (JsonProcessingException e) {
            throw new WebApplicationException("Error converting HealthInfo from JSON", (Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (IOException e) {
            throw new WebApplicationException("IOException converting HealthInfo from JSON", (Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private static List<MaintenanceInfo> maintenanceFromJson(String json) {
        if (json == null) {
            return null;
        }
        try {
            return (List)MAPPER.readValue(json, (JavaType)MAPPER.getTypeFactory().constructCollectionType(List.class, MaintenanceInfo.class));
        }
        catch (JsonProcessingException e) {
            throw new WebApplicationException("Error converting maintenance from JSON", (Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (IOException e) {
            throw new WebApplicationException("IOException converting maintenance from JSON", (Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    static {
        MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, true);
    }
}

