/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.dao;

import be.iminds.ilabt.jfed.fedmon.webapi.base.dao.BindPostgressStringArray;
import be.iminds.ilabt.jfed.fedmon.webapi.service.dao.TaskMapper;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Task;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.skife.jdbi.v2.sqlobject.Bind;
import org.skife.jdbi.v2.sqlobject.BindBean;
import org.skife.jdbi.v2.sqlobject.SqlCall;
import org.skife.jdbi.v2.sqlobject.SqlQuery;
import org.skife.jdbi.v2.sqlobject.SqlUpdate;
import org.skife.jdbi.v2.sqlobject.Transaction;
import org.skife.jdbi.v2.sqlobject.customizers.RegisterMapper;

@RegisterMapper(value={TaskMapper.class})
public abstract class TaskDao {
    @SqlQuery(value="INSERT INTO task (id,testinstance_id, start, deadline, log, run_info, state) VALUES (DEFAULT,:testInstanceId, :start, :deadline, :log, :runInfo, CAST(:state AS taskstate)) RETURNING id")
    public abstract Long insert(@BindBean Task var1);

    @SqlUpdate(value="UPDATE task SET state=CAST(:state AS taskstate) WHERE id=:id   AND state NOT IN ('EXPIRED','FINISHED','CANCELLED')   AND deadline > :now")
    public abstract void updateState(@Bind(value="id") Long var1, @Bind(value="state") Task.State var2, @Bind(value="now") Timestamp var3);

    @SqlUpdate(value="UPDATE task SET deadline=:deadline,log=:log,result_id=:resultId,run_info=:runInfo,stop=:stop,state=CAST(:state AS taskstate) WHERE id=:id   AND state NOT IN ('EXPIRED','FINISHED','CANCELLED')   AND :state NOT IN ('EXPIRED','FINISHED')   AND deadline > :now")
    public abstract void updateAll(@BindBean Task var1, @Bind(value="now") Timestamp var2);

    @SqlUpdate(value="UPDATE task SET state='CANCELLED' WHERE state IN ('CREATED','RUNNING')   AND deadline > :now")
    public abstract void forceCancelStateAll(@Bind(value="now") Timestamp var1);

    @SqlUpdate(value="UPDATE task SET state='CANCELLING' WHERE state IN ('CREATED','RUNNING')   AND deadline > :now")
    public abstract void forceCancellingStateAll(@Bind(value="now") Timestamp var1);

    @SqlUpdate(value="UPDATE task t SET state='CANCELLING' FROM testinstance ti WHERE t.testinstance_id = ti.id  AND ti.user_parameter_value = :userId  AND t.state IN ('CREATED','RUNNING')  AND ti.selftest_immune IS false  AND t.deadline >= :now")
    public abstract void forceCancellingStateForUser(@Bind(value="userId") String var1, @Bind(value="now") Timestamp var2);

    @SqlUpdate(value="UPDATE task SET result_id=:resultId,state='FINISHED' WHERE id=:id AND (state != 'CANCELLING' AND state != 'CANCELLED')")
    public abstract void setResult(@Bind(value="id") Long var1, @Bind(value="resultId") Long var2);

    @SqlQuery(value="SELECT id,testinstance_id,start,deadline,stop,log,result_id,run_info,state FROM task WHERE id = :id")
    public abstract Task findById(@NotNull @Bind(value="id") Long var1);

    @SqlQuery(value="SELECT id,testinstance_id,start,deadline,stop,log,result_id,run_info,state FROM task WHERE testinstance_id = :testInstanceId")
    public abstract List<Task> findByTestInstanceId(@Bind(value="testInstanceId") Integer var1);

    @SqlQuery(value="SELECT id,testinstance_id,start,deadline,stop,log,result_id,run_info,state FROM task WHERE (state = 'CREATED' OR state = 'RUNNING' OR state = 'CANCELLING') AND  deadline >= :now  ORDER BY id DESC  LIMIT :last")
    public abstract List<Task> findActive(@Bind(value="last") int var1, @Bind(value="now") Timestamp var2);

    @SqlQuery(value="SELECT id,testinstance_id,start,deadline,stop,log,result_id,run_info,state FROM task WHERE (NOT (state = 'CREATED' OR state = 'RUNNING' OR state = 'CANCELLING') ) OR  deadline < :now  ORDER BY id DESC  LIMIT :last")
    public abstract List<Task> findHistoric(@Bind(value="last") int var1, @Bind(value="now") Timestamp var2);

    @SqlQuery(value="SELECT id,testinstance_id,start,deadline,stop,log,result_id,run_info,state FROM task WHERE (state = 'CREATED' OR state = 'RUNNING' OR state = 'CANCELLING' OR state = 'EXPIRED') AND  deadline < :now  ORDER BY id DESC  LIMIT :last")
    public abstract List<Task> findExpired(@Bind(value="last") int var1, @Bind(value="now") Timestamp var2);

    @SqlQuery(value="UPDATE task SET state = 'EXPIRED'  WHERE (state = 'CREATED' OR state = 'RUNNING' OR state = 'CANCELLING') AND       deadline < :now  RETURNING id,testinstance_id,start,deadline,stop,log,result_id,run_info,state")
    public abstract List<Task> handleExpired(@Bind(value="now") Timestamp var1);

    @SqlQuery(value="SELECT id,testinstance_id,start,deadline,stop,log,result_id,run_info,state  FROM task  ORDER BY id DESC  LIMIT :last")
    public abstract List<Task> findAll(@Bind(value="last") int var1);

    @SqlCall(value="DELETE FROM task WHERE id = :id")
    public abstract void deleteById(@Bind(value="id") Long var1);

    @SqlCall(value="DELETE FROM task WHERE id = :id")
    public abstract void delete(@BindBean Task var1);

    @SqlQuery(value="INSERT INTO task (testinstance_id, start, deadline, run_info, state)\nSELECT ti.id,:start,:deadline,:runInfo,'CREATED'\nFROM testinstance_with_testbed ti\n LEFT JOIN frequency f ON f.id = ti.frequency_id \n LEFT JOIN sfa_user u ON u.id = ti.user_parameter_value \n WHERE ( ti.next_run IS NULL OR ti.next_run <= :now )\n      AND ti.enabled \n      AND (ti.selftest_immune OR u.selftest_failed IS NULL OR (NOT u.selftest_failed) ) \n      AND (ti.test_version_name=COALESCE(:testVersionName,ti.test_version_name)) \n      AND (ti.testdefinition_id=ANY(COALESCE(:testDefinitionNameArray,array[ti.testdefinition_id]))) \n      AND (ti.id=COALESCE(:testInstanceId,ti.id)) \n      AND (ti.name=COALESCE(:testInstanceName,ti.name))\n      AND (ti.testbed_id IS NULL OR ti.testbed_id=COALESCE(:testbed,ti.testbed_id)) \n      AND (NOT EXISTS (SELECT ta.testinstance_id FROM task ta WHERE                               ta.state IN ('CREATED','RUNNING','CANCELLING') AND                                ta.deadline >= :now AND                               ta.testinstance_id = ti.id))\n      AND f.description NOT ILIKE 'never%' \n      AND ti.frequency_id IS NOT NULL \n LIMIT :maxCount\n RETURNING id,testinstance_id,start,deadline,stop,log,result_id,run_info,state")
    public abstract List<Task> searchAndCreate(@NotNull @Bind(value="maxCount") Integer var1, @Bind(value="testInstanceId") Integer var2, @Bind(value="testVersionName") String var3, @BindPostgressStringArray(value="testDefinitionNameArray") List<String> var4, @Bind(value="testbed") String var5, @Bind(value="testInstanceName") String var6, @Bind(value="runInfo") String var7, @Bind(value="start") Timestamp var8, @Bind(value="deadline") Timestamp var9, @Bind(value="now") Timestamp var10);

    @SqlQuery(value="INSERT INTO task (testinstance_id, start, deadline, run_info, state)\n VALUES (:testInstanceId,:start,:deadline,:runInfo,'CREATED') \n RETURNING id,testinstance_id,start,deadline,stop,log,result_id,run_info,state")
    public abstract List<Task> createSingle(@Bind(value="testInstanceId") int var1, @Bind(value="runInfo") String var2, @Bind(value="start") Timestamp var3, @Bind(value="deadline") Timestamp var4, @Bind(value="now") Timestamp var5);

    @Transaction
    public List<Task> createMultiple(@Bind(value="stressTestCount") int stressTestCount, @Bind(value="testInstanceId") int testInstanceId, @Bind(value="runInfo") String runInfo, @Bind(value="start") Timestamp start, @Bind(value="deadline") Timestamp deadline, @Bind(value="now") Timestamp now) {
        ArrayList<Task> res = new ArrayList<Task>();
        for (int i = 0; i < stressTestCount; ++i) {
            res.addAll(this.createSingle(testInstanceId, runInfo, start, deadline, now));
        }
        return res;
    }
}

