/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.dao;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestInstanceStatistics;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestInstanceStatisticsBuilder;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.ResultSetMapper;

public class TestInstanceStatisticsMapper
implements ResultSetMapper<TestInstanceStatisticsBuilder> {
    public TestInstanceStatisticsBuilder map(int index, ResultSet r, StatementContext ctx) throws SQLException {
        TestInstanceStatisticsBuilder res = new TestInstanceStatisticsBuilder();
        res.setTestInstanceId(Integer.valueOf(r.getInt("id")));
        String summationJson = r.getString("summation_text");
        TestInstanceStatistics.Summation summation = null;
        if (summationJson != null) {
            try {
                summation = new TestInstanceStatisticsBuilder.SummationBuilder(summationJson).create();
            }
            catch (IOException e) {
                throw new SQLException("Error processing JSON in DB: " + summationJson, e);
            }
        }
        res.setSummation(summation);
        String testStatisticsJson = r.getString("test_statistics_text");
        TestInstanceStatistics.RrdStatistics rrdStatistics = null;
        if (testStatisticsJson != null) {
            try {
                rrdStatistics = new TestInstanceStatisticsBuilder.RrdStatisticsBuilder(testStatisticsJson).create();
            }
            catch (IOException e) {
                throw new SQLException("Error processing JSON in DB: " + testStatisticsJson, e);
            }
        }
        res.setRrdStatistics(rrdStatistics);
        res.setNextRun(r.getTimestamp("next_run"));
        res.setLastRun(r.getTimestamp("last_run"));
        if (r.getObject("last_result_id") != null) {
            res.setLastResultInfo("any", Long.valueOf(r.getLong("last_result_id")), r.getTimestamp("last_result_date"));
        }
        if (r.getObject("last_result_id_excluding_cancelled") != null) {
            res.setLastResultInfo("anyButCancelled", Long.valueOf(r.getLong("last_result_id_excluding_cancelled")), r.getTimestamp("last_result_excluding_cancelled_date"));
        }
        res.setActiveTask(r.getObject("active_task_id") == null ? null : Long.valueOf(r.getLong("active_task_id")), null);
        return res;
    }
}

