/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.dao;

import be.iminds.ilabt.jfed.fedmon.webapi.base.dao.DaoCommon;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.F4FFederationStatus;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Federation;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.FederationBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.GDPRInfo;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Organisation;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.OrganisationBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ProxyBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ServerBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Service;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ServiceBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Testbed;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestbedBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestbedCategoryBuilder;
import be.iminds.ilabt.util.jsonld.JsonLdObjectsMetaData;
import be.iminds.ilabt.util.jsonld.UriTool;
import be.iminds.ilabt.util.jsonld.iface.JsonLdObjectBuilder;
import be.iminds.ilabt.util.jsonld.impl.PrimaryIdObjectBuilder;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.dropwizard.jackson.Jackson;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.HashPrefixStatementRewriter;
import org.skife.jdbi.v2.Query;
import org.skife.jdbi.v2.sqlobject.BindBean;
import org.skife.jdbi.v2.sqlobject.SqlUpdate;
import org.skife.jdbi.v2.sqlobject.mixins.GetHandle;
import org.skife.jdbi.v2.tweak.StatementRewriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TestbedDao
implements GetHandle {
    private static final Logger LOG = LoggerFactory.getLogger(TestbedDao.class);
    private static final ObjectMapper MAPPER = Jackson.newObjectMapper();

    @SqlUpdate(value="UPDATE testbed \nSET iface_url=:interfaceUrl,\n    default_urn=:defaultComponentManagerUrn,\n    default_server_id=:defaultServerId,\n    info_url=:infoUrl,\n    long_name=:longName,\n    help_url=:helpUrl,\n    ping_host=:pingHost,\n    otrs_name=:otrsName,\n    description=:description,\n    geni_id=:geniId,\n    geni_href=:geniHrefAsString,\n    organisation_id=:organisationId,\n    allow_links=:allowLinks,\n    color=:color,\n    logo=:logo,\n    nodes_location_visualisation_coordinates_url=:nodesLocationVisualisationCoordinatesUrl,\n    nodes_location_visualisation_image_url=:nodesLocationVisualisationImageUrl,\n    technical_contact_emails=CAST(string_to_array(:technicalContactEmailsAsCsv, ',') AS text[]),\n    primary_contact_emails=CAST(string_to_array(:primaryContactEmailsAsCsv, ',') AS text[]),\n    gdpr_contact_emails=CAST(string_to_array(:gdprContactEmailsAsCsv, ',') AS text[]),\n    testbed_admin_urns=CAST(string_to_array(:testbedAdminUrnsAsCsv, ',') AS text[]),\n    software=CAST(string_to_array(:softwareAsCsv, ',') AS text[]),\n    notes=:notes,\n    f4f_federation_status=CAST(:f4fFederationStatusAsJsonString AS jsonb),\n    gdpr_info=CAST(:gdprInfoAsJsonString AS jsonb)\nWHERE id=:id")
    public abstract void update(@BindBean Testbed var1);

    @SqlUpdate(value="INSERT INTO testbed (id, iface_url, default_urn, info_url, long_name, help_url, ping_host, \n      otrs_name, description, geni_id, geni_href, organisation_id, allow_links,color,logo, \n      nodes_location_visualisation_coordinates_url, nodes_location_visualisation_image_url,\n      default_server_id, technical_contact_emails, primary_contact_emails, gdpr_contact_emails, testbed_admin_urns,\n      software, notes, f4f_federation_status, gdpr_info) \nVALUES (:id, :interfaceUrl, :defaultComponentManagerUrn, :infoUrl, :longName, :helpUrl, :pingHost, :otrsName, :description, \n        :geniId, :geniHrefAsString, :organisationId, COALESCE(:allowLinks, false), :color, :logo, \n        :nodesLocationVisualisationCoordinatesUrl, :nodesLocationVisualisationImageUrl,\n        :defaultServerId, CAST(string_to_array(:technicalContactEmailsAsCsv, ',') AS text[]),\n        CAST(string_to_array(:primaryContactEmailsAsCsv, ',') AS text[]), CAST(string_to_array(:gdprContactEmailsAsCsv, ',') AS text[]),\n        CAST(string_to_array(:testbedAdminUrnsAsCsv, ',') AS text[]), CAST(string_to_array(:softwareAsCsv, ',') AS text[]),\n        :notes, CAST(:f4fFederationStatusAsJsonString AS JSONB), CAST(:gdprInfoAsJsonString AS JSONB) )")
    public abstract void insert(@BindBean Testbed var1);

    public List<TestbedBuilder> search(UriTool uriAdder, List<String> categories, List<String> geniIds, List<String> ids, List<String> urns) {
        return this.query(uriAdder, categories, geniIds, ids, urns, null, false);
    }

    public List<TestbedBuilder> findAll(UriTool uriAdder) {
        return this.query(uriAdder, null, null, null, null, null, false);
    }

    @Nullable
    public TestbedBuilder findById(@Nullable UriTool uriAdder, @Nonnull String id) {
        List<TestbedBuilder> res = this.query(uriAdder, null, null, null, null, id, false);
        if (res.isEmpty()) {
            return null;
        }
        assert (res.size() == 1) : "size=" + res.size();
        return res.get(0);
    }

    public List<TestbedBuilder> query(@Nullable UriTool uriAdder, @Nullable List<String> categories, @Nullable List<String> geniIds, @Nullable List<String> ids, @Nullable List<String> urns, @Nullable String id, boolean deep) {
        String where;
        String queryString = "SELECT t.id,\n         t.iface_url,t.default_urn,t.info_url,t.long_name,\n         t.help_url,t.ping_host,t.otrs_name,\n         t.description,t.geni_id,t.geni_href,\n         array_to_string(t.categories, ',') AS categories, \n         array_to_string(t.category_ids, ',') AS category_ids,\n         t.allow_links,t.color,t.logo,\n         t.nodes_location_visualisation_coordinates_url,\n         t.nodes_location_visualisation_image_url,\n         t.default_server_id,\n         array_to_string(t.technical_contact_emails, ',') AS testbed$technical_contact_emails_csv, \n         array_to_string(t.primary_contact_emails, ',') AS testbed$primary_contact_emails_csv, \n         array_to_string(t.gdpr_contact_emails, ',') AS testbed$gdpr_contact_emails_csv, \n         array_to_string(t.testbed_admin_urns, ',') AS testbed$testbed_admin_urns_csv, \n         array_to_string(t.software, ',') AS testbed$software_csv, \n         t.notes, \n         CAST(f4f_federation_status AS text) AS f4f_federation_status_json_text, \n         array_to_string(t.federation_ids, ',') AS testbed$federation_ids_csv, \n         CAST(gdpr_info AS text) AS gdpr_info_json_text, \n         serve.id AS server$id,\n         serve.base_url AS server$base_url,\n         o.id AS organisation$id,\n" + (deep ? "         o.name AS organisation$name,\n         o.site_url AS organisation$site_url,\n         o.logo_url AS organisation$logo_url,\n         o.coordinates AS organisation$coordinates,\n         array_to_string(o.technical_contact_emails, ',') AS organisation$technical_contact_emails_csv,          serve.name AS server$name,\n         serve.allowed_certificate_alias AS server$allowed_certificate_alias,\n         serve.certificate_chain AS server$certificate_chain,\n         serve.coordinates AS server$coordinates,\n         serve.server_type AS server$server_type,\n         serve.urn_tld AS server$urn_tld,\n         array_to_string(serve.flags, ',') AS server$flags,\n         array_to_string(serve.scs, ',') AS server$scs,\n         array_to_string(serve.user_auth, ',') AS server$user_auth,\n         serve.default_scs AS server$default_scs,\n         serve.default_user_auth AS server$default_user_auth,\n         serve.default_urn AS server$default_urn,\n         serve.default_am AS server$default_am,\n         servi.id AS service$id,\n         servi.api AS service$api,\n         servi.api_version AS service$api_version,\n         servi.urn AS service$urn,\n         servi.url AS service$url, \n" : "") + "         p.id AS proxy$id,\n         p.name AS proxy$name,\n         p.type AS proxy$type,\n         p.hostname AS proxy$hostname,\n         p.port_range AS proxy$port_range,\n         p.host_key AS proxy$host_key,\n         p.username_pattern AS proxy$username_pattern\n FROM testbed_with_categories t \n LEFT JOIN proxy p ON t.proxy_id = p.id \n LEFT JOIN organisation o ON t.organisation_id = o.id \n LEFT JOIN server serve ON serve.testbed_id = t.id \n" + (deep ? " LEFT JOIN service servi ON servi.server_id = serve.id \n" : "");
        boolean searchCats = categories != null && !categories.isEmpty();
        boolean searchGeniIds = geniIds != null && !geniIds.isEmpty();
        boolean searchIds = ids != null && !ids.isEmpty();
        boolean searchUrns = urns != null && !urns.isEmpty();
        boolean searchId = id != null && !id.trim().isEmpty();
        ArrayList<Object> whereParts = new ArrayList<Object>();
        if (searchGeniIds) {
            whereParts.add(DaoCommon.makeWherePart((String)"geni_id", (String)"gid", (int)geniIds.size()));
        }
        if (searchUrns) {
            whereParts.add(DaoCommon.makeWherePart((String)"t.default_urn", (String)"urns", (int)urns.size()));
        }
        if (searchIds) {
            whereParts.add(DaoCommon.makeWherePart((String)"t.id", (String)"ids", (int)ids.size()));
        }
        if (searchId) {
            whereParts.add("t.id = #id");
        }
        if (searchCats) {
            whereParts.add("t.categories && ARRAY[" + DaoCommon.makeWherePartList((String)"tbcat", (int)categories.size()) + "]::varchar[]");
        }
        if ((where = DaoCommon.joinWhereParts(whereParts)) != null && !where.trim().isEmpty()) {
            queryString = queryString + where;
        }
        LOG.debug("Testbed Query = " + queryString);
        Handle h = this.getHandle();
        Query query = h.createQuery(queryString);
        query.setStatementRewriter((StatementRewriter)new HashPrefixStatementRewriter());
        if (searchGeniIds) {
            query = DaoCommon.setVars((Query)query, (String)"gid", geniIds);
        }
        if (searchIds) {
            query = DaoCommon.setVars((Query)query, (String)"ids", ids);
        }
        if (searchUrns) {
            query = DaoCommon.setVars((Query)query, (String)"urns", urns);
        }
        if (searchCats) {
            query = DaoCommon.setVars((Query)query, (String)"tbcat", categories);
        }
        if (searchId) {
            query = (Query)query.bind("id", id);
        }
        HashMap<String, OrganisationBuilder> organisationBuildersById = new HashMap<String, OrganisationBuilder>();
        ArrayList<TestbedBuilder> noOrganisationTestbedBuilders = new ArrayList<TestbedBuilder>();
        HashMap<String, TestbedBuilder> testbedBuildersById = new HashMap<String, TestbedBuilder>();
        HashMap<Integer, ServerBuilder> serverBuildersById = new HashMap<Integer, ServerBuilder>();
        HashMap<Integer, ServiceBuilder> serviceBuildersById = new HashMap<Integer, ServiceBuilder>();
        for (Map row : query) {
            ServerBuilder curServerBuilder;
            TestbedBuilder curTestbedBuilder;
            Integer serviceId;
            String organisationId = DaoCommon.rowString((Map)row, (String)"organisation$id");
            String testbedId = DaoCommon.rowString((Map)row, (String)"id");
            Integer serverId = DaoCommon.rowInteger((Map)row, (String)"server$id");
            Integer n = serviceId = deep ? DaoCommon.rowInteger((Map)row, (String)"service$id") : null;
            if (testbedId == null) {
                throw new RuntimeException("testbed.id may not be NULL");
            }
            boolean existingTestbed = testbedBuildersById.containsKey(testbedId);
            boolean existingServer = serverId != null && serverBuildersById.containsKey(serverId);
            boolean existingService = serviceId != null && serviceBuildersById.containsKey(serviceId);
            LOG.debug("Processing row with " + organisationId + " " + testbedId + " " + serverId + " " + serviceId);
            if (!existingTestbed) {
                URI geniUrl;
                String geniHrefString;
                List categoryIds;
                List<Object> categoryNames;
                assert (testbedId != null);
                LOG.debug("Creating Testbed " + testbedId);
                String categoriesString = DaoCommon.rowString((Map)row, (String)"categories");
                if (categoriesString != null && !categoriesString.trim().isEmpty()) {
                    String[] cats = categoriesString.split(",");
                    categoryNames = Arrays.asList(cats);
                } else {
                    categoryNames = Collections.emptyList();
                }
                String categoryIdsString = DaoCommon.rowString((Map)row, (String)"category_ids");
                if (categoryIdsString != null && !categoryIdsString.trim().isEmpty()) {
                    String[] catIds = categoryIdsString.split(",");
                    categoryIds = new ArrayList();
                    for (String catIdStr : catIds) {
                        categoryIds.add(Integer.parseInt(catIdStr));
                    }
                } else {
                    categoryIds = Collections.emptyList();
                }
                if ((geniHrefString = DaoCommon.rowString((Map)row, (String)"geni_href")) != null && !geniHrefString.trim().isEmpty()) {
                    try {
                        geniUrl = new URI(geniHrefString);
                    }
                    catch (URISyntaxException e) {
                        LOG.error("geni_href for testbed \"" + DaoCommon.rowString((Map)row, (String)"id") + "\" is \"" + geniHrefString + "\", which does not parse as a URI");
                        geniUrl = null;
                    }
                } else {
                    geniUrl = null;
                }
                List<FederationBuilder> federationBuilders = TestbedDao.idToFederationBuilder(DaoCommon.rowStringArray((Map)row, (String)"testbed$federation_ids_csv"));
                if (uriAdder != null && federationBuilders != null) {
                    for (FederationBuilder federationBuilder : federationBuilders) {
                        uriAdder.setBuilderUri((PrimaryIdObjectBuilder)federationBuilder, true);
                    }
                }
                List federations = federationBuilders.stream().map(FederationBuilder::create).collect(Collectors.toList());
                curTestbedBuilder = new TestbedBuilder();
                curTestbedBuilder = ((TestbedBuilder)curTestbedBuilder.setId((Object)DaoCommon.rowString((Map)row, (String)"id"))).setLongName(DaoCommon.rowString((Map)row, (String)"long_name")).setInterfaceUrl(DaoCommon.rowString((Map)row, (String)"iface_url")).setPingHost(DaoCommon.rowString((Map)row, (String)"ping_host")).setInfoUrl(DaoCommon.rowString((Map)row, (String)"info_url")).setHelpUrl(DaoCommon.rowString((Map)row, (String)"help_url")).setDefaultComponentManagerUrn(DaoCommon.rowString((Map)row, (String)"default_urn")).setOtrsName(DaoCommon.rowString((Map)row, (String)"otrs_name")).setDescription(DaoCommon.rowString((Map)row, (String)"description")).setGeniId(DaoCommon.rowString((Map)row, (String)"geni_id")).setAllowLinks(DaoCommon.rowBoolean((Map)row, (String)"allow_links")).setColor(DaoCommon.rowString((Map)row, (String)"color")).setLogo(DaoCommon.rowString((Map)row, (String)"logo")).setNodesLocationVisualisationCoordinatesUrl(DaoCommon.rowString((Map)row, (String)"nodes_location_visualisation_coordinates_url")).setNodesLocationVisualisationImageUrl(DaoCommon.rowString((Map)row, (String)"nodes_location_visualisation_image_url")).setTechnicalContactEmails(DaoCommon.rowStringArray((Map)row, (String)"testbed$technical_contact_emails_csv")).setPrimaryContactEmails(DaoCommon.rowStringArray((Map)row, (String)"testbed$primary_contact_emails_csv")).setGdprContactEmails(DaoCommon.rowStringArray((Map)row, (String)"testbed$gdpr_contact_emails_csv")).setTestbedAdminUrns(DaoCommon.rowGeniUrnArray((Map)row, (String)"testbed$testbed_admin_urns_csv")).setSoftware(DaoCommon.rowStringArray((Map)row, (String)"testbed$software_csv")).setNotes(DaoCommon.rowString((Map)row, (String)"notes")).setF4fFederationStatus(this.federationStatusFromJsonString(DaoCommon.rowString((Map)row, (String)"f4f_federation_status_json_text"))).setGdprInfo(this.gdprInfoFromJsonString(DaoCommon.rowString((Map)row, (String)"gdpr_info_json_text"))).setFederations(federations).setGeniHref(geniUrl).setDefaultServerBuilder(TestbedDao.idToServerBuilder(DaoCommon.rowInteger((Map)row, (String)"default_server_id")));
                testbedBuildersById.put(testbedId, curTestbedBuilder);
                if (uriAdder != null) {
                    uriAdder.setBuilderUri((PrimaryIdObjectBuilder)curTestbedBuilder, true);
                }
                assert (categoryIds.size() == categoryNames.size());
                for (int i = 0; i < categoryNames.size(); ++i) {
                    TestbedCategoryBuilder testbedCategoryBuilder = new TestbedCategoryBuilder();
                    testbedCategoryBuilder.setId((Object)((Integer)categoryIds.get(i)));
                    testbedCategoryBuilder.setName((String)categoryNames.get(i));
                    if (uriAdder != null) {
                        uriAdder.setBuilderUri((PrimaryIdObjectBuilder)testbedCategoryBuilder, true);
                    }
                    curTestbedBuilder = curTestbedBuilder.addCategory(testbedCategoryBuilder.create());
                }
                if (categoryIds.isEmpty()) {
                    curTestbedBuilder.setCategories(Collections.emptyList());
                }
                if (row.containsKey("proxy$id") && row.get("proxy$id") != null) {
                    ProxyBuilder proxyBuilder = new ProxyBuilder();
                    proxyBuilder.setId((Object)DaoCommon.rowInteger((Map)row, (String)"proxy$id"));
                    proxyBuilder.setName(DaoCommon.rowString((Map)row, (String)"proxy$name"));
                    proxyBuilder.setType(DaoCommon.rowString((Map)row, (String)"proxy$type"));
                    proxyBuilder.setHostname(DaoCommon.rowString((Map)row, (String)"proxy$hostname"));
                    proxyBuilder.setPortRange(DaoCommon.rowString((Map)row, (String)"proxy$port_range"));
                    proxyBuilder.setHostKey(DaoCommon.rowString((Map)row, (String)"proxy$host_key"));
                    proxyBuilder.setUsernamePattern(DaoCommon.rowString((Map)row, (String)"proxy$username_pattern"));
                    if (uriAdder != null) {
                        uriAdder.setBuilderUri((PrimaryIdObjectBuilder)proxyBuilder, true);
                    }
                    curTestbedBuilder.setProxyBuilders(Arrays.asList(proxyBuilder));
                }
                if (organisationId == null) {
                    LOG.debug("Testbed " + testbedId + " has no Organisation");
                    noOrganisationTestbedBuilders.add(curTestbedBuilder);
                } else {
                    OrganisationBuilder organisationBuilder = (OrganisationBuilder)organisationBuildersById.get(organisationId);
                    if (organisationBuilder == null) {
                        LOG.debug("Creating Organisation " + organisationId);
                        organisationBuilder = new OrganisationBuilder();
                        organisationBuilder.setId((Object)DaoCommon.rowString((Map)row, (String)"organisation$id"));
                        if (deep) {
                            organisationBuilder.setName(DaoCommon.rowString((Map)row, (String)"organisation$name"));
                            organisationBuilder.setLogoUrl(DaoCommon.rowString((Map)row, (String)"organisation$logo_url"));
                            organisationBuilder.setSiteUrl(DaoCommon.rowString((Map)row, (String)"organisation$site_url"));
                            organisationBuilder.setLocation(DaoCommon.toLocation((String)DaoCommon.rowString((Map)row, (String)"organisation$coordinates")));
                            organisationBuilder.setTechnicalContactEmails(DaoCommon.rowStringArray((Map)row, (String)"organisation$technical_contact_emails_csv"));
                        }
                        organisationBuildersById.put(organisationId, organisationBuilder);
                        if (uriAdder != null) {
                            uriAdder.setBuilderUri((PrimaryIdObjectBuilder)organisationBuilder, true);
                        }
                    }
                    LOG.debug("Adding Testbed " + testbedId + " to Organisation " + organisationId);
                    organisationBuilder.addTestbedBuilder(curTestbedBuilder);
                }
            } else {
                curTestbedBuilder = (TestbedBuilder)testbedBuildersById.get(testbedId);
                assert (curTestbedBuilder != null);
            }
            if (serverId != null) {
                assert (testbedId != null) : "server " + serverId + " without testbed";
                assert (curTestbedBuilder != null) : "testbed without builder for server " + serverId + " testbed " + testbedId;
                if (!existingServer) {
                    LOG.debug("Creating Server " + serverId);
                    curServerBuilder = new ServerBuilder();
                    curServerBuilder.setId((Object)DaoCommon.rowInteger((Map)row, (String)"server$id"));
                    curServerBuilder.setBaseUrl(DaoCommon.rowString((Map)row, (String)"server$base_url"));
                    if (deep) {
                        curServerBuilder.setName(DaoCommon.rowString((Map)row, (String)"server$name"));
                        curServerBuilder.setAllowedCertificateAlias(DaoCommon.rowString((Map)row, (String)"server$allowed_certificate_alias"));
                        curServerBuilder.setCertificateChain(DaoCommon.rowString((Map)row, (String)"server$certificate_chain"));
                        curServerBuilder.setLocation(DaoCommon.toLocation((String)DaoCommon.rowString((Map)row, (String)"server$coordinates")));
                        curServerBuilder.setServerType(DaoCommon.rowString((Map)row, (String)"server$server_type"));
                        curServerBuilder.setUrnTld(DaoCommon.rowString((Map)row, (String)"server$urn_tld"));
                        curServerBuilder.setFlags((Collection)DaoCommon.rowStringArray((Map)row, (String)"server$flags"));
                        curServerBuilder.setScs(TestbedDao.idToService(DaoCommon.rowIntegerArray((Map)row, (String)"server$scs")));
                        curServerBuilder.setUserAuth(TestbedDao.idToService(DaoCommon.rowIntegerArray((Map)row, (String)"server$user_auth")));
                        curServerBuilder.setDefaultScs(TestbedDao.idToService(DaoCommon.rowInteger((Map)row, (String)"server$default_scs")));
                        curServerBuilder.setDefaultUserAuth(TestbedDao.idToService(DaoCommon.rowInteger((Map)row, (String)"server$default_user_auth")));
                        curServerBuilder.setDefaultComponentManagerUrn(DaoCommon.rowString((Map)row, (String)"server$default_urn"));
                        curServerBuilder.setDefaultAMServiceBuilder(TestbedDao.idToServiceBuilder(DaoCommon.rowInteger((Map)row, (String)"server$default_am")));
                    }
                    serverBuildersById.put(serverId, curServerBuilder);
                    if (uriAdder != null) {
                        uriAdder.setUriRecursive((JsonLdObjectBuilder)curServerBuilder, true);
                    }
                    curTestbedBuilder.addServerBuilder(curServerBuilder);
                    if (curTestbedBuilder.getDefaultServerBuilder() == null && curTestbedBuilder.getDefaultServer() == null) {
                        curTestbedBuilder.setDefaultServerBuilder(curServerBuilder);
                    }
                } else {
                    curServerBuilder = (ServerBuilder)serverBuildersById.get(serverId);
                    assert (curServerBuilder != null);
                }
            } else {
                curServerBuilder = null;
                assert (serviceId == null) : "service " + serviceId + " without server";
            }
            if (deep && serviceId != null) {
                ServiceBuilder curServiceBuilder;
                assert (serverId != null) : "service " + serviceId + " without server";
                assert (curServerBuilder != null) : "server without builder for service " + serviceId + " server " + serverId;
                if (!existingService) {
                    LOG.debug("Creating Service " + serviceId);
                    curServiceBuilder = new ServiceBuilder();
                    curServiceBuilder.setId((Object)DaoCommon.rowInteger((Map)row, (String)"service$id"));
                    curServiceBuilder.setApi(DaoCommon.rowString((Map)row, (String)"service$api"));
                    curServiceBuilder.setApiVersion(DaoCommon.rowString((Map)row, (String)"service$api_version"));
                    curServiceBuilder.setUrn(DaoCommon.rowString((Map)row, (String)"service$urn"));
                    curServiceBuilder.setUrl(DaoCommon.rowString((Map)row, (String)"service$url"));
                    if (uriAdder != null) {
                        uriAdder.setBuilderUri((PrimaryIdObjectBuilder)curServiceBuilder, true);
                    }
                    if (curServiceBuilder.getApi() != null && curServiceBuilder.getApi().equalsIgnoreCase("Geni.AM")) {
                        if (curServiceBuilder.getUrn() != null && curServerBuilder.getDefaultComponentManagerUrn() == null) {
                            curServerBuilder.setDefaultComponentManagerUrn(curServiceBuilder.getUrn());
                        }
                        if (curServerBuilder.getDefaultAMService() == null && curServerBuilder.getDefaultAMServiceBuilder() == null) {
                            curServerBuilder.setDefaultAMServiceBuilder(curServiceBuilder);
                        }
                    }
                    serviceBuildersById.put(serviceId, curServiceBuilder);
                    curServerBuilder.addServiceBuilder(curServiceBuilder);
                    continue;
                }
                curServiceBuilder = (ServiceBuilder)serviceBuildersById.get(serviceId);
                assert (curServiceBuilder != null);
                LOG.error("In the current query, you should never have 2 rows with the same service!");
                assert (false) : "In the current query, you should never have 2 rows with the same service!";
                continue;
            }
            Object var34_34 = null;
        }
        ArrayList<TestbedBuilder> res = new ArrayList<TestbedBuilder>();
        for (OrganisationBuilder organisationBuilder : organisationBuildersById.values()) {
            Organisation organisation = organisationBuilder.create();
            assert (organisationBuilder.getTestbedBuilders() != null);
            for (TestbedBuilder testbedBuilder : organisationBuilder.getTestbedBuilders()) {
                testbedBuilder.setOrganisation(organisation);
                res.add(testbedBuilder);
            }
        }
        for (TestbedBuilder testbedBuilder : noOrganisationTestbedBuilders) {
            res.add(testbedBuilder);
        }
        h.close();
        return res;
    }

    private F4FFederationStatus federationStatusFromJsonString(String json) {
        if (json == null) {
            return null;
        }
        try {
            return (F4FFederationStatus)MAPPER.readValue(json, F4FFederationStatus.class);
        }
        catch (JsonProcessingException e) {
            throw new WebApplicationException("Error converting F4FFederationStatus from JSON \"" + json + "\"", (Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (IOException e) {
            throw new WebApplicationException("IOException converting F4FFederationStatus from JSON", (Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private GDPRInfo gdprInfoFromJsonString(String json) {
        if (json == null) {
            return null;
        }
        try {
            return (GDPRInfo)MAPPER.readValue(json, GDPRInfo.class);
        }
        catch (JsonProcessingException e) {
            throw new WebApplicationException("Error converting GDPRInfo from JSON \"" + json + "\"", (Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (IOException e) {
            throw new WebApplicationException("IOException converting GDPRInfo from JSON", (Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private static List<Federation> idToFederation(List<String> federationIds) {
        if (federationIds == null) {
            return null;
        }
        return federationIds.stream().map(id -> TestbedDao.idToFederation(id)).collect(Collectors.toList());
    }

    private static List<FederationBuilder> idToFederationBuilder(List<String> federationIds) {
        if (federationIds == null) {
            return null;
        }
        return federationIds.stream().map(id -> TestbedDao.idToFederationBuilder(id)).collect(Collectors.toList());
    }

    private static List<Service> idToService(List<Integer> serviceIds) {
        if (serviceIds == null) {
            return null;
        }
        return serviceIds.stream().map(i -> TestbedDao.idToService(i)).collect(Collectors.toList());
    }

    private static Service idToService(Integer serviceId) {
        if (serviceId == null) {
            return null;
        }
        return ((ServiceBuilder)new ServiceBuilder().setId((Object)serviceId)).createMinimized(JsonLdObjectsMetaData.Minimization.ID_ONLY);
    }

    private static Federation idToFederation(String federationId) {
        if (federationId == null) {
            return null;
        }
        return ((FederationBuilder)new FederationBuilder().setId((Object)federationId)).createMinimized(JsonLdObjectsMetaData.Minimization.MINIMAL_ID_ONLY);
    }

    private static FederationBuilder idToFederationBuilder(String federationId) {
        if (federationId == null) {
            return null;
        }
        return (FederationBuilder)new FederationBuilder().setId((Object)federationId);
    }

    private static ServiceBuilder idToServiceBuilder(Integer serviceId) {
        if (serviceId == null) {
            return null;
        }
        return (ServiceBuilder)new ServiceBuilder().setId((Object)serviceId);
    }

    private static ServerBuilder idToServerBuilder(Integer serverId) {
        if (serverId == null) {
            return null;
        }
        return (ServerBuilder)new ServerBuilder().setId((Object)serverId);
    }

    static {
        MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, true);
    }
}

