/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.resource;

import be.iminds.ilabt.jfed.fedmon.webapi.base.AbstractWebApiConfigurationIface;
import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonAccess;
import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonWebApiServiceConfiguration;
import be.iminds.ilabt.jfed.fedmon.webapi.service.dao.GuiConfigSetDao;
import be.iminds.ilabt.jfed.fedmon.webapi.service.dao.UserConfigSetMappingDao;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.GuiConfigSet;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.GuiConfigSetBuilder;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import be.iminds.ilabt.util.jsonld.iface.JsonLdObjectBuilder;
import com.codahale.metrics.annotation.Timed;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.dropwizard.jackson.Jackson;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.NotNull;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import javax.ws.rs.core.UriInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/guiconfigset")
@Produces(value={"application/json"})
public class GuiConfigSetResource {
    private static final Logger LOG = LoggerFactory.getLogger(GuiConfigSetResource.class);
    @Context
    UriInfo uriInfo;
    private final GuiConfigSetDao guiConfigSetDao;
    private final UserConfigSetMappingDao userConfigSetMappingDao;
    private final FedmonWebApiServiceConfiguration configuration;
    private static final ObjectMapper MAPPER = Jackson.newObjectMapper();

    public GuiConfigSetResource(GuiConfigSetDao guiConfigSetDao, UserConfigSetMappingDao userConfigSetMappingDao, FedmonWebApiServiceConfiguration configuration) {
        this.guiConfigSetDao = guiConfigSetDao;
        this.userConfigSetMappingDao = userConfigSetMappingDao;
        this.configuration = configuration;
    }

    @GET
    @Produces(value={"*/*"})
    @Timed
    public Response all(@Nullable @QueryParam(value="userUrn") String userUrn, @Context HttpServletRequest request) {
        List<GuiConfigSet> resBase;
        this.configuration.assureAccessAllowed(FedmonAccess.ADMIN, request);
        TreeSet<String> limitToIds = null;
        if (userUrn != null) {
            GeniUrn parsedUserUrn = GeniUrn.parse((String)userUrn);
            if (parsedUserUrn == null) {
                throw new BadRequestException("Invalid URN in query: '" + userUrn + "'");
            }
            limitToIds = new TreeSet<String>(this.userConfigSetMappingDao.getGuiConfigSetIdFromUserUrn(parsedUserUrn.getEncodedTopLevelAuthority(), parsedUserUrn.getEncodedResourceName()));
        }
        if ((resBase = this.guiConfigSetDao.findAll()) == null) {
            return null;
        }
        final ArrayList<GuiConfigSet> res = new ArrayList<GuiConfigSet>(resBase.size());
        for (GuiConfigSet base : resBase) {
            if (limitToIds != null && !limitToIds.contains(base.getId())) continue;
            GuiConfigSetBuilder guiConfigSetBuilder = new GuiConfigSetBuilder(base);
            this.setUris(guiConfigSetBuilder);
            res.add(guiConfigSetBuilder.create());
        }
        boolean acceptJson = false;
        String acceptHeader = request.getHeader("Accept");
        if (acceptHeader != null) {
            acceptJson = acceptHeader.equalsIgnoreCase("application/json");
        }
        if (acceptJson) {
            StreamingOutput stream = new StreamingOutput(){

                public void write(OutputStream os) throws IOException, WebApplicationException {
                    MAPPER.writer().writeValue(os, (Object)res);
                }
            };
            return Response.ok((Object)stream, (String)"application/json").build();
        }
        Object flagHtml = "<dl class=\"dl-horizontal\">\n";
        for (GuiConfigSet guiConfigSet : res) {
            flagHtml = (String)flagHtml + "  <dt><a href=\"https://flsmonitor-api.fed4fire.eu:9443/guiconfigset/" + (String)guiConfigSet.getId() + "\" target=\"_blank\">" + (String)guiConfigSet.getId() + "</a></dt>\n";
            if (guiConfigSet.getDescription() != null) {
                flagHtml = (String)flagHtml + "  <dd>" + guiConfigSet.getDescription() + "</dd>\n";
                continue;
            }
            flagHtml = (String)flagHtml + "  <dd><small>(no description)</small></dd>\n";
        }
        flagHtml = (String)flagHtml + "</dl>\n";
        String htmlRes = "<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \n\"http://www.w3.org/TR/html4/loose.dtd\">\n<html>\n<head>\n<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">\n<link rel=\"stylesheet\" href=\"https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/4.0.0-alpha.6/css/bootstrap.min.css\">\n<title>All Gui Config Flags</title>\n</head>\n<body>\n<h1>All Gui Config Flags</h1>\n" + (String)flagHtml + "\n</body>\n</html>";
        return Response.ok((Object)htmlRes, (String)"text/html").build();
    }

    @GET
    @Path(value="{id}")
    @Timed
    public GuiConfigSet get(@NotNull @PathParam(value="id") String id, @Context HttpServletRequest request) {
        this.configuration.assureAccessAllowed(FedmonAccess.ADMIN, request);
        GuiConfigSet res = this.guiConfigSetDao.findById(id);
        if (res == null) {
            throw new NotFoundException("There is no object with id=" + id);
        }
        GuiConfigSetBuilder guiConfigSetBuilder = new GuiConfigSetBuilder(res);
        this.setUris(guiConfigSetBuilder);
        return guiConfigSetBuilder.create();
    }

    @DELETE
    @Path(value="{id}")
    @Timed
    public void delete(@NotNull @PathParam(value="id") String id, @Context HttpServletRequest request) {
        this.configuration.assureAccessAllowed(FedmonAccess.ADMIN, request);
        int deletedCount = this.guiConfigSetDao.delete(id);
        if (deletedCount == 0) {
            throw new NotFoundException("Did not find GuiConfigSet with id '" + id + "'");
        }
        if (deletedCount != 1) {
            LOG.error("SQL delete query returned " + deletedCount + " instead of 0 or 1");
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @PUT
    @Path(value="{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Timed
    public GuiConfigSet update(@NotNull @PathParam(value="id") String id, @NotNull GuiConfigSet guiConfigSet, @Context HttpServletRequest request) {
        this.configuration.assureAccessAllowed(FedmonAccess.ADMIN, request);
        if (guiConfigSet.getId() == null || !((String)guiConfigSet.getId()).equals(id)) {
            throw new WebApplicationException("ID of provided GuiConfigSet differs with ID in request URL path", Response.Status.BAD_REQUEST);
        }
        this.guiConfigSetDao.update(guiConfigSet);
        return this.get(id, request);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Timed
    public GuiConfigSet insert(@NotNull GuiConfigSet guiConfigSet, @Context HttpServletRequest request) {
        this.configuration.assureAccessAllowed(FedmonAccess.ADMIN, request);
        if (guiConfigSet.getId() == null || ((String)guiConfigSet.getId()).trim().isEmpty()) {
            throw new WebApplicationException("ID is required for new GuiConfigSet", Response.Status.BAD_REQUEST);
        }
        if (((String)guiConfigSet.getId()).length() < 3) {
            throw new WebApplicationException("ID \"" + (String)guiConfigSet.getId() + "\" for new GuiConfigSet is too short (min 3 chars)", Response.Status.BAD_REQUEST);
        }
        if (!((String)guiConfigSet.getId()).matches("[a-zA-Z]*[a-zA-Z0-9_-]*")) {
            throw new WebApplicationException("ID \"" + (String)guiConfigSet.getId() + "\" for new GuiConfigSet contains forbidden characters", Response.Status.BAD_REQUEST);
        }
        String newId = this.guiConfigSetDao.insert(guiConfigSet);
        if (newId == null) {
            throw new RuntimeException("Exception inserting GuiConfigSet");
        }
        if (!newId.equals(guiConfigSet.getId())) {
            throw new RuntimeException("Requested ID \"" + (String)guiConfigSet.getId() + "\" was not assigned to new GuiConfigSet, \"" + newId + "\" was assigned instead!");
        }
        return this.get(newId, request);
    }

    private GuiConfigSetBuilder setUris(GuiConfigSetBuilder builder) {
        this.configuration.getUriTool(AbstractWebApiConfigurationIface.UriType.AUTHENTICATED_HTTPS).setUriRecursive((JsonLdObjectBuilder)builder);
        return builder;
    }

    static {
        MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, true);
    }
}

