/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.resource;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Graph;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Result;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ServerGlimpse;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ServerGlimpseBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ServerGlimpseBuilder_v1;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ServerGlimpse_v1;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Task;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestDefinitionBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestInstance;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestInstanceBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestInstanceStatistics;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestInstanceStatisticsBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Testbed;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestbedBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.UserInfo;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.UserInfoBuilder;
import be.iminds.ilabt.util.jsonld.UriTool;
import be.iminds.ilabt.util.jsonld.iface.JsonLdObjectBuilder;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.Map;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchUriGenerator
implements UriTool.DerivedUriGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(SearchUriGenerator.class);

    public void addDerivedUri(JsonLdObjectBuilder builder, UriTool uriTool) {
        TestDefinitionBuilder testDefinitionBuilder;
        String testDefinitionId;
        TestInstanceBuilder testInstanceBuilder;
        Integer testInstanceId;
        TestbedBuilder testbedBuilder;
        String testbedId;
        Class<?> builderClass = builder.getClass();
        if (builderClass.equals(TestbedBuilder.class) && (testbedId = (String)(testbedBuilder = (TestbedBuilder)builder).getId()) != null) {
            testbedBuilder.setResultsUri(SearchUriGenerator.getResultSearchUri(true, null, testbedId, uriTool));
            testbedBuilder.setTestInstancesUri(SearchUriGenerator.getTestInstanceSearchUri(null, testbedId, false, uriTool));
        }
        if (builderClass.equals(TestInstanceBuilder.class) && (testInstanceId = (Integer)(testInstanceBuilder = (TestInstanceBuilder)builder).getId()) != null) {
            testInstanceBuilder.setResultsUri(SearchUriGenerator.getResultSearchUri(false, testInstanceId, null, uriTool));
            testInstanceBuilder.setGraphsUri(SearchUriGenerator.getGraphSearchUri(testInstanceId, uriTool));
        }
        if (builderClass.equals(TestDefinitionBuilder.class) && (testDefinitionId = (String)(testDefinitionBuilder = (TestDefinitionBuilder)builder).getId()) != null) {
            testDefinitionBuilder.setTestInstancesUri(SearchUriGenerator.getTestInstanceSearchUri(testDefinitionId, null, false, uriTool));
        }
    }

    public void addForeignUri(JsonLdObjectBuilder builder, UriTool uriTool) {
        ServerGlimpseBuilder sgBuilder;
        URI uri;
        if (builder instanceof TestInstanceStatisticsBuilder) {
            TestInstanceStatisticsBuilder tisBuilder = (TestInstanceStatisticsBuilder)builder;
            if (tisBuilder.getTestInstanceId() == null) {
                LOG.warn("addDerivedUri called on TestInstanceStatisticsBuilder without TestInstance ID");
            } else {
                uri = uriTool.getUriUsingFedmonObject(TestInstanceStatistics.class, (Object)tisBuilder.getTestInstanceId());
                tisBuilder.setUri(uri);
            }
        }
        if (builder instanceof ServerGlimpseBuilder) {
            sgBuilder = (ServerGlimpseBuilder)builder;
            if (sgBuilder.getServerId() == null) {
                LOG.warn("addDerivedUri called on ServerGlimpseBuilder without Server ID");
            } else {
                uri = uriTool.getUriUsingFedmonObject(ServerGlimpse.class, (Object)sgBuilder.getServerId());
                sgBuilder.setUri(uri);
            }
        }
        if (builder instanceof ServerGlimpseBuilder_v1) {
            sgBuilder = (ServerGlimpseBuilder_v1)builder;
            if (sgBuilder.getServerId() == null) {
                LOG.warn("addDerivedUri called on ServerGlimpseBuilder without Server ID");
            } else {
                uri = uriTool.getUriUsingFedmonObject(ServerGlimpse_v1.class, (Object)sgBuilder.getServerId());
                sgBuilder.setUri(uri);
            }
        }
    }

    public static URI getTestInstanceSearchUri(String testDefinitionId, String testbedId, boolean enabledOnly, UriTool uriTool) {
        URI base = uriTool.getUriUsingFedmonObject(TestInstance.class, null);
        try {
            Object extra = "?";
            if (enabledOnly) {
                extra = (String)extra + "enabled=true";
            }
            if (testDefinitionId != null) {
                if (((String)extra).length() > 1) {
                    extra = (String)extra + "&";
                }
                extra = (String)extra + "testdefinitionname=" + testDefinitionId;
            }
            if (testbedId != null) {
                if (((String)extra).length() > 1) {
                    extra = (String)extra + "&";
                }
                extra = (String)extra + "testbed=" + testbedId;
            }
            return new URI(base + (String)extra);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Failed to create valid URI for testDefinitionId=\"" + testDefinitionId + "\" testbedId=\"" + testbedId + "\" enabled=" + enabledOnly, e);
        }
    }

    public static URI getResultSearchUri(boolean lastOnly, @Nullable Integer testInstanceId, String testbedId, UriTool uriTool) {
        URI base = uriTool.getUriUsingFedmonObject(Result.class, null);
        try {
            Object extra = "?";
            if (lastOnly) {
                extra = (String)extra + "last=1";
            }
            if (testInstanceId != null) {
                if (((String)extra).length() > 1) {
                    extra = (String)extra + "&";
                }
                extra = (String)extra + "testinstanceid=" + testInstanceId;
            }
            if (testbedId != null) {
                if (((String)extra).length() > 1) {
                    extra = (String)extra + "&";
                }
                extra = (String)extra + "testbed=" + testbedId;
            }
            return new URI(base + (String)extra);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Failed to create valid URI for lastOnly=" + lastOnly + " testInstanceId=\"" + testInstanceId + "\" testbedId=\"" + testbedId + "\"", e);
        }
    }

    public static URI getGraphSearchUri(Integer testInstanceId, UriTool uriTool) {
        URI base = uriTool.getUriUsingFedmonObject(Graph.class, null);
        try {
            Object extra = "?";
            if (testInstanceId != null) {
                if (((String)extra).length() > 1) {
                    extra = (String)extra + "&";
                }
                extra = (String)extra + "testinstanceid=" + testInstanceId;
            }
            return new URI(base + (String)extra);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Failed to create valid URI for testInstanceId=\"" + testInstanceId + "\"", e);
        }
    }

    public static URI getTestbedEmbedUri(UriTool uriTool) {
        URI base = uriTool.getUriUsingFedmonObject(Testbed.class, null);
        try {
            String extra = "?embed=true";
            return new URI(base.toASCIIString() + extra);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Failed to create valid URI for testbeds with embed", e);
        }
    }

    public static URI getGuiConfigUri(UriTool uriTool) {
        UserInfo defaultUserInfo = new UserInfoBuilder().setUrn("urn:publicid:IDN+wall2.ilabt.iminds.be+user+ftester").create();
        return SearchUriGenerator.getGuiConfigUri(defaultUserInfo, uriTool);
    }

    public static URI getGuiConfigUri(UserInfo userInfo, UriTool uriTool) {
        String baseUrl = uriTool.getBaseUrlString();
        assert (baseUrl != null);
        assert (baseUrl.endsWith("/"));
        URI base = null;
        try {
            base = new URI(baseUrl + "guiconfig");
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Failed to create guiconfig URI using baseUrl=\"" + baseUrl + "\"", e);
        }
        try {
            boolean first = true;
            Object extra = "";
            for (Map.Entry e : userInfo.getQueryParameters().entrySet()) {
                if (first) {
                    extra = (String)extra + "?";
                    first = false;
                } else {
                    extra = (String)extra + "&";
                }
                String key = URLEncoder.encode((String)e.getKey(), "UTF-8");
                String value = URLEncoder.encode(e.getValue().toString(), "UTF-8");
                extra = (String)extra + key + "=" + value;
            }
            return new URI(base.toASCIIString() + (String)extra);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Failed to create valid URI", e);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Failed to create valid URI", e);
        }
    }

    public static URI getTaskSearchUri(Boolean active, Boolean expired, Integer last, UriTool uriTool) {
        URI base = uriTool.getUriUsingFedmonObject(Task.class, null);
        try {
            Object extra = "?";
            if (active.booleanValue()) {
                extra = (String)extra + "active=true";
            }
            if (expired.booleanValue()) {
                if (((String)extra).length() > 1) {
                    extra = (String)extra + "&";
                }
                extra = (String)extra + "expired=true";
            }
            if (last != null) {
                if (((String)extra).length() > 1) {
                    extra = (String)extra + "&";
                }
                extra = (String)extra + "last=" + last;
            }
            return new URI(base + (String)extra);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Failed to create valid URI for testbeds with embed", e);
        }
    }
}

