/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.resource;

import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonAccess;
import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonWebApiServiceConfiguration;
import be.iminds.ilabt.jfed.fedmon.webapi.service.dao.TestDefinitionDao;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestDefinition;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestDefinitionBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.resource.SharedResourceCache;
import be.iminds.ilabt.util.jsonld.iface.JsonLdObjectBuilder;
import com.codahale.metrics.annotation.Timed;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.NotNull;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@Path(value="/testdefinition")
@Produces(value={"application/json"})
public class TestDefinitionResource {
    @Context
    UriInfo uriInfo;
    private final TestDefinitionDao testDefinitionDAO;
    private final FedmonWebApiServiceConfiguration configuration;
    private final SharedResourceCache sharedResourceCache;

    public TestDefinitionResource(TestDefinitionDao testDefinitionDAO, FedmonWebApiServiceConfiguration configuration, SharedResourceCache sharedResourceCache) {
        this.testDefinitionDAO = testDefinitionDAO;
        this.configuration = configuration;
        this.sharedResourceCache = sharedResourceCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Path(value="{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Timed
    public TestDefinition update(@NotNull @PathParam(value="id") String id, TestDefinition testDefinition, @Context HttpServletRequest request) {
        this.configuration.assureAccessAllowed(FedmonAccess.ADMIN, request);
        if (id == null) {
            throw new BadRequestException("Path ID cannot be null");
        }
        if (testDefinition.getId() == null) {
            throw new BadRequestException("Provided TestDefinition ID may not be null");
        }
        if (!id.equals(testDefinition.getId())) {
            throw new BadRequestException("Path ID (" + id + ") does not match ID of provided TestDefinition (" + (String)testDefinition.getId() + ")");
        }
        if (testDefinition.getType() == null) {
            throw new BadRequestException("You need to specify a type for the testdefinition");
        }
        if (testDefinition.getMaxTestDurationMs() == null) {
            throw new BadRequestException("You need to specify maxTestDurationMs for the testdefinition");
        }
        SharedResourceCache.SingleResourceCache<String, TestDefinition> singleResourceCache = this.sharedResourceCache.getTestDefinitionCache();
        synchronized (singleResourceCache) {
            try {
                this.testDefinitionDAO.update(testDefinition);
            }
            finally {
                this.sharedResourceCache.getTestDefinitionCache().invalidateAllAndSingle(id);
            }
        }
        return this.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Timed
    public TestDefinition insert(@NotNull TestDefinition testDefinition, @Context HttpServletRequest request) {
        TestDefinition r;
        this.configuration.assureAccessAllowed(FedmonAccess.ADMIN, request);
        if (testDefinition.getId() == null) {
            throw new BadRequestException("You need to specify an ID for the testdefinition (a unique String)");
        }
        if (testDefinition.getType() == null) {
            throw new BadRequestException("You need to specify a type for the testdefinition");
        }
        if (testDefinition.getMaxTestDurationMs() == null) {
            throw new BadRequestException("You need to specify maxTestDurationMs for the testdefinition");
        }
        SharedResourceCache.SingleResourceCache<String, TestDefinition> singleResourceCache = this.sharedResourceCache.getTestDefinitionCache();
        synchronized (singleResourceCache) {
            try {
                this.testDefinitionDAO.insert(testDefinition);
                TestDefinitionBuilder res = new TestDefinitionBuilder(testDefinition);
                this.configuration.getUriTool().setUriRecursive((JsonLdObjectBuilder)res);
                r = res.create();
                this.sharedResourceCache.getTestDefinitionCache().update(r);
            }
            catch (Throwable t) {
                this.sharedResourceCache.getTestDefinitionCache().invalidateFull();
                throw t;
            }
        }
        return r;
    }

    @GET
    @Timed
    public List<TestDefinition> getAll() {
        return this.sharedResourceCache.getTestDefinitionCache().getAll();
    }

    @GET
    @Path(value="{id}")
    @Timed
    public TestDefinition get(@NotNull @PathParam(value="id") String id) {
        return this.sharedResourceCache.getTestDefinitionCache().getById(id);
    }

    @DELETE
    @Path(value="{name}")
    @Timed
    public void delete(@NotNull @PathParam(value="name") String name, @Context HttpServletRequest request) {
        this.configuration.assureAccessAllowed(FedmonAccess.ADMIN, request);
        this.sharedResourceCache.getTestDefinitionCache().invalidateAllAndSingle(name);
        throw new WebApplicationException("not yet implemented (and probably will never be implemented)", Response.Status.NOT_IMPLEMENTED);
    }
}

