/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.resource;

import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonAccess;
import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonWebApiServiceConfiguration;
import be.iminds.ilabt.jfed.fedmon.webapi.service.dao.TestInstanceDao;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestDefinition;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestDefinitionParameter;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestInstance;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestInstanceBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.resource.ResourceCommon;
import be.iminds.ilabt.jfed.fedmon.webapi.service.resource.SharedResourceCache;
import be.iminds.ilabt.util.jsonld.JsonLdObjectsMetaData;
import be.iminds.ilabt.util.jsonld.iface.JsonLdObject;
import be.iminds.ilabt.util.jsonld.iface.JsonLdObjectBuilder;
import com.codahale.metrics.annotation.Timed;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.NotNull;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/testinstance")
@Produces(value={"application/json"})
public class TestInstanceResource {
    private static final Logger LOG = LoggerFactory.getLogger(TestInstanceResource.class);
    @Context
    UriInfo uriInfo;
    private final TestInstanceDao testinstanceDAO;
    private final FedmonWebApiServiceConfiguration configuration;
    private final SharedResourceCache sharedResourceCache;

    public TestInstanceResource(TestInstanceDao testinstanceDAO, FedmonWebApiServiceConfiguration configuration, SharedResourceCache sharedResourceCache) {
        this.testinstanceDAO = testinstanceDAO;
        this.configuration = configuration;
        this.sharedResourceCache = sharedResourceCache;
    }

    private void checkTestInstance(TestInstance testInstance) throws BadRequestException {
        TestDefinition testDefinition;
        if (testInstance.getName() == null) {
            throw new BadRequestException("TestInstance.name is a required field");
        }
        if (testInstance.getEnabled() == null) {
            throw new BadRequestException("TestInstance.enabled is a required field");
        }
        if (testInstance.getTestVersion() == null) {
            throw new BadRequestException("TestInstance.testVersion is a required field");
        }
        if (testInstance.getTestDefinition() == null) {
            throw new BadRequestException("TestInstance.testDefinition is a required field");
        }
        if (testInstance.getTestDefinition().getId() == null) {
            throw new BadRequestException("TestInstance.testDefinition must have an ID");
        }
        try {
            testDefinition = this.sharedResourceCache.getTestDefinitionCache().getById((String)testInstance.getTestDefinition().getId());
            if (testDefinition == null) {
                throw new InternalServerErrorException("Internal error: null returned for TestInstance.testDefinition \"" + (String)testInstance.getTestDefinition().getId() + "\"");
            }
        }
        catch (NotFoundException e) {
            throw new BadRequestException("TestInstance.testDefinition \"" + (String)testInstance.getTestDefinition().getId() + "\" not found");
        }
        catch (WebApplicationException e) {
            throw new InternalServerErrorException("Internal exception while fetching TestInstance.testDefinition \"" + (String)testInstance.getTestDefinition().getId() + "\"");
        }
        HashSet<String> allowedParameterNames = new HashSet<String>();
        allowedParameterNames.add("test_class");
        allowedParameterNames.add("test_group");
        if (testDefinition.getParameters() != null) {
            for (TestDefinitionParameter testDefinitionParameter : testDefinition.getParameters()) {
                if (testDefinitionParameter.isNonNullValueRequired() && testDefinitionParameter.getDefaultValue() == null && testInstance.getParameter(testDefinitionParameter.getName()) == null) {
                    throw new BadRequestException("a TestInstance with TestDefinition \"" + (String)testInstance.getTestDefinition().getId() + "\" must always specify a \"" + testDefinitionParameter.getName() + "\" parameter");
                }
                allowedParameterNames.add(testDefinitionParameter.getName());
            }
        }
        if (testInstance.getParameters() != null) {
            for (Map.Entry entry : testInstance.getParameters().entrySet()) {
                String paramName = (String)entry.getKey();
                if (allowedParameterNames.contains(paramName)) continue;
                throw new BadRequestException("a TestInstance with TestDefinition \"" + (String)testInstance.getTestDefinition().getId() + "\" can not have a \"" + paramName + "\" parameter");
            }
        }
        if (testInstance.getFrequencyId() == null) {
            throw new BadRequestException("TestInstance.frequency is a required field");
        }
    }

    @PUT
    @Path(value="{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Timed
    public TestInstance update(@NotNull @PathParam(value="id") Integer id, TestInstance testInstance, @Context HttpServletRequest request) {
        this.configuration.assureAccessAllowed(FedmonAccess.ADMIN, request);
        if (id == null) {
            throw new BadRequestException("Path ID cannot be null");
        }
        if (testInstance.getId() == null) {
            throw new BadRequestException("Provided TestInstance ID may not be null");
        }
        if (!id.equals(testInstance.getId())) {
            throw new BadRequestException("Path ID (" + id + ") does not match ID of provided TestInstance (" + testInstance.getId() + ")");
        }
        this.checkTestInstance(testInstance);
        this.testinstanceDAO.update(testInstance);
        return this.get(id);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Timed
    public TestInstance insert(@NotNull TestInstance testInstance, @Context HttpServletRequest request) {
        this.configuration.assureAccessAllowed(FedmonAccess.ADMIN, request);
        this.checkTestInstance(testInstance);
        Integer newId = this.testinstanceDAO.insert(testInstance);
        TestInstanceBuilder res = (TestInstanceBuilder)new TestInstanceBuilder(testInstance).setId((Object)newId);
        this.configuration.getUriTool().setUriRecursive((JsonLdObjectBuilder)res);
        return res.create();
    }

    @GET
    @Timed
    public List<TestInstance> search(@QueryParam(value="testversionname") String versionNameArgString, @QueryParam(value="testname") String testInstanceNameArgString, @QueryParam(value="testdefinitionname") String testDefinitionNameArgString, @QueryParam(value="testinstanceid") String testInstanceIdArgString, @QueryParam(value="testbedcategory") String testbedCategoryArgString, @QueryParam(value="geni_testbed") String testbedGeniNameArgString, @QueryParam(value="testbed") String testbedNameArgString, @QueryParam(value="testbed_urn") String testbedUrnNamesArgString, @QueryParam(value="nextrun") String nextRunArg, @QueryParam(value="enabled") String enabledArg, @QueryParam(value="disabled") String disabledArg, @QueryParam(value="activeTasks") String hasActiveTasksArg, @QueryParam(value="user") String userIdArgString, @QueryParam(value="server") String serverIdArgString) {
        List<String> versionNameFilter = ResourceCommon.parseArg(versionNameArgString);
        List<String> testInstanceNameFilter = ResourceCommon.parseArg(testInstanceNameArgString);
        List<String> testDefinitionNameFilter = ResourceCommon.parseArg(testDefinitionNameArgString);
        List<Integer> testInstanceIdFilter = ResourceCommon.parseIntListArg(testInstanceIdArgString);
        List<String> testbedCategoryFilter = ResourceCommon.parseArg(testbedCategoryArgString);
        List<String> testbedGeniNameFilter = ResourceCommon.parseArg(testbedGeniNameArgString);
        List<String> testbedNameFilter = ResourceCommon.parseArg(testbedNameArgString);
        List<String> testbedUrnNames = ResourceCommon.parseArg(testbedUrnNamesArgString);
        List<String> userIds = ResourceCommon.parseArg(userIdArgString);
        List<Integer> serverIds = ResourceCommon.parseIntListArg(serverIdArgString);
        LOG.debug("testbedNameFilter=" + testbedNameFilter);
        if (disabledArg != null && enabledArg != null && ResourceCommon.parameterTruth(disabledArg) == ResourceCommon.parameterTruth(enabledArg)) {
            throw new WebApplicationException("disabled and enabled query parameter conflict", Response.Status.BAD_REQUEST);
        }
        Boolean disabled = disabledArg == null ? ResourceCommon.parameterTruthOrNull(enabledArg) : ResourceCommon.parameterTruthOrNull(disabledArg);
        Boolean nextRunHelper = ResourceCommon.parameterTruthOrNull(nextRunArg);
        List<TestInstance> resBase = this.testinstanceDAO.search(versionNameFilter, testInstanceNameFilter, testDefinitionNameFilter, testInstanceIdFilter, testbedCategoryFilter, testbedGeniNameFilter, testbedNameFilter, testbedUrnNames, nextRunHelper == null ? false : nextRunHelper, disabled, ResourceCommon.parameterTruthOrNull(hasActiveTasksArg), userIds, serverIds);
        ArrayList<TestInstance> res = new ArrayList<TestInstance>(resBase.size());
        for (TestInstance ti : resBase) {
            res.add(this.minimize(this.addUris(this.uriInfo, ti)));
        }
        return res;
    }

    @GET
    @Path(value="{id}")
    @Timed
    public TestInstance get(@NotNull @PathParam(value="id") Integer id) {
        TestInstance res = this.testinstanceDAO.findById(id);
        if (res == null) {
            throw new NotFoundException("There is no object with id=" + id);
        }
        return this.minimize(this.addUris(this.uriInfo, res));
    }

    @DELETE
    @Path(value="{id}")
    @Timed
    public void delete(@NotNull @PathParam(value="id") Integer id, @Context HttpServletRequest request) {
        this.configuration.assureAccessAllowed(FedmonAccess.ADMIN, request);
        this.testinstanceDAO.deleteById(id);
    }

    public TestInstance minimize(TestInstance orig) {
        return TestInstanceBuilder.minimize((JsonLdObjectsMetaData.Minimization)JsonLdObjectsMetaData.Minimization.FULL_WITH_MINIMAL_LINK_IDS, (TestInstance)orig);
    }

    public TestInstance addUris(UriInfo uriInfo, TestInstance orig) {
        assert (uriInfo != null);
        assert (orig != null);
        assert (orig.getId() != null);
        return (TestInstance)this.configuration.getUriTool().setUriRecursive((JsonLdObject)orig);
    }
}

