/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.resource;

import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonAccess;
import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonWebApiServiceConfiguration;
import be.iminds.ilabt.jfed.fedmon.webapi.service.dao.TestbedCategoryDao;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestbedCategory;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestbedCategoryBuilder;
import be.iminds.ilabt.util.jsonld.JsonLdObjectsMetaData;
import be.iminds.ilabt.util.jsonld.iface.JsonLdObjectBuilder;
import com.codahale.metrics.annotation.Timed;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@Path(value="/testbedcategory")
@Produces(value={"application/json"})
public class TestbedCategoryResource {
    @Context
    UriInfo uriInfo;
    private final TestbedCategoryDao testbedCategoryDAO;
    private final FedmonWebApiServiceConfiguration configuration;

    public TestbedCategoryResource(TestbedCategoryDao testbedCategoryDAO, FedmonWebApiServiceConfiguration configuration) {
        this.testbedCategoryDAO = testbedCategoryDAO;
        this.configuration = configuration;
    }

    @PUT
    @Path(value="{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Timed
    public TestbedCategory update(@NotNull @PathParam(value="id") Integer id, TestbedCategory testbedCategory, @Context HttpServletRequest request) {
        this.configuration.assureAccessAllowed(FedmonAccess.ADMIN, request);
        throw new WebApplicationException("not yet implemented", Response.Status.NOT_IMPLEMENTED);
    }

    @GET
    @Timed
    public List<TestbedCategory> getAll() {
        List<TestbedCategory> resBase = this.testbedCategoryDAO.findAll();
        ArrayList<TestbedCategory> res = new ArrayList<TestbedCategory>();
        for (TestbedCategory tc : resBase) {
            TestbedCategoryBuilder testbedCategoryBuilder = new TestbedCategoryBuilder(tc);
            testbedCategoryBuilder = this.addUris(testbedCategoryBuilder);
            res.add(this.createMinimized(testbedCategoryBuilder));
        }
        return res;
    }

    @GET
    @Path(value="{id}")
    @Timed
    public TestbedCategory get(@NotNull @PathParam(value="id") Integer id) {
        TestbedCategory res = this.testbedCategoryDAO.findById(id);
        if (res == null) {
            throw new NotFoundException("There is no object with id=" + id);
        }
        TestbedCategoryBuilder testbedCategoryBuilder = new TestbedCategoryBuilder(res);
        testbedCategoryBuilder = this.addUris(testbedCategoryBuilder);
        return this.createMinimized(testbedCategoryBuilder);
    }

    @DELETE
    @Path(value="{id}")
    @Timed
    public void delete(@NotNull @PathParam(value="id") Integer id, @Context HttpServletRequest request) {
        this.configuration.assureAccessAllowed(FedmonAccess.ADMIN, request);
        throw new WebApplicationException("not yet implemented", Response.Status.NOT_IMPLEMENTED);
    }

    private TestbedCategory createMinimized(TestbedCategoryBuilder proxyBuilder) {
        return proxyBuilder.createMinimized(JsonLdObjectsMetaData.Minimization.FULL_WITH_MINIMAL_LINK_IDS);
    }

    public TestbedCategoryBuilder addUris(TestbedCategoryBuilder orig) {
        assert (this.uriInfo != null);
        assert (orig != null);
        assert (orig.getId() != null);
        return (TestbedCategoryBuilder)this.configuration.getUriTool().setUriRecursive((JsonLdObjectBuilder)orig);
    }
}

