/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.resource;

import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonAccess;
import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonWebApiServiceConfiguration;
import be.iminds.ilabt.jfed.fedmon.webapi.service.dao.FederationTestbedMappingDao;
import be.iminds.ilabt.jfed.fedmon.webapi.service.dao.OrganisationDao;
import be.iminds.ilabt.jfed.fedmon.webapi.service.dao.ProxyDao;
import be.iminds.ilabt.jfed.fedmon.webapi.service.dao.ServerDao;
import be.iminds.ilabt.jfed.fedmon.webapi.service.dao.ServiceDao;
import be.iminds.ilabt.jfed.fedmon.webapi.service.dao.TestbedCategoryDao;
import be.iminds.ilabt.jfed.fedmon.webapi.service.dao.TestbedDao;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.OrganisationBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Proxy;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ServerBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Service;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ServiceBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Testbed;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestbedBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.resource.ResourceCommon;
import be.iminds.ilabt.jfed.fedmon.webapi.service.resource.SharedResourceCache;
import be.iminds.ilabt.util.jsonld.JsonLdObjectsMetaData;
import be.iminds.ilabt.util.jsonld.impl.PrimaryIdObject;
import com.codahale.metrics.annotation.Timed;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import jersey.repackaged.com.google.common.cache.CacheBuilder;
import jersey.repackaged.com.google.common.cache.CacheLoader;
import jersey.repackaged.com.google.common.cache.LoadingCache;
import jersey.repackaged.com.google.common.util.concurrent.UncheckedExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/testbed")
@Produces(value={"application/json"})
@Singleton
public class TestbedResource {
    private static final Logger LOG = LoggerFactory.getLogger(TestbedResource.class);
    @Context
    UriInfo uriInfo;
    private final TestbedDao testbedDao;
    private final FederationTestbedMappingDao ftMappingDao;
    private final TestbedCategoryDao testbedCategoryDao;
    private final ServerDao serverDao;
    private final ServiceDao serviceDao;
    private final OrganisationDao organisationDao;
    private final ProxyDao proxyDao;
    private final FedmonWebApiServiceConfiguration configuration;
    private SharedResourceCache sharedResourceCache;
    LoadingCache<CacheKey, List<TestbedBuilder>> cache = CacheBuilder.newBuilder().maximumSize(100L).expireAfterWrite(10L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<CacheKey, List<TestbedBuilder>>(){

        public List<TestbedBuilder> load(CacheKey key) {
            if (key.isFindSingle()) {
                TestbedBuilder res = TestbedResource.this.uncachedGet(key.getId());
                return res == null ? null : Collections.singletonList(res);
            }
            if (key.isMultiSearch()) {
                return TestbedResource.this.uncachedSearch(key.getCategories(), key.getGeniNames(), key.getIds(), key.getUrns());
            }
            if (key.isFindAll()) {
                return TestbedResource.this.uncachedAll();
            }
            throw new RuntimeException("Implementation error, CacheKey not handled: " + key);
        }
    });
    private static final boolean MUNGE_INSTEAD_OF_DELETE = true;

    public void invalidateSearchCache() {
        ArrayList<CacheKey> toInvalidate = new ArrayList<CacheKey>();
        for (CacheKey key : this.cache.asMap().keySet()) {
            if (!key.isMultiSearch() && !key.isFindAll()) continue;
            toInvalidate.add(key);
        }
        this.cache.invalidateAll(toInvalidate);
        this.cache.invalidateAll();
    }

    public List<TestbedBuilder> uncachedAll() {
        return this.testbedDao.query(this.configuration.getUriTool(), null, null, null, null, null, true);
    }

    public List<TestbedBuilder> uncachedSearch(String categories, String geniNames, String ids, String urns) {
        if (CacheKey.isNotNullOrEmptyString(categories) || CacheKey.isNotNullOrEmptyString(geniNames) || CacheKey.isNotNullOrEmptyString(ids) || CacheKey.isNotNullOrEmptyString(urns)) {
            List<TestbedBuilder> res = this.testbedDao.query(this.configuration.getUriTool(), ResourceCommon.parseArg(categories), ResourceCommon.parseArg(geniNames), ResourceCommon.parseArg(ids), ResourceCommon.parseArg(urns), null, true);
            return res;
        }
        LOG.warn("uncachedSearch called with all empty parameters");
        return this.uncachedAll();
    }

    public TestbedBuilder uncachedGet(@NotNull String id) {
        List<TestbedBuilder> resList = this.testbedDao.query(this.configuration.getUriTool(), null, null, null, null, id, true);
        if (resList == null) {
            throw new WebApplicationException("Internal error: Null while searching Testbed with ID " + id + ". resList == null", Response.Status.INTERNAL_SERVER_ERROR);
        }
        if (resList.isEmpty()) {
            throw new NotFoundException("There is no object with id=" + id);
        }
        if (resList.size() != 1) {
            throw new WebApplicationException("Internal error: Multiple Testbeds found while searching Testbed with ID " + id + ". resList.size()==" + resList.size(), Response.Status.INTERNAL_SERVER_ERROR);
        }
        return resList.get(0);
    }

    public TestbedResource(TestbedDao testbedDao, TestbedCategoryDao testbedCategoryDao, ServerDao serverDao, ServiceDao serviceDao, OrganisationDao organisationDao, ProxyDao proxyDao, FederationTestbedMappingDao ftMappingDao, FedmonWebApiServiceConfiguration configuration) {
        this.testbedDao = testbedDao;
        this.testbedCategoryDao = testbedCategoryDao;
        this.serverDao = serverDao;
        this.serviceDao = serviceDao;
        this.organisationDao = organisationDao;
        this.proxyDao = proxyDao;
        this.ftMappingDao = ftMappingDao;
        this.configuration = configuration;
    }

    public void setSharedResourceCache(SharedResourceCache sharedResourceCache) {
        this.sharedResourceCache = sharedResourceCache;
    }

    @PUT
    @Path(value="{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Timed
    public Testbed update(@NotNull @PathParam(value="id") String id, Testbed testbed, @Context HttpServletRequest request) {
        this.configuration.assureAccessAllowed(FedmonAccess.ADMIN, request);
        if (testbed.getId() == null || !((String)testbed.getId()).equals(id)) {
            throw new WebApplicationException("ID of provided Testbed differs with ID in request URL path", Response.Status.BAD_REQUEST);
        }
        if (testbed.getServers() != null) {
            throw new WebApplicationException("You may not specify servers in a Testbed update request", Response.Status.BAD_REQUEST);
        }
        if (testbed.getProxies() != null) {
            throw new WebApplicationException("Testbed update does not yet implement editing proxies", Response.Status.NOT_IMPLEMENTED);
        }
        this.testbedDao.update(testbed);
        if (testbed.getFederations() != null) {
            this.ftMappingDao.updateFederationsForTestbed((String)testbed.getId(), testbed.getFederations().stream().map(PrimaryIdObject::getId).collect(Collectors.toList()));
            this.sharedResourceCache.getFederationCache().invalidateFull();
        }
        if (testbed.getCategories() != null) {
            this.testbedCategoryDao.setCategoryIdsForTestbed((String)testbed.getId(), testbed.getCategories().stream().map(PrimaryIdObject::getId).collect(Collectors.toList()));
        }
        this.invalidateSearchCache();
        return this.get(id, false, request);
    }

    @PUT
    @Path(value="{id}/categories")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Timed
    public List<URI> updateCategories(@NotNull @PathParam(value="id") String testbedId, @NotNull List<URI> newCategories, @Context HttpServletRequest request) {
        this.configuration.assureAccessAllowed(FedmonAccess.ADMIN, request);
        if (newCategories == null) {
            throw new WebApplicationException("must provide list of new categories", Response.Status.BAD_REQUEST);
        }
        List<Integer> newCategoryIds = newCategories.stream().map(u -> (Integer)this.configuration.getJsonLdObjectsMetaData().getIdFromUri(u)).collect(Collectors.toList());
        this.testbedCategoryDao.setCategoryIdsForTestbed(testbedId, newCategoryIds);
        this.invalidateSearchCache();
        return this.getCategories(testbedId, request);
    }

    @GET
    @Path(value="{id}/categories")
    @Produces(value={"application/json"})
    @Timed
    public List<URI> getCategories(@NotNull @PathParam(value="id") String testbedId, @Context HttpServletRequest request) {
        CacheKey key = new CacheKey(testbedId, null, null, null, null);
        assert (!key.isMultiSearch() && !key.isFindAll());
        assert (key.isFindSingle());
        List testbedBuilders = (List)this.cache.getUnchecked((Object)key);
        if (testbedBuilders.isEmpty()) {
            throw new WebApplicationException("testbed \"" + testbedId + "\" not found", Response.Status.NOT_FOUND);
        }
        assert (testbedBuilders.size() == 1);
        if (((TestbedBuilder)testbedBuilders.get(0)).getCategories() == null) {
            return Collections.emptyList();
        }
        List<URI> categoryUris = ((TestbedBuilder)testbedBuilders.get(0)).getCategories().stream().map(PrimaryIdObject::getUri).collect(Collectors.toList());
        return categoryUris;
    }

    @PUT
    @Path(value="{id}/federations")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Timed
    public List<URI> updateFederations(@NotNull @PathParam(value="id") String testbedId, @NotNull List<URI> newFederations, @Context HttpServletRequest request) {
        this.configuration.assureAccessAllowed(FedmonAccess.ADMIN, request);
        if (newFederations == null) {
            throw new WebApplicationException("must provide list of federations", Response.Status.BAD_REQUEST);
        }
        List<String> newFederationIds = newFederations.stream().map(u -> (String)this.configuration.getJsonLdObjectsMetaData().getIdFromUri(u)).collect(Collectors.toList());
        this.ftMappingDao.updateFederationsForTestbed(testbedId, newFederationIds);
        this.invalidateSearchCache();
        this.sharedResourceCache.getFederationCache().invalidateFull();
        return this.getFederations(testbedId, request);
    }

    @GET
    @Path(value="{id}/federations")
    @Produces(value={"application/json"})
    @Timed
    public List<URI> getFederations(@NotNull @PathParam(value="id") String testbedId, @Context HttpServletRequest request) {
        CacheKey key = new CacheKey(testbedId, null, null, null, null);
        assert (!key.isMultiSearch() && !key.isFindAll());
        assert (key.isFindSingle());
        List testbedBuilders = (List)this.cache.getUnchecked((Object)key);
        if (testbedBuilders.isEmpty()) {
            throw new WebApplicationException("testbed \"" + testbedId + "\" not found", Response.Status.NOT_FOUND);
        }
        assert (testbedBuilders.size() == 1);
        if (((TestbedBuilder)testbedBuilders.get(0)).getFederations() == null) {
            return Collections.emptyList();
        }
        List<URI> federationUris = ((TestbedBuilder)testbedBuilders.get(0)).getFederations().stream().map(PrimaryIdObject::getUri).collect(Collectors.toList());
        assert (!federationUris.contains(null));
        return federationUris;
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Timed
    public Testbed create(@NotNull Testbed newTestbed, @Context HttpServletRequest request, @QueryParam(value="forceIds") boolean forceIds) {
        Object existingOrganisation;
        this.configuration.assureAccessAllowed(FedmonAccess.ADMIN, request);
        if (newTestbed.getId() == null) {
            throw new WebApplicationException("Provided testbed must have an (new and non existing) ID", Response.Status.BAD_REQUEST);
        }
        if (newTestbed.getDefaultServer() != null) {
            throw new WebApplicationException("You may not specify a default server in a create Testbed request (it will be picked automatically if you specify servers to create)", Response.Status.BAD_REQUEST);
        }
        if (newTestbed.getDefaultComponentManagerUrn() != null && newTestbed.getServers() != null && !newTestbed.getServers().isEmpty()) {
            throw new WebApplicationException("You may not specify a default component manager URN and a list of new servers in a create Testbed request (the default component manager will be picked automatically from the servers)", Response.Status.BAD_REQUEST);
        }
        if (this.testbedDao.findById(null, (String)newTestbed.getId()) != null) {
            throw new WebApplicationException("A Testbed with that ID (" + (String)newTestbed.getId() + ") already exists.", Response.Status.CONFLICT);
        }
        LOG.debug("Testbed.create: Testbed \"" + (String)newTestbed.getId() + "\" does not exist yet.");
        if (newTestbed.getOrganisation() != null && (existingOrganisation = this.organisationDao.findById((String)newTestbed.getOrganisation().getId())) == null) {
            LOG.debug("Testbed.create: Creating organisation \"" + (String)newTestbed.getOrganisation().getId() + "\"");
            this.organisationDao.insert(newTestbed.getOrganisation());
        }
        if (newTestbed.getServers() != null) {
            for (Server newServer : newTestbed.getServers()) {
                if (newServer.getId() != null && !forceIds) {
                    throw new WebApplicationException("You may not specify an ID for an embedded Server in a create Testbed request (server ID's are created automatically)", Response.Status.BAD_REQUEST);
                }
                if (newServer.getId() == null && forceIds) {
                    throw new WebApplicationException("You must specify an ID for an embedded Server in a create Testbed request if you use forceIds", Response.Status.BAD_REQUEST);
                }
                if (newServer.getDefaultAMService() != null) {
                    throw new WebApplicationException("You may not specify a default AM service in a Server in a create Testbed request (will be picked automatically)", Response.Status.BAD_REQUEST);
                }
                if (newServer.getDefaultComponentManagerUrn() != null && newServer.getServices() != null && !newServer.getServices().isEmpty()) {
                    throw new WebApplicationException("You may not specify a default component manager URN for a Server with services in a create Testbed request (will be picked automatically)", Response.Status.BAD_REQUEST);
                }
                if (newServer.getServices() == null) continue;
                for (Service newService : newServer.getServices()) {
                    if (newService.getId() != null && !forceIds) {
                        throw new WebApplicationException("You may not specify an ID for an embedded Service in a create Testbed request (server and service ID's are created automatically)", Response.Status.BAD_REQUEST);
                    }
                    if (newService.getId() != null || !forceIds) continue;
                    throw new WebApplicationException("You must specify an ID for an embedded Service in a create Testbed request if you use forceIds", Response.Status.BAD_REQUEST);
                }
            }
            LOG.debug("Testbed.create: Servers and Services check passed");
        }
        if (newTestbed.getCategories() != null && !newTestbed.getCategories().isEmpty()) {
            for (Object cat : newTestbed.getCategories()) {
                if (cat.getName() != null) continue;
                throw new WebApplicationException("You must specify a name for an embedded TestbedCategory", Response.Status.BAD_REQUEST);
            }
            LOG.debug("Testbed.create: TestbedCategory check passed");
        }
        LOG.debug("Testbed.create: Creating Testbed \"" + (String)newTestbed.getId() + "\".");
        this.testbedDao.insert(newTestbed);
        if (newTestbed.getCategories() != null && !newTestbed.getCategories().isEmpty()) {
            for (Object cat : newTestbed.getCategories()) {
                LOG.debug("Testbed.create: Adding testbed to category \"" + cat.getName() + "\".");
                this.testbedCategoryDao.addTestbedToCategory((String)newTestbed.getId(), cat.getName(), true);
            }
        }
        TestbedBuilder testbedWithDefaults = new TestbedBuilder(newTestbed);
        if (newTestbed.getServers() != null) {
            for (Server newServer : newTestbed.getServers()) {
                Integer createdServerId;
                ServerBuilder newServerBuilder = new ServerBuilder(newServer);
                newServerBuilder.setTestbed(newTestbed);
                newServerBuilder.setServices(null);
                Integer n = createdServerId = forceIds ? this.serverDao.insertWithForcedId(newServerBuilder.create()) : this.serverDao.insert(newServerBuilder.create());
                if (forceIds && !createdServerId.equals(newServerBuilder.getId())) {
                    throw new WebApplicationException("Something went wrong. Server should have forced ID " + newServerBuilder.getId() + " but has ID " + createdServerId, Response.Status.INTERNAL_SERVER_ERROR);
                }
                LOG.debug("Testbed.create: Created server " + createdServerId);
                newServerBuilder.setId((Object)createdServerId);
                newServerBuilder.setTestbed(null);
                if (newServer.getServices() != null) {
                    for (Service newService : newServer.getServices()) {
                        ServiceBuilder newServiceBuilder = new ServiceBuilder(newService);
                        newServiceBuilder.setServer(newServerBuilder.create());
                        Integer newServiceId = forceIds ? this.serviceDao.insertWithForcedId(newServiceBuilder.create()) : this.serviceDao.insert(newServiceBuilder.create());
                        LOG.debug("Testbed.create: Created service " + newServiceId + " api=" + newServiceBuilder.getApi() + " version=" + newServiceBuilder.getApiVersion());
                        if (forceIds && !newServiceId.equals(newServiceBuilder.getId())) {
                            throw new WebApplicationException("Something went wrong. Service should have forced ID " + newServiceBuilder.getId() + " but has ID " + newServiceId, Response.Status.INTERNAL_SERVER_ERROR);
                        }
                        newServiceBuilder.setId((Object)newServiceId);
                        newServiceBuilder.setServer(null);
                        if (newServerBuilder.getDefaultComponentManagerUrn() == null) {
                            newServerBuilder.setDefaultComponentManagerUrn(newServiceBuilder.getUrn());
                        }
                        if (!newServiceBuilder.getApi().equals("Geni.AM") || newServerBuilder.getDefaultAMServiceBuilder() != null && !newServiceBuilder.getApiVersion().equals("3")) continue;
                        LOG.debug("Testbed.create: Setting default AM to " + newServiceId);
                        newServerBuilder.setDefaultAMServiceBuilder(newServiceBuilder);
                        newServerBuilder.setDefaultComponentManagerUrn(newServiceBuilder.getUrn());
                    }
                    newServerBuilder.setTestbedId((String)newTestbed.getId());
                    LOG.debug("Testbed.create: Updating defaults for server " + newServerBuilder.getId());
                    Server updatedServer = newServerBuilder.create();
                    this.serverDao.update(updatedServer);
                }
                testbedWithDefaults.setDefaultServer(newServerBuilder.create());
                testbedWithDefaults.setDefaultComponentManagerUrn(newServerBuilder.getDefaultComponentManagerUrn());
            }
        }
        if (newTestbed.getProxies() != null) {
            testbedWithDefaults.setProxies(null);
            testbedWithDefaults.setProxyBuilders(null);
            for (Proxy proxy : newTestbed.getProxies()) {
                Integer proxyId = (Integer)proxy.getId();
                if (proxyId == null) {
                    if (proxy.getName() == null) {
                        throw new WebApplicationException("You must specify either the name, or the ID of each proxy", Response.Status.BAD_REQUEST);
                    }
                    Proxy foundProxy = this.proxyDao.getByName(proxy.getName());
                    if (foundProxy != null) {
                        assert (foundProxy.getId() != null);
                        proxyId = (Integer)foundProxy.getId();
                        LOG.debug("Testbed.create: Found proxy by name \"" + proxy.getName() + "\" id=" + proxyId);
                    }
                    if (proxyId == null) {
                        assert (proxy.getName() != null);
                        proxyId = this.proxyDao.insert(proxy);
                        LOG.debug("Testbed.create: Created proxy \"" + proxy.getName() + "\" new ID=" + proxyId);
                        if (proxyId == null) {
                            throw new WebApplicationException("Internal error creating proxy \"" + proxy.getName() + "\": no ID created", Response.Status.INTERNAL_SERVER_ERROR);
                        }
                    }
                } else {
                    LOG.debug("Testbed.create: Using provided proxy id=" + proxyId);
                }
                assert (proxyId != null);
                LOG.debug("Testbed.create: Linking proxy \"" + proxy.getName() + "\" (id=" + proxyId + ") to testbed \"" + (String)testbedWithDefaults.getId() + "\"");
                this.proxyDao.linkTestbedAndProxy(proxyId, (String)testbedWithDefaults.getId());
            }
        }
        LOG.debug("Testbed.create: Updating defaults and proxies for Testbed " + (String)testbedWithDefaults.getId() + " (cmi=" + testbedWithDefaults.getDefaultComponentManagerUrn() + ")");
        this.testbedDao.update(testbedWithDefaults.create());
        if (newTestbed.getFederations() != null && !newTestbed.getFederations().isEmpty()) {
            this.ftMappingDao.updateFederationsForTestbed((String)newTestbed.getId(), newTestbed.getFederations().stream().map(PrimaryIdObject::getId).collect(Collectors.toList()));
            this.sharedResourceCache.getFederationCache().invalidateFull();
        }
        this.invalidateSearchCache();
        List<TestbedBuilder> resList = this.testbedDao.query(this.configuration.getUriTool(), null, null, null, null, (String)newTestbed.getId(), true);
        if (resList == null || resList.isEmpty() || resList.size() != 1) {
            throw new WebApplicationException("Internal error: Could not find created Testbed. resLis -> =" + (Serializable)(resList == null ? "null" : Integer.valueOf(resList.size())), Response.Status.INTERNAL_SERVER_ERROR);
        }
        TestbedBuilder resBuilder = resList.get(0);
        return TestbedResource.minimize(true, resBuilder);
    }

    @GET
    @Timed
    @Produces(value={"application/json"})
    public List<Testbed> search(@QueryParam(value="category") String categories, @QueryParam(value="geni_name") String geniNames, @QueryParam(value="id") String ids, @QueryParam(value="urn") String urns, @QueryParam(value="embed") Boolean embed, @QueryParam(value="full") Boolean full, @Context HttpServletRequest request) {
        boolean showEmails = this.configuration.hasAnyAccess(request, new FedmonAccess[]{FedmonAccess.CREATE_TASK_AND_RESULT});
        CacheKey key = new CacheKey(null, categories, geniNames, ids, urns);
        assert (key.isMultiSearch() || key.isFindAll());
        assert (!key.isFindSingle());
        List<TestbedBuilder> resBuilders = TestbedResource.stripEmails((List)this.cache.getUnchecked((Object)key), !showEmails);
        if (full != Boolean.TRUE) {
            resBuilders = TestbedResource.stripDataFromSearchResult(resBuilders);
        }
        boolean mustEmbed = embed == null ? false : embed;
        return TestbedResource.minimize(mustEmbed, resBuilders);
    }

    public static TestbedBuilder stripDataFromSearchResult(TestbedBuilder origBuilder) {
        TestbedBuilder resBuilder = new TestbedBuilder(origBuilder);
        resBuilder.setPrimaryContactEmails(null);
        resBuilder.setTechnicalContactEmails(null);
        resBuilder.setGdprContactEmails(null);
        resBuilder.setSoftware(null);
        resBuilder.setNotes(null);
        resBuilder.setTestbedAdminUrns(null);
        resBuilder.setF4fFederationStatus(null);
        resBuilder.setInterfaceUrl(null);
        resBuilder.setPingHost(null);
        resBuilder.setOtrsName(null);
        resBuilder.setGeniId(null);
        resBuilder.setGeniHref(null);
        return resBuilder;
    }

    public static List<TestbedBuilder> stripDataFromSearchResult(List<TestbedBuilder> resBuilders) {
        return resBuilders.stream().map(TestbedBuilder::new).map(TestbedResource::stripDataFromSearchResult).collect(Collectors.toList());
    }

    @GET
    @Path(value="{id}")
    @Timed
    public Testbed get(@NotNull @PathParam(value="id") String id, @Nullable @QueryParam(value="embed") Boolean embed, @Context HttpServletRequest request) {
        boolean showEmails = this.configuration.hasAnyAccess(request, new FedmonAccess[]{FedmonAccess.CREATE_TASK_AND_RESULT});
        CacheKey key = new CacheKey(id, null, null, null, null);
        assert (!key.isMultiSearch());
        assert (!key.isFindAll());
        assert (key.isFindSingle());
        List res = null;
        try {
            res = (List)this.cache.get((Object)key);
        }
        catch (com.google.common.util.concurrent.UncheckedExecutionException | ExecutionException | UncheckedExecutionException e) {
            if (e.getCause() != null && e.getCause() instanceof NotFoundException) {
                throw new NotFoundException("There is no Testbed with id=" + id);
            }
            if (e.getCause() != null && e.getCause() instanceof WebApplicationException) {
                throw (WebApplicationException)e.getCause();
            }
            throw new WebApplicationException("Internal error", e, Response.Status.INTERNAL_SERVER_ERROR);
        }
        if (res == null || res.isEmpty()) {
            throw new NotFoundException("No Testbed with id " + id + " found");
        }
        if (res.size() != 1) {
            throw new RuntimeException("Internal error: unexpected size in cache list: " + res.size());
        }
        TestbedBuilder resBuilder = TestbedResource.stripEmails((TestbedBuilder)res.get(0), !showEmails);
        boolean mustEmbed = embed == null ? false : embed;
        return TestbedResource.minimize(mustEmbed, resBuilder);
    }

    private static List<TestbedBuilder> stripEmails(List<TestbedBuilder> origList, boolean strip) {
        if (!strip) {
            return origList;
        }
        return origList.stream().map(TestbedBuilder::new).map(tb -> TestbedResource.stripEmails(tb, true)).collect(Collectors.toList());
    }

    private static TestbedBuilder stripEmails(TestbedBuilder tb, boolean strip) {
        if (!strip) {
            return tb;
        }
        if (tb.getPrimaryContactEmails() != null) {
            tb = new TestbedBuilder(tb);
            tb.setPrimaryContactEmails(TestbedResource.mungeEmails(tb.getPrimaryContactEmails()));
        }
        if (tb.getGdprContactEmails() != null) {
            tb = new TestbedBuilder(tb);
            tb.setGdprContactEmails(TestbedResource.mungeEmails(tb.getGdprContactEmails()));
        }
        if (tb.getTechnicalContactEmails() != null || tb.getOrganisation() != null && tb.getOrganisation().getTechnicalContactEmails() != null) {
            if ((tb = new TestbedBuilder(tb)).getTechnicalContactEmails() != null) {
                tb.setTechnicalContactEmails(TestbedResource.mungeEmails(tb.getTechnicalContactEmails()));
            }
            if (tb.getOrganisation() != null && tb.getOrganisation().getTechnicalContactEmails() != null) {
                OrganisationBuilder ob = new OrganisationBuilder(tb.getOrganisation());
                ob.setTechnicalContactEmails(TestbedResource.mungeEmails(tb.getOrganisation().getTechnicalContactEmails()));
                tb.setOrganisation(ob.create());
            }
        }
        return tb;
    }

    public static String mungeEmail(@Nonnull String origEmail) {
        if (origEmail == null) {
            return null;
        }
        return origEmail.replaceAll("@", " (AT) ").replaceAll("\\.", " -DOT- ");
    }

    public static List<String> mungeEmails(@Nonnull List<String> origEmails) {
        if (origEmails == null) {
            return null;
        }
        return origEmails.stream().filter(Objects::nonNull).map(TestbedResource::mungeEmail).collect(Collectors.toList());
    }

    @DELETE
    @Path(value="{id}")
    @Timed
    public void delete(@NotNull @PathParam(value="id") String id, @Context HttpServletRequest request) {
        this.configuration.assureAccessAllowed(FedmonAccess.ADMIN, request);
        throw new WebApplicationException("not yet implemented", Response.Status.NOT_IMPLEMENTED);
    }

    private static List<Testbed> minimize(boolean embed, List<TestbedBuilder> builders) {
        if (embed) {
            return TestbedBuilder.minimizeBuilders((JsonLdObjectsMetaData.Minimization)JsonLdObjectsMetaData.Minimization.FULL_EMBEDDING_PARENT_AND_CHILDREN, builders);
        }
        return TestbedBuilder.minimizeBuilders((JsonLdObjectsMetaData.Minimization)JsonLdObjectsMetaData.Minimization.FULL_WITH_MINIMAL_LINK_IDS, builders);
    }

    private static Testbed minimize(boolean embed, TestbedBuilder builder) {
        if (embed) {
            return builder.createMinimized(JsonLdObjectsMetaData.Minimization.FULL_EMBEDDING_PARENT_AND_CHILDREN);
        }
        return builder.createMinimized(JsonLdObjectsMetaData.Minimization.FULL_WITH_MINIMAL_LINK_IDS);
    }

    private static class CacheKey {
        private final String id;
        private final String categories;
        private final String geniNames;
        private final String ids;
        private final String urns;

        private CacheKey(String id, String categories, String geniNames, String ids, String urns) {
            this.id = CacheKey.isNotNullOrEmptyString(id) ? id : null;
            this.categories = CacheKey.isNotNullOrEmptyString(categories) ? categories.trim() : null;
            this.geniNames = CacheKey.isNotNullOrEmptyString(geniNames) ? geniNames.trim() : null;
            this.ids = CacheKey.isNotNullOrEmptyString(ids) ? ids.trim() : null;
            this.urns = CacheKey.isNotNullOrEmptyString(urns) ? urns.trim() : null;
            boolean isSearch = CacheKey.isNotNullOrEmptyString(categories) || CacheKey.isNotNullOrEmptyString(geniNames) || CacheKey.isNotNullOrEmptyString(ids) || CacheKey.isNotNullOrEmptyString(urns);
            boolean isDirect = CacheKey.isNotNullOrEmptyString(id);
            assert (!isDirect || !isSearch) : "isDirect=" + isDirect + " && isSearch=" + isSearch + " is not allowed";
        }

        public String getId() {
            return this.id;
        }

        public String getCategories() {
            return this.categories;
        }

        public String getGeniNames() {
            return this.geniNames;
        }

        public String getIds() {
            return this.ids;
        }

        public String getUrns() {
            return this.urns;
        }

        public boolean isFindSingle() {
            return this.id != null;
        }

        public boolean isMultiSearch() {
            boolean isSearch = CacheKey.isNotNullOrEmptyString(this.categories) || CacheKey.isNotNullOrEmptyString(this.geniNames) || CacheKey.isNotNullOrEmptyString(this.ids) || CacheKey.isNotNullOrEmptyString(this.urns);
            boolean isDirect = CacheKey.isNotNullOrEmptyString(this.id);
            return isSearch || !isDirect || this.isFindAll();
        }

        public boolean isFindAll() {
            return CacheKey.isNullOrEmptyString(this.categories) && CacheKey.isNullOrEmptyString(this.geniNames) && CacheKey.isNullOrEmptyString(this.ids) && CacheKey.isNullOrEmptyString(this.urns) && CacheKey.isNullOrEmptyString(this.id);
        }

        public static boolean isNullOrEmptyString(String val) {
            return val == null || val.trim().isEmpty();
        }

        public static boolean isNotNullOrEmptyString(String val) {
            return val != null && !val.trim().isEmpty();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            if (this.id != null ? !this.id.equals(cacheKey.id) : cacheKey.id != null) {
                return false;
            }
            if (this.categories != null ? !this.categories.equals(cacheKey.categories) : cacheKey.categories != null) {
                return false;
            }
            if (this.geniNames != null ? !this.geniNames.equals(cacheKey.geniNames) : cacheKey.geniNames != null) {
                return false;
            }
            if (this.ids != null ? !this.ids.equals(cacheKey.ids) : cacheKey.ids != null) {
                return false;
            }
            return this.urns != null ? this.urns.equals(cacheKey.urns) : cacheKey.urns == null;
        }

        public int hashCode() {
            int result = this.id != null ? this.id.hashCode() : 0;
            result = 31 * result + (this.categories != null ? this.categories.hashCode() : 0);
            result = 31 * result + (this.geniNames != null ? this.geniNames.hashCode() : 0);
            result = 31 * result + (this.ids != null ? this.ids.hashCode() : 0);
            result = 31 * result + (this.urns != null ? this.urns.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "CacheKey{id='" + this.id + "', categories='" + this.categories + "', geniNames='" + this.geniNames + "', ids='" + this.ids + "', urns='" + this.urns + "'}";
        }
    }
}

