/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.lowlevel.connection;

import be.iminds.ilabt.jfed.lowlevel.connection.ConnectionConfig;
import be.iminds.ilabt.jfed.lowlevel.connection.HttpConnection;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import java.io.IOException;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicHttpConnection
extends HttpConnection {
    private static final Logger LOG = LoggerFactory.getLogger(BasicHttpConnection.class);
    private final HttpClientBuilder clientBuilder;
    private final HttpContext httpContext;
    private final HttpContext preemptiveAuthHttpContext;
    private CloseableHttpClient httpClient;
    private boolean preemptiveAuthEnabled = false;

    public BasicHttpConnection(ConnectionConfig connectionConfig, HttpClientBuilder clientBuilder, HttpContext httpContext, HttpContext preemptiveAuthHttpContext) throws JFedException {
        super(connectionConfig);
        this.clientBuilder = clientBuilder;
        this.httpContext = httpContext;
        this.preemptiveAuthHttpContext = preemptiveAuthHttpContext;
    }

    @Override
    public void enablePreemptiveAuthentication(boolean enable) {
        this.preemptiveAuthEnabled = enable;
    }

    public CloseableHttpClient getHttpClient() {
        if (this.httpClient == null) {
            this.httpClient = this.clientBuilder.build();
        }
        return this.httpClient;
    }

    public HttpClientBuilder getClientBuilder() {
        return this.clientBuilder;
    }

    @Override
    public HttpContext getHttpContext() {
        if (this.preemptiveAuthEnabled) {
            return this.preemptiveAuthHttpContext;
        }
        return this.httpContext;
    }

    @Override
    public void close() {
        this.error = true;
        try {
            this.httpClient.close();
        }
        catch (IOException e) {
            LOG.warn("Error while closing http client");
        }
        this.httpClient = null;
    }
}

