/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.util.library;

import be.iminds.ilabt.jfed.util.library.KeyUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class JFedTrustStore {
    private static final Logger LOG = LoggerFactory.getLogger(JFedTrustStore.class);
    @Nonnull
    private final Set<String> allowedServerCertificateHostnameAliases;
    @Nonnull
    private final KeyStore trustStore;
    @Nonnull
    public final List<String> addedPems = new ArrayList<String>();
    @Nonnull
    private final List<Certificate> extraTrustedCertificates = new ArrayList<Certificate>();
    private static KeyStore systemTrustStore = null;

    public JFedTrustStore() {
        this.trustStore = JFedTrustStore.getSystemTrustStore();
        if (this.trustStore == null) {
            throw new NullPointerException("getSystemTrustStore returned null");
        }
        this.allowedServerCertificateHostnameAliases = new HashSet<String>();
    }

    public JFedTrustStore(@Nonnull KeyStore trustStore) {
        if (trustStore == null) {
            throw new NullPointerException("trustStore may not be null");
        }
        try {
            this.trustStore = JFedTrustStore.copyTrustStore(trustStore, null, null, "somepass".toCharArray());
        }
        catch (Exception e) {
            throw new RuntimeException("Could not copy trust store: " + e.getMessage(), e);
        }
        this.allowedServerCertificateHostnameAliases = new HashSet<String>();
    }

    public JFedTrustStore(@Nonnull JFedTrustStore jFedTrustStore) {
        if (jFedTrustStore == null) {
            throw new NullPointerException("jFedTrustStore may not be null");
        }
        if (jFedTrustStore.trustStore == null) {
            throw new NullPointerException("jFedTrustStore.trustStore may not be null");
        }
        try {
            this.trustStore = JFedTrustStore.copyTrustStore(jFedTrustStore.trustStore, null, null, "somepass".toCharArray());
        }
        catch (Exception e) {
            throw new RuntimeException("Could not copy trust store: " + e.getMessage(), e);
        }
        this.allowedServerCertificateHostnameAliases = new HashSet<String>(jFedTrustStore.getAllowedServerCertificateHostnameAliases());
    }

    public JFedTrustStore(@Nonnull TrustInfo server) {
        this.trustStore = JFedTrustStore.getSystemTrustStore();
        if (this.trustStore == null) {
            throw new NullPointerException("getSystemTrustStore() returned null");
        }
        if (server.getCertificateChain() != null) {
            this.addTrustedPemCertificateIfNotAdded(server.getCertificateChain());
        }
        this.allowedServerCertificateHostnameAliases = new HashSet<String>();
        if (server.getAllowedCertificateAlias() != null && !server.getAllowedCertificateAlias().trim().isEmpty()) {
            this.allowedServerCertificateHostnameAliases.add(server.getAllowedCertificateAlias());
        }
    }

    public JFedTrustStore(@Nonnull Collection<TrustInfo> trustInfoCollection) {
        this.trustStore = JFedTrustStore.getSystemTrustStore();
        if (this.trustStore == null) {
            throw new NullPointerException("getSystemTrustStore() returned null");
        }
        this.addAuthorityCerts(trustInfoCollection);
        this.allowedServerCertificateHostnameAliases = new HashSet<String>();
    }

    public void addAuthorityCerts(@Nonnull Collection<TrustInfo> trustInfoCollection) {
        trustInfoCollection.stream().filter(server -> server.getCertificateChain() != null).forEach(server -> this.addTrustedPemCertificateIfNotAddedAndValidPem(server.getCertificateChain()));
    }

    public void addAuthorityCert(@Nonnull TrustInfo server) {
        if (server.getCertificateChain() != null) {
            this.addTrustedPemCertificateIfNotAddedAndValidPem(server.getCertificateChain());
        }
    }

    @Nonnull
    public Collection<String> getAllowedServerCertificateHostnameAliases() {
        return Collections.unmodifiableCollection(this.allowedServerCertificateHostnameAliases);
    }

    @Nonnull
    public KeyStore getTrustStore() {
        return this.trustStore;
    }

    public void addAllowedServerCertificateHostnameAlias(@Nonnull String alias) {
        if (alias != null) {
            this.allowedServerCertificateHostnameAliases.add(alias);
        }
    }

    public void addAllowedServerCertificateHostnameAliases(@Nonnull Collection<String> aliases) {
        if (aliases != null) {
            this.allowedServerCertificateHostnameAliases.addAll(aliases);
        }
    }

    public void addTrustedCertificate(@Nonnull X509Certificate c) throws InvalidCertificateDate {
        assert (c != null);
        Date now = new Date();
        if (c.getNotBefore() == null || c.getNotBefore().after(now)) {
            throw new InvalidCertificateDate("provided PEM is not valid yet (notBefore=" + c.getNotBefore() + "). Subject=\"" + c.getSubjectDN() + "\" AltSubjectDNS=" + KeyUtil.findDnsInCertAltSubjectNames(c));
        }
        this.extraTrustedCertificates.add(c);
        try {
            this.trustStore.setCertificateEntry("extraCert" + this.extraTrustedCertificates.size(), c);
        }
        catch (KeyStoreException e) {
            LOG.error("Error while creating adding certificate to trust store", (Throwable)e);
            throw new RuntimeException("Could not add certificate to trust store: " + e.getMessage(), e);
        }
    }

    public void addTrustedPemCertificate(@Nonnull String pem) {
        assert (pem != null);
        X509Certificate cert = KeyUtil.pemToX509Certificate(pem);
        if (cert == null) {
            throw new RuntimeException("provided PEM is not a valid certificate: \"" + pem + "\"");
        }
        try {
            this.addTrustedCertificate(cert);
        }
        catch (InvalidCertificateDate e) {
            throw new RuntimeException("provided PEM is an expired certificate: \"" + pem + "\" " + e.getMessage());
        }
    }

    public void addTrustedPemCertificateIfNotAdded(@Nonnull String pem) {
        assert (pem != null);
        if (this.addedPems.contains(pem)) {
            return;
        }
        this.addedPems.add(pem);
        this.addTrustedPemCertificate(pem);
    }

    public void addTrustedPemCertificateIfNotAddedAndValidPem(@Nonnull String pem) {
        assert (pem != null);
        if (this.addedPems.contains(pem)) {
            return;
        }
        X509Certificate cert = KeyUtil.pemToX509Certificate(pem);
        if (cert == null) {
            LOG.warn("Invalid PEM ignored");
            return;
        }
        this.addedPems.add(pem);
        try {
            this.addTrustedCertificate(cert);
        }
        catch (InvalidCertificateDate e) {
            LOG.warn("Expired PEM ignored: " + e.getMessage());
            return;
        }
    }

    public void add(@Nonnull JFedTrustStore other) {
        if (other == null) {
            throw new NullPointerException("other may not be null");
        }
        if (other.trustStore == null) {
            throw new NullPointerException("other.trustStore may not be null");
        }
        char[] tmpPass = "somepass".toCharArray();
        try {
            Enumeration<String> enumeration = other.trustStore.aliases();
            while (enumeration.hasMoreElements()) {
                String alias = enumeration.nextElement();
                if (this.trustStore.containsAlias(alias)) {
                    LOG.info("Skipping duplicate alias " + alias);
                    continue;
                }
                Certificate cert = other.trustStore.getCertificate(alias);
                Key key = other.trustStore.getKey(alias, null);
                Certificate[] certs = other.trustStore.getCertificateChain(alias);
                if (cert != null && key == null && certs == null) {
                    this.trustStore.setCertificateEntry(alias, cert);
                    continue;
                }
                if (key != null && certs != null) {
                    this.trustStore.setKeyEntry(alias, key, null, certs);
                    continue;
                }
                LOG.warn("While merging KeyStore " + (key == null ? "key==null" : "") + " " + (certs == null ? "certs==null" : "") + " " + (cert == null ? "cert==null" : "") + " for alias=" + alias);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to merge KeyStores", e);
        }
        this.allowedServerCertificateHostnameAliases.addAll(other.getAllowedServerCertificateHostnameAliases());
        this.addedPems.addAll(other.addedPems);
        this.extraTrustedCertificates.addAll(other.extraTrustedCertificates);
    }

    public static synchronized KeyStore getSystemTrustStore() {
        String systemTrustStorePass = System.getProperty("javax.net.ssl.trustStorePassword");
        if (systemTrustStorePass == null) {
            systemTrustStorePass = "changeit";
        }
        if (systemTrustStore != null) {
            try {
                return JFedTrustStore.copyTrustStore(systemTrustStore, systemTrustStorePass.toCharArray(), null, systemTrustStorePass.toCharArray());
            }
            catch (Exception e) {
                LOG.error("Failed to copy system trust store", (Throwable)e);
                throw new RuntimeException("Failed to copy system trust store", e);
            }
        }
        String jssecacertsFilename = System.getProperty("java.home") + File.separator + "lib" + File.separator + "security" + File.separator + "jssecacerts";
        String cacertsFilename = System.getProperty("java.home") + File.separator + "lib" + File.separator + "security" + File.separator + "cacerts";
        Object systemTrustStoreFilename = System.getProperty("javax.net.ssl.trustStore");
        if (systemTrustStoreFilename == null) {
            systemTrustStoreFilename = jssecacertsFilename;
            if (!new File((String)systemTrustStoreFilename).exists()) {
                systemTrustStoreFilename = cacertsFilename;
            }
            if (!new File((String)systemTrustStoreFilename).exists()) {
                throw new RuntimeException("Could not find any system trust store!");
            }
        }
        try {
            systemTrustStore = KeyStore.getInstance(KeyStore.getDefaultType());
            FileInputStream system_trustStore_in = new FileInputStream((String)systemTrustStoreFilename);
            systemTrustStore.load(system_trustStore_in, systemTrustStorePass.toCharArray());
            system_trustStore_in.close();
        }
        catch (Exception e) {
            LOG.error("ERROR loading system trust store: " + e.getMessage(), (Throwable)e);
            LOG.error("  Normally, the trust store is at one of these locations:\n   - <JAVA_HOME>/lib/security/jssecacerts => \"" + jssecacertsFilename + "\"\n   - <JAVA_HOME>/lib/security/cacerts => \"" + cacertsFilename + "\"\n");
            LOG.error("  You can use another by setting the system property \"javax.net.ssl.trustStore\"");
            LOG.error("  You can specify a non default password with \"javax.net.ssl.trustStorePassword\" (default pass is \"changeit\")");
            systemTrustStore = null;
            throw new RuntimeException("Cannot locate and load system trust store: " + e.getMessage(), e);
        }
        if (systemTrustStore == null) {
            throw new NullPointerException("systemTrustStore may not be null");
        }
        try {
            return JFedTrustStore.copyTrustStore(systemTrustStore, systemTrustStorePass.toCharArray(), null, systemTrustStorePass.toCharArray());
        }
        catch (Exception e) {
            LOG.error("Could not copy the found system trust store.", (Throwable)e);
            throw new RuntimeException("Could not copy the found system trust store.", e);
        }
    }

    public static KeyStore copyTrustStore(@Nonnull KeyStore origKeyStore, @Nullable char[] origPass, @Nullable char[] origKeyPass, @Nullable char[] resultPass) throws KeyStoreException, UnrecoverableKeyException, NoSuchAlgorithmException, IOException, CertificateException {
        return JFedTrustStore.copyKeyStore(origKeyStore, origPass, origKeyPass, resultPass);
    }

    public static KeyStore copyKeyStore(@Nonnull KeyStore origKeyStore, @Nullable char[] origPass, @Nullable char[] origKeyPass, @Nullable char[] resultPass) throws KeyStoreException, NoSuchAlgorithmException, IOException, CertificateException {
        if (origKeyStore == null) {
            throw new NullPointerException("origKeyStore may not be null");
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        origKeyStore.store(baos, resultPass);
        KeyStore res = KeyStore.getInstance("jks");
        ByteArrayInputStream bois = new ByteArrayInputStream(baos.toByteArray());
        res.load(bois, resultPass);
        return res;
    }

    public static interface TrustInfo {
        @Nullable
        public String getCertificateChain();

        @Nullable
        public String getAllowedCertificateAlias();
    }

    public static class InvalidCertificateDate
    extends Exception {
        public InvalidCertificateDate() {
        }

        public InvalidCertificateDate(String message) {
            super(message);
        }

        public InvalidCertificateDate(String message, Throwable cause) {
            super(message, cause);
        }

        public InvalidCertificateDate(Throwable cause) {
            super(cause);
        }
    }
}

