/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.util.library;

import be.iminds.ilabt.jfed.util.library.KeyUtil;
import be.iminds.ilabt.jfed.util.library.PublicKeyConvertor;
import ch.ethz.ssh2.crypto.cipher.AES;
import ch.ethz.ssh2.crypto.cipher.BlockCipher;
import ch.ethz.ssh2.crypto.cipher.CBCMode;
import ch.ethz.ssh2.crypto.cipher.DES;
import ch.ethz.ssh2.crypto.cipher.DESede;
import ch.ethz.ssh2.crypto.digest.MD5;
import com.hierynomus.sshj.userauth.keyprovider.OpenSSHKeyV1KeyFile;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.invoke.CallSite;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.security.KeyPair;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.schmizz.sshj.userauth.password.PasswordFinder;
import net.schmizz.sshj.userauth.password.Resource;
import org.apache.commons.lang.WordUtils;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PEMUtil {
    private static final Logger LOG = LoggerFactory.getLogger(PEMUtil.class);
    protected static final String BEGIN_RSA_PRIVATE_KEY = "-----BEGIN RSA PRIVATE KEY-----";
    protected static final String END_RSA_PRIVATE_KEY = "-----END RSA PRIVATE KEY-----";
    protected static final String BEGIN_PRIVATE_KEY = "-----BEGIN PRIVATE KEY-----";
    protected static final String END_PRIVATE_KEY = "-----END PRIVATE KEY-----";
    protected static final String BEGIN_OPENSSH_PRIVATE_KEY = "-----BEGIN OPENSSH PRIVATE KEY----";
    protected static final String END_OPENSSH_PRIVATE_KEY = "-----END OPENSSH PRIVATE KEY----";

    private PEMUtil() {
    }

    @Nonnull
    public static PEM fromPrivateKey(@Nonnull PrivateKey privateKey) {
        String pemContent = new String(KeyUtil.privateKeyToAnyPem(privateKey));
        try {
            return PEMUtil.extractPEM(pemContent);
        }
        catch (PEMDecodingException e) {
            throw new RuntimeException("Unexpected PEMDecodingException while converting private key to PEM", e);
        }
    }

    @Nonnull
    public static PEM extractPEM(@Nonnull String pemContent) throws PEMDecodingException {
        List<PEM> pems = PEMUtil.extractPEMs(pemContent);
        if (pems.isEmpty()) {
            throw new PEMDecodingException("No PEM found");
        }
        return pems.get(0);
    }

    @Nullable
    public static PEM extractOptionalPEM(@Nonnull String pemContent) throws PEMDecodingException {
        List<PEM> pems = PEMUtil.extractPEMs(pemContent);
        return pems.isEmpty() ? null : pems.get(0);
    }

    public static boolean hasValidPrivateKeyPEM(@Nonnull String pemContent) {
        try {
            List<PEM> pems = PEMUtil.extractPEMs(pemContent);
            return !pems.isEmpty();
        }
        catch (PEMDecodingException e) {
            return false;
        }
    }

    @Nonnull
    public static List<PEM> extractPEMs(@Nonnull String pemContent) throws PEMDecodingException {
        ArrayList<PEM> res = new ArrayList<PEM>();
        BufferedReader bufReader = new BufferedReader(new StringReader(pemContent));
        String curBlock = null;
        ArrayList<String> curLines = new ArrayList<String>();
        try {
            String line;
            while ((line = bufReader.readLine()) != null) {
                if ((line = line.trim()).startsWith("-----BEGIN ") && line.endsWith("-----") && curBlock == null) {
                    curBlock = line.substring(11, line.length() - 5);
                    continue;
                }
                if (curBlock != null && line.equals("-----END " + curBlock + "-----")) {
                    PEMType type = PEMType.fromName(curBlock);
                    if (type != null) {
                        String pemLines = String.join((CharSequence)"\n", curLines);
                        String pemConcat = String.join((CharSequence)"", curLines);
                        boolean encrypted = false;
                        if (type == PEMType.RSA_PRIVATE_KEY) {
                            boolean bl = encrypted = pemContent.contains("Proc-Type:") || pemContent.contains("DEK-Info: ") || pemContent.contains("ENCRYPTED");
                        }
                        if (type == PEMType.OPENSSH_PRIVATE_KEY) {
                            byte[] pemBytes = Base64.getDecoder().decode(pemConcat.trim().replaceAll("\r\n", "\n").replaceAll("\n", ""));
                            OpenSSHPemParser k = new OpenSSHPemParser(pemBytes);
                            encrypted = k.encryptedPrivateKey;
                        }
                        res.add(new PEM(pemLines, type, encrypted));
                    }
                    curLines.clear();
                    curBlock = null;
                    continue;
                }
                if (curBlock == null) continue;
                curLines.add(line);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return res;
    }

    @Nonnull
    private static byte[] decryptPEM(@Nonnull String algo, @Nonnull byte[] salt, @Nonnull byte[] data, @Nonnull byte[] pw) throws PEMDecodingException {
        assert (algo != null);
        assert (pw != null);
        assert (data != null);
        assert (salt != null);
        if (LOG.isDebugEnabled()) {
            try {
                String pwMd5String;
                String dataMd5String;
                if (data.length > 0) {
                    MessageDigest md = MessageDigest.getInstance("MD5");
                    byte[] dataMd5 = md.digest(data);
                    dataMd5String = org.apache.commons.codec.binary.Base64.encodeBase64String((byte[])dataMd5);
                } else {
                    dataMd5String = "empty";
                }
                if (pw.length > 0) {
                    MessageDigest md = MessageDigest.getInstance("MD5");
                    byte[] pwMd5 = md.digest(pw);
                    pwMd5String = org.apache.commons.codec.binary.Base64.encodeBase64String((byte[])pwMd5);
                } else {
                    pwMd5String = "empty";
                }
                LOG.debug("decryptPEM() algo=" + algo + " salt=" + org.apache.commons.codec.binary.Base64.encodeBase64String((byte[])salt) + " dataMd5=" + dataMd5String + " pwMd5=" + pwMd5String);
            }
            catch (NoSuchAlgorithmException e) {
                LOG.debug("decryptPEM() Error creating debug message", (Throwable)e);
            }
        }
        CBCMode bc = switch (algo) {
            case "DES-EDE3-CBC" -> {
                DESede des3 = new DESede();
                des3.init(false, PEMUtil.generateKeyFromPasswordSaltWithMD5(pw, salt, 24));
                yield new CBCMode((BlockCipher)des3, salt, false);
            }
            case "DES-CBC" -> {
                DES des = new DES();
                des.init(false, PEMUtil.generateKeyFromPasswordSaltWithMD5(pw, salt, 8));
                yield new CBCMode((BlockCipher)des, salt, false);
            }
            case "AES-128-CBC" -> {
                AES aes = new AES();
                aes.init(false, PEMUtil.generateKeyFromPasswordSaltWithMD5(pw, salt, 16));
                yield new CBCMode((BlockCipher)aes, salt, false);
            }
            case "AES-192-CBC" -> {
                AES aes = new AES();
                aes.init(false, PEMUtil.generateKeyFromPasswordSaltWithMD5(pw, salt, 24));
                yield new CBCMode((BlockCipher)aes, salt, false);
            }
            case "AES-256-CBC" -> {
                AES aes = new AES();
                aes.init(false, PEMUtil.generateKeyFromPasswordSaltWithMD5(pw, salt, 32));
                yield new CBCMode((BlockCipher)aes, salt, false);
            }
            default -> {
                LOG.error("decryptPEM() Cannot decrypt PEM structure, unknown cipher " + algo);
                throw new PEMDecodingException("Cannot decrypt PEM structure, unknown cipher " + algo);
            }
        };
        if (data.length % bc.getBlockSize() != 0) {
            LOG.error("Invalid PEM structure, size of encrypted block is not a multiple of " + bc.getBlockSize());
            throw new PEMDecodingException("Invalid PEM structure, size of encrypted block is not a multiple of " + bc.getBlockSize());
        }
        byte[] dz = new byte[data.length];
        for (int i = 0; i < data.length / bc.getBlockSize(); ++i) {
            bc.transformBlock(data, i * bc.getBlockSize(), dz, i * bc.getBlockSize());
        }
        dz = PEMUtil.removePadding(dz, bc.getBlockSize());
        return dz;
    }

    @Nonnull
    private static byte[] addPadding(@Nonnull byte[] buff, int blockSize) {
        assert (blockSize == 8);
        int origLen = buff.length;
        int extraBytes = 8 - buff.length % blockSize;
        int resLen = origLen + extraBytes;
        byte[] res = new byte[resLen];
        System.arraycopy(buff, 0, res, 0, origLen);
        for (int i = origLen; i < resLen; ++i) {
            res[i] = (byte)extraBytes;
        }
        return res;
    }

    @Nonnull
    private static byte[] removePadding(@Nonnull byte[] buff, int blockSize) throws PEMDecodingException {
        int rfc_1423_padding = buff[buff.length - 1] & 0xFF;
        if (rfc_1423_padding < 1 || rfc_1423_padding > blockSize) {
            throw new PEMDecodingException("Decrypted PEM has wrong padding, did you specify the correct password?");
        }
        for (int i = 2; i <= rfc_1423_padding; ++i) {
            if (buff[buff.length - i] == rfc_1423_padding) continue;
            throw new PEMDecodingException("Decrypted PEM has wrong padding, did you specify the correct password?");
        }
        byte[] tmp = new byte[buff.length - rfc_1423_padding];
        System.arraycopy(buff, 0, tmp, 0, buff.length - rfc_1423_padding);
        return tmp;
    }

    @Nonnull
    private static byte[] generateKeyFromPasswordSaltWithMD5(@Nonnull byte[] password, @Nonnull byte[] salt, int keyLen) throws PEMDecodingException {
        if (salt.length < 8) {
            throw new PEMDecodingException("Salt needs to be at least 8 bytes for key generation. It is only " + salt.length + " bytes");
        }
        MD5 md5 = new MD5();
        byte[] key = new byte[keyLen];
        byte[] tmp = new byte[md5.getDigestLength()];
        while (true) {
            md5.update(password, 0, password.length);
            md5.update(salt, 0, 8);
            int copy = keyLen < tmp.length ? keyLen : tmp.length;
            md5.digest(tmp, 0);
            System.arraycopy(tmp, 0, key, key.length - keyLen, copy);
            if ((keyLen -= copy) == 0) {
                return key;
            }
            md5.update(tmp, 0, tmp.length);
        }
    }

    @Nonnull
    private static String encryptPEM(@Nonnull byte[] data, @Nonnull byte[] pw) throws PEMDecodingException {
        byte[] salt = new byte[8];
        Random rand = new Random();
        rand.nextBytes(salt);
        Object saltString = "";
        for (byte aSalt : salt) {
            saltString = (String)saltString + String.format("%02X", aSalt);
        }
        byte[] crypted = PEMUtil.encryptPEMhelper(data, salt, pw);
        return "Proc-Type: 4,ENCRYPTED\nDEK-Info: DES-EDE3-CBC," + (String)saltString + "\n\n" + org.apache.commons.codec.binary.Base64.encodeBase64String((byte[])crypted);
    }

    @Nonnull
    private static byte[] encryptPEMhelper(@Nonnull byte[] data, @Nonnull byte[] salt, @Nonnull byte[] pw) throws PEMDecodingException {
        DESede des3 = new DESede();
        des3.init(true, PEMUtil.generateKeyFromPasswordSaltWithMD5(pw, salt, 24));
        CBCMode bc = new CBCMode((BlockCipher)des3, salt, true);
        byte[] paddedData = PEMUtil.addPadding(data, bc.getBlockSize());
        byte[] res = new byte[paddedData.length];
        for (int i = 0; i < paddedData.length / bc.getBlockSize(); ++i) {
            bc.transformBlock(paddedData, i * bc.getBlockSize(), res, i * bc.getBlockSize());
        }
        return res;
    }

    public static int hexToInt(char c) {
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        throw new IllegalArgumentException("Need hex char");
    }

    @Nonnull
    public static byte[] hexToByteArray(@Nonnull String hex) {
        if (hex.length() % 2 != 0) {
            throw new IllegalArgumentException("Uneven string length in hex encoding \"" + hex + "\" len=" + hex.length());
        }
        byte[] decoded = new byte[hex.length() / 2];
        for (int i = 0; i < decoded.length; ++i) {
            int hi = PEMUtil.hexToInt(hex.charAt(i * 2));
            int lo = PEMUtil.hexToInt(hex.charAt(i * 2 + 1));
            decoded[i] = (byte)(hi * 16 + lo);
        }
        return decoded;
    }

    public static class PEM {
        @Nonnull
        private final String pem;
        @Nonnull
        private final PEMType type;
        private final boolean encrypted;
        private final KeyPair keyPair;
        @Nullable
        private final String cheatPassword;

        private PEM(@Nonnull String pem, @Nonnull PEMType type, boolean encrypted) throws PEMDecodingException {
            this.pem = pem;
            this.type = type;
            this.encrypted = encrypted;
            this.cheatPassword = null;
            this.keyPair = this.toKeyPair();
        }

        private PEM(@Nonnull String pem, @Nonnull PEMType type, boolean encrypted, String cheatPassword) throws PEMDecodingException {
            this.pem = pem;
            this.type = type;
            this.encrypted = encrypted;
            this.cheatPassword = cheatPassword;
            this.keyPair = this.toKeyPair();
        }

        public boolean isEncrypted() {
            return this.encrypted;
        }

        @Nonnull
        public PEMType getType() {
            return this.type;
        }

        @Nonnull
        public byte[] getBytes() {
            if (this.cheatPassword != null) {
                throw new RuntimeException("not implemented because not really decrypted");
            }
            return Base64.getDecoder().decode(this.pem.trim().replaceAll("\r\n", "\n").replaceAll("\n", ""));
        }

        private String helperToString() {
            String start = "-----BEGIN " + this.type.name + "-----";
            String end = "-----END " + this.type.name + "-----";
            return start + "\n" + this.pem + "\n" + end;
        }

        public String toString() {
            if (this.cheatPassword != null) {
                throw new RuntimeException("not implemented because not really decrypted");
            }
            return this.helperToString();
        }

        @Nonnull
        public PEM encrypt(@Nonnull char[] password) throws PEMDecodingException {
            assert (!this.isEncrypted());
            if (this.getType() == PEMType.RSA_PRIVATE_KEY || this.getType() == PEMType.PRIVATE_KEY) {
                String encryptedPem = PEMUtil.encryptPEM(this.getBytes(), new String(password).getBytes());
                return new PEM(encryptedPem, this.type, true);
            }
            if (this.getType() == PEMType.OPENSSH_PRIVATE_KEY && this.cheatPassword != null && this.cheatPassword.equals(new String(password))) {
                return new PEM(this.pem, this.type, true, null);
            }
            throw new PEMDecodingException("key type " + this.type.name + " is not supported for decryption");
        }

        @Nonnull
        public PEM decrypt(@Nonnull char[] password) throws PEMDecodingException {
            assert (this.isEncrypted());
            if (this.getType() == PEMType.RSA_PRIVATE_KEY || this.getType() == PEMType.PRIVATE_KEY) {
                assert (this.pem.trim().startsWith("Proc-Type: 4,ENCRYPTED"));
                int dekInfoIndex = this.pem.indexOf("DEK-Info: ");
                if (dekInfoIndex < 0) {
                    throw new PEMDecodingException("Found Proc-Type: 4,ENCRYPTED in RSA PRIVATE KEY, but no DEK-Info");
                }
                int dekInfoEndIndex = this.pem.indexOf("\n", dekInfoIndex);
                int emptyLineIndex = this.pem.indexOf("\n\n");
                LOG.debug("emptyLineIndex=" + emptyLineIndex);
                if (emptyLineIndex < 0) {
                    throw new PEMDecodingException("Did not find empty line in encoded PEM block");
                }
                assert (dekInfoEndIndex != -1);
                String dekInfoLine = this.pem.substring(dekInfoIndex, dekInfoEndIndex);
                LOG.debug("pemToRsaKeyPair() read dekInfoLine=\"" + dekInfoLine + "\"");
                assert (dekInfoLine.startsWith("DEK-Info: "));
                String dekInfoContent = dekInfoLine.substring("DEK-Info: ".length());
                Object[] dekInfoContentParts = dekInfoContent.split(",");
                LOG.debug("pemToRsaKeyPair() dekInfoContent=\"" + dekInfoContent + "\" dekInfoContentParts=" + Arrays.toString(dekInfoContentParts));
                if (dekInfoContentParts.length != 2) {
                    throw new PEMDecodingException("Did not find 2 parts of info in DEK-Info: \"" + dekInfoContent + "\"");
                }
                Object algo = dekInfoContentParts[0];
                byte[] salt = PEMUtil.hexToByteArray((String)dekInfoContentParts[1]);
                LOG.debug("pemToRsaKeyPair() read dekInfoLine algo=\"" + (String)algo + "\" salt=\"" + (String)dekInfoContentParts[1] + "\"");
                String pemEncodedData = this.pem.substring(emptyLineIndex + 1);
                byte[] data = Base64.getDecoder().decode(pemEncodedData.replaceAll("\n", ""));
                byte[] passBytes = new String(password).getBytes();
                byte[] decodedBytes = PEMUtil.decryptPEM((String)algo, salt, data, passBytes);
                String decodedPem = Base64.getEncoder().encodeToString(decodedBytes);
                decodedPem = WordUtils.wrap((String)decodedPem, (int)64);
                return new PEM(decodedPem, this.type, false);
            }
            if (this.getType() == PEMType.OPENSSH_PRIVATE_KEY) {
                return new PEM(this.pem, this.type, false, new String(password));
            }
            throw new PEMDecodingException("key type " + this.type.name + " is not supported for decryption");
        }

        @Nonnull
        public KeyPair getKeyPair() {
            return this.keyPair;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private KeyPair toKeyPair() throws PEMDecodingException {
            try {
                if (this.getType() == PEMType.OPENSSH_PRIVATE_KEY) {
                    if (this.cheatPassword != null || !this.encrypted) {
                        PasswordFinder passwordFinder = this.cheatPassword != null ? new PasswordFinder(){

                            public char[] reqPassword(Resource<?> resource) {
                                return cheatPassword.toCharArray();
                            }

                            public boolean shouldRetry(Resource<?> resource) {
                                return false;
                            }
                        } : null;
                        OpenSSHKeyV1KeyFile kf = new OpenSSHKeyV1KeyFile();
                        kf.init(this.helperToString(), null, passwordFinder);
                        PrivateKey key = kf.getPrivate();
                        PublicKey pubkey = kf.getPublic();
                        return new KeyPair(pubkey, key);
                    }
                    OpenSSHPemParser k = new OpenSSHPemParser(this.getBytes());
                    assert (k.pubKeys.size() >= 1);
                    PublicKey pubKey = PublicKeyConvertor.fromOpensshFormat(k.pubKeys.get(0)).getPublicKey();
                    return new KeyPair(pubKey, null);
                }
                if (this.getType() != PEMType.RSA_PRIVATE_KEY) {
                    if (this.getType() != PEMType.PRIVATE_KEY) return new KeyPair(null, null);
                }
                try (PEMParser pem = new PEMParser((Reader)new StringReader(this.toString()));){
                    JcaPEMKeyConverter jcaPEMKeyConverter = new JcaPEMKeyConverter();
                    Object pemContent = pem.readObject();
                    if (pemContent instanceof PEMKeyPair) {
                        PEMKeyPair pemKeyPair = (PEMKeyPair)pemContent;
                        KeyPair keyPair = jcaPEMKeyConverter.getKeyPair(pemKeyPair);
                        return keyPair;
                    }
                    if (pemContent instanceof PEMEncryptedKeyPair) {
                        KeyPair pemKeyPair = new KeyPair(null, null);
                        return pemKeyPair;
                    }
                    if (!(pemContent instanceof PrivateKeyInfo)) throw new PEMDecodingException("Unsupported private key format '" + pemContent.getClass().getSimpleName() + "\"");
                    PrivateKeyInfo privateKeyInfo = (PrivateKeyInfo)pemContent;
                    PrivateKey privateKey = jcaPEMKeyConverter.getPrivateKey(privateKeyInfo);
                    RSAPublicKey publicKey = privateKey instanceof RSAPrivateKey ? KeyUtil.rsaPrivateKeyToRsaPublicKey((RSAPrivateKey)privateKey) : null;
                    KeyPair keyPair = new KeyPair(publicKey, privateKey);
                    return keyPair;
                }
            }
            catch (IOException e) {
                throw new PEMDecodingException(e);
            }
        }

        @Nonnull
        public PrivateKey toPrivateKey() {
            return this.getKeyPair().getPrivate();
        }

        @Nullable
        public PublicKey toPublicKey() {
            return this.getKeyPair().getPublic();
        }

        @Nonnull
        public PublicKeyConvertor toPublicKeyConvertor() throws PEMDecodingException {
            return PublicKeyConvertor.fromPublicKey(this.toKeyPair().getPublic());
        }

        public boolean includesPubKey() {
            if (this.getType() == PEMType.RSA_PRIVATE_KEY || this.getType() == PEMType.PRIVATE_KEY) {
                return !this.encrypted;
            }
            return this.getType() == PEMType.OPENSSH_PRIVATE_KEY;
        }
    }

    public static class PEMDecodingException
    extends Exception {
        public PEMDecodingException() {
        }

        public PEMDecodingException(String message) {
            super(message);
        }

        public PEMDecodingException(String message, Throwable cause) {
            super(message, cause);
        }

        public PEMDecodingException(Throwable cause) {
            super(cause);
        }
    }

    public static enum PEMType {
        RSA_PRIVATE_KEY("RSA PRIVATE KEY"),
        PRIVATE_KEY("PRIVATE KEY"),
        OPENSSH_PRIVATE_KEY("OPENSSH PRIVATE KEY");

        private final String name;

        private PEMType(String name) {
            this.name = name;
        }

        @Nullable
        public static PEMType fromName(@Nonnull String name) {
            for (PEMType t : PEMType.values()) {
                if (!t.name.equals(name)) continue;
                return t;
            }
            return null;
        }
    }

    private static class OpenSSHPemParser {
        @Nonnull
        public final String cipherName;
        @Nonnull
        public final String kdfName;
        @Nonnull
        public final String kdfOptions;
        public final int keyCount;
        @Nonnull
        public final List<String> pubKeys;
        public final boolean encryptedPrivateKey;

        public OpenSSHPemParser(@Nonnull byte[] pemBytes) throws PEMDecodingException {
            ByteBuffer bb = ByteBuffer.wrap(pemBytes);
            byte[] AUTH_MAGIC = "openssh-key-v1\u0000".getBytes();
            for (int i = 0; i < AUTH_MAGIC.length; ++i) {
                if (bb.get() == AUTH_MAGIC[i]) continue;
                throw new PEMDecodingException("OPENSSH PRIVATE KEY invalid (AUTH_MAGIC is bad)");
            }
            this.cipherName = OpenSSHPemParser.readString(bb);
            System.out.println("OpenSSHPemParser cipherName=\"" + this.cipherName + "\"");
            this.encryptedPrivateKey = !this.cipherName.equals("none");
            this.kdfName = OpenSSHPemParser.readString(bb);
            System.out.println("OpenSSHPemParser kdfName=\"" + this.kdfName + "\"");
            this.kdfOptions = OpenSSHPemParser.readString(bb);
            System.out.println("OpenSSHPemParser kdfOptions=\"" + this.kdfOptions + "\"");
            this.keyCount = bb.getInt();
            System.out.println("OpenSSHPemParser keyCount=\"" + this.keyCount + "\"");
            ArrayList<CallSite> pubKeys = new ArrayList<CallSite>(this.keyCount);
            for (int i = 0; i < this.keyCount; ++i) {
                byte[] pubKeyBytes = OpenSSHPemParser.readByteString(bb);
                String keyType = OpenSSHPemParser.readString(ByteBuffer.wrap(pubKeyBytes));
                String pubKeyB64 = keyType + " " + Base64.getEncoder().encodeToString(pubKeyBytes);
                pubKeys.add((CallSite)((Object)pubKeyB64));
                System.out.println("OpenSSHPemParser pubKey[" + i + "]=\"" + new String(pubKeyBytes) + "\"");
                System.out.println("OpenSSHPemParser pubKey[" + i + "]=\"" + pubKeyB64 + "\"");
            }
            this.pubKeys = Collections.unmodifiableList(pubKeys);
        }

        @Nonnull
        private static String readString(@Nonnull ByteBuffer bb) {
            int strLen = bb.getInt();
            byte[] strBytes = new byte[strLen];
            bb.get(strBytes);
            return new String(strBytes, 0, strLen, Charset.defaultCharset());
        }

        @Nonnull
        private static byte[] readByteString(@Nonnull ByteBuffer bb) {
            int strLen = bb.getInt();
            byte[] strBytes = new byte[strLen];
            bb.get(strBytes);
            return strBytes;
        }
    }
}

