/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.util;

import be.iminds.ilabt.jfed.util.common.IOUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmailSender {
    private static final Logger LOG = LoggerFactory.getLogger(EmailSender.class);
    public static final long INTER_MAIL_DELAY_MS = 10000L;
    public static final String mailSubjectPrefix = "Fedmon API:";
    private final EmailSenderConfig config;
    private final Executor executor;

    public EmailSender(@Nullable EmailSenderConfig config) {
        this.config = config;
        this.executor = Executors.newSingleThreadExecutor();
    }

    public EmailSenderConfig getConfig() {
        return this.config;
    }

    public void sendExceptionToAdmin(String id, Throwable e) {
        String message = "There was an exception in Fedmon.\nID: " + id + "\n\nStacktrace:\n" + IOUtils.exceptionToStacktraceString((Throwable)e) + "\n";
        this.sendToAdmin("Fedmon API: Unexpected error " + id, message);
    }

    public void sendToAdmin(@Nonnull String subject, @Nonnull String body) {
        if (!this.hasValidConfig()) {
            LOG.debug("Email not configured: will not try to send");
            return;
        }
        this.executor.execute(() -> {
            this.performSendToAdmin(subject, body);
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException e) {
                LOG.warn("In between mail sleep was interrupted. Will skip rest of sleep.", (Throwable)e);
            }
        });
    }

    public void sendTo(@Nonnull String from, @Nonnull List<String> replyTos, @Nonnull List<String> tos, @Nonnull List<String> ccs, @Nonnull String subject, @Nonnull String body) {
        InternetAddress fromAddress;
        if (!this.hasValidConfig()) {
            LOG.debug("Email not configured: will not try to send");
            return;
        }
        List<InternetAddress> toAddresses = tos.stream().map(a -> {
            try {
                return new InternetAddress(a);
            }
            catch (AddressException e) {
                LOG.error("Invalid InternetAddress in TO, will skip it: \"" + a + "\"", (Throwable)e);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
        List<InternetAddress> replyToAddresses = replyTos.stream().map(a -> {
            try {
                return new InternetAddress(a);
            }
            catch (AddressException e) {
                LOG.error("Invalid InternetAddress in Reply-To, will skip it: \"" + a + "\"", (Throwable)e);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
        List<InternetAddress> ccAddresses = ccs.stream().map(a -> {
            try {
                return new InternetAddress(a);
            }
            catch (AddressException e) {
                LOG.error("Invalid InternetAddress in CC, will skip it: \"" + a + "\"", (Throwable)e);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
        try {
            fromAddress = new InternetAddress(from);
        }
        catch (AddressException e) {
            LOG.error("Invalid InternetAddress in FROM, will fall back to default. Default=\"" + this.config.getRawFrom() + "\" Bad address: \"" + from + "\"", (Throwable)e);
            fromAddress = this.config.getFrom();
        }
        this.sendTo(fromAddress, replyToAddresses, toAddresses, ccAddresses, subject, body);
    }

    public void sendTo(@Nonnull InternetAddress from, @Nonnull List<InternetAddress> replyTos, @Nonnull List<InternetAddress> tos, @Nonnull List<InternetAddress> ccs, @Nonnull String subject, @Nonnull String body) {
        ArrayList<InternetAddress> replyTosCopy = new ArrayList<InternetAddress>(replyTos);
        ArrayList<InternetAddress> tosCopy = new ArrayList<InternetAddress>(tos);
        ArrayList<InternetAddress> ccsCopy = new ArrayList<InternetAddress>(ccs);
        if (!this.hasValidConfig()) {
            LOG.debug("Email not configured: will not try to send");
            return;
        }
        this.executor.execute(() -> {
            this.performSendTo(from, replyTosCopy, tosCopy, ccsCopy, subject, body);
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException e) {
                LOG.warn("In between mail sleep was interrupted. Will skip rest of sleep.", (Throwable)e);
            }
        });
    }

    protected void performSendToAdmin(@Nonnull String subject, @Nonnull String body) {
        if (!this.hasValidConfig()) {
            return;
        }
        this.performSendTo(this.config.getFrom(), Collections.emptyList(), this.config.getTos(), Collections.emptyList(), subject, body);
    }

    protected void performSendTo(@Nonnull InternetAddress from, @Nonnull List<InternetAddress> replyTos, @Nonnull List<InternetAddress> tos, @Nonnull List<InternetAddress> ccs, @Nonnull String subject, @Nonnull String body) {
        if (!this.hasValidConfig()) {
            return;
        }
        Properties sysProperties = System.getProperties();
        sysProperties.setProperty("mail.smtp.host", this.config.getSmtpServer());
        Session session = this.config.getSmtpPassword() == null ? Session.getDefaultInstance((Properties)sysProperties) : Session.getInstance((Properties)sysProperties, (Authenticator)new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(EmailSender.this.config.getSmtpUsername(), EmailSender.this.config.getSmtpPassword());
            }
        });
        try {
            MimeMessage message = new MimeMessage(session);
            message.setFrom((Address)from);
            if (!replyTos.isEmpty()) {
                message.setReplyTo((Address[])replyTos.toArray(new InternetAddress[replyTos.size()]));
            }
            for (InternetAddress to : tos) {
                message.addRecipient(Message.RecipientType.TO, (Address)to);
            }
            for (InternetAddress cc : ccs) {
                message.addRecipient(Message.RecipientType.CC, (Address)cc);
            }
            message.setSubject(subject);
            message.setText(body);
            Transport.send((Message)message);
            LOG.info("Mail successfully sent to " + tos + (String)(ccs.isEmpty() ? "" : " and " + ccs));
        }
        catch (MessagingException e) {
            LOG.error("Error sending mail to " + tos + (String)(ccs.isEmpty() ? "" : " and " + ccs) + " using SMTP server " + this.config.getSmtpServer(), (Throwable)e);
        }
    }

    public boolean hasValidConfig() {
        return this.config != null && this.config.getTos() != null && !this.config.getTos().isEmpty() && this.config.getFrom() != null && this.config.getSmtpServer() != null;
    }

    public static class EmailSenderConfig {
        private final InternetAddress from;
        private final List<InternetAddress> tos;
        private final String rawFrom;
        private final List<String> rawTos;
        private final String smtpServer;
        private final String smtpUsername;
        private final String smtpPassword;
        private final Boolean notifyOnStartup;

        public EmailSenderConfig(@JsonProperty(value="fromAddress") @Nonnull String fromAddress, @JsonProperty(value="adminAddresses") @Nonnull List<String> adminAddresses, @JsonProperty(value="smtpServer") @Nonnull String smtpServer, @JsonProperty(value="smtpUsername") @Nullable String smtpUsername, @JsonProperty(value="smtpPassword") @Nullable String smtpPassword, @JsonProperty(value="notifyOnStartup") @Nullable Boolean notifyOnStartup) throws AddressException {
            this.rawFrom = fromAddress;
            this.rawTos = adminAddresses;
            this.from = new InternetAddress(fromAddress);
            this.tos = new ArrayList<InternetAddress>();
            for (String adminAddress : adminAddresses) {
                this.tos.add(new InternetAddress(adminAddress));
            }
            this.smtpServer = smtpServer;
            this.smtpUsername = smtpUsername;
            this.smtpPassword = smtpPassword;
            this.notifyOnStartup = Objects.equals(notifyOnStartup, Boolean.TRUE);
        }

        @JsonProperty(value="notifyOnStartup")
        public Boolean getNotifyOnStartup() {
            return this.notifyOnStartup;
        }

        @JsonProperty(value="fromAddress")
        public String getRawFrom() {
            return this.rawFrom;
        }

        @JsonProperty(value="adminAddresses")
        public List<String> getRawTos() {
            return this.rawTos;
        }

        @JsonIgnore
        public InternetAddress getFrom() {
            return this.from;
        }

        @JsonIgnore
        public List<InternetAddress> getTos() {
            return this.tos;
        }

        @JsonProperty
        public String getSmtpServer() {
            return this.smtpServer;
        }

        @JsonProperty
        public String getSmtpUsername() {
            return this.smtpUsername;
        }

        @JsonProperty
        public String getSmtpPassword() {
            return this.smtpPassword;
        }
    }
}

