/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.util;

import be.iminds.ilabt.jfed.fedmon.webapi.service.util.EmailSender;
import io.dropwizard.jersey.errors.ErrorMessage;
import java.sql.SQLException;
import java.util.concurrent.ThreadLocalRandom;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class JFedLoggingExceptionMapper<E extends Throwable>
implements ExceptionMapper<E> {
    private static final Logger LOGGER = LoggerFactory.getLogger(JFedLoggingExceptionMapper.class);
    private final EmailSender emailSender;

    public JFedLoggingExceptionMapper(EmailSender emailSender) {
        this.emailSender = emailSender;
    }

    public Response toResponse(E exception) {
        ErrorMessage errorMessage;
        int status;
        if (exception instanceof WebApplicationException) {
            Response id = ((WebApplicationException)exception).getResponse();
            if (id.getStatusInfo().equals(Response.Status.INTERNAL_SERVER_ERROR)) {
                this.logException(exception);
            }
            status = id.getStatus();
            errorMessage = new ErrorMessage(status, ((Throwable)exception).getLocalizedMessage());
        } else {
            long id1 = this.logException(exception);
            status = Response.Status.INTERNAL_SERVER_ERROR.getStatusCode();
            errorMessage = new ErrorMessage(this.formatErrorMessage(id1, exception));
        }
        return Response.status((int)status).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)errorMessage).build();
    }

    protected String formatErrorMessage(long id, E exception) {
        return String.format("Fedmon encountered an error processing your request. It has been logged (ID %016x).", id);
    }

    protected void logSQLException(long id, SQLException exception) {
        String message = this.formatLogMessage(id, exception);
        for (Throwable throwable : exception) {
            LOGGER.error(message, throwable);
        }
    }

    protected long logException(E exception) {
        long id = ThreadLocalRandom.current().nextLong();
        if (exception instanceof SQLException) {
            this.logSQLException(id, (SQLException)exception);
        } else {
            this.logException(id, exception);
        }
        if (this.emailSender != null) {
            try {
                this.emailSender.sendExceptionToAdmin(String.format("%016x", id), (Throwable)exception);
            }
            catch (Throwable e) {
                LOGGER.error("Exception sending email to admin. will ignore it.", e);
            }
        }
        return id;
    }

    protected void logException(long id, E exception) {
        LOGGER.error(this.formatLogMessage(id, (Throwable)exception), exception);
    }

    protected String formatLogMessage(long id, Throwable exception) {
        return String.format("Error handling a request: %016x", id);
    }
}

