/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.bugreport.dao;

import be.iminds.ilabt.jfed.bugreport.dao.BugReportDao;
import be.iminds.ilabt.jfed.bugreport.model.BugReport;
import be.iminds.ilabt.jfed.bugreport.model.BugReportBuilder;
import be.iminds.ilabt.jfed.bugreport.model.ConnectivityTestResult;
import be.iminds.ilabt.jfed.bugreport.model.LogLine;
import be.iminds.ilabt.jfed.bugreport.model.test.BugReportTestCollection;
import be.iminds.ilabt.jfed.bugreport.service.JFedBugReportWebApiApplication;
import be.iminds.ilabt.jfed.bugreport.service.JFedBugReportWebApiConfiguration;
import be.iminds.ilabt.jfed.bugreport.test.JFedBugReportTestPostgresDB;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import be.iminds.ilabt.util.jsonld.iface.JsonLdObjectWithId;
import be.iminds.ilabt.util.jsonld.test.CommonTest;
import io.dropwizard.db.PooledDataSourceFactory;
import io.dropwizard.jdbi.DBIFactory;
import io.dropwizard.setup.Environment;
import io.dropwizard.testing.ConfigOverride;
import io.dropwizard.testing.junit.DropwizardAppRule;
import java.sql.SQLException;
import java.time.Clock;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.skife.jdbi.v2.DBI;

public class BugReportDaoTest {
    @ClassRule
    public static final DropwizardAppRule<JFedBugReportWebApiConfiguration> RULE = new DropwizardAppRule(JFedBugReportWebApiApplication.class, "../fedmon-webapi-service-TESTING.yml", new ConfigOverride[0]);
    private static JFedBugReportTestPostgresDB testPostgresDB;
    private static DBI jdbi;
    private static BugReportDao bugReportDao;
    private BugReportTestCollection bugReportTestCollection;

    @BeforeClass
    public static void setUp() throws Exception {
        testPostgresDB = new JFedBugReportTestPostgresDB(RULE);
        testPostgresDB.dropAllTables();
        testPostgresDB.createAllTables();
        JFedBugReportWebApiConfiguration configuration = (JFedBugReportWebApiConfiguration)RULE.getConfiguration();
        Environment environment = RULE.getEnvironment();
        DBIFactory factory = new DBIFactory();
        jdbi = factory.build(environment, (PooledDataSourceFactory)configuration.getDataSourceFactory(), "postgresql");
        bugReportDao = (BugReportDao)jdbi.onDemand(BugReportDao.class);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        assert (testPostgresDB != null);
        testPostgresDB.close();
        jdbi.close((Object)bugReportDao);
        jdbi = null;
        bugReportDao = null;
        testPostgresDB = null;
        System.gc();
    }

    @Before
    public void beforeEachMethod() throws SQLException {
        assert (testPostgresDB != null);
        testPostgresDB.refillDB();
        this.bugReportTestCollection = new BugReportTestCollection();
    }

    @After
    public void afterEachMethod() throws SQLException {
    }

    @Test
    public void testFindById1() throws Exception {
        int index = 0;
        BugReportBuilder expectedBugReport = (BugReportBuilder)this.bugReportTestCollection.getBuilderByIndex(index);
        Integer id = (Integer)expectedBugReport.getId();
        BugReport actualBugReport = bugReportDao.get(id.intValue());
        MatcherAssert.assertThat((String)("Did not find bugReport " + id), (Object)actualBugReport, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        this.bugReportTestCollection.assertSame((JsonLdObjectWithId)actualBugReport, (JsonLdObjectWithId)expectedBugReport.create(), CommonTest.ComparePrecision.IGNORE_URI, CommonTest.ComparePrecision.MINIMAL_ID_ONLY);
        MatcherAssert.assertThat((Object)actualBugReport.getApiCallDetailIds(), (Matcher)Matchers.hasSize((int)3));
    }

    @Test
    public void testFindById2() throws Exception {
        int index = 1;
        BugReportBuilder expectedBugReport = (BugReportBuilder)this.bugReportTestCollection.getBuilderByIndex(index);
        Integer id = (Integer)expectedBugReport.getId();
        BugReport actualBugReport = bugReportDao.get(id.intValue());
        MatcherAssert.assertThat((String)("Did not find bugReport " + id), (Object)actualBugReport, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        this.bugReportTestCollection.assertSame((JsonLdObjectWithId)actualBugReport, (JsonLdObjectWithId)expectedBugReport.create(), CommonTest.ComparePrecision.IGNORE_URI, CommonTest.ComparePrecision.MINIMAL_ID_ONLY);
        MatcherAssert.assertThat((Object)actualBugReport.getApiCallDetailIds(), (Matcher)Matchers.hasSize((int)0));
    }

    @Test
    public void testFindById3() throws Exception {
        int index = 2;
        BugReportBuilder expectedBugReport = (BugReportBuilder)this.bugReportTestCollection.getBuilderByIndex(index);
        Integer id = (Integer)expectedBugReport.getId();
        BugReport actualBugReport = bugReportDao.get(id.intValue());
        MatcherAssert.assertThat((String)("Did not find bugReport " + id), (Object)actualBugReport, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        this.bugReportTestCollection.assertSame((JsonLdObjectWithId)actualBugReport, (JsonLdObjectWithId)expectedBugReport.create(), CommonTest.ComparePrecision.IGNORE_URI, CommonTest.ComparePrecision.MINIMAL_ID_ONLY);
        MatcherAssert.assertThat((Object)actualBugReport.getApiCallDetailIds(), (Matcher)Matchers.hasSize((int)0));
    }

    @Test
    public void testInsert() throws Exception {
        Clock clock = this.bugReportTestCollection.getClock();
        BugReport newBugReport = new BugReportBuilder().setReportTarget(BugReport.ReportTarget.TESTBED).setReportType(BugReport.ReportType.QUESTION).setPostOnPublicList(Boolean.valueOf(false)).setRelatedTestbeds(Arrays.asList(GeniUrn.createGeniUrnFromEncodedParts((String)"new.example.com", (String)"auth", (String)"am"))).addConnectivityTestResults(new ConnectivityTestResult("conTest7", ConnectivityTestResult.Status.SKIPPED, "conTestMessage7", null)).addLogLine(new LogLine(clock.instant().minus(71L, ChronoUnit.MINUTES), "class7", "WARNING", "message7", null, "thread 7")).setDescription("Description 7").setEnvironment("Environment 7").setLoggedInUserInfo("LoggedInUserInfo 7").setPreferences("test = seven\npref = p7\n").setReporterUrn(GeniUrn.createGeniUrnFromEncodedParts((String)"seven.example.com", (String)"user", (String)"seven").getValue()).setSubject("Test Subject 7").setVersion("version7").setMail("tester7@example.com").setCommitTime(clock.instant().plus(70L, ChronoUnit.SECONDS)).setScreenshot("screenshot 7").create();
        Integer newId = bugReportDao.insert(newBugReport);
        MatcherAssert.assertThat((Object)newId, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        BugReportBuilder expectedNewBugReportBuilder = new BugReportBuilder(newBugReport);
        expectedNewBugReportBuilder.setId((Object)newId);
        BugReport expectedNewBugReport = expectedNewBugReportBuilder.create();
        BugReport actualNewBugReport = bugReportDao.get(newId.intValue());
        System.out.println("Lookup inserted bugReport (" + newId + ") result: " + actualNewBugReport);
        MatcherAssert.assertThat((Object)actualNewBugReport, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)((Integer)actualNewBugReport.getId()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)newId)));
        this.bugReportTestCollection.assertSame((JsonLdObjectWithId)expectedNewBugReport, (JsonLdObjectWithId)actualNewBugReport, CommonTest.ComparePrecision.IGNORE_URI, CommonTest.ComparePrecision.MINIMAL_ID_ONLY);
    }
}

