/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.dao;

import be.iminds.ilabt.jfed.fedmon.util.Clock;
import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonWebApiServiceApplication;
import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonWebApiServiceConfiguration;
import be.iminds.ilabt.jfed.fedmon.webapi.service.dao.FederationTestbedMappingDao;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Federation;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Testbed;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.FederationTestCollection;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.FedmonTestPostgresDB;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.TestbedTestCollection;
import be.iminds.ilabt.util.jsonld.impl.PrimaryIdObject;
import io.dropwizard.db.PooledDataSourceFactory;
import io.dropwizard.jdbi.DBIFactory;
import io.dropwizard.setup.Environment;
import io.dropwizard.testing.ConfigOverride;
import io.dropwizard.testing.junit.DropwizardAppRule;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.skife.jdbi.v2.DBI;

public class FederationTestbedMappingDaoTest {
    @ClassRule
    public static final DropwizardAppRule<FedmonWebApiServiceConfiguration> RULE = new DropwizardAppRule(FedmonWebApiServiceApplication.class, "../fedmon-webapi-service-TESTING.yml", new ConfigOverride[0]);
    private static FedmonTestPostgresDB testPostgresDB;
    private static DBI jdbi;
    private static FederationTestbedMappingDao ftMappingDao;
    private static Lock lock;
    private FederationTestCollection federationTestCollection;
    private TestbedTestCollection testbedTestCollection;

    @BeforeClass
    public static void setUp() throws Exception {
        Clock.set((Clock.CurrentTimeProvider)new Clock.DefaultTestTimeProvider());
        testPostgresDB = new FedmonTestPostgresDB(RULE);
        testPostgresDB.dropAllTables();
        testPostgresDB.createAllTables();
        FedmonWebApiServiceConfiguration configuration = (FedmonWebApiServiceConfiguration)RULE.getConfiguration();
        Environment environment = RULE.getEnvironment();
        DBIFactory factory = new DBIFactory();
        jdbi = factory.build(environment, (PooledDataSourceFactory)configuration.getDataSourceFactory(), "postgresql");
        ftMappingDao = (FederationTestbedMappingDao)jdbi.onDemand(FederationTestbedMappingDao.class);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        assert (testPostgresDB != null);
        testPostgresDB.close();
        jdbi.close((Object)ftMappingDao);
        jdbi = null;
        ftMappingDao = null;
        testPostgresDB = null;
        System.gc();
        Clock.reset();
    }

    @Before
    public void beforeEachMethod() throws SQLException {
        lock.lock();
        assert (testPostgresDB != null);
        testPostgresDB.refillDB();
        this.federationTestCollection = new FederationTestCollection(true);
        this.testbedTestCollection = new TestbedTestCollection(false);
    }

    @After
    public void afterEachMethod() throws SQLException {
        lock.unlock();
    }

    @Test
    public void testFindByFederationId0() throws Exception {
        Federation expectedFederation = (Federation)this.federationTestCollection.getByIndex(0);
        List expectedTestbeds = expectedFederation.getTestbeds() == null ? Collections.emptyList() : expectedFederation.getTestbeds();
        List expectedTestbedIds = expectedTestbeds.stream().map(PrimaryIdObject::getId).collect(Collectors.toList());
        List actualTestbedIds = ftMappingDao.getTestbedIdsByFederationId((String)expectedFederation.getId());
        System.out.println("actualTestbedIds=" + actualTestbedIds);
        MatcherAssert.assertThat((Object)actualTestbedIds, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)actualTestbedIds, (Matcher)Matchers.containsInAnyOrder((Object[])expectedTestbedIds.toArray()));
    }

    @Test
    public void testFindByFederationId1() throws Exception {
        Federation expectedFederation = (Federation)this.federationTestCollection.getByIndex(0);
        List expectedTestbeds = expectedFederation.getTestbeds() == null ? Collections.emptyList() : expectedFederation.getTestbeds();
        List expectedTestbedIds = expectedTestbeds.stream().map(PrimaryIdObject::getId).collect(Collectors.toList());
        List actualTestbedIds = ftMappingDao.getTestbedIdsByFederationId((String)expectedFederation.getId());
        System.out.println("actualTestbedIds=" + actualTestbedIds);
        MatcherAssert.assertThat((Object)actualTestbedIds, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)actualTestbedIds, (Matcher)Matchers.containsInAnyOrder((Object[])expectedTestbedIds.toArray()));
    }

    @Test
    public void testFindByFederationId2() throws Exception {
        Federation expectedFederation = (Federation)this.federationTestCollection.getByIndex(0);
        List expectedTestbeds = expectedFederation.getTestbeds() == null ? Collections.emptyList() : expectedFederation.getTestbeds();
        List expectedTestbedIds = expectedTestbeds.stream().map(PrimaryIdObject::getId).collect(Collectors.toList());
        List actualTestbedIds = ftMappingDao.getTestbedIdsByFederationId((String)expectedFederation.getId());
        System.out.println("actualTestbedIds=" + actualTestbedIds);
        MatcherAssert.assertThat((Object)actualTestbedIds, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)actualTestbedIds, (Matcher)Matchers.containsInAnyOrder((Object[])expectedTestbedIds.toArray()));
    }

    @Test
    public void testFindByTestbedId0() throws Exception {
        Testbed expectedTestbed = (Testbed)this.testbedTestCollection.getByIndex(0);
        List expectedFederations = expectedTestbed.getFederations() == null ? Collections.emptyList() : expectedTestbed.getFederations();
        List expectedFederationIds = expectedFederations.stream().map(PrimaryIdObject::getId).collect(Collectors.toList());
        List actualFederationIds = ftMappingDao.getFederationIdsByTestbedId((String)expectedTestbed.getId());
        System.out.println("actualFederationIds=" + actualFederationIds);
        MatcherAssert.assertThat((Object)actualFederationIds, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)actualFederationIds, (Matcher)Matchers.containsInAnyOrder((Object[])expectedFederationIds.toArray()));
    }

    @Test
    public void testFindByTestbedId1() throws Exception {
        Testbed expectedTestbed = (Testbed)this.testbedTestCollection.getByIndex(0);
        List expectedFederations = expectedTestbed.getFederations() == null ? Collections.emptyList() : expectedTestbed.getFederations();
        List expectedFederationIds = expectedFederations.stream().map(PrimaryIdObject::getId).collect(Collectors.toList());
        List actualFederationIds = ftMappingDao.getFederationIdsByTestbedId((String)expectedTestbed.getId());
        System.out.println("actualFederationIds=" + actualFederationIds);
        MatcherAssert.assertThat((Object)actualFederationIds, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)actualFederationIds, (Matcher)Matchers.containsInAnyOrder((Object[])expectedFederationIds.toArray()));
    }

    @Test
    public void testFindByTestbedId2() throws Exception {
        Testbed expectedTestbed = (Testbed)this.testbedTestCollection.getByIndex(0);
        List expectedFederations = expectedTestbed.getFederations() == null ? Collections.emptyList() : expectedTestbed.getFederations();
        List expectedFederationIds = expectedFederations.stream().map(PrimaryIdObject::getId).collect(Collectors.toList());
        List actualFederationIds = ftMappingDao.getFederationIdsByTestbedId((String)expectedTestbed.getId());
        System.out.println("actualFederationIds=" + actualFederationIds);
        MatcherAssert.assertThat((Object)actualFederationIds, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)actualFederationIds, (Matcher)Matchers.containsInAnyOrder((Object[])expectedFederationIds.toArray()));
    }

    @Test
    public void testInsert() {
        List actualFederationIds = ftMappingDao.getFederationIdsByTestbedId("C");
        List<String> expectedFederationIds = Arrays.asList("fed2");
        MatcherAssert.assertThat((Object)actualFederationIds, (Matcher)Matchers.containsInAnyOrder((Object[])expectedFederationIds.toArray()));
        ftMappingDao.insert("C", "fed1");
        actualFederationIds = ftMappingDao.getFederationIdsByTestbedId("C");
        expectedFederationIds = Arrays.asList("fed2", "fed1");
        MatcherAssert.assertThat((Object)actualFederationIds, (Matcher)Matchers.containsInAnyOrder((Object[])expectedFederationIds.toArray()));
    }

    @Test
    public void testDelete() {
        List actualFederationIds = ftMappingDao.getFederationIdsByTestbedId("A");
        List<String> expectedFederationIds = Arrays.asList("fed1", "subfed1a");
        MatcherAssert.assertThat((Object)actualFederationIds, (Matcher)Matchers.containsInAnyOrder((Object[])expectedFederationIds.toArray()));
        ftMappingDao.delete("A", "fed1");
        actualFederationIds = ftMappingDao.getFederationIdsByTestbedId("A");
        expectedFederationIds = Arrays.asList("subfed1a");
        System.out.println("actualFederationIds=" + actualFederationIds);
        MatcherAssert.assertThat((Object)actualFederationIds, (Matcher)Matchers.containsInAnyOrder((Object[])expectedFederationIds.toArray()));
    }

    @Test
    public void testUpdateTestbedsForFederation() {
        List<String> expectedTestbedIds = Arrays.asList("B", "C");
        int count = ftMappingDao.updateTestbedsForFederation("fed1", expectedTestbedIds);
        MatcherAssert.assertThat((Object)count, (Matcher)Matchers.is((Object)2));
        List actualTestbedIds = ftMappingDao.getTestbedIdsByFederationId("fed1");
        System.out.println("actualTestbedIds=" + actualTestbedIds);
        MatcherAssert.assertThat((Object)actualTestbedIds, (Matcher)Matchers.containsInAnyOrder((Object[])expectedTestbedIds.toArray()));
    }

    @Test
    public void testUpdateFederationsForTestbed() {
        List<String> expectedFederationIds = Arrays.asList("fed2", "subfed1a");
        int count = ftMappingDao.updateFederationsForTestbed("A", expectedFederationIds);
        MatcherAssert.assertThat((Object)count, (Matcher)Matchers.is((Object)2));
        List actualFederationIds = ftMappingDao.getFederationIdsByTestbedId("A");
        System.out.println("actualFederationIds=" + actualFederationIds);
        MatcherAssert.assertThat((Object)actualFederationIds, (Matcher)Matchers.containsInAnyOrder((Object[])expectedFederationIds.toArray()));
    }

    static {
        lock = new ReentrantLock();
    }
}

