/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.dao;

import be.iminds.ilabt.jfed.fedmon.util.Clock;
import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonWebApiServiceApplication;
import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonWebApiServiceConfiguration;
import be.iminds.ilabt.jfed.fedmon.webapi.service.dao.JFedExperimenterGuiConfigDao;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.GuiConfigSet;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.JFedExperimenterGuiConfig;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.JFedExperimenterGuiConfigBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.UserInfo;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.FedmonTestPostgresDB;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.GuiConfigSetTestCollection;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.JFedExperimenterGuiConfigTestCollection;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.UserInfoTestCollection;
import be.iminds.ilabt.util.jsonld.iface.JsonLdObject;
import be.iminds.ilabt.util.jsonld.test.CommonTest;
import io.dropwizard.db.PooledDataSourceFactory;
import io.dropwizard.jdbi.DBIFactory;
import io.dropwizard.setup.Environment;
import io.dropwizard.testing.ConfigOverride;
import io.dropwizard.testing.junit.DropwizardAppRule;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.skife.jdbi.v2.DBI;

public class JFedExperimenterGuiConfigDaoTest {
    @ClassRule
    public static final DropwizardAppRule<FedmonWebApiServiceConfiguration> RULE = new DropwizardAppRule(FedmonWebApiServiceApplication.class, "../fedmon-webapi-service-TESTING.yml", new ConfigOverride[0]);
    private static FedmonTestPostgresDB testPostgresDB;
    private static DBI jdbi;
    private static JFedExperimenterGuiConfigDao jFedExperimenterGuiConfigDao;
    private static Lock lock;
    private UserInfoTestCollection userInfoTestCollection;
    private GuiConfigSetTestCollection guiConfigSetTestCollection;
    private JFedExperimenterGuiConfigTestCollection jFedExperimenterGuiConfigTestCollection;

    @BeforeClass
    public static void setUp() throws Exception {
        Clock.set((Clock.CurrentTimeProvider)new Clock.DefaultTestTimeProvider());
        testPostgresDB = new FedmonTestPostgresDB(RULE);
        testPostgresDB.dropAllTables();
        testPostgresDB.createAllTables();
        FedmonWebApiServiceConfiguration configuration = (FedmonWebApiServiceConfiguration)RULE.getConfiguration();
        Environment environment = RULE.getEnvironment();
        DBIFactory factory = new DBIFactory();
        jdbi = factory.build(environment, (PooledDataSourceFactory)configuration.getDataSourceFactory(), "postgresql");
        jFedExperimenterGuiConfigDao = (JFedExperimenterGuiConfigDao)jdbi.onDemand(JFedExperimenterGuiConfigDao.class);
        assert (jFedExperimenterGuiConfigDao != null);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        assert (testPostgresDB != null);
        testPostgresDB.close();
        jdbi.close((Object)jFedExperimenterGuiConfigDao);
        jdbi = null;
        jFedExperimenterGuiConfigDao = null;
        testPostgresDB = null;
        System.gc();
        Clock.reset();
    }

    @Before
    public void beforeEachMethod() throws SQLException {
        lock.lock();
        assert (testPostgresDB != null);
        testPostgresDB.refillDB();
        assert (jFedExperimenterGuiConfigDao != null);
        this.jFedExperimenterGuiConfigTestCollection = new JFedExperimenterGuiConfigTestCollection();
        this.userInfoTestCollection = new UserInfoTestCollection();
        this.guiConfigSetTestCollection = new GuiConfigSetTestCollection();
    }

    @After
    public void afterEachMethod() throws SQLException {
        lock.unlock();
    }

    @Test
    public void testGetConfig0() throws Exception {
        List<String> guiConfigSetIds = Arrays.asList("testA");
        assert (guiConfigSetIds.get(0).equals(((GuiConfigSet)this.guiConfigSetTestCollection.getByIndex(0)).getId()));
        assert (jFedExperimenterGuiConfigDao != null);
        JFedExperimenterGuiConfigBuilder actualBuilder = jFedExperimenterGuiConfigDao.getConfig(guiConfigSetIds);
        JFedExperimenterGuiConfig expected = (JFedExperimenterGuiConfig)this.jFedExperimenterGuiConfigTestCollection.getByIndex(0);
        actualBuilder.setUser((UserInfo)this.userInfoTestCollection.getByIndex(0));
        JFedExperimenterGuiConfig actual = actualBuilder.create();
        System.out.println("testGetConfig 0 res = " + actual);
        MatcherAssert.assertThat((Object)actual, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        this.jFedExperimenterGuiConfigTestCollection.assertSame((JsonLdObject)actual, (JsonLdObject)expected, CommonTest.ComparePrecision.IGNORE_URI, CommonTest.ComparePrecision.IGNORE_URI);
    }

    @Test
    public void testGetConfig1() throws Exception {
        List<String> guiConfigSetIds = Arrays.asList("testB");
        assert (guiConfigSetIds.get(0).equals(((GuiConfigSet)this.guiConfigSetTestCollection.getByIndex(1)).getId()));
        assert (((GuiConfigSet)this.guiConfigSetTestCollection.getByIndex(1)).getBindableServers() == null);
        assert (((GuiConfigSet)this.guiConfigSetTestCollection.getByIndex(1)).getHideServers() == null);
        assert (jFedExperimenterGuiConfigDao != null);
        JFedExperimenterGuiConfigBuilder actualBuilder = jFedExperimenterGuiConfigDao.getConfig(guiConfigSetIds);
        JFedExperimenterGuiConfig expected = (JFedExperimenterGuiConfig)this.jFedExperimenterGuiConfigTestCollection.getByIndex(1);
        assert (expected.getBindableServers() == null);
        assert (expected.getHideServers() == null);
        actualBuilder.setUser((UserInfo)this.userInfoTestCollection.getByIndex(1));
        JFedExperimenterGuiConfig actual = actualBuilder.create();
        System.out.println("testGetConfig 1 res = " + actual);
        MatcherAssert.assertThat((Object)actual, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        this.jFedExperimenterGuiConfigTestCollection.assertSame((JsonLdObject)actual, (JsonLdObject)expected, CommonTest.ComparePrecision.IGNORE_URI, CommonTest.ComparePrecision.IGNORE_URI);
    }

    static {
        lock = new ReentrantLock();
    }
}

