/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.dao;

import be.iminds.ilabt.jfed.fedmon.util.Clock;
import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonWebApiServiceApplication;
import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonWebApiServiceConfiguration;
import be.iminds.ilabt.jfed.fedmon.webapi.service.dao.ResourceClassDao;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Resource;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ResourceClass;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ResourceClassBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.FedmonTestPostgresDB;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.ResourceClassTestCollection;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.ResourceTestCollection;
import be.iminds.ilabt.util.jsonld.iface.JsonLdObjectWithId;
import io.dropwizard.db.PooledDataSourceFactory;
import io.dropwizard.jdbi.DBIFactory;
import io.dropwizard.setup.Environment;
import io.dropwizard.testing.ConfigOverride;
import io.dropwizard.testing.junit.DropwizardAppRule;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.skife.jdbi.v2.DBI;

public class ResourceClassDaoTest {
    @ClassRule
    public static final DropwizardAppRule<FedmonWebApiServiceConfiguration> RULE = new DropwizardAppRule(FedmonWebApiServiceApplication.class, "../fedmon-webapi-service-TESTING.yml", new ConfigOverride[0]);
    private static FedmonTestPostgresDB testPostgresDB;
    private static DBI jdbi;
    private static ResourceClassDao resourceClassDao;
    private static Lock lock;
    private ResourceClassTestCollection resourceClassTestCollection;
    private ResourceTestCollection resourceTestCollection;

    @BeforeClass
    public static void setUp() throws Exception {
        Clock.set((Clock.CurrentTimeProvider)new Clock.DefaultTestTimeProvider());
        testPostgresDB = new FedmonTestPostgresDB(RULE);
        testPostgresDB.dropAllTables();
        testPostgresDB.createAllTables();
        FedmonWebApiServiceConfiguration configuration = (FedmonWebApiServiceConfiguration)RULE.getConfiguration();
        Environment environment = RULE.getEnvironment();
        DBIFactory factory = new DBIFactory();
        jdbi = factory.build(environment, (PooledDataSourceFactory)configuration.getDataSourceFactory(), "postgresql");
        resourceClassDao = (ResourceClassDao)jdbi.onDemand(ResourceClassDao.class);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        assert (testPostgresDB != null);
        testPostgresDB.close();
        jdbi.close((Object)resourceClassDao);
        jdbi = null;
        resourceClassDao = null;
        testPostgresDB = null;
        System.gc();
        Clock.reset();
    }

    @Before
    public void beforeEachMethod() throws SQLException {
        lock.lock();
        assert (testPostgresDB != null);
        testPostgresDB.refillDB();
        this.resourceClassTestCollection = new ResourceClassTestCollection(false, true, true);
        this.resourceTestCollection = new ResourceTestCollection(false, false, true);
    }

    @After
    public void afterEachMethod() throws SQLException {
        lock.unlock();
    }

    @Test
    public void testFindById0() throws Exception {
        ResourceClass expectedResourceClass = (ResourceClass)this.resourceClassTestCollection.getByIndex(0);
        ResourceClass actualResourceClass = resourceClassDao.findById((String)expectedResourceClass.getId()).create();
        this.resourceClassTestCollection.assertSameButIgnoreUri((JsonLdObjectWithId)actualResourceClass, (JsonLdObjectWithId)expectedResourceClass);
    }

    @Test
    public void testFindById1() throws Exception {
        ResourceClass expectedResourceClass = (ResourceClass)this.resourceClassTestCollection.getByIndex(1);
        ResourceClass actualResourceClass = resourceClassDao.findById((String)expectedResourceClass.getId()).create();
        this.resourceClassTestCollection.assertSameButIgnoreUri((JsonLdObjectWithId)actualResourceClass, (JsonLdObjectWithId)expectedResourceClass);
    }

    @Test
    public void testFindAll() throws Exception {
        List res = resourceClassDao.findAll();
        System.out.println("testFindAll res = " + res);
        MatcherAssert.assertThat((Object)res, (Matcher)Matchers.hasSize((int)this.resourceClassTestCollection.getSize()));
        for (ResourceClassBuilder resResourceClass : res) {
            MatcherAssert.assertThat((Object)resResourceClass, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            ResourceClass origResourceClass = (ResourceClass)this.resourceClassTestCollection.getById((String)resResourceClass.getId());
            MatcherAssert.assertThat((Object)origResourceClass, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            try {
                this.resourceClassTestCollection.assertSameButIgnoreUri((JsonLdObjectWithId)resResourceClass.create(), (JsonLdObjectWithId)origResourceClass);
            }
            catch (AssertionError e) {
                System.err.flush();
                System.out.println("\n\nCompared resourceClasses differ!\nExpected:\n" + origResourceClass);
                System.out.println("\n\nActual:\n" + resResourceClass.create() + "\n\n");
                System.out.flush();
                System.err.flush();
                throw e;
            }
        }
    }

    @Test
    public void testInsert() {
        String newId = "testInsert";
        ResourceClass newResourceClass = ((ResourceClassBuilder)new ResourceClassBuilder((ResourceClass)this.resourceClassTestCollection.getByIndex(0)).setId((Object)newId)).setHrn("Test Insert").create();
        resourceClassDao.insert(newResourceClass);
        ResourceClass actualNewResourceClass = resourceClassDao.findById(newId).create();
        System.out.println("Lookup inserted resourceClass (" + newId + ") result: " + actualNewResourceClass);
        MatcherAssert.assertThat((Object)actualNewResourceClass, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)((String)actualNewResourceClass.getId()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)newId)));
        this.resourceClassTestCollection.assertSameButIgnoreUri((JsonLdObjectWithId)newResourceClass, (JsonLdObjectWithId)actualNewResourceClass);
    }

    @Test
    public void testUpdate1() {
        ResourceClass origResourceClass = (ResourceClass)this.resourceClassTestCollection.getByIndex(0);
        Resource newDefaultResource = (Resource)this.resourceTestCollection.getByIndex(3);
        MatcherAssert.assertThat((Object)origResourceClass.getDefaultResource().size(), (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat((Object)((Integer)((Resource)origResourceClass.getDefaultResource().get(0)).getId()), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)((Integer)newDefaultResource.getId())))));
        MatcherAssert.assertThat((Object)((Integer)((Resource)origResourceClass.getDefaultResource().get(1)).getId()), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)((Integer)newDefaultResource.getId())))));
        ResourceClass updatedResourceClass = new ResourceClassBuilder(origResourceClass).setHrn("Test Update").setDefaultResource(Arrays.asList(newDefaultResource)).create();
        MatcherAssert.assertThat((Object)updatedResourceClass.getDefaultResource(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)updatedResourceClass.getDefaultResource().size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)((Integer)((Resource)updatedResourceClass.getDefaultResource().get(0)).getId()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)((Integer)newDefaultResource.getId()))));
        resourceClassDao.update(updatedResourceClass);
        ResourceClass actualNewResourceClass = resourceClassDao.findById((String)origResourceClass.getId()).create();
        System.out.println("Lookup updated resourceClass (" + (String)origResourceClass.getId() + ") result: " + actualNewResourceClass);
        MatcherAssert.assertThat((Object)actualNewResourceClass, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)((String)actualNewResourceClass.getId()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)((String)origResourceClass.getId()))));
        this.resourceClassTestCollection.assertSameButIgnoreUri((JsonLdObjectWithId)updatedResourceClass, (JsonLdObjectWithId)actualNewResourceClass);
        MatcherAssert.assertThat((Object)actualNewResourceClass.getDefaultResource().size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)((Integer)((Resource)actualNewResourceClass.getDefaultResource().get(0)).getId()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)((Integer)newDefaultResource.getId()))));
    }

    @Test
    public void testUpdate2() {
        ResourceClass origResourceClass = (ResourceClass)this.resourceClassTestCollection.getByIndex(0);
        MatcherAssert.assertThat((Object)origResourceClass.getDefaultResource().size(), (Matcher)Matchers.is((Object)2));
        ResourceClass updatedResourceClass = new ResourceClassBuilder(origResourceClass).setHrn("Test Update").setDefaultResource(null).create();
        MatcherAssert.assertThat((Object)updatedResourceClass.getDefaultResource(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        resourceClassDao.update(updatedResourceClass);
        ResourceClass actualNewResourceClass = resourceClassDao.findById((String)origResourceClass.getId()).create();
        System.out.println("Lookup updated resourceClass (" + (String)origResourceClass.getId() + ") result: " + actualNewResourceClass);
        MatcherAssert.assertThat((Object)actualNewResourceClass, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)((String)actualNewResourceClass.getId()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)((String)origResourceClass.getId()))));
        this.resourceClassTestCollection.assertSameButIgnoreUri((JsonLdObjectWithId)updatedResourceClass, (JsonLdObjectWithId)actualNewResourceClass);
        MatcherAssert.assertThat((Object)actualNewResourceClass.getDefaultResource(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void testUpdate3() {
        ResourceClass origResourceClass = (ResourceClass)this.resourceClassTestCollection.getByIndex(0);
        MatcherAssert.assertThat((Object)origResourceClass.getDefaultResource().size(), (Matcher)Matchers.is((Object)2));
        ResourceClass updatedResourceClass = new ResourceClassBuilder(origResourceClass).setHrn("Test Update").setDefaultResource(Collections.emptyList()).create();
        MatcherAssert.assertThat((Object)updatedResourceClass.getDefaultResource(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)updatedResourceClass.getDefaultResource(), (Matcher)Matchers.hasSize((int)0));
        resourceClassDao.update(updatedResourceClass);
        ResourceClass actualNewResourceClass = resourceClassDao.findById((String)origResourceClass.getId()).create();
        System.out.println("Lookup updated resourceClass (" + (String)origResourceClass.getId() + ") result: " + actualNewResourceClass);
        MatcherAssert.assertThat((Object)actualNewResourceClass, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)((String)actualNewResourceClass.getId()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)((String)origResourceClass.getId()))));
        this.resourceClassTestCollection.assertSameButIgnoreUri((JsonLdObjectWithId)updatedResourceClass, (JsonLdObjectWithId)actualNewResourceClass);
        MatcherAssert.assertThat((Object)actualNewResourceClass.getDefaultResource(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)actualNewResourceClass.getDefaultResource(), (Matcher)Matchers.hasSize((int)0));
    }

    static {
        lock = new ReentrantLock();
    }
}

