/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.dao;

import be.iminds.ilabt.jfed.fedmon.util.Clock;
import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonWebApiServiceApplication;
import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonWebApiServiceConfiguration;
import be.iminds.ilabt.jfed.fedmon.webapi.service.dao.ResultDao;
import be.iminds.ilabt.jfed.fedmon.webapi.service.dao.TaskDao;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Result;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ResultBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Task;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestInstance;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.FedmonTestPostgresDB;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.ResultTestCollection;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.TaskTestCollection;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.TestClock;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.TestInstancesTestCollection;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.TestbedTestCollection;
import be.iminds.ilabt.util.jsonld.iface.JsonLdObjectWithId;
import io.dropwizard.db.PooledDataSourceFactory;
import io.dropwizard.jdbi.DBIFactory;
import io.dropwizard.setup.Environment;
import io.dropwizard.testing.ConfigOverride;
import io.dropwizard.testing.junit.DropwizardAppRule;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.skife.jdbi.v2.DBI;

public class ResultDaoTest {
    @ClassRule
    public static final DropwizardAppRule<FedmonWebApiServiceConfiguration> RULE = new DropwizardAppRule(FedmonWebApiServiceApplication.class, "../fedmon-webapi-service-TESTING.yml", new ConfigOverride[0]);
    private static FedmonTestPostgresDB testPostgresDB;
    private static DBI jdbi;
    private static ResultDao resultDao;
    private static TaskDao taskDao;
    private static Lock lock;
    private static Clock.DefaultTestTimeProvider timeProvider;
    private TaskTestCollection taskTestCollection;
    private ResultTestCollection resultTestCollection;
    private TestbedTestCollection testbedTestCollection;
    private TestInstancesTestCollection testInstances;

    @BeforeClass
    public static void setUp() throws Exception {
        timeProvider = new Clock.DefaultTestTimeProvider();
        Clock.set((Clock.CurrentTimeProvider)timeProvider);
        Clock.lockProvider();
        testPostgresDB = new FedmonTestPostgresDB(RULE);
        testPostgresDB.dropAllTables();
        testPostgresDB.createAllTables();
        FedmonWebApiServiceConfiguration configuration = (FedmonWebApiServiceConfiguration)RULE.getConfiguration();
        Environment environment = RULE.getEnvironment();
        DBIFactory factory = new DBIFactory();
        jdbi = factory.build(environment, (PooledDataSourceFactory)configuration.getDataSourceFactory(), "postgresql");
        resultDao = (ResultDao)jdbi.onDemand(ResultDao.class);
        taskDao = (TaskDao)jdbi.onDemand(TaskDao.class);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        assert (testPostgresDB != null);
        testPostgresDB.close();
        jdbi.close((Object)resultDao);
        jdbi.close((Object)taskDao);
        jdbi = null;
        taskDao = null;
        resultDao = null;
        testPostgresDB = null;
        System.gc();
        Clock.reset();
    }

    @Before
    public void beforeEachMethod() throws SQLException {
        lock.lock();
        assert (testPostgresDB != null);
        testPostgresDB.refillDB();
        timeProvider.relativeNowOffsetMillis(0L);
        this.taskTestCollection = new TaskTestCollection();
        this.resultTestCollection = new ResultTestCollection(false);
        this.testbedTestCollection = new TestbedTestCollection();
        this.testInstances = new TestInstancesTestCollection();
    }

    @After
    public void afterEachMethod() throws SQLException {
        lock.unlock();
    }

    @Test
    public void testInsert() throws Exception {
        long taskId = 2L;
        int testInstanceId = 10;
        TestInstance ti = (TestInstance)this.testInstances.getById(testInstanceId);
        assert (ti != null);
        assert (ti.getParameters() != null);
        Task origTask2 = (Task)this.taskTestCollection.getByIndex(1);
        timeProvider.setNowOffset(origTask2.getStart());
        timeProvider.relativeNowOffsetMinutes(1L);
        assert (Clock.nowDate().after(origTask2.getStart()));
        assert (Clock.nowDate().before(origTask2.getDeadline()));
        ResultBuilder newResult = this.resultTestCollection.createNewResult(ti, "SUCCESS");
        assert (newResult.getTask() == null);
        Timestamp newResultExpire = newResult.getExpire();
        newResult.setTask(Long.valueOf(taskId), null);
        assert (newResultExpire.after(origTask2.getStart()));
        assert (newResultExpire.before(origTask2.getDeadline())) : "\norigTask2.getStart()=   " + origTask2.getStart() + "\nnewResultExpire=        " + newResultExpire + "\norigTask2.getDeadline()=" + origTask2.getDeadline();
        Long newId = resultDao.insert(newResult.create(), newResultExpire, TestClock.get().getOffsetMinutes(5L));
        MatcherAssert.assertThat((Object)newId, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        newResult.setId((Object)newId);
        newResult.setTestDefinitionId(newResult.getTestInstance().getTestDefinitionId());
        newResult.setTask(null);
        Result expectedResult = newResult.create();
        Result actualResult = resultDao.findById(newId);
        Task t = taskDao.findById(Long.valueOf(taskId));
        newResult = null;
        MatcherAssert.assertThat((Object)actualResult.getTaskId(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        this.resultTestCollection.assertSameButIgnoreUri((JsonLdObjectWithId)actualResult, (JsonLdObjectWithId)expectedResult);
        MatcherAssert.assertThat((Object)t.getResultId(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)t.getResultId(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)newId)));
        MatcherAssert.assertThat((Object)t.getState(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Task.State.FINISHED)));
    }

    @Test
    public void testInsertSpecialCase() throws Exception {
        ResultBuilder newResult = this.resultTestCollection.createNewResult((TestInstance)this.testInstances.getById(9), "SUCCESS");
        newResult.setTask(null, null);
        Long newId = resultDao.insert(newResult.create(), TestClock.get().getOffsetMinutes(10L), TestClock.get().getOffsetMinutes(5L));
        MatcherAssert.assertThat((Object)newId, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test(expected=Exception.class)
    public void testInsertFail2() throws Exception {
        ResultBuilder newResult = this.resultTestCollection.createNewResult((TestInstance)this.testInstances.getById(9), "SUCCESS");
        newResult.setTask(Long.valueOf(4L), null);
        Long newId = resultDao.insert(newResult.create(), TestClock.get().getOffsetMinutes(10L), TestClock.get().getOffsetMinutes(5L));
    }

    @Test
    public void testFindById1() throws Exception {
        int index = 0;
        Result expectedResult = (Result)this.resultTestCollection.getByIndex(index);
        long id = (Long)expectedResult.getId();
        Result actualResult = resultDao.findById(Long.valueOf(id));
        MatcherAssert.assertThat((String)("Did not find result " + id), (Object)actualResult, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        this.resultTestCollection.assertSameButIgnoreUri((JsonLdObjectWithId)actualResult, (JsonLdObjectWithId)expectedResult);
    }

    @Test
    public void testFindById2() throws Exception {
        int index = 1;
        Result expectedResult = (Result)this.resultTestCollection.getByIndex(index);
        long id = (Long)expectedResult.getId();
        Result actualResult = resultDao.findById(Long.valueOf(id));
        MatcherAssert.assertThat((String)("Did not find result " + id), (Object)actualResult, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        this.resultTestCollection.assertSameButIgnoreUri((JsonLdObjectWithId)actualResult, (JsonLdObjectWithId)expectedResult);
    }

    @Test
    public void testFindById3() throws Exception {
        int index = 2;
        Result expectedResult = (Result)this.resultTestCollection.getByIndex(index);
        long id = (Long)expectedResult.getId();
        Result actualResult = resultDao.findById(Long.valueOf(id));
        MatcherAssert.assertThat((String)("Did not find result " + id), (Object)actualResult, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        this.resultTestCollection.assertSameButIgnoreUri((JsonLdObjectWithId)actualResult, (JsonLdObjectWithId)expectedResult);
    }

    @Test
    public void testFindById4() throws Exception {
        int index = 3;
        Result expectedResult = (Result)this.resultTestCollection.getByIndex(index);
        long id = (Long)expectedResult.getId();
        Result actualResult = resultDao.findById(Long.valueOf(id));
        MatcherAssert.assertThat((String)("Did not find result " + id), (Object)actualResult, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        this.resultTestCollection.assertSameButIgnoreUri((JsonLdObjectWithId)actualResult, (JsonLdObjectWithId)expectedResult);
    }

    @Test
    public void testFindById5() throws Exception {
        int index = 4;
        Result expectedResult = (Result)this.resultTestCollection.getByIndex(index);
        long id = (Long)expectedResult.getId();
        Result actualResult = resultDao.findById(Long.valueOf(id));
        MatcherAssert.assertThat((String)("Did not find result " + id), (Object)actualResult, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        System.out.println("Expecting: " + expectedResult + "\n\n");
        System.out.println("Actual:    " + actualResult + "\n\n");
        this.resultTestCollection.assertSameButIgnoreUri((JsonLdObjectWithId)actualResult, (JsonLdObjectWithId)expectedResult);
    }

    @Test
    public void testFindById6() throws Exception {
        int index = 5;
        Result expectedResult = (Result)this.resultTestCollection.getByIndex(index);
        long id = (Long)expectedResult.getId();
        Result actualResult = resultDao.findById(Long.valueOf(id));
        MatcherAssert.assertThat((String)("Did not find result " + id), (Object)actualResult, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        this.resultTestCollection.assertSameButIgnoreUri((JsonLdObjectWithId)actualResult, (JsonLdObjectWithId)expectedResult);
    }

    @Test
    public void testFindById7() throws Exception {
        int index = 6;
        Result expectedResult = (Result)this.resultTestCollection.getByIndex(index);
        long id = (Long)expectedResult.getId();
        Result actualResult = resultDao.findById(Long.valueOf(id));
        MatcherAssert.assertThat((String)("Did not find result " + id), (Object)actualResult, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        this.resultTestCollection.assertSameButIgnoreUri((JsonLdObjectWithId)actualResult, (JsonLdObjectWithId)expectedResult);
    }

    @Test
    public void testSearch0() throws Exception {
        List<String> versionNameFilter = Arrays.asList(new String[0]);
        List<String> testInstanceNameFilter = Arrays.asList(new String[0]);
        List<String> testDefinitionNameFilter = Arrays.asList(new String[0]);
        List<Integer> testInstanceIdFilter = Arrays.asList(new Integer[0]);
        List<String> testbedCategoryFilter = Arrays.asList(new String[0]);
        List<String> testbedGeniNameFilter = Arrays.asList(new String[0]);
        List<String> testbedUrnFilter = Arrays.asList(new String[0]);
        List<String> testbedNameFilter = Arrays.asList(new String[0]);
        List<Integer> serverIdFilter = Arrays.asList(new Integer[0]);
        Boolean disabled = null;
        ResultDao.CancelledTestResultIncluded cancelledIncluded = ResultDao.CancelledTestResultIncluded.INCLUDED;
        Boolean expired = null;
        List expected = this.resultTestCollection.getByIds(new Long[]{1L, 2L, 4L, 7L});
        List actualResults = resultDao.searchLast(versionNameFilter, testInstanceNameFilter, testDefinitionNameFilter, testInstanceIdFilter, testbedCategoryFilter, testbedGeniNameFilter, testbedUrnFilter, testbedNameFilter, serverIdFilter, disabled, cancelledIncluded, expired);
        MatcherAssert.assertThat((Object)actualResults, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)actualResults, (Matcher)Matchers.hasSize((int)expected.size()));
        for (Result actual : actualResults) {
            Result expectedResult = (Result)this.resultTestCollection.searchListById(expected, (Long)actual.getId());
            this.resultTestCollection.assertSameButIgnoreUri((JsonLdObjectWithId)actual, (JsonLdObjectWithId)expectedResult);
        }
    }

    @Test
    public void testSearch1() throws Exception {
        List<String> versionNameFilter = Arrays.asList("prod", "test");
        List<String> testInstanceNameFilter = Arrays.asList("getVersionB", "pingA");
        List<String> testDefinitionNameFilter = Arrays.asList("anyGetVersion", "ping");
        List<Integer> testInstanceIdFilter = Arrays.asList(9, 10);
        List<String> testbedCategoryFilter = Arrays.asList("oneAndTwo");
        List<String> testbedGeniNameFilter = Arrays.asList("ex-a", "ex-b");
        List<String> testbedUrnFilter = Arrays.asList("urn:publicid:IDN+b.example.com+authority+cm", "urn:publicid:IDN+a.example.com+authority+cm");
        List<String> testbedNameFilter = Arrays.asList("A", "B");
        List<Integer> serverIdFilter = Arrays.asList(99, 100);
        Boolean disabled = false;
        ResultDao.CancelledTestResultIncluded cancelledIncluded = ResultDao.CancelledTestResultIncluded.INCLUDED;
        Boolean expired = true;
        List expected = this.resultTestCollection.getByIds(new Long[]{1L, 2L});
        if (((Result)expected.get(0)).getExpire().after(((Result)expected.get(1)).getExpire())) {
            timeProvider.setNowOffset(((Result)expected.get(0)).getExpire());
        } else {
            timeProvider.setNowOffset(((Result)expected.get(1)).getExpire());
        }
        timeProvider.relativeNowOffsetMillis(2000L);
        assert (Clock.nowDate().after(((Result)expected.get(0)).getExpire()));
        assert (Clock.nowDate().after(((Result)expected.get(1)).getExpire()));
        List actualResults = resultDao.searchLast(versionNameFilter, testInstanceNameFilter, testDefinitionNameFilter, testInstanceIdFilter, testbedCategoryFilter, testbedGeniNameFilter, testbedUrnFilter, testbedNameFilter, serverIdFilter, disabled, cancelledIncluded, expired);
        MatcherAssert.assertThat((Object)actualResults, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)actualResults, (Matcher)Matchers.hasSize((int)expected.size()));
        for (Result actual : actualResults) {
            Result expectedResult = (Result)this.resultTestCollection.searchListById(expected, (Long)actual.getId());
            this.resultTestCollection.assertSameButIgnoreUri((JsonLdObjectWithId)actual, (JsonLdObjectWithId)expectedResult);
        }
    }

    @Test
    public void testSearchSummary0a() throws Exception {
        Integer testInstanceIdFilter = 9;
        Boolean expired = null;
        List<String> summary = Arrays.asList("SUCCESS");
        List expected = this.resultTestCollection.getByIds(new Long[]{1L});
        List actualResults = resultDao.searchLastSummaryFiltered(testInstanceIdFilter, expired, summary);
        MatcherAssert.assertThat((Object)actualResults, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)actualResults, (Matcher)Matchers.hasSize((int)expected.size()));
        for (Result actual : actualResults) {
            Result expectedResult = (Result)this.resultTestCollection.searchListById(expected, (Long)actual.getId());
            this.resultTestCollection.assertSameButIgnoreUri((JsonLdObjectWithId)actual, (JsonLdObjectWithId)expectedResult);
        }
    }

    @Test
    public void testSearchSummary0b() throws Exception {
        Integer testInstanceIdFilter = 12;
        Boolean expired = null;
        List<String> summary = Arrays.asList("SUCCESS");
        List expected = this.resultTestCollection.getByIds(new Long[]{7L});
        List actualResults = resultDao.searchLastSummaryFiltered(testInstanceIdFilter, expired, summary);
        MatcherAssert.assertThat((Object)actualResults, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)actualResults, (Matcher)Matchers.hasSize((int)expected.size()));
        for (Result actual : actualResults) {
            Result expectedResult = (Result)this.resultTestCollection.searchListById(expected, (Long)actual.getId());
            this.resultTestCollection.assertSameButIgnoreUri((JsonLdObjectWithId)actual, (JsonLdObjectWithId)expectedResult);
        }
    }

    @Test
    public void testSearchSummary1() throws Exception {
        Integer testInstanceIdFilter = 10;
        Boolean expired = null;
        List<String> summary = Arrays.asList("FAILURE", "WARNING");
        List expected = this.resultTestCollection.getByIds(new Long[]{2L});
        List actualResults = resultDao.searchLastSummaryFiltered(testInstanceIdFilter, expired, summary);
        MatcherAssert.assertThat((Object)actualResults, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)actualResults, (Matcher)Matchers.hasSize((int)expected.size()));
        for (Result actual : actualResults) {
            Result expectedResult = (Result)this.resultTestCollection.searchListById(expected, (Long)actual.getId());
            this.resultTestCollection.assertSameButIgnoreUri((JsonLdObjectWithId)actual, (JsonLdObjectWithId)expectedResult);
        }
    }

    @Test
    public void testSearchHistory0() throws Exception {
        int testInstanceId = 9;
        ArrayList<Result> expected = new ArrayList<Result>();
        for (Result r : this.resultTestCollection.getAll()) {
            if (!r.getTestInstanceId().equals(testInstanceId)) continue;
            expected.add(r);
        }
        assert (!expected.isEmpty());
        List actualResults = resultDao.searchHistory(Integer.valueOf(testInstanceId), Integer.valueOf(10), null, null);
        MatcherAssert.assertThat((Object)actualResults, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)actualResults, (Matcher)Matchers.hasSize((int)expected.size()));
        for (Result actual : actualResults) {
            Result expectedResult = (Result)this.resultTestCollection.searchListById(expected, (Long)actual.getId());
            this.resultTestCollection.assertSameButIgnoreUri((JsonLdObjectWithId)actual, (JsonLdObjectWithId)expectedResult);
        }
    }

    @Test
    public void testSearchHistory1() throws Exception {
        int testInstanceId = 10;
        ArrayList<Result> expected = new ArrayList<Result>();
        for (Result r : this.resultTestCollection.getAll()) {
            if (r.getTestInstanceId() != testInstanceId) continue;
            expected.add(r);
        }
        assert (!expected.isEmpty());
        List actualResults = resultDao.searchHistory(Integer.valueOf(testInstanceId), Integer.valueOf(10), null, null);
        MatcherAssert.assertThat((Object)actualResults, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)actualResults, (Matcher)Matchers.hasSize((int)expected.size()));
        for (Result actual : actualResults) {
            Result expectedResult = (Result)this.resultTestCollection.searchListById(expected, (Long)actual.getId());
            this.resultTestCollection.assertSameButIgnoreUri((JsonLdObjectWithId)actual, (JsonLdObjectWithId)expectedResult);
        }
    }

    static {
        lock = new ReentrantLock();
    }
}

