/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.dao;

import be.iminds.ilabt.jfed.fedmon.util.Clock;
import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonWebApiServiceApplication;
import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonWebApiServiceConfiguration;
import be.iminds.ilabt.jfed.fedmon.webapi.service.dao.ServerDao;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Location;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ServerBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Testbed;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestbedBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.FedmonTestPostgresDB;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.LinkedTestbedDataTestCollection;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.ServerTestCollection;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.TestInstancesTestCollection;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.TestbedTestCollection;
import be.iminds.ilabt.util.jsonld.JsonLdObjectsMetaData;
import be.iminds.ilabt.util.jsonld.iface.JsonLdObjectWithId;
import be.iminds.ilabt.util.jsonld.impl.PrimaryIdObjectBuilder;
import io.dropwizard.db.PooledDataSourceFactory;
import io.dropwizard.jdbi.DBIFactory;
import io.dropwizard.setup.Environment;
import io.dropwizard.testing.ConfigOverride;
import io.dropwizard.testing.junit.DropwizardAppRule;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.skife.jdbi.v2.DBI;

public class ServerDaoTest {
    @ClassRule
    public static final DropwizardAppRule<FedmonWebApiServiceConfiguration> RULE = new DropwizardAppRule(FedmonWebApiServiceApplication.class, "../fedmon-webapi-service-TESTING.yml", new ConfigOverride[0]);
    private static FedmonTestPostgresDB testPostgresDB;
    private static DBI jdbi;
    private static ServerDao serverDao;
    private static Lock lock;
    private static Clock.DefaultTestTimeProvider timeProvider;
    private TestbedTestCollection testbedTestCollection;
    private ServerTestCollection serverTestCollection;
    private LinkedTestbedDataTestCollection linkedTestbedDataTestCollection;
    private TestInstancesTestCollection testInstances;

    @BeforeClass
    public static void setUp() throws Exception {
        timeProvider = new Clock.DefaultTestTimeProvider();
        Clock.set((Clock.CurrentTimeProvider)timeProvider);
        Clock.lockProvider();
        testPostgresDB = new FedmonTestPostgresDB(RULE);
        testPostgresDB.dropAllTables();
        testPostgresDB.createAllTables();
        FedmonWebApiServiceConfiguration configuration = (FedmonWebApiServiceConfiguration)RULE.getConfiguration();
        Environment environment = RULE.getEnvironment();
        DBIFactory factory = new DBIFactory();
        jdbi = factory.build(environment, (PooledDataSourceFactory)configuration.getDataSourceFactory(), "postgresql");
        serverDao = (ServerDao)jdbi.onDemand(ServerDao.class);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        assert (testPostgresDB != null);
        testPostgresDB.close();
        jdbi.close((Object)serverDao);
        jdbi = null;
        serverDao = null;
        testPostgresDB = null;
        System.gc();
        Clock.reset();
    }

    @Before
    public void beforeEachMethod() throws SQLException {
        lock.lock();
        assert (testPostgresDB != null);
        testPostgresDB.refillDB();
        timeProvider.setNowOffsetMinutes(0L);
        this.serverTestCollection = new ServerTestCollection();
        this.linkedTestbedDataTestCollection = new LinkedTestbedDataTestCollection(false, -1, null);
        this.testbedTestCollection = new TestbedTestCollection();
        this.testInstances = new TestInstancesTestCollection();
    }

    @After
    public void afterEachMethod() throws SQLException {
        lock.unlock();
    }

    @Test
    public void testFindById1() throws Exception {
        int index = 0;
        ServerBuilder expectedServer = (ServerBuilder)this.serverTestCollection.getBuilderByIndex(index);
        expectedServer.setTestbed(TestbedBuilder.minimize((JsonLdObjectsMetaData.Minimization)JsonLdObjectsMetaData.Minimization.MINIMAL_ID_ONLY, (Testbed)this.linkedTestbedDataTestCollection.getServerByIndex(index).getTestbed()));
        Integer id = (Integer)expectedServer.getId();
        Server actualServer = serverDao.findById(id);
        MatcherAssert.assertThat((String)("Did not find server " + id), (Object)actualServer, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        this.serverTestCollection.assertSameButIgnoreUri((JsonLdObjectWithId)actualServer, (JsonLdObjectWithId)expectedServer.create());
    }

    @Test
    public void testFindWithServiceById1() throws Exception {
        int index = 0;
        Server expectedServer = this.linkedTestbedDataTestCollection.getServerByIndex(index);
        Integer id = (Integer)expectedServer.getId();
        Server actualServer = serverDao.findWithServicesById(id);
        MatcherAssert.assertThat((String)("Did not find server " + id), (Object)actualServer, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        this.serverTestCollection.assertSameButIgnoreUri((JsonLdObjectWithId)actualServer, (JsonLdObjectWithId)expectedServer);
    }

    @Test
    public void testFindById2() throws Exception {
        int index = 1;
        ServerBuilder expectedServer = (ServerBuilder)this.serverTestCollection.getBuilderByIndex(index);
        expectedServer.setTestbed(TestbedBuilder.minimize((JsonLdObjectsMetaData.Minimization)JsonLdObjectsMetaData.Minimization.MINIMAL_ID_ONLY, (Testbed)this.linkedTestbedDataTestCollection.getServerByIndex(index).getTestbed()));
        Integer id = (Integer)expectedServer.getId();
        Server actualServer = serverDao.findById(id);
        MatcherAssert.assertThat((String)("Did not find server " + id), (Object)actualServer, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        this.serverTestCollection.assertSameButIgnoreUri((JsonLdObjectWithId)actualServer, (JsonLdObjectWithId)expectedServer.create());
    }

    @Test
    public void testFindWithServiceById2() throws Exception {
        int index = 1;
        Server expectedServer = this.linkedTestbedDataTestCollection.getServerByIndex(index);
        Integer id = (Integer)expectedServer.getId();
        Server actualServer = serverDao.findWithServicesById(id);
        MatcherAssert.assertThat((String)("Did not find server " + id), (Object)actualServer, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        this.serverTestCollection.assertSameButIgnoreUri((JsonLdObjectWithId)actualServer, (JsonLdObjectWithId)expectedServer);
    }

    @Test
    public void testFindById3() throws Exception {
        int index = 2;
        ServerBuilder expectedServer = (ServerBuilder)this.serverTestCollection.getBuilderByIndex(index);
        expectedServer.setTestbed(TestbedBuilder.minimize((JsonLdObjectsMetaData.Minimization)JsonLdObjectsMetaData.Minimization.MINIMAL_ID_ONLY, (Testbed)this.linkedTestbedDataTestCollection.getServerByIndex(index).getTestbed()));
        Integer id = (Integer)expectedServer.getId();
        Server actualServer = serverDao.findById(id);
        MatcherAssert.assertThat((String)("Did not find server " + id), (Object)actualServer, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        this.serverTestCollection.assertSameButIgnoreUri((JsonLdObjectWithId)actualServer, (JsonLdObjectWithId)expectedServer.create());
    }

    @Test
    public void testFindWithServiceById3() throws Exception {
        int index = 2;
        Server expectedServer = this.linkedTestbedDataTestCollection.getServerByIndex(index);
        Integer id = (Integer)expectedServer.getId();
        Server actualServer = serverDao.findWithServicesById(id);
        MatcherAssert.assertThat((String)("Did not find server " + id), (Object)actualServer, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        this.serverTestCollection.assertSameButIgnoreUri((JsonLdObjectWithId)actualServer, (JsonLdObjectWithId)expectedServer);
    }

    @Test
    public void testInsert() throws Exception {
        Testbed testbedA = (Testbed)this.testbedTestCollection.getByIndex(0);
        Server newServer = new ServerBuilder().setTestbed(testbedA).setAllowedCertificateAlias("certAliasNew").setCertificateChain("NewChain").setBaseUrl("http://new.example.com/").setUrnTld("new.example.com").setFlags(Arrays.asList("workaroundMustReconnectEachCall", "featureStitching")).setLocation(new Location("BE", Double.valueOf(0.2), Double.valueOf(0.3), "no address")).setName("New Server for test").setServerType("new").setDefaultScs(null).setDefaultUserAuth(null).setScs(null).setUserAuth(null).create();
        Integer newId = serverDao.insert(newServer);
        MatcherAssert.assertThat((Object)newId, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        ServerBuilder expectedNewServerBuilder = new ServerBuilder(newServer);
        expectedNewServerBuilder.setId((Object)newId);
        ((FedmonWebApiServiceConfiguration)RULE.getConfiguration()).getJsonLdObjectsMetaData().makeUriTool("http://localhost:9000").setBuilderUri((PrimaryIdObjectBuilder)expectedNewServerBuilder, true);
        Server expectedNewServer = expectedNewServerBuilder.create();
        Server actualNewServer = serverDao.findById(newId);
        System.out.println("Lookup inserted server (" + newId + ") result: " + actualNewServer);
        MatcherAssert.assertThat((Object)actualNewServer, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)((Integer)actualNewServer.getId()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)newId)));
        this.serverTestCollection.assertSameAndExpectActualHasUri((JsonLdObjectWithId)expectedNewServer, (JsonLdObjectWithId)actualNewServer, true);
    }

    static {
        lock = new ReentrantLock();
    }
}

