/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.dao;

import be.iminds.ilabt.jfed.fedmon.util.Clock;
import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonWebApiServiceApplication;
import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonWebApiServiceConfiguration;
import be.iminds.ilabt.jfed.fedmon.webapi.service.dao.TestDefinitionDao;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestDefinition;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestDefinitionBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestDefinitionParameter;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.FedmonTestPostgresDB;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.TestDefinitionsTestCollection;
import be.iminds.ilabt.util.jsonld.iface.JsonLdObjectWithId;
import io.dropwizard.db.PooledDataSourceFactory;
import io.dropwizard.jdbi.DBIFactory;
import io.dropwizard.setup.Environment;
import io.dropwizard.testing.ConfigOverride;
import io.dropwizard.testing.junit.DropwizardAppRule;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.skife.jdbi.v2.DBI;

public class TestDefinitionDaoTest {
    @ClassRule
    public static final DropwizardAppRule<FedmonWebApiServiceConfiguration> RULE = new DropwizardAppRule(FedmonWebApiServiceApplication.class, "../fedmon-webapi-service-TESTING.yml", new ConfigOverride[0]);
    private static FedmonTestPostgresDB testPostgresDB;
    private static DBI jdbi;
    private static TestDefinitionDao testDefinitionDao;
    private static Lock lock;
    private TestDefinitionsTestCollection testDefinitionsTestCollection;

    @BeforeClass
    public static void setUp() throws Exception {
        Clock.set((Clock.CurrentTimeProvider)new Clock.DefaultTestTimeProvider());
        testPostgresDB = new FedmonTestPostgresDB(RULE);
        testPostgresDB.dropAllTables();
        testPostgresDB.createAllTables();
        FedmonWebApiServiceConfiguration configuration = (FedmonWebApiServiceConfiguration)RULE.getConfiguration();
        Environment environment = RULE.getEnvironment();
        DBIFactory factory = new DBIFactory();
        jdbi = factory.build(environment, (PooledDataSourceFactory)configuration.getDataSourceFactory(), "postgresql");
        testDefinitionDao = (TestDefinitionDao)jdbi.onDemand(TestDefinitionDao.class);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        assert (testPostgresDB != null);
        testPostgresDB.close();
        jdbi.close((Object)testDefinitionDao);
        jdbi = null;
        testDefinitionDao = null;
        testPostgresDB = null;
        System.gc();
        Clock.reset();
    }

    @Before
    public void beforeEachMethod() throws SQLException {
        lock.lock();
        assert (testPostgresDB != null);
        testPostgresDB.refillDB();
        this.testDefinitionsTestCollection = new TestDefinitionsTestCollection();
    }

    @After
    public void afterEachMethod() throws SQLException {
        lock.unlock();
    }

    @Test
    public void testFindByName1() throws Exception {
        TestDefinition expectedTestDefinition = (TestDefinition)this.testDefinitionsTestCollection.getByIndex(0);
        TestDefinition actualTestDefinition = testDefinitionDao.findById((String)expectedTestDefinition.getId());
        this.testDefinitionsTestCollection.assertSameButIgnoreUri((JsonLdObjectWithId)actualTestDefinition, (JsonLdObjectWithId)expectedTestDefinition);
    }

    @Test
    public void testFindByName2() throws Exception {
        TestDefinition expectedTestDefinition = (TestDefinition)this.testDefinitionsTestCollection.getByIndex(1);
        TestDefinition actualTestDefinition = testDefinitionDao.findById((String)expectedTestDefinition.getId());
        this.testDefinitionsTestCollection.assertSameButIgnoreUri((JsonLdObjectWithId)actualTestDefinition, (JsonLdObjectWithId)expectedTestDefinition);
    }

    @Test
    public void testFindAll() throws Exception {
        List res = testDefinitionDao.findAll();
        System.out.println("testFindAll res = " + res);
        MatcherAssert.assertThat((Object)res, (Matcher)Matchers.hasSize((int)this.testDefinitionsTestCollection.getSize()));
        for (TestDefinition resTestDefinition : res) {
            MatcherAssert.assertThat((Object)resTestDefinition, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            TestDefinition origTestDefinition = (TestDefinition)this.testDefinitionsTestCollection.getById((String)resTestDefinition.getId());
            MatcherAssert.assertThat((Object)origTestDefinition, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            this.testDefinitionsTestCollection.assertSameButIgnoreUri((JsonLdObjectWithId)resTestDefinition, (JsonLdObjectWithId)origTestDefinition);
        }
    }

    @Test
    public void testInsert() {
        TestDefinitionBuilder newTestDefinition = new TestDefinitionBuilder();
        newTestDefinition.setId((Object)"newTD");
        newTestDefinition.setType("newType");
        newTestDefinition.setGeniDatastoreMetric("gm");
        newTestDefinition.setGeniDatastoreDescription("gd");
        newTestDefinition.setGeniDatastoreUnits("gu");
        newTestDefinition.setMaxTestDurationMs(Long.valueOf(50000L));
        ArrayList<TestDefinitionParameter> parameters = new ArrayList<TestDefinitionParameter>();
        parameters.add(TestDefinition.getUserTestDefinitionParameter());
        parameters.add(new TestDefinitionParameter("dummyparam", "int", "desc dummy required param", null, true));
        newTestDefinition.setParameters(parameters);
        testDefinitionDao.insert(newTestDefinition.create());
        TestDefinition expected = newTestDefinition.create();
        TestDefinition actual = testDefinitionDao.findById("newTD");
        this.testDefinitionsTestCollection.assertSameButIgnoreUri((JsonLdObjectWithId)actual, (JsonLdObjectWithId)expected);
    }

    @Test
    public void testUpdate() {
        TestDefinition orig = (TestDefinition)this.testDefinitionsTestCollection.getByIndex(0);
        TestDefinitionBuilder newTestDefinition = new TestDefinitionBuilder();
        newTestDefinition.setId((Object)((String)orig.getId()));
        newTestDefinition.setType("updatedType");
        newTestDefinition.setGeniDatastoreMetric("gmu");
        newTestDefinition.setGeniDatastoreDescription("gdu");
        newTestDefinition.setGeniDatastoreUnits("guu");
        newTestDefinition.setMaxTestDurationMs(Long.valueOf(123456L));
        ArrayList<TestDefinitionParameter> parameters = new ArrayList<TestDefinitionParameter>();
        parameters.add(TestDefinition.getUserTestDefinitionParameter());
        parameters.add(new TestDefinitionParameter("updateddummyparam", "int", "desc dummy required param", null, true));
        newTestDefinition.setParameters(parameters);
        testDefinitionDao.update(newTestDefinition.create());
        TestDefinition expected = newTestDefinition.create();
        TestDefinition actual = testDefinitionDao.findById((String)orig.getId());
        this.testDefinitionsTestCollection.assertSameButIgnoreUri((JsonLdObjectWithId)actual, (JsonLdObjectWithId)expected);
    }

    static {
        lock = new ReentrantLock();
    }
}

