/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.dao;

import be.iminds.ilabt.jfed.fedmon.util.Clock;
import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonWebApiServiceApplication;
import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonWebApiServiceConfiguration;
import be.iminds.ilabt.jfed.fedmon.webapi.service.dao.TestInstanceDao;
import be.iminds.ilabt.jfed.fedmon.webapi.service.dao.TestInstanceStatisticsDao;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Frequency;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestDefinition;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestInstance;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestInstanceBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestInstanceStatistics;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestInstanceStatisticsBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Testbed;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.User;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.FedmonTestPostgresDB;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.FrequencyTestCollection;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.TestDefinitionsTestCollection;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.TestInstancesStatisticsTestCollection;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.TestInstancesTestCollection;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.TestbedTestCollection;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.UserTestCollection;
import be.iminds.ilabt.util.jsonld.iface.JsonLdObject;
import be.iminds.ilabt.util.jsonld.impl.PrimaryIdObjectBuilder;
import be.iminds.ilabt.util.jsonld.test.CommonTest;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.dropwizard.db.PooledDataSourceFactory;
import io.dropwizard.jdbi.DBIFactory;
import io.dropwizard.setup.Environment;
import io.dropwizard.testing.ConfigOverride;
import io.dropwizard.testing.junit.DropwizardAppRule;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.skife.jdbi.v2.DBI;

public class TestInstanceStatisticsDaoTest {
    @ClassRule
    public static final DropwizardAppRule<FedmonWebApiServiceConfiguration> RULE = new DropwizardAppRule(FedmonWebApiServiceApplication.class, "../fedmon-webapi-service-TESTING.yml", new ConfigOverride[0]);
    private static FedmonTestPostgresDB testPostgresDB;
    private static DBI jdbi;
    private static TestInstanceStatisticsDao testInstanceStatisticsDao;
    private static TestInstanceDao testInstanceDao;
    private static Lock lock;
    protected static Clock.DefaultTestTimeProvider timeProvider;
    private TestInstancesTestCollection testInstancesTestCollection;
    private TestDefinitionsTestCollection testDefinitionsTestCollection;
    private FrequencyTestCollection frequencyTestCollection;
    private TestbedTestCollection testbedTestCollection;
    private UserTestCollection userTestCollection;
    private TestInstancesStatisticsTestCollection testInstancesStatisticsTestCollection;

    @BeforeClass
    public static void setUp() throws Exception {
        timeProvider = new Clock.DefaultTestTimeProvider();
        Clock.set((Clock.CurrentTimeProvider)timeProvider);
        testPostgresDB = new FedmonTestPostgresDB(RULE);
        testPostgresDB.dropAllTables();
        testPostgresDB.createAllTables();
        FedmonWebApiServiceConfiguration configuration = (FedmonWebApiServiceConfiguration)RULE.getConfiguration();
        Environment environment = RULE.getEnvironment();
        DBIFactory factory = new DBIFactory();
        jdbi = factory.build(environment, (PooledDataSourceFactory)configuration.getDataSourceFactory(), "postgresql");
        testInstanceDao = (TestInstanceDao)jdbi.onDemand(TestInstanceDao.class);
        testInstanceStatisticsDao = (TestInstanceStatisticsDao)jdbi.onDemand(TestInstanceStatisticsDao.class);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        assert (testPostgresDB != null);
        testPostgresDB.close();
        jdbi.close((Object)testInstanceStatisticsDao);
        jdbi.close((Object)testInstanceDao);
        jdbi = null;
        testInstanceStatisticsDao = null;
        testInstanceDao = null;
        testPostgresDB = null;
        System.gc();
        Clock.reset();
    }

    @Before
    public void beforeMethod() throws Exception {
        timeProvider.setNowOffsetMinutes(0L);
    }

    @Before
    public void beforeEachMethod() throws SQLException {
        lock.lock();
        assert (testPostgresDB != null);
        testPostgresDB.refillDB();
        this.testInstancesTestCollection = new TestInstancesTestCollection();
        this.testDefinitionsTestCollection = new TestDefinitionsTestCollection();
        this.frequencyTestCollection = new FrequencyTestCollection();
        this.testbedTestCollection = new TestbedTestCollection();
        this.userTestCollection = new UserTestCollection();
        this.testInstancesStatisticsTestCollection = new TestInstancesStatisticsTestCollection();
    }

    @After
    public void afterEachMethod() throws SQLException {
        lock.unlock();
    }

    @Test
    public void testFindById0() throws Exception {
        timeProvider.setNowOffsetMinutes(-7L);
        this.testFindById(0);
    }

    @Test
    public void testFindById1() throws Exception {
        timeProvider.setNowOffsetMinutes(-7L);
        this.testFindById(0);
    }

    @Test
    public void testFindById2() throws Exception {
        timeProvider.setNowOffsetMinutes(-7L);
        this.testFindById(0);
    }

    @Test
    public void testFindById3() throws Exception {
        timeProvider.setNowOffsetMinutes(-7L);
        this.testFindById(0);
    }

    @Test
    public void testFindById4() throws Exception {
        timeProvider.setNowOffsetMinutes(-7L);
        this.testFindById(0);
    }

    @Test
    public void testFindById5() throws Exception {
        timeProvider.setNowOffsetMinutes(-7L);
        this.testFindById(0);
    }

    public void testFindById(int index) throws Exception {
        TestInstanceStatistics expectedTestInstanceStatistics = (TestInstanceStatistics)this.testInstancesStatisticsTestCollection.getByIndex(index);
        TestInstanceStatistics actualTestInstanceStatistics = testInstanceStatisticsDao.getByTestInstanceId(expectedTestInstanceStatistics.getTestInstanceId().intValue(), Clock.nowTimestamp()).create();
        this.testInstancesStatisticsTestCollection.assertSame((JsonLdObject)actualTestInstanceStatistics, (JsonLdObject)expectedTestInstanceStatistics, CommonTest.ComparePrecision.FULL, CommonTest.ComparePrecision.ID_AND_URI_ONLY);
    }

    @Test
    public void testSearch1() throws Exception {
        timeProvider.setNowOffsetMinutes(-7L);
        List res = testInstanceStatisticsDao.search(Arrays.asList("prod", "test"), null, null, null, null, null, null, null, false, null, null, Clock.nowTimestamp());
        System.out.println("testSearch res = " + res);
        MatcherAssert.assertThat((Object)res, (Matcher)Matchers.hasSize((int)this.testInstancesStatisticsTestCollection.getSize()));
        for (TestInstanceStatisticsBuilder resTestInstanceStatisticsBuilder : res) {
            MatcherAssert.assertThat((Object)resTestInstanceStatisticsBuilder, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            TestInstanceStatistics origTestInstanceStatistics = this.testInstancesStatisticsTestCollection.getByTestInstanceId(resTestInstanceStatisticsBuilder.getTestInstanceId()).create();
            MatcherAssert.assertThat((Object)origTestInstanceStatistics, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            System.out.println("Comparing TestInstanceStatistics id=" + resTestInstanceStatisticsBuilder.getTestInstanceId());
            System.out.println("Actual TestInstanceStatistics =" + resTestInstanceStatisticsBuilder.create().toString());
            System.out.println("Expected TestInstanceStatistics =" + origTestInstanceStatistics.toString());
            this.testInstancesStatisticsTestCollection.assertSame((JsonLdObject)resTestInstanceStatisticsBuilder.create(), (JsonLdObject)origTestInstanceStatistics, CommonTest.ComparePrecision.FULL, CommonTest.ComparePrecision.ID_AND_URI_ONLY);
        }
    }

    @Test
    public void testUpdateTestStatistics() throws JsonProcessingException {
        TestInstanceStatistics orig = (TestInstanceStatistics)this.testInstancesStatisticsTestCollection.getByIndex(2);
        TestInstanceStatistics.RrdStatistics newRrdStatistics = new TestInstanceStatisticsBuilder.RrdStatisticsBuilder().setDayTotal(6.0).setWeekTotal(2.0).setMonthTotal(15.0).setMetricName("failure").setUnit("times").create();
        String newTestStatisticsJsonText = new ObjectMapper().writeValueAsString((Object)newRrdStatistics);
        System.out.println("Replacing statistics of " + orig.getTestInstanceId() + " with:\n" + newTestStatisticsJsonText);
        testInstanceStatisticsDao.updateTestStatistics(orig.getTestInstanceId(), newTestStatisticsJsonText);
        TestInstanceStatistics expectedTestInstanceStatistics = new TestInstanceStatisticsBuilder(orig).setRrdStatistics(newRrdStatistics).create();
        TestInstanceStatistics actualTestInstanceStatistics = testInstanceStatisticsDao.getByTestInstanceId(expectedTestInstanceStatistics.getTestInstanceId().intValue(), Clock.nowTimestamp()).create();
        this.testInstancesStatisticsTestCollection.assertSame((JsonLdObject)actualTestInstanceStatistics, (JsonLdObject)expectedTestInstanceStatistics, CommonTest.ComparePrecision.FULL, CommonTest.ComparePrecision.ID_AND_URI_ONLY);
        System.out.println("Got: " + actualTestInstanceStatistics);
    }

    @Test
    public void testUpdateSummation() throws JsonProcessingException {
        TestInstanceStatistics orig = (TestInstanceStatistics)this.testInstancesStatisticsTestCollection.getByIndex(2);
        TestInstanceStatistics.Summation newSummation = new TestInstanceStatisticsBuilder.SummationBuilder().setYear(new TestInstanceStatistics.SummationDetail(1.0, 0.0, 5.0, 9.0, 13.0, 17.0)).setMonth(new TestInstanceStatistics.SummationDetail(2.0, 1.0, 6.0, 10.0, 14.0, 18.0)).setWeek(new TestInstanceStatistics.SummationDetail(3.0, 2.0, 7.0, 11.0, 15.0, 19.0)).setDay(new TestInstanceStatistics.SummationDetail(4.0, 3.0, 8.0, 12.0, 16.0, 20.0)).setUnit("parsec").create();
        String newSummationJsonText = new ObjectMapper().writeValueAsString((Object)newSummation);
        System.out.println("Replacing statistics of " + orig.getTestInstanceId() + " with:\n" + newSummationJsonText);
        testInstanceStatisticsDao.updateSummation(orig.getTestInstanceId(), newSummationJsonText);
        TestInstanceStatistics expectedTestInstanceStatistics = new TestInstanceStatisticsBuilder(orig).setSummation(newSummation).create();
        TestInstanceStatistics actualTestInstanceStatistics = testInstanceStatisticsDao.getByTestInstanceId(expectedTestInstanceStatistics.getTestInstanceId().intValue(), Clock.nowTimestamp()).create();
        this.testInstancesStatisticsTestCollection.assertSame((JsonLdObject)actualTestInstanceStatistics, (JsonLdObject)expectedTestInstanceStatistics, CommonTest.ComparePrecision.FULL, CommonTest.ComparePrecision.ID_AND_URI_ONLY);
        System.out.println("Got: " + actualTestInstanceStatistics);
    }

    @Test
    public void testInsert() {
        TestDefinition testDefinitionA = (TestDefinition)this.testDefinitionsTestCollection.getByIndex(0);
        Frequency testFrequencyA = (Frequency)this.frequencyTestCollection.getByIndex(0);
        Testbed testbedA = (Testbed)this.testbedTestCollection.getByIndex(0);
        User userA = (User)this.userTestCollection.getByIndex(0);
        TestInstance newTestInstance = new TestInstanceBuilder().setTestDefinition(testDefinitionA).setTestVersion("test").setEnabled(Boolean.valueOf(true)).setFrequency(testFrequencyA).setName("New For Test").setServerParameter((Server)testbedA.getServers().get(0)).setUserParameter(userA).addParameter("keyA", "valA").addParameter("keyB", "valB").create();
        Integer newId = testInstanceDao.insert(newTestInstance);
        MatcherAssert.assertThat((Object)newId, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        TestInstanceBuilder expectedNewTestInstanceBuilder = new TestInstanceBuilder(newTestInstance);
        expectedNewTestInstanceBuilder.setId((Object)newId);
        ((FedmonWebApiServiceConfiguration)RULE.getConfiguration()).getJsonLdObjectsMetaData().makeUriTool("http://localhost:9000").setBuilderUri((PrimaryIdObjectBuilder)expectedNewTestInstanceBuilder, true);
        TestInstance expectedNewTestInstance = expectedNewTestInstanceBuilder.create();
        TestInstanceStatisticsBuilder expectedTestInstanceStatistics = new TestInstanceStatisticsBuilder().setTestInstanceId(newId).setNextRun(null).setLastRun(null);
        TestInstanceStatisticsBuilder actualTestInstanceStatistics = testInstanceStatisticsDao.getByTestInstanceId(newId.intValue(), Clock.nowTimestamp());
        MatcherAssert.assertThat((Object)actualTestInstanceStatistics, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        this.testInstancesStatisticsTestCollection.assertSame((JsonLdObject)actualTestInstanceStatistics.create(), (JsonLdObject)expectedTestInstanceStatistics.setNextRun(actualTestInstanceStatistics.getNextRun()).create(), CommonTest.ComparePrecision.FULL, CommonTest.ComparePrecision.ID_AND_URI_ONLY);
    }

    static {
        lock = new ReentrantLock();
    }
}

