/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.dao;

import be.iminds.ilabt.jfed.fedmon.util.Clock;
import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonWebApiServiceApplication;
import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonWebApiServiceConfiguration;
import be.iminds.ilabt.jfed.fedmon.webapi.service.dao.JFedUserStatisticsDao;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.UserInfo;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.FedmonTestPostgresDB;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.UserInfoTestCollection;
import io.dropwizard.db.PooledDataSourceFactory;
import io.dropwizard.jdbi.DBIFactory;
import io.dropwizard.setup.Environment;
import io.dropwizard.testing.ConfigOverride;
import io.dropwizard.testing.junit.DropwizardAppRule;
import java.sql.SQLException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.skife.jdbi.v2.DBI;

public class jFedUserStatisticsDaoTest {
    @ClassRule
    public static final DropwizardAppRule<FedmonWebApiServiceConfiguration> RULE = new DropwizardAppRule(FedmonWebApiServiceApplication.class, "../fedmon-webapi-service-TESTING.yml", new ConfigOverride[0]);
    private static FedmonTestPostgresDB testPostgresDB;
    private static DBI jdbi;
    private static JFedUserStatisticsDao jFedUserStatisticsDao;
    private static Lock lock;
    private UserInfoTestCollection userInfoTestCollection;

    @BeforeClass
    public static void setUp() throws Exception {
        Clock.set((Clock.CurrentTimeProvider)new Clock.DefaultTestTimeProvider());
        testPostgresDB = new FedmonTestPostgresDB(RULE);
        testPostgresDB.dropAllTables();
        testPostgresDB.createAllTables();
        FedmonWebApiServiceConfiguration configuration = (FedmonWebApiServiceConfiguration)RULE.getConfiguration();
        Environment environment = RULE.getEnvironment();
        DBIFactory factory = new DBIFactory();
        jdbi = factory.build(environment, (PooledDataSourceFactory)configuration.getDataSourceFactory(), "postgresql");
        jFedUserStatisticsDao = (JFedUserStatisticsDao)jdbi.onDemand(JFedUserStatisticsDao.class);
        assert (jFedUserStatisticsDao != null);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        assert (testPostgresDB != null);
        testPostgresDB.close();
        assert (jFedUserStatisticsDao != null);
        jdbi.close((Object)jFedUserStatisticsDao);
        jdbi = null;
        jFedUserStatisticsDao = null;
        testPostgresDB = null;
        System.gc();
        Clock.reset();
    }

    @Before
    public void beforeEachMethod() throws SQLException {
        lock.lock();
        assert (testPostgresDB != null);
        testPostgresDB.refillDB();
        this.userInfoTestCollection = new UserInfoTestCollection();
    }

    @After
    public void afterEachMethod() throws SQLException {
        lock.unlock();
    }

    @Test
    public void testStatistics() throws Exception {
        for (UserInfo ui : this.userInfoTestCollection.getExtra()) {
            jFedUserStatisticsDao.logUserConfigRequest(ui);
        }
        Instant now = Instant.now();
        Instant weekStart = JFedUserStatisticsDao.truncateTo((Instant)now, (TemporalUnit)ChronoUnit.WEEKS);
        List actual = jFedUserStatisticsDao.get(30, (TemporalUnit)ChronoUnit.WEEKS);
        MatcherAssert.assertThat((Object)actual, (Matcher)Matchers.hasSize((int)1));
        JFedUserStatisticsDao.AggUserStatistics s = (JFedUserStatisticsDao.AggUserStatistics)actual.get(0);
        MatcherAssert.assertThat((Object)s.getBucketStart(), (Matcher)Matchers.equalTo((Object)weekStart));
        MatcherAssert.assertThat((Object)s.getLoginCount(), (Matcher)Matchers.equalTo((Object)4));
        MatcherAssert.assertThat((Object)s.getUniqueUsers(), (Matcher)Matchers.equalTo((Object)3));
        System.out.println("s=" + s);
    }

    static {
        lock = new ReentrantLock();
    }
}

