/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.json_test;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Result;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Testbed;
import be.iminds.ilabt.jfed.fedmon.webapi.service.resource.SearchUriGenerator;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.FedmonObjectTests;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.ResultTestCollection;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.TestInstancesTestCollection;
import be.iminds.ilabt.util.jsonld.JsonLdObjectsMetaData;
import be.iminds.ilabt.util.jsonld.UriTool;
import be.iminds.ilabt.util.jsonld.iface.JsonLdObject;
import be.iminds.ilabt.util.jsonld.iface.JsonLdObjectBuilder;
import be.iminds.ilabt.util.jsonld.test.BasicObjectTestCollection;
import be.iminds.ilabt.util.jsonld.test.CommonTest;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.dropwizard.jackson.Jackson;
import io.dropwizard.testing.FixtureHelpers;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class JsonTest {
    private static final ObjectMapper MAPPER = Jackson.newObjectMapper();
    private static JsonLdObjectsMetaData jsonLdObjectsMetaData;
    private final BasicObjectTestCollection testFedmonObjectCollection;
    private final int index;

    @BeforeClass
    public static void beforeClass() {
        jsonLdObjectsMetaData = JsonLdObjectsMetaData.getInstance((String)Testbed.class.getPackage().getName());
    }

    @Parameterized.Parameters(name="{index}: collection={0} index={1}")
    public static Collection<Object[]> data() {
        ArrayList<Object[]> res = new ArrayList<Object[]>();
        for (FedmonObjectTests.TestFedmonObjectCollectionFactory<? extends BasicObjectTestCollection> collectionFactory : FedmonObjectTests.getAllTestFedmonObjectCollectionFactories()) {
            BasicObjectTestCollection sampleCollection = collectionFactory.create();
            for (int i = 0; i < sampleCollection.getSize(); ++i) {
                if (sampleCollection.getObjectClass() == Result.class && i >= 2 && i != 7) continue;
                res.add(new Object[]{collectionFactory.create(), i});
            }
        }
        return res;
    }

    public JsonTest(BasicObjectTestCollection testFedmonObjectCollection, int index) throws URISyntaxException {
        UriTool uriTool = jsonLdObjectsMetaData.makeUriTool("http://localhost:9000", (UriTool.DerivedUriGenerator)new SearchUriGenerator());
        if (index == 0) {
            testFedmonObjectCollection.setUri(index, uriTool);
        }
        if (testFedmonObjectCollection instanceof TestInstancesTestCollection && index == 6) {
            testFedmonObjectCollection.setUri(index, uriTool);
        }
        if (testFedmonObjectCollection instanceof ResultTestCollection && index == 7) {
            testFedmonObjectCollection.setUri(index, uriTool);
        }
        this.testFedmonObjectCollection = testFedmonObjectCollection;
        this.index = index;
    }

    @Test
    public void serializesToJSON() throws Exception {
        String fixtureFilename = this.testFedmonObjectCollection.getFixtureByIndex(this.index);
        System.out.println("serializesToJSON is reading " + fixtureFilename + " and minimizing with " + this.testFedmonObjectCollection.getFixtureMinimization());
        JsonLdObjectBuilder fedmonObjectBuilder = this.testFedmonObjectCollection.getBuilderByIndex(this.index);
        Class fedmonObjectClass = this.testFedmonObjectCollection.getObjectClass();
        JsonLdObject fedmonObject = fedmonObjectBuilder.createMinimized(this.testFedmonObjectCollection.getFixtureMinimization());
        JsonLdObject deserializedObject = (JsonLdObject)MAPPER.readValue(FixtureHelpers.fixture((String)fixtureFilename), fedmonObjectClass);
        String expected = MAPPER.writer().with(SerializationFeature.INDENT_OUTPUT).writeValueAsString((Object)deserializedObject);
        String actual = MAPPER.writer().with(SerializationFeature.INDENT_OUTPUT).writeValueAsString((Object)fedmonObject);
        MatcherAssert.assertThat((Object)actual, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expected)));
    }

    @Test
    public void serializesToJSONTree() throws Exception {
        String fixtureFilename = this.testFedmonObjectCollection.getFixtureByIndex(this.index);
        System.out.println("serializesToJSON is reading " + fixtureFilename + " and minimizing with " + this.testFedmonObjectCollection.getFixtureMinimization());
        JsonLdObjectBuilder basicLdObjectBuilder = this.testFedmonObjectCollection.getBuilderByIndex(this.index);
        JsonLdObject basicLdObject = basicLdObjectBuilder.createMinimized(this.testFedmonObjectCollection.getFixtureMinimization());
        Map expected = (Map)MAPPER.readValue(FixtureHelpers.fixture((String)fixtureFilename), Map.class);
        Map actual = (Map)MAPPER.readValue(MAPPER.writer().with(SerializationFeature.INDENT_OUTPUT).writeValueAsString((Object)basicLdObject), Map.class);
        MatcherAssert.assertThat((Object)JsonTest.mapToString(actual), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)JsonTest.mapToString(expected))));
        MatcherAssert.assertThat((String)(JsonTest.mapToString(actual) + "\n\n != \n\n" + JsonTest.mapToString(expected)), (Object)actual, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expected)));
    }

    @Test
    public void deserializesFromJSON() throws Exception {
        String fixtureFilename = this.testFedmonObjectCollection.getFixtureByIndex(this.index);
        System.out.println("deserializesFromJSON is reading " + fixtureFilename);
        JsonLdObjectBuilder expectedFedmonObjectBuilder = this.testFedmonObjectCollection.getBuilderByIndex(this.index);
        JsonLdObject expectedFedmonObject = expectedFedmonObjectBuilder.createMinimized(this.testFedmonObjectCollection.getFixtureMinimization());
        Class fedmonObjectClass = this.testFedmonObjectCollection.getObjectClass();
        JsonLdObject actualFedmonObject = (JsonLdObject)MAPPER.readValue(FixtureHelpers.fixture((String)fixtureFilename), fedmonObjectClass);
        this.testFedmonObjectCollection.assertSame(actualFedmonObject, expectedFedmonObject, CommonTest.ComparePrecision.IGNORE_URI, CommonTest.ComparePrecision.IGNORE_URI);
        System.out.flush();
        System.err.flush();
    }

    public static String mapToString(Map m) {
        if (m == null) {
            return "null";
        }
        Object res = "{\n";
        TreeSet sortedKeys = new TreeSet(m.keySet());
        boolean first = true;
        for (Object key : sortedKeys) {
            if (!first) {
                res = (String)res + ",\n";
            }
            first = false;
            Object val = m.get(key);
            if (val == null) {
                res = (String)res + "  \"" + key + "\" : null";
                continue;
            }
            if (val instanceof Number || val instanceof Boolean) {
                res = (String)res + "  \"" + key + "\" : " + val;
                continue;
            }
            if (val instanceof String) {
                res = (String)res + "  \"" + key + "\" : \"" + val + "\"";
                continue;
            }
            if (val instanceof Map) {
                res = (String)res + "  \"" + key + "\" : " + JsonTest.mapToString((Map)val);
                continue;
            }
            if (val instanceof List) {
                res = (String)res + "  \"" + key + "\" : " + JsonTest.listToString((List)val);
                continue;
            }
            throw new RuntimeException("Unsupported value type: " + val.getClass().getName());
        }
        return (String)res + "\n}";
    }

    public static String listToString(List l) {
        if (l == null) {
            return "null";
        }
        Object res = "[\n";
        boolean first = true;
        for (Object val : l) {
            if (!first) {
                res = (String)res + ", ";
            }
            first = false;
            if (val == null) {
                res = (String)res + "null";
                continue;
            }
            if (val instanceof Number || val instanceof Boolean) {
                res = (String)res + val;
                continue;
            }
            if (val instanceof String) {
                res = (String)res + "\"" + val + "\"";
                continue;
            }
            if (val instanceof Map) {
                res = (String)res + JsonTest.mapToString((Map)val);
                continue;
            }
            if (val instanceof List) {
                res = (String)res + JsonTest.listToString((List)val);
                continue;
            }
            throw new RuntimeException("Unsupported value type: " + val.getClass().getName());
        }
        return (String)res + "\n]";
    }
}

