/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.test;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.GtsConfig;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.GuiConfigSet;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.GuiConfigSetBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.LoginSite;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.LoginSiteBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ServerBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TriggeredMessage;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TriggeredMessageBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.ResourceClassTestCollection;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.ResourceTestCollection;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.ServerTestCollection;
import be.iminds.ilabt.util.jsonld.JsonLdObjectsMetaData;
import be.iminds.ilabt.util.jsonld.test.ObjectWithIdTestCollection;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nonnull;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;

public class GuiConfigSetTestCollection
extends ObjectWithIdTestCollection<String, GuiConfigSet, GuiConfigSetBuilder> {
    @Nonnull
    public static final TriggeredMessage getTestTriggeredMessage() {
        TriggeredMessageBuilder res = new TriggeredMessageBuilder();
        res.setId(Integer.valueOf(1));
        res.setGuiTrigger(TriggeredMessage.GuiTrigger.LOGIN);
        res.setText("This is a test message. You can ignore it.");
        res.setTitle("Test Message");
        res.setFrequency(TriggeredMessage.TriggerFrequency.ALWAYS);
        res.setType(TriggeredMessage.MessageType.INFO);
        res.setEnableDoNotShowAgainButton(Boolean.valueOf(true));
        return res.create();
    }

    @Nonnull
    public static final LoginSite getTestLoginSite() {
        LoginSiteBuilder res = new LoginSiteBuilder();
        res.setId(Integer.valueOf(1));
        res.setImageId("fed4fire");
        res.setUrlType(LoginSite.UrlType.GET_PEM);
        res.setUrl("https://fed4fire.eu/");
        res.setButtonText("test button");
        return res.create();
    }

    @Nonnull
    public static final GtsConfig getTestGtsConfig() {
        String gtsJsonstr = "{\n    \"locations\" : [ \"AMS\", \"LJU\", \"PRG\" ],\n    \"externalDomains\" : [ {\n      \"id\" : \"ams-ep1\",\n      \"location\" : \"AMS\",\n      \"port\" : \"ep1\",\n      \"name\" : \"iMinds #1\",\n      \"description\" : \"from AMS via GN/BRU, BELnet\"\n    } ],\n    \"gtsToFed4FIREVlans\" : [ {\n      \"id\" : \"vlan1175\",\n      \"gtsExternalDomain\" : \"ams-ep1\",\n      \"urn\" : \"urn:publicid:IDN+gts1175-edge.ilabt.iminds.be+authority+cm\"\n    } ],\n    \"@type\" : \"GtsConfig\"\n  }";
        try {
            return (GtsConfig)new ObjectMapper().readValue(gtsJsonstr, GtsConfig.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public GuiConfigSetTestCollection() {
        super(String.class, GuiConfigSet.class, GuiConfigSetBuilder.class);
        ResourceClassTestCollection resourceClassTestCollection = new ResourceClassTestCollection(false, false, false);
        ResourceTestCollection resourceTestCollection = new ResourceTestCollection(false, false, false);
        ServerTestCollection serverTestCollection = new ServerTestCollection();
        GuiConfigSetBuilder guiConfigSet1 = ((GuiConfigSetBuilder)new GuiConfigSetBuilder().setId((Object)"testA")).setBindableServers(ServerBuilder.minimize((JsonLdObjectsMetaData.Minimization)JsonLdObjectsMetaData.Minimization.MINIMAL_ID_ONLY, (Collection)serverTestCollection.getByIndexes(new int[]{0, 1}))).setHideServers(ServerBuilder.minimize((JsonLdObjectsMetaData.Minimization)JsonLdObjectsMetaData.Minimization.MINIMAL_ID_ONLY, (Collection)serverTestCollection.getByIndexes(new int[]{1}))).setTriggeredMessages(Collections.singletonList(GuiConfigSetTestCollection.getTestTriggeredMessage())).setLoginSites(Collections.singletonList(GuiConfigSetTestCollection.getTestLoginSite())).setFlag("message", (Object)"test").setFlag("switch", (Object)true).setGtsConfig(GuiConfigSetTestCollection.getTestGtsConfig()).setDescription("Test Flag A description");
        this.all.add(guiConfigSet1);
        GuiConfigSetBuilder guiConfigSet2 = ((GuiConfigSetBuilder)new GuiConfigSetBuilder().setId((Object)"testB")).setFlag("message", (Object)"test2").setFlag("switch", (Object)false).setBindableServers(null).setHideServers(null);
        this.all.add(guiConfigSet2);
        GuiConfigSetBuilder guiConfigSet3 = ((GuiConfigSetBuilder)new GuiConfigSetBuilder().setId((Object)"testC")).setBindableServers(ServerBuilder.minimize((JsonLdObjectsMetaData.Minimization)JsonLdObjectsMetaData.Minimization.MINIMAL_ID_ONLY, (Collection)serverTestCollection.getByIndexes(new int[]{1}))).setHideServers(ServerBuilder.minimize((JsonLdObjectsMetaData.Minimization)JsonLdObjectsMetaData.Minimization.MINIMAL_ID_ONLY, (Collection)serverTestCollection.getByIndexes(new int[]{0})));
        this.all.add(guiConfigSet3);
    }

    public void assertSameExtraIds(GuiConfigSet actual, GuiConfigSet expected) {
    }

    public void assertSameDetails(GuiConfigSet actual, GuiConfigSet expected) {
        MatcherAssert.assertThat((Object)actual.getDescription(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expected.getDescription())));
        MatcherAssert.assertThat((Object)actual.getFlags(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expected.getFlags())));
        MatcherAssert.assertThat((Object)actual.getGtsConfig(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expected.getGtsConfig())));
        MatcherAssert.assertThat((Object)actual.getTriggeredMessages(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expected.getTriggeredMessages())));
        MatcherAssert.assertThat((Object)actual.getLoginSites(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expected.getLoginSites())));
    }

    public void assertSearchLinks(GuiConfigSet actual) {
    }
}

