/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.test;

import be.iminds.ilabt.jfed.fedmon.util.Clock;
import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonWebApiServiceApplication;
import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonWebApiServiceConfiguration;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.JFedExperimenterGuiConfig;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.JFedExperimenterGuiConfigBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.UserInfo;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.FedmonTestPostgresDB;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.JFedExperimenterGuiConfigTestCollection;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.UserInfoTestCollection;
import be.iminds.ilabt.util.jsonld.iface.JsonLdObject;
import be.iminds.ilabt.util.jsonld.test.CommonTest;
import io.dropwizard.testing.ConfigOverride;
import io.dropwizard.testing.junit.DropwizardAppRule;
import java.util.Map;
import org.glassfish.jersey.client.JerseyClient;
import org.glassfish.jersey.client.JerseyClientBuilder;
import org.glassfish.jersey.client.JerseyWebTarget;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

public class JFedExperimenterGuiConfigIntegrationTest {
    @ClassRule
    public static final DropwizardAppRule<FedmonWebApiServiceConfiguration> RULE = new DropwizardAppRule(FedmonWebApiServiceApplication.class, "../fedmon-webapi-service-TESTING.yml", new ConfigOverride[0]);
    protected static JFedExperimenterGuiConfigTestCollection jFedExperimenterGuiConfigTestCollection;
    protected static UserInfoTestCollection userInfoTestCollection;
    protected JerseyClient client;

    @BeforeClass
    public static void setUp() throws Exception {
        JFedExperimenterGuiConfigIntegrationTest.setUp(RULE);
    }

    public static void setUp(DropwizardAppRule<FedmonWebApiServiceConfiguration> RULE) throws Exception {
        Clock.set((Clock.CurrentTimeProvider)new Clock.DefaultTestTimeProvider());
        assert (RULE != null);
        FedmonTestPostgresDB testPostgresDB = new FedmonTestPostgresDB(RULE);
        testPostgresDB.recreateDB();
        testPostgresDB.close();
        jFedExperimenterGuiConfigTestCollection = new JFedExperimenterGuiConfigTestCollection();
        userInfoTestCollection = new UserInfoTestCollection();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        Clock.reset();
    }

    @Before
    public void beforeMethod() throws Exception {
        this.client = new JerseyClientBuilder().build();
        assert (this.client != null);
    }

    public void testLookup(UserInfo userInfo, JFedExperimenterGuiConfig expected) throws Exception {
        JFedExperimenterGuiConfig actual = this.doLookup(userInfo);
        this.checkLookup(expected, actual);
    }

    public JFedExperimenterGuiConfig doLookup(UserInfo userInfo) throws Exception {
        assert (this.client != null);
        JerseyWebTarget query = this.client.target(String.format("http://localhost:%d/guiconfig", RULE.getLocalPort()));
        Map queryParameters = userInfo.getQueryParameters();
        for (Map.Entry e : queryParameters.entrySet()) {
            query = query.queryParam((String)e.getKey(), new Object[]{e.getValue()});
        }
        JFedExperimenterGuiConfig actual = (JFedExperimenterGuiConfig)query.request().get(JFedExperimenterGuiConfig.class);
        System.out.println("Got result JFedExperimenterGuiConfig: " + actual);
        return actual;
    }

    public void checkLookup(JFedExperimenterGuiConfig expected, JFedExperimenterGuiConfig actual) {
        jFedExperimenterGuiConfigTestCollection.assertSame((JsonLdObject)actual, (JsonLdObject)expected, CommonTest.ComparePrecision.FULL, CommonTest.ComparePrecision.IGNORE_URI);
    }

    private JFedExperimenterGuiConfig removeUser(JFedExperimenterGuiConfig orig) {
        JFedExperimenterGuiConfigBuilder b = new JFedExperimenterGuiConfigBuilder(orig);
        b.setUser(null);
        return b.create();
    }

    @Test
    public void lookup0() throws Exception {
        UserInfo userInfo = (UserInfo)userInfoTestCollection.getByIndex(0);
        JFedExperimenterGuiConfig expected = this.removeUser((JFedExperimenterGuiConfig)jFedExperimenterGuiConfigTestCollection.getByIndex(0));
        this.testLookup(userInfo, expected);
    }

    @Test
    public void lookup1() throws Exception {
        UserInfo userInfo = (UserInfo)userInfoTestCollection.getByIndex(1);
        JFedExperimenterGuiConfig expected = this.removeUser((JFedExperimenterGuiConfig)jFedExperimenterGuiConfigTestCollection.getByIndex(1));
        this.testLookup(userInfo, expected);
    }
}

