/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.test;

import be.iminds.ilabt.jfed.fedmon.util.Clock;
import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonWebApiServiceApplication;
import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonWebApiServiceConfiguration;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.JFedExperimenterGuiConfig;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.UserInfo;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.FedmonTestPostgresDB;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.UserInfoTestCollection;
import io.dropwizard.testing.ConfigOverride;
import io.dropwizard.testing.junit.DropwizardAppRule;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.client.JerseyClient;
import org.glassfish.jersey.client.JerseyClientBuilder;
import org.glassfish.jersey.client.JerseyWebTarget;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

public class JFedUserStatisticsIntegrationTest {
    @ClassRule
    public static final DropwizardAppRule<FedmonWebApiServiceConfiguration> RULE = new DropwizardAppRule(FedmonWebApiServiceApplication.class, "../fedmon-webapi-service-TESTING.yml", new ConfigOverride[0]);
    protected JerseyClient client;

    @BeforeClass
    public static void setUp() throws Exception {
        JFedUserStatisticsIntegrationTest.setUp(RULE);
    }

    public static void setUp(DropwizardAppRule<FedmonWebApiServiceConfiguration> RULE) throws Exception {
        Clock.set((Clock.CurrentTimeProvider)new Clock.DefaultTestTimeProvider());
        assert (RULE != null);
        FedmonTestPostgresDB testPostgresDB = new FedmonTestPostgresDB(RULE);
        testPostgresDB.recreateDB();
        testPostgresDB.close();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        Clock.reset();
    }

    @Before
    public void beforeMethod() throws Exception {
        this.client = new JerseyClientBuilder().build();
        assert (this.client != null);
    }

    public Response doLookupAll() throws Exception {
        assert (this.client != null);
        JerseyWebTarget query = this.client.target(String.format("http://localhost:%d/jfed-user-statistics/", RULE.getLocalPort()));
        return query.request().get();
    }

    private void addDummyStat() {
        JerseyWebTarget query = this.client.target(String.format("http://localhost:%d/guiconfig", RULE.getLocalPort()));
        UserInfo userInfo = (UserInfo)new UserInfoTestCollection().getByIndex(0);
        Map queryParameters = userInfo.getQueryParameters();
        for (Map.Entry e : queryParameters.entrySet()) {
            query = query.queryParam((String)e.getKey(), new Object[]{e.getValue()});
        }
        query.request().get(JFedExperimenterGuiConfig.class);
    }

    @Test
    public void get0() throws Exception {
        Response r = this.doLookupAll();
        MatcherAssert.assertThat((Object)r.getStatus(), (Matcher)Matchers.is((Object)200));
    }

    @Test
    public void get1() throws Exception {
        this.addDummyStat();
        Response r = this.doLookupAll();
        MatcherAssert.assertThat((Object)r.getStatus(), (Matcher)Matchers.is((Object)200));
    }
}

