/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.test;

import be.iminds.ilabt.jfed.fedmon.util.Clock;
import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonWebApiServiceApplication;
import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonWebApiServiceConfiguration;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Location;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Organisation;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.OrganisationBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.FedmonTestPostgresDB;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.OrganisationTestCollection;
import be.iminds.ilabt.util.jsonld.iface.JsonLdObjectWithId;
import be.iminds.ilabt.util.jsonld.impl.PrimaryIdObject;
import be.iminds.ilabt.util.jsonld.test.CommonTest;
import io.dropwizard.testing.ConfigOverride;
import io.dropwizard.testing.junit.DropwizardAppRule;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import org.glassfish.jersey.client.JerseyClient;
import org.glassfish.jersey.client.JerseyClientBuilder;
import org.glassfish.jersey.client.JerseyWebTarget;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

public class OrganisationIntegrationTest {
    @ClassRule
    public static final DropwizardAppRule<FedmonWebApiServiceConfiguration> RULE = new DropwizardAppRule(FedmonWebApiServiceApplication.class, "../fedmon-webapi-service-TESTING.yml", new ConfigOverride[0]);
    protected static OrganisationTestCollection organisationTestCollection;
    protected JerseyClient client;

    @BeforeClass
    public static void setUp() throws Exception {
        OrganisationIntegrationTest.setUp(RULE);
    }

    public static void setUp(DropwizardAppRule<FedmonWebApiServiceConfiguration> RULE) throws Exception {
        Clock.set((Clock.CurrentTimeProvider)new Clock.DefaultTestTimeProvider());
        assert (RULE != null);
        FedmonTestPostgresDB testPostgresDB = new FedmonTestPostgresDB(RULE);
        testPostgresDB.recreateDB();
        testPostgresDB.close();
        organisationTestCollection = new OrganisationTestCollection();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        Clock.reset();
    }

    @Before
    public void beforeMethod() throws Exception {
        this.client = new JerseyClientBuilder().build();
        assert (this.client != null);
    }

    public void testLookup(Organisation expected, String id) throws Exception {
        Organisation actual = this.doLookup(id);
        this.checkLookup(expected, actual);
    }

    public Organisation doLookup(String id) throws Exception {
        assert (this.client != null);
        JerseyWebTarget query = this.client.target(String.format("http://localhost:%d/organisation/" + id, RULE.getLocalPort()));
        Organisation actual = (Organisation)query.request().get(Organisation.class);
        System.out.println("Got result Organisation: " + actual);
        return actual;
    }

    public void checkLookup(Organisation expected, Organisation actual) {
        organisationTestCollection.assertSame((JsonLdObjectWithId)actual, (JsonLdObjectWithId)expected, CommonTest.ComparePrecision.FULL, CommonTest.ComparePrecision.MINIMAL_ID_AND_URI_ONLY);
    }

    public void testLookupAll(List<Organisation> expected) throws Exception {
        List<Organisation> actual = this.doLookupAll();
        this.checkLookupAll(expected, actual);
    }

    public List<Organisation> doLookupAll() throws Exception {
        assert (this.client != null);
        JerseyWebTarget query = this.client.target(String.format("http://localhost:%d/organisation/", RULE.getLocalPort()));
        List actual = (List)query.request().get((GenericType)new GenericType<List<Organisation>>(){});
        System.out.println("Got " + actual.size() + " Organisations. Id's: " + actual.stream().map(PrimaryIdObject::getId).collect(Collectors.toList()));
        return actual;
    }

    public void checkLookupAll(List<Organisation> expected, List<Organisation> actual) {
        MatcherAssert.assertThat(actual, (Matcher)Matchers.hasSize((int)expected.size()));
        for (Organisation ex : expected) {
            Organisation ac = (Organisation)organisationTestCollection.searchListById(actual, (String)ex.getId());
            MatcherAssert.assertThat((String)("Expected id " + (String)ex.getId() + " not found in result"), (Object)ac, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            organisationTestCollection.assertSame((JsonLdObjectWithId)ac, (JsonLdObjectWithId)ex, CommonTest.ComparePrecision.FULL, CommonTest.ComparePrecision.MINIMAL_ID_AND_URI_ONLY);
        }
    }

    @Test
    public void lookup0() throws Exception {
        Organisation expected = (Organisation)organisationTestCollection.getByIndex(0);
        this.testLookup(expected, (String)expected.getId());
    }

    @Test
    public void lookup1() throws Exception {
        Organisation expected = (Organisation)organisationTestCollection.getByIndex(1);
        this.testLookup(expected, (String)expected.getId());
    }

    @Test
    public void lookupAll() throws Exception {
        List expected = organisationTestCollection.getAll();
        this.testLookupAll(expected);
    }

    public Organisation createOrganisationsCall(Organisation organisation) throws Exception {
        JerseyWebTarget w = this.client.target(String.format("http://localhost:%d/organisation/", RULE.getLocalPort()));
        Entity entity = Entity.entity((Object)organisation, (MediaType)MediaType.APPLICATION_JSON_TYPE);
        Organisation res = (Organisation)w.request().post(entity, Organisation.class);
        return res;
    }

    public void deleteOrganisationCall(long id) throws Exception {
        this.client.target(String.format("http://localhost:%d/organisation/%d", RULE.getLocalPort(), id)).request().delete();
    }

    public void updateOrganisationCall(Organisation updatedOrganisation) throws Exception {
        this.client.target(String.format("http://localhost:%d/organisation/%d/", RULE.getLocalPort(), updatedOrganisation.getId())).request().put(Entity.entity((Object)updatedOrganisation, (MediaType)MediaType.APPLICATION_JSON_TYPE));
    }

    @Test
    public void testInsert() throws Exception {
        Organisation newOrganisation = ((OrganisationBuilder)new OrganisationBuilder().setId((Object)"new-test")).setName("New Test Org").setLocation(new Location("BE", Double.valueOf(0.2), Double.valueOf(0.1), "Belgium")).setLogoUrl("logoUrl").setSiteUrl("siteUrl").create();
        Organisation actualCreatedOrganisation = this.createOrganisationsCall(newOrganisation);
        MatcherAssert.assertThat((String)"created organisation is null", (Object)actualCreatedOrganisation, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        System.out.println("Got inserted organisation: " + actualCreatedOrganisation);
        System.out.flush();
        MatcherAssert.assertThat((String)"id of created organisation is null", (Object)((String)actualCreatedOrganisation.getId()), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        Organisation expectedOrganisation = ((OrganisationBuilder)new OrganisationBuilder(newOrganisation).setId((Object)((String)actualCreatedOrganisation.getId()))).setTestbeds(Collections.emptyList()).create();
        assert (expectedOrganisation.getTestbeds() != null);
        assert (expectedOrganisation.getTestbeds().isEmpty());
        MatcherAssert.assertThat((String)"URI of created organisation is null", (Object)actualCreatedOrganisation.getUri(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)actualCreatedOrganisation.getTestbeds(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)actualCreatedOrganisation.getTestbeds(), (Matcher)Matchers.hasSize((int)0));
        organisationTestCollection.assertSame((JsonLdObjectWithId)actualCreatedOrganisation, (JsonLdObjectWithId)expectedOrganisation, CommonTest.ComparePrecision.FULL, CommonTest.ComparePrecision.ID_AND_REFS_ONLY);
        Organisation lookedUpOrganisation = this.doLookup((String)actualCreatedOrganisation.getId());
        MatcherAssert.assertThat((String)"created organisation is null after lookup", (Object)lookedUpOrganisation, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)lookedUpOrganisation.getTestbeds(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)lookedUpOrganisation.getTestbeds(), (Matcher)Matchers.hasSize((int)0));
        organisationTestCollection.assertSame((JsonLdObjectWithId)lookedUpOrganisation, (JsonLdObjectWithId)expectedOrganisation, CommonTest.ComparePrecision.FULL, CommonTest.ComparePrecision.ID_AND_REFS_ONLY);
    }
}

