/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.test;

import be.iminds.ilabt.jfed.fedmon.util.Clock;
import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonWebApiServiceApplication;
import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonWebApiServiceConfiguration;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ResourceMapping;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ResourceMappingBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.FedmonTestPostgresDB;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.ResourceMappingTestCollection;
import be.iminds.ilabt.util.jsonld.iface.JsonLdObject;
import be.iminds.ilabt.util.jsonld.test.CommonTest;
import io.dropwizard.testing.ConfigOverride;
import io.dropwizard.testing.junit.DropwizardAppRule;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.client.JerseyClient;
import org.glassfish.jersey.client.JerseyClientBuilder;
import org.glassfish.jersey.client.JerseyWebTarget;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

public class ResourceMappingIntegrationTest {
    @ClassRule
    public static final DropwizardAppRule<FedmonWebApiServiceConfiguration> RULE = new DropwizardAppRule(FedmonWebApiServiceApplication.class, "../fedmon-webapi-service-TESTING.yml", new ConfigOverride[0]);
    protected static ResourceMappingTestCollection resourceMappingTestCollection;
    protected JerseyClient client;

    @BeforeClass
    public static void setUp() throws Exception {
        ResourceMappingIntegrationTest.setUp(RULE);
    }

    public static void setUp(DropwizardAppRule<FedmonWebApiServiceConfiguration> RULE) throws Exception {
        Clock.set((Clock.CurrentTimeProvider)new Clock.DefaultTestTimeProvider());
        assert (RULE != null);
        Clock.set((Clock.CurrentTimeProvider)new Clock.DefaultTestTimeProvider());
        FedmonTestPostgresDB testPostgresDB = new FedmonTestPostgresDB(RULE);
        testPostgresDB.recreateDB();
        testPostgresDB.close();
        resourceMappingTestCollection = new ResourceMappingTestCollection();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        Clock.reset();
    }

    @Before
    public void beforeMethod() throws Exception {
        this.client = new JerseyClientBuilder().build();
        assert (this.client != null);
    }

    public void testLookupAll(List<ResourceMapping> expected) throws Exception {
        List<ResourceMapping> actual = this.doLookupAll();
        this.checkLookupAll(expected, actual);
    }

    public List<ResourceMapping> doLookupAll() throws Exception {
        assert (this.client != null);
        JerseyWebTarget query = this.client.target(String.format("http://localhost:%d/resourcemapping/", RULE.getLocalPort()));
        List actual = (List)query.request().get((GenericType)new GenericType<List<ResourceMapping>>(){});
        System.out.println("Got result ResourceMapping: " + actual);
        return actual;
    }

    public void checkLookupAll(List<ResourceMapping> expected, List<ResourceMapping> actual) {
        MatcherAssert.assertThat(actual, (Matcher)Matchers.hasSize((int)expected.size()));
        for (ResourceMapping ex : expected) {
            boolean found = false;
            for (ResourceMapping ac : actual) {
                boolean same = true;
                same = same && this.isSame(ac.getResourceClassId(), ex.getResourceClassId());
                same = same && this.isSame(ac.getResourceId(), ex.getResourceId());
                if (!(same = same && this.isSame(ac.getConfigSetId(), ex.getConfigSetId()))) continue;
                resourceMappingTestCollection.assertSame((JsonLdObject)ac, (JsonLdObject)ex, CommonTest.ComparePrecision.FULL, null);
                found = true;
            }
            MatcherAssert.assertThat((String)("Expected ResourceMapping not found in result: " + ex), (Object)found, (Matcher)Matchers.is((Object)true));
        }
    }

    private boolean isSame(Object a, Object e) {
        if (a == null != (e == null)) {
            return false;
        }
        if (a == null) {
            return true;
        }
        return a.equals(e);
    }

    @Test
    public void lookupAll() throws Exception {
        List expected = resourceMappingTestCollection.getAll();
        this.testLookupAll(expected);
    }

    public void createResourceMappingsCall(ResourceMapping resourceMapping) throws Exception {
        JerseyWebTarget w = this.client.target(String.format("http://localhost:%d/resourcemapping/", RULE.getLocalPort()));
        Entity entity = Entity.entity((Object)resourceMapping, (MediaType)MediaType.APPLICATION_JSON_TYPE);
        w.request().post(entity, ResourceMapping.class);
    }

    public void deleteResourceMapping(ResourceMapping resourceMapping) throws Exception {
        String id = resourceMapping.getResourceId() + "/" + resourceMapping.getResourceClassId() + "/" + resourceMapping.getConfigSetId();
        JerseyWebTarget w = this.client.target(String.format("http://localhost:%d/resourcemapping/" + id, RULE.getLocalPort()));
        Response r = w.request().delete();
        if (r.getStatus() != 204) {
            throw new RuntimeException("not ok: " + r);
        }
    }

    @Test
    public void testInsertAndDelete() throws Exception {
        ResourceMappingBuilder newResourceMapping = new ResourceMappingBuilder().setResourceId(Integer.valueOf(3)).setResourceClassId("raw-pc").setConfigSetId("testB");
        this.createResourceMappingsCall(newResourceMapping.create());
        List<Object> expected = new ArrayList<ResourceMapping>(resourceMappingTestCollection.getAll());
        expected.add(newResourceMapping.create());
        this.testLookupAll(expected);
        this.deleteResourceMapping(newResourceMapping.create());
        expected = resourceMappingTestCollection.getAll();
        this.testLookupAll(expected);
    }
}

