/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.test;

import be.iminds.ilabt.jfed.fedmon.util.Clock;
import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonWebApiServiceApplication;
import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonWebApiServiceConfiguration;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Result;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ResultBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.FedmonTestPostgresDB;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.ResultTestCollection;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.TestInstancesTestCollection;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.TestbedTestCollection;
import be.iminds.ilabt.jfed.util.common.IOUtils;
import be.iminds.ilabt.util.jsonld.iface.JsonLdObjectWithId;
import be.iminds.ilabt.util.jsonld.impl.PrimaryIdObject;
import io.dropwizard.testing.ConfigOverride;
import io.dropwizard.testing.junit.DropwizardAppRule;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.core.GenericType;
import org.glassfish.jersey.client.JerseyClient;
import org.glassfish.jersey.client.JerseyClientBuilder;
import org.glassfish.jersey.client.JerseyWebTarget;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

public class ResultIntegrationTest {
    @ClassRule
    public static final DropwizardAppRule<FedmonWebApiServiceConfiguration> RULE = new DropwizardAppRule(FedmonWebApiServiceApplication.class, "../fedmon-webapi-service-TESTING.yml", new ConfigOverride[0]);
    protected static ResultTestCollection resultTestCollection;
    protected static TestbedTestCollection testbedTestCollection;
    protected static TestInstancesTestCollection testInstancesTestCollection;
    protected JerseyClient client;

    @BeforeClass
    public static void setUp() throws Exception {
        ResultIntegrationTest.setUp(RULE);
    }

    public static void setUp(DropwizardAppRule<FedmonWebApiServiceConfiguration> RULE) throws Exception {
        Clock.set((Clock.CurrentTimeProvider)new Clock.DefaultTestTimeProvider());
        assert (RULE != null);
        FedmonTestPostgresDB testPostgresDB = new FedmonTestPostgresDB(RULE);
        testPostgresDB.recreateDB();
        testPostgresDB.close();
        testbedTestCollection = new TestbedTestCollection();
        testInstancesTestCollection = new TestInstancesTestCollection();
        resultTestCollection = new ResultTestCollection(false);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        Clock.reset();
    }

    @Before
    public void beforeMethod() throws Exception {
        this.client = new JerseyClientBuilder().build();
        assert (this.client != null);
    }

    public void testSearch(List<Result> expected, String lastArg, String versionNameArgString, String testInstanceNameArgString, String testDefinitionNameArgString, String testInstanceIdArgString, String testbedCategoryArgString, String testbedGeniNameArgString, String testbedNameArgString, String testbedUrnArgString, String summaryArgString, Boolean enabledArg, Boolean disabledArg, Boolean expiredArg, Boolean cancelledExcludedArg, Boolean cancelledIncludedArg, Date from, Date till, boolean embed) throws Exception {
        List<Result> actual = this.doSearch(lastArg, versionNameArgString, testInstanceNameArgString, testDefinitionNameArgString, testInstanceIdArgString, testbedCategoryArgString, testbedGeniNameArgString, testbedNameArgString, testbedUrnArgString, summaryArgString, enabledArg, disabledArg, expiredArg, cancelledExcludedArg, cancelledIncludedArg, from, till, embed);
        this.checkSearch(expected, actual, embed);
    }

    public List<Result> doSearch(String lastArg, String versionNameArgString, String testInstanceNameArgString, String testDefinitionNameArgString, String testInstanceIdArgString, String testbedCategoryArgString, String testbedGeniNameArgString, String testbedNameArgString, String testbedUrnArgString, String summaryArgString, Boolean enabledArg, Boolean disabledArg, Boolean expiredArg, Boolean cancelledExcludedArg, Boolean cancelledIncludedArg, Date from, Date till, boolean embed) throws Exception {
        assert (this.client != null);
        JerseyWebTarget query = this.client.target(String.format("http://localhost:%d/result/", RULE.getLocalPort()));
        if (lastArg != null) {
            query = query.queryParam("last", new Object[]{lastArg});
        }
        if (versionNameArgString != null) {
            query = query.queryParam("testversionname", new Object[]{versionNameArgString});
        }
        if (testInstanceNameArgString != null) {
            query = query.queryParam("testname", new Object[]{testInstanceNameArgString});
        }
        if (testDefinitionNameArgString != null) {
            query = query.queryParam("testdefinitionname", new Object[]{testDefinitionNameArgString});
        }
        if (testInstanceIdArgString != null) {
            query = query.queryParam("testinstanceid", new Object[]{testInstanceIdArgString});
        }
        if (testbedCategoryArgString != null) {
            query = query.queryParam("testbedcategory", new Object[]{testbedCategoryArgString});
        }
        if (testbedGeniNameArgString != null) {
            query = query.queryParam("geni_testbed", new Object[]{testbedGeniNameArgString});
        }
        if (testbedUrnArgString != null) {
            query = query.queryParam("testbed_urn", new Object[]{testbedUrnArgString});
        }
        if (testbedNameArgString != null) {
            query = query.queryParam("testbed", new Object[]{testbedNameArgString});
        }
        if (summaryArgString != null) {
            query = query.queryParam("summary", new Object[]{summaryArgString});
        }
        if (enabledArg != null) {
            query = query.queryParam("enabled", new Object[]{enabledArg});
        }
        if (disabledArg != null) {
            query = query.queryParam("disabled", new Object[]{disabledArg});
        }
        if (cancelledExcludedArg != null) {
            query = query.queryParam("cancelled_excluded", new Object[]{cancelledExcludedArg});
        }
        if (cancelledIncludedArg != null) {
            query = query.queryParam("cancelled_included", new Object[]{cancelledIncludedArg});
        }
        if (from != null) {
            query = query.queryParam("from", new Object[]{from});
        }
        if (till != null) {
            query = query.queryParam("till", new Object[]{till});
        }
        if (embed) {
            query = query.queryParam("embed", new Object[]{embed});
        }
        List actual = (List)query.request().get((GenericType)new GenericType<List<Result>>(){});
        System.out.println("Got " + actual.size() + " results. Id's: " + actual.stream().map(PrimaryIdObject::getId).collect(Collectors.toList()));
        if (!actual.isEmpty()) {
            System.out.println("First result: " + actual.get(0));
        }
        return actual;
    }

    public void checkSearch(List<Result> expected, List<Result> actual, boolean embed) {
        MatcherAssert.assertThat((String)("size differs. actual=" + actual.stream().map(PrimaryIdObject::getId).collect(Collectors.toList()) + " expected=" + expected.stream().map(PrimaryIdObject::getId).collect(Collectors.toList())), actual, (Matcher)Matchers.hasSize((int)expected.size()));
        for (Result ex : expected) {
            Result ac = (Result)resultTestCollection.searchListById(actual, (Long)ex.getId());
            MatcherAssert.assertThat((String)("Expected id " + ex.getId() + " not found in result. actual=" + actual.stream().map(PrimaryIdObject::getId).collect(Collectors.toList()) + " expected=" + expected.stream().map(PrimaryIdObject::getId).collect(Collectors.toList())), (Object)ac, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            resultTestCollection.assertSameAndExpectActualHasUri((JsonLdObjectWithId)ac, (JsonLdObjectWithId)ex);
            if (!embed || ex.getTestInstanceId() == null) continue;
            ResultBuilder exResultBuilder = new ResultBuilder(ex);
            ResultBuilder resultBuilder = new ResultBuilder(ac);
            MatcherAssert.assertThat((Object)resultBuilder.getTestInstance(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        }
    }

    public void testLookup(Result expected, long id) throws Exception {
        this.testLookup(expected, id, false);
    }

    public void testLookup(Result expected, long id, boolean embed) throws Exception {
        Result actual = this.doLookup(id, embed);
        this.checkLookup(expected, actual, embed);
    }

    public Result doLookup(long id, boolean embed) throws Exception {
        assert (this.client != null);
        JerseyWebTarget query = this.client.target(String.format("http://localhost:%d/result/" + id, RULE.getLocalPort()));
        if (embed) {
            query = query.queryParam("embed", new Object[]{embed});
        }
        Result actual = (Result)query.request().get(Result.class);
        System.out.println("Got result result: " + actual);
        return actual;
    }

    public void checkLookup(Result expected, Result actual, boolean embed) {
        resultTestCollection.assertSameAndExpectActualHasUri((JsonLdObjectWithId)actual, (JsonLdObjectWithId)expected);
        if (embed && expected.getTestInstanceId() != null) {
            ResultBuilder resultBuilder = new ResultBuilder(actual);
            MatcherAssert.assertThat((Object)resultBuilder.getTestInstance(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        }
    }

    @Test
    public void lookup0() throws Exception {
        Result expected = (Result)resultTestCollection.getByIndex(0);
        this.testLookup(expected, (Long)expected.getId());
    }

    @Test
    public void lookup0Embed() throws Exception {
        Result expected = (Result)resultTestCollection.getByIndex(0);
        this.testLookup(expected, (Long)expected.getId(), true);
    }

    @Test
    public void lookup1() throws Exception {
        Result expected = (Result)resultTestCollection.getByIndex(1);
        this.testLookup(expected, (Long)expected.getId());
    }

    @Test
    public void lookup2() throws Exception {
        Result expected = (Result)resultTestCollection.getByIndex(2);
        this.testLookup(expected, (Long)expected.getId());
    }

    @Test
    public void lookup3() throws Exception {
        Result expected = (Result)resultTestCollection.getByIndex(3);
        this.testLookup(expected, (Long)expected.getId());
    }

    @Test
    public void lookup4() throws Exception {
        Result expected = (Result)resultTestCollection.getByIndex(4);
        this.testLookup(expected, (Long)expected.getId());
    }

    @Test
    public void lookup5() throws Exception {
        Result expected = (Result)resultTestCollection.getByIndex(5);
        this.testLookup(expected, (Long)expected.getId());
    }

    @Test
    public void lookup6() throws Exception {
        Result expected = (Result)resultTestCollection.getByIndex(6);
        this.testLookup(expected, (Long)expected.getId());
    }

    @Test
    public void search1() throws Exception {
        String versionNameArgString = null;
        String testInstanceNameArgString = null;
        String testDefinitionNameArgString = null;
        String testInstanceIdArgString = null;
        String testbedCategoryArgString = null;
        String testbedGeniNameArgString = null;
        String testbedNameArgString = null;
        String testbedUrnArgString = null;
        Boolean enabledArg = null;
        Boolean disabledArg = null;
        Boolean expiredArg = null;
        String lastArg = "";
        String summaryArgString = null;
        Boolean cancelledExcludedArg = null;
        Boolean cancelledIncludedArg = null;
        Date fromArg = null;
        Date tillArg = null;
        List expected = resultTestCollection.getByIds(new Long[]{1L, 2L, 4L, 7L});
        this.testSearch(expected, lastArg, versionNameArgString, testInstanceNameArgString, testDefinitionNameArgString, testInstanceIdArgString, testbedCategoryArgString, testbedGeniNameArgString, testbedNameArgString, testbedUrnArgString, summaryArgString, enabledArg, disabledArg, expiredArg, cancelledExcludedArg, cancelledIncludedArg, fromArg, tillArg, false);
    }

    @Test
    public void search2() throws Exception {
        String versionNameArgString = "";
        String testInstanceNameArgString = "";
        String testDefinitionNameArgString = "";
        String testInstanceIdArgString = "";
        String testbedCategoryArgString = "";
        String testbedGeniNameArgString = "";
        String testbedNameArgString = null;
        String testbedUrnArgString = null;
        Boolean enabledArg = null;
        Boolean disabledArg = null;
        Boolean expiredArg = null;
        String lastArg = "";
        String summaryArgString = null;
        Boolean cancelledExcludedArg = null;
        Boolean cancelledIncludedArg = null;
        Date fromArg = null;
        Date tillArg = null;
        List expected = resultTestCollection.getByIds(new Long[]{1L, 2L, 4L, 7L});
        this.testSearch(expected, lastArg, versionNameArgString, testInstanceNameArgString, testDefinitionNameArgString, testInstanceIdArgString, testbedCategoryArgString, testbedGeniNameArgString, testbedNameArgString, testbedUrnArgString, summaryArgString, enabledArg, disabledArg, expiredArg, cancelledExcludedArg, cancelledIncludedArg, fromArg, tillArg, false);
    }

    @Test
    public void search3() throws Exception {
        String versionNameArgString = null;
        String testInstanceNameArgString = null;
        String testDefinitionNameArgString = null;
        String testInstanceIdArgString = "9";
        String testbedCategoryArgString = null;
        String testbedGeniNameArgString = null;
        String testbedNameArgString = null;
        String testbedUrnArgString = null;
        Boolean enabledArg = null;
        Boolean disabledArg = null;
        Boolean expiredArg = null;
        String lastArg = "";
        String summaryArgString = null;
        Boolean cancelledExcludedArg = null;
        Boolean cancelledIncludedArg = null;
        Date fromArg = null;
        Date tillArg = null;
        List<Result> expected = resultTestCollection.getByTestInstanceIds(9);
        this.testSearch(expected, lastArg, versionNameArgString, testInstanceNameArgString, testDefinitionNameArgString, testInstanceIdArgString, testbedCategoryArgString, testbedGeniNameArgString, testbedNameArgString, testbedUrnArgString, summaryArgString, enabledArg, disabledArg, expiredArg, cancelledExcludedArg, cancelledIncludedArg, fromArg, tillArg, false);
    }

    @Test
    public void search4() throws Exception {
        String versionNameArgString = null;
        String testInstanceNameArgString = null;
        String testDefinitionNameArgString = null;
        String testInstanceIdArgString = "9,11";
        String testbedCategoryArgString = null;
        String testbedGeniNameArgString = null;
        String testbedNameArgString = null;
        String testbedUrnArgString = null;
        Boolean enabledArg = null;
        Boolean disabledArg = null;
        Boolean expiredArg = null;
        String lastArg = "";
        String summaryArgString = null;
        Boolean cancelledExcludedArg = null;
        Boolean cancelledIncludedArg = null;
        Date fromArg = null;
        Date tillArg = null;
        List<Result> expected = resultTestCollection.getLastByTestInstanceIds(9, 11);
        this.testSearch(expected, lastArg, versionNameArgString, testInstanceNameArgString, testDefinitionNameArgString, testInstanceIdArgString, testbedCategoryArgString, testbedGeniNameArgString, testbedNameArgString, testbedUrnArgString, summaryArgString, enabledArg, disabledArg, expiredArg, cancelledExcludedArg, cancelledIncludedArg, fromArg, tillArg, false);
    }

    @Test
    public void search5() throws Exception {
        String versionNameArgString = null;
        String testInstanceNameArgString = null;
        String testDefinitionNameArgString = "anyGetVersion";
        String testInstanceIdArgString = null;
        String testbedCategoryArgString = null;
        String testbedGeniNameArgString = null;
        String testbedNameArgString = null;
        String testbedUrnArgString = null;
        Boolean enabledArg = null;
        Boolean disabledArg = null;
        Boolean expiredArg = null;
        String lastArg = "";
        String summaryArgString = null;
        Boolean cancelledExcludedArg = null;
        Boolean cancelledIncludedArg = null;
        Date fromArg = null;
        Date tillArg = null;
        List<Result> expected = resultTestCollection.getLastByTestInstanceIds(10, 12, 13);
        this.testSearch(expected, lastArg, versionNameArgString, testInstanceNameArgString, testDefinitionNameArgString, testInstanceIdArgString, testbedCategoryArgString, testbedGeniNameArgString, testbedNameArgString, testbedUrnArgString, summaryArgString, enabledArg, disabledArg, expiredArg, cancelledExcludedArg, cancelledIncludedArg, fromArg, tillArg, false);
    }

    @Test
    public void search6() throws Exception {
        String versionNameArgString = null;
        String testInstanceNameArgString = null;
        String testDefinitionNameArgString = null;
        String testInstanceIdArgString = null;
        String testbedCategoryArgString = null;
        String testbedGeniNameArgString = null;
        String testbedNameArgString = null;
        String testbedUrnArgString = null;
        Boolean enabledArg = null;
        Boolean disabledArg = true;
        Boolean expiredArg = null;
        String lastArg = "";
        String summaryArgString = null;
        Boolean cancelledExcludedArg = null;
        Boolean cancelledIncludedArg = null;
        Date fromArg = null;
        Date tillArg = null;
        List<Result> expected = resultTestCollection.getLastByTestInstanceIds(11);
        this.testSearch(expected, lastArg, versionNameArgString, testInstanceNameArgString, testDefinitionNameArgString, testInstanceIdArgString, testbedCategoryArgString, testbedGeniNameArgString, testbedNameArgString, testbedUrnArgString, summaryArgString, enabledArg, disabledArg, expiredArg, cancelledExcludedArg, cancelledIncludedArg, fromArg, tillArg, false);
    }

    @Test
    public void search7() throws Exception {
        String versionNameArgString = null;
        String testInstanceNameArgString = null;
        String testDefinitionNameArgString = null;
        String testInstanceIdArgString = null;
        String testbedCategoryArgString = null;
        String testbedGeniNameArgString = null;
        String testbedNameArgString = "A";
        String testbedUrnArgString = null;
        Boolean enabledArg = null;
        Boolean disabledArg = null;
        Boolean expiredArg = null;
        String lastArg = "";
        String summaryArgString = null;
        Boolean cancelledExcludedArg = null;
        Boolean cancelledIncludedArg = null;
        Date fromArg = null;
        Date tillArg = null;
        List<Result> expected = resultTestCollection.getLastByTestInstanceIds(9, 12);
        this.testSearch(expected, lastArg, versionNameArgString, testInstanceNameArgString, testDefinitionNameArgString, testInstanceIdArgString, testbedCategoryArgString, testbedGeniNameArgString, testbedNameArgString, testbedUrnArgString, summaryArgString, enabledArg, disabledArg, expiredArg, cancelledExcludedArg, cancelledIncludedArg, fromArg, tillArg, false);
    }

    @Test
    public void search8() throws Exception {
        String versionNameArgString = "test";
        String testInstanceNameArgString = null;
        String testDefinitionNameArgString = null;
        String testInstanceIdArgString = null;
        String testbedCategoryArgString = null;
        String testbedGeniNameArgString = null;
        String testbedNameArgString = null;
        String testbedUrnArgString = null;
        Boolean enabledArg = null;
        Boolean disabledArg = null;
        Boolean expiredArg = null;
        String lastArg = "";
        String summaryArgString = null;
        Boolean cancelledExcludedArg = null;
        Boolean cancelledIncludedArg = null;
        Date fromArg = null;
        Date tillArg = null;
        List<Result> expected = resultTestCollection.getLastByTestInstanceIds(10, 11);
        this.testSearch(expected, lastArg, versionNameArgString, testInstanceNameArgString, testDefinitionNameArgString, testInstanceIdArgString, testbedCategoryArgString, testbedGeniNameArgString, testbedNameArgString, testbedUrnArgString, summaryArgString, enabledArg, disabledArg, expiredArg, cancelledExcludedArg, cancelledIncludedArg, fromArg, tillArg, false);
    }

    @Test
    public void search8embed() throws Exception {
        String versionNameArgString = "test";
        String testInstanceNameArgString = null;
        String testDefinitionNameArgString = null;
        String testInstanceIdArgString = null;
        String testbedCategoryArgString = null;
        String testbedGeniNameArgString = null;
        String testbedNameArgString = null;
        String testbedUrnArgString = null;
        Boolean enabledArg = null;
        Boolean disabledArg = null;
        Boolean expiredArg = null;
        String lastArg = "";
        String summaryArgString = null;
        Boolean cancelledExcludedArg = null;
        Boolean cancelledIncludedArg = null;
        Date fromArg = null;
        Date tillArg = null;
        List<Result> expected = resultTestCollection.getLastByTestInstanceIds(10, 11);
        this.testSearch(expected, lastArg, versionNameArgString, testInstanceNameArgString, testDefinitionNameArgString, testInstanceIdArgString, testbedCategoryArgString, testbedGeniNameArgString, testbedNameArgString, testbedUrnArgString, summaryArgString, enabledArg, disabledArg, expiredArg, cancelledExcludedArg, cancelledIncludedArg, fromArg, tillArg, true);
    }

    @Test
    public void search10() throws Exception {
        String versionNameArgString = null;
        String testInstanceNameArgString = null;
        String testDefinitionNameArgString = null;
        String testInstanceIdArgString = null;
        String testbedCategoryArgString = "oneAndTwo";
        String testbedGeniNameArgString = null;
        String testbedNameArgString = null;
        String testbedUrnArgString = null;
        Boolean enabledArg = null;
        Boolean disabledArg = null;
        Boolean expiredArg = null;
        String lastArg = "";
        String summaryArgString = null;
        Boolean cancelledExcludedArg = null;
        Boolean cancelledIncludedArg = null;
        Date fromArg = null;
        Date tillArg = null;
        List<Result> expected = resultTestCollection.getLastByTestInstanceIds(9, 10, 11, 12);
        this.testSearch(expected, lastArg, versionNameArgString, testInstanceNameArgString, testDefinitionNameArgString, testInstanceIdArgString, testbedCategoryArgString, testbedGeniNameArgString, testbedNameArgString, testbedUrnArgString, summaryArgString, enabledArg, disabledArg, expiredArg, cancelledExcludedArg, cancelledIncludedArg, fromArg, tillArg, false);
    }

    @Test
    public void search11() throws Exception {
        String versionNameArgString = null;
        String testInstanceNameArgString = null;
        String testDefinitionNameArgString = null;
        String testInstanceIdArgString = null;
        String testbedCategoryArgString = null;
        String testbedGeniNameArgString = "ex-b";
        String testbedNameArgString = null;
        String testbedUrnArgString = null;
        Boolean enabledArg = null;
        Boolean disabledArg = null;
        Boolean expiredArg = null;
        String lastArg = "";
        String summaryArgString = null;
        Boolean cancelledExcludedArg = null;
        Boolean cancelledIncludedArg = null;
        Date fromArg = null;
        Date tillArg = null;
        List<Result> expected = resultTestCollection.getLastByTestInstanceIds(10, 11);
        this.testSearch(expected, lastArg, versionNameArgString, testInstanceNameArgString, testDefinitionNameArgString, testInstanceIdArgString, testbedCategoryArgString, testbedGeniNameArgString, testbedNameArgString, testbedUrnArgString, summaryArgString, enabledArg, disabledArg, expiredArg, cancelledExcludedArg, cancelledIncludedArg, fromArg, tillArg, false);
    }

    @Test
    public void search12() throws Exception {
        String versionNameArgString = null;
        String testInstanceNameArgString = null;
        String testDefinitionNameArgString = null;
        String testInstanceIdArgString = null;
        String testbedCategoryArgString = null;
        String testbedGeniNameArgString = null;
        String testbedNameArgString = null;
        String testbedUrnArgString = null;
        Boolean enabledArg = null;
        Boolean disabledArg = null;
        Boolean expiredArg = null;
        String lastArg = "";
        String summaryArgString = null;
        Boolean cancelledExcludedArg = null;
        Boolean cancelledIncludedArg = null;
        Date fromArg = null;
        Date tillArg = null;
        List<Result> expected = resultTestCollection.getLastByTestInstanceIds(9, 10, 11, 12, 13);
        this.testSearch(expected, lastArg, versionNameArgString, testInstanceNameArgString, testDefinitionNameArgString, testInstanceIdArgString, testbedCategoryArgString, testbedGeniNameArgString, testbedNameArgString, testbedUrnArgString, summaryArgString, enabledArg, disabledArg, expiredArg, cancelledExcludedArg, cancelledIncludedArg, fromArg, tillArg, false);
    }

    @Test
    public void search13() throws Exception {
        String versionNameArgString = "prod,test";
        String testInstanceNameArgString = null;
        String testDefinitionNameArgString = "anyGetVersion";
        String testInstanceIdArgString = null;
        String testbedCategoryArgString = "oneAndTwo";
        String testbedGeniNameArgString = "ex-b";
        String testbedNameArgString = "B";
        String testbedUrnArgString = null;
        Boolean enabledArg = true;
        Boolean disabledArg = false;
        Boolean expiredArg = null;
        String lastArg = "";
        String summaryArgString = null;
        Boolean cancelledExcludedArg = null;
        Boolean cancelledIncludedArg = null;
        Date fromArg = null;
        Date tillArg = null;
        List<Result> expected = resultTestCollection.getLastByTestInstanceIds(10);
        this.testSearch(expected, lastArg, versionNameArgString, testInstanceNameArgString, testDefinitionNameArgString, testInstanceIdArgString, testbedCategoryArgString, testbedGeniNameArgString, testbedNameArgString, testbedUrnArgString, summaryArgString, enabledArg, disabledArg, expiredArg, cancelledExcludedArg, cancelledIncludedArg, fromArg, tillArg, false);
    }

    @Test
    public void search14() throws Exception {
        String versionNameArgString = "prod,test";
        String testInstanceNameArgString = "pingA,pingB,getVersionA,getVersionB,getVersionC,pingC";
        String testDefinitionNameArgString = "anyGetVersion,ping";
        String testInstanceIdArgString = "9,10,11,12,13,14";
        String testbedCategoryArgString = null;
        String testbedGeniNameArgString = null;
        String testbedNameArgString = "A,B,C";
        String testbedUrnArgString = null;
        Boolean enabledArg = null;
        Boolean disabledArg = null;
        Boolean expiredArg = null;
        String lastArg = "";
        String summaryArgString = null;
        Boolean cancelledExcludedArg = null;
        Boolean cancelledIncludedArg = null;
        Date fromArg = null;
        Date tillArg = null;
        List<Result> expected = resultTestCollection.getLastByTestInstanceIds(9, 10, 11, 12, 13, 14);
        this.testSearch(expected, lastArg, versionNameArgString, testInstanceNameArgString, testDefinitionNameArgString, testInstanceIdArgString, testbedCategoryArgString, testbedGeniNameArgString, testbedNameArgString, testbedUrnArgString, summaryArgString, enabledArg, disabledArg, expiredArg, cancelledExcludedArg, cancelledIncludedArg, fromArg, tillArg, false);
    }

    @Test
    public void search15() throws Exception {
        String versionNameArgString = null;
        String testInstanceNameArgString = null;
        String testDefinitionNameArgString = null;
        String testInstanceIdArgString = null;
        String testbedCategoryArgString = null;
        String testbedGeniNameArgString = null;
        String testbedNameArgString = null;
        String testbedUrnArgString = "urn:publicid:IDN+b.example.com+authority+cm";
        Boolean enabledArg = null;
        Boolean disabledArg = null;
        Boolean expiredArg = null;
        String lastArg = "";
        String summaryArgString = null;
        Boolean cancelledExcludedArg = null;
        Boolean cancelledIncludedArg = null;
        Date fromArg = null;
        Date tillArg = null;
        List<Result> expected = resultTestCollection.getLastByTestInstanceIds(10, 11);
        this.testSearch(expected, lastArg, versionNameArgString, testInstanceNameArgString, testDefinitionNameArgString, testInstanceIdArgString, testbedCategoryArgString, testbedGeniNameArgString, testbedNameArgString, testbedUrnArgString, summaryArgString, enabledArg, disabledArg, expiredArg, cancelledExcludedArg, cancelledIncludedArg, fromArg, tillArg, false);
    }

    @Test
    public void search16() throws Exception {
        String versionNameArgString = null;
        String testInstanceNameArgString = null;
        String testDefinitionNameArgString = null;
        String testInstanceIdArgString = null;
        String testbedCategoryArgString = null;
        String testbedGeniNameArgString = null;
        String testbedNameArgString = null;
        String testbedUrnArgString = "urn:publicid:IDN+b.example.com+authority+cm,urn:publicid:IDN+a.example.com+authority+cm";
        Boolean enabledArg = null;
        Boolean disabledArg = null;
        Boolean expiredArg = null;
        String lastArg = "";
        String summaryArgString = null;
        Boolean cancelledExcludedArg = null;
        Boolean cancelledIncludedArg = null;
        Date fromArg = null;
        Date tillArg = null;
        List<Result> expected = resultTestCollection.getLastByTestInstanceIds(9, 10, 11, 12);
        this.testSearch(expected, lastArg, versionNameArgString, testInstanceNameArgString, testDefinitionNameArgString, testInstanceIdArgString, testbedCategoryArgString, testbedGeniNameArgString, testbedNameArgString, testbedUrnArgString, summaryArgString, enabledArg, disabledArg, expiredArg, cancelledExcludedArg, cancelledIncludedArg, fromArg, tillArg, false);
    }

    @Test
    public void search17() throws Exception {
        String versionNameArgString = null;
        String testInstanceNameArgString = null;
        String testDefinitionNameArgString = null;
        String testInstanceIdArgString = null;
        String testbedCategoryArgString = null;
        String testbedGeniNameArgString = null;
        String testbedNameArgString = null;
        String testbedUrnArgString = null;
        Boolean enabledArg = null;
        Boolean disabledArg = null;
        Boolean expiredArg = null;
        String lastArg = "";
        String summaryArgString = null;
        Boolean cancelledExcludedArg = true;
        Boolean cancelledIncludedArg = null;
        Date fromArg = null;
        Date tillArg = null;
        List expected = resultTestCollection.getByIds(new Long[]{1L, 2L, 3L, 7L});
        this.testSearch(expected, lastArg, versionNameArgString, testInstanceNameArgString, testDefinitionNameArgString, testInstanceIdArgString, testbedCategoryArgString, testbedGeniNameArgString, testbedNameArgString, testbedUrnArgString, summaryArgString, enabledArg, disabledArg, expiredArg, cancelledExcludedArg, cancelledIncludedArg, fromArg, tillArg, false);
    }

    @Test
    public void search18a() throws Exception {
        String versionNameArgString = null;
        String testInstanceNameArgString = null;
        String testDefinitionNameArgString = null;
        String testInstanceIdArgString = "12";
        String testbedCategoryArgString = null;
        String testbedGeniNameArgString = null;
        String testbedNameArgString = null;
        String testbedUrnArgString = null;
        Boolean enabledArg = null;
        Boolean disabledArg = null;
        Boolean expiredArg = null;
        String lastArg = "";
        String summaryArgString = "SUCCESS,FAILURE";
        Boolean cancelledExcludedArg = null;
        Boolean cancelledIncludedArg = null;
        Date fromArg = null;
        Date tillArg = null;
        List expected = resultTestCollection.getByIds(new Long[]{7L});
        this.testSearch(expected, lastArg, versionNameArgString, testInstanceNameArgString, testDefinitionNameArgString, testInstanceIdArgString, testbedCategoryArgString, testbedGeniNameArgString, testbedNameArgString, testbedUrnArgString, summaryArgString, enabledArg, disabledArg, expiredArg, cancelledExcludedArg, cancelledIncludedArg, fromArg, tillArg, false);
    }

    @Test
    public void search18b() throws Exception {
        String versionNameArgString = null;
        String testInstanceNameArgString = null;
        String testDefinitionNameArgString = null;
        String testInstanceIdArgString = "12";
        String testbedCategoryArgString = null;
        String testbedGeniNameArgString = null;
        String testbedNameArgString = null;
        String testbedUrnArgString = null;
        Boolean enabledArg = null;
        Boolean disabledArg = null;
        Boolean expiredArg = null;
        String lastArg = "";
        String summaryArgString = "FAILURE";
        Boolean cancelledExcludedArg = null;
        Boolean cancelledIncludedArg = null;
        Date fromArg = null;
        Date tillArg = null;
        List expected = resultTestCollection.getByIds(new Long[]{5L});
        this.testSearch(expected, lastArg, versionNameArgString, testInstanceNameArgString, testDefinitionNameArgString, testInstanceIdArgString, testbedCategoryArgString, testbedGeniNameArgString, testbedNameArgString, testbedUrnArgString, summaryArgString, enabledArg, disabledArg, expiredArg, cancelledExcludedArg, cancelledIncludedArg, fromArg, tillArg, false);
    }

    @Test
    public void search18c() throws Exception {
        String versionNameArgString = null;
        String testInstanceNameArgString = null;
        String testDefinitionNameArgString = null;
        String testInstanceIdArgString = "12";
        String testbedCategoryArgString = null;
        String testbedGeniNameArgString = null;
        String testbedNameArgString = null;
        String testbedUrnArgString = null;
        Boolean enabledArg = null;
        Boolean disabledArg = null;
        Boolean expiredArg = null;
        String lastArg = "";
        String summaryArgString = "WARNING,FAILURE";
        Boolean cancelledExcludedArg = null;
        Boolean cancelledIncludedArg = null;
        Date fromArg = null;
        Date tillArg = null;
        List expected = resultTestCollection.getByIds(new Long[]{6L});
        this.testSearch(expected, lastArg, versionNameArgString, testInstanceNameArgString, testDefinitionNameArgString, testInstanceIdArgString, testbedCategoryArgString, testbedGeniNameArgString, testbedNameArgString, testbedUrnArgString, summaryArgString, enabledArg, disabledArg, expiredArg, cancelledExcludedArg, cancelledIncludedArg, fromArg, tillArg, false);
    }

    @Test
    public void search18dFail() throws Exception {
        String versionNameArgString = null;
        String testInstanceNameArgString = null;
        String testDefinitionNameArgString = null;
        String testInstanceIdArgString = "12";
        String testbedCategoryArgString = null;
        String testbedGeniNameArgString = null;
        String testbedNameArgString = null;
        String testbedUrnArgString = null;
        Boolean enabledArg = null;
        Boolean disabledArg = null;
        Boolean expiredArg = null;
        String lastArg = "";
        String summaryArgString = "BADSUMMARY";
        Boolean cancelledExcludedArg = null;
        Boolean cancelledIncludedArg = null;
        Date fromArg = null;
        Date tillArg = null;
        try {
            List<Result> actual = this.doSearch(lastArg, versionNameArgString, testInstanceNameArgString, testDefinitionNameArgString, testInstanceIdArgString, testbedCategoryArgString, testbedGeniNameArgString, testbedNameArgString, testbedUrnArgString, summaryArgString, enabledArg, disabledArg, expiredArg, cancelledExcludedArg, cancelledIncludedArg, fromArg, tillArg, false);
            throw new RuntimeException("call did not fail as expected");
        }
        catch (BadRequestException e) {
            System.out.println("Got exception as expected:");
            e.printStackTrace(System.out);
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"HTTP 400 Bad Request"));
            String responseContent = IOUtils.streamToString((InputStream)((InputStream)e.getResponse().getEntity()), (Charset)StandardCharsets.UTF_8);
            System.out.println("Exception response content:" + responseContent);
            MatcherAssert.assertThat((Object)responseContent, (Matcher)Matchers.containsString((String)"illegal value in summary"));
            return;
        }
    }
}

