/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.test;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.AdvertisementCounts;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.MaintenanceInfo;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Result;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ServerGlimpse;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ServerGlimpseBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.ResultTestCollection;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.ServerTestCollection;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.TestClock;
import be.iminds.ilabt.jfed.util.common.RFC3339Util;
import be.iminds.ilabt.util.jsonld.test.BasicObjectTestCollection;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;

public class ServerGlimpseTestCollection
extends BasicObjectTestCollection<ServerGlimpse, ServerGlimpseBuilder> {
    final ServerTestCollection serverTestCollection = new ServerTestCollection();
    final ResultTestCollection resultTestCollection = new ResultTestCollection(true);

    public ServerGlimpseTestCollection() {
        super(ServerGlimpse.class, ServerGlimpseBuilder.class);
        ResultTestCollection resultTestCollection = new ResultTestCollection(true);
        Server serverA = (Server)this.serverTestCollection.getById(99);
        Result resultA = (Result)resultTestCollection.getByIndex(0);
        Result resultA2 = (Result)resultTestCollection.getByIndex(1);
        Result resultB = (Result)resultTestCollection.getByIndex(2);
        Result resultB2 = (Result)resultTestCollection.getByIndex(3);
        ServerGlimpseBuilder builder = new ServerGlimpseBuilder();
        builder.setServer(serverA);
        builder.setAdvertisementResult(resultA);
        builder.addComponentManagerId(serverA.getDefaultComponentManagerUrn());
        builder.addAvailableComponentId("urn:publicid:IDN+a.example.com+node+available1");
        builder.addAvailableComponentId("urn:publicid:IDN+a.example.com+node+available2");
        builder.addUnavailableComponentId("urn:publicid:IDN+a.example.com+node+used");
        builder.setHardwareTypesForComponent("urn:publicid:IDN+a.example.com+node+available1", Arrays.asList("hw1"));
        builder.setHardwareTypesForComponent("urn:publicid:IDN+a.example.com+node+available2", Collections.emptyList());
        builder.setHardwareTypesForComponent("urn:publicid:IDN+a.example.com+node+used", Arrays.asList("hw1", "hw2"));
        builder.addNoSliverHardwareType("ipv4");
        builder.mergeSliverTypeInfo("raw-pc", Arrays.asList("pcA", "pcB"), null, "urn:publicid:IDN+a.example.com+image+img2");
        builder.mergeSliverTypeInfo("shared-vm", Arrays.asList("vmB"), null, "urn:publicid:IDN+a.example.com+image+img5");
        builder.mergeDiskImage("urn:publicid:IDN+a.example.com+image+img2", "http://a.example.com/image/2", "desc2", "ver2", "os2", "raw-pc");
        builder.mergeDiskImage("urn:publicid:IDN+a.example.com+image+img2", "http://a.example.com/image/2", "desc2", "ver2", "os2", Arrays.asList("raw-pc2", "raw-pc3"));
        builder.mergeDiskImage("urn:publicid:IDN+a.example.com+image+img5", "http://a.example.com/image/5", "desc5", "ver5", "os5", Arrays.asList("shared-vm"));
        builder.setCount(AdvertisementCounts.CountedObject.RAW_PC, Integer.valueOf(20), Integer.valueOf(2));
        builder.setCount(AdvertisementCounts.CountedObject.IPV4, Integer.valueOf(510), Integer.valueOf(509));
        builder.setCount(AdvertisementCounts.CountedObject.VM, Integer.valueOf(100), Integer.valueOf(1));
        builder.setCount(AdvertisementCounts.CountedObject.OPENFLOW, Integer.valueOf(0), Integer.valueOf(0));
        builder.setCount(AdvertisementCounts.CountedObject.ANY, AdvertisementCounts.CountScope.ALL, Integer.valueOf(20));
        builder.setCount(AdvertisementCounts.CountedObject.ANY, AdvertisementCounts.CountScope.AVAILABLE, Integer.valueOf(2));
        builder.setHwCount("pcgen1", AdvertisementCounts.CountScope.AVAILABLE, Integer.valueOf(2));
        builder.setHwCount("pcgen1", AdvertisementCounts.CountScope.ALL, Integer.valueOf(4));
        builder.setHealth(Integer.valueOf(100));
        builder.setHealthExplanation("test1");
        builder.setHealthExplanationFull("Just a 1st test.");
        builder.setHealthResult(resultA2);
        builder.setHealthStatus("SUCCESS");
        builder.setHealthTimestamp(TestClock.get().getOffsetSeconds(1L));
        builder.setReputation(null);
        builder.setMaintenance(null);
        try {
            builder.setRspec(new URI("http://example.com/rspecs/99/advertisement.rspec"));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("should not occur", e);
        }
        builder.setAdvertisementTimestamp(TestClock.get().getBase());
        this.all.add(builder);
        Server serverB = (Server)this.serverTestCollection.getById(100);
        builder = new ServerGlimpseBuilder();
        builder.setServer(serverB);
        builder.setAdvertisementResult(resultB);
        builder.addComponentManagerId(serverB.getDefaultComponentManagerUrn());
        builder.addAvailableComponentId("urn:publicid:IDN+b.example.com+node+available");
        builder.addUnavailableComponentId("urn:publicid:IDN+b.example.com+node+used1");
        builder.addUnavailableComponentId("urn:publicid:IDN+b.example.com+node+used2");
        builder.setHardwareTypesForComponent("urn:publicid:IDN+b.example.com+node+available", Arrays.asList("hw1b", "hw2b"));
        builder.setHardwareTypesForComponent("urn:publicid:IDN+b.example.com+node+used1", Arrays.asList("hw3b"));
        builder.mergeSliverTypeInfo("raw-pc", Arrays.asList("pc"), Arrays.asList("banana", "vanilla"), "urn:publicid:IDN+b.example.com+image+img1");
        builder.mergeDiskImage("urn:publicid:IDN+b.example.com+image+img1", "http://b.example.com/image/1", "desc1", "ver1", "os1", "raw-pcEXTRA");
        try {
            builder.setRspec(new URI("http://example.com/rspecs/100/advertisement.rspec"));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("should not occur", e);
        }
        builder.setAdvertisementTimestamp(TestClock.get().getOffsetSeconds(10L));
        builder.setHealth(Integer.valueOf(0));
        builder.setHealthExplanation("test2");
        builder.setHealthExplanationFull("Just a 2nd test.");
        builder.setHealthResult(resultB2);
        builder.setHealthStatus("FAILURE");
        builder.setHealthTimestamp(TestClock.get().getOffsetSeconds(11L));
        builder.setReputation(Integer.valueOf(10));
        try {
            builder.addMaintenance(new MaintenanceInfo(new Timestamp(RFC3339Util.rfc3339StringToDate((String)"2030-02-18T11:00:00Z").getTime()), new Timestamp(RFC3339Util.rfc3339StringToDate((String)"2030-02-20T12:00:11Z").getTime()), new Timestamp(RFC3339Util.rfc3339StringToDate((String)"2030-02-20T13:15:30Z").getTime()), "Test Maintenance message", Boolean.valueOf(true)));
            builder.addMaintenance(new MaintenanceInfo(null, new Timestamp(RFC3339Util.rfc3339StringToDate((String)"2030-02-21T12:00:11Z").getTime()), new Timestamp(RFC3339Util.rfc3339StringToDate((String)"2030-02-21T13:15:30Z").getTime()), "Second test Maintenance message", null));
        }
        catch (ParseException e) {
            throw new RuntimeException("Implementation error", e);
        }
        this.all.add(builder);
    }

    public void assertSameDetails(ServerGlimpse actual, ServerGlimpse expected) {
        MatcherAssert.assertThat((String)"advertisementInfo == null differs", (Object)(actual.getAdvertisementInfo() == null ? 1 : 0), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)(expected.getAdvertisementInfo() == null ? 1 : 0))));
        MatcherAssert.assertThat((String)"healthInfo == null differs", (Object)(actual.getHealthInfo() == null ? 1 : 0), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)(expected.getHealthInfo() == null ? 1 : 0))));
        MatcherAssert.assertThat((String)"maintenance == null differs", (Object)(actual.getMaintenance() == null ? 1 : 0), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)(expected.getMaintenance() == null ? 1 : 0))));
        if (actual.getAdvertisementInfo() != null) {
            ServerGlimpse.AdvertisementInfo actualAdvertisementInfo = actual.getAdvertisementInfo();
            ServerGlimpse.AdvertisementInfo expectedAdvertisementInfo = expected.getAdvertisementInfo();
            MatcherAssert.assertThat((Object)actualAdvertisementInfo.getComponentManagerIds(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expectedAdvertisementInfo.getComponentManagerIds())));
            MatcherAssert.assertThat((Object)actualAdvertisementInfo.getComponentDetails(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expectedAdvertisementInfo.getComponentDetails())));
            MatcherAssert.assertThat((Object)actualAdvertisementInfo.getAvailableComponentIds(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expectedAdvertisementInfo.getAvailableComponentIds())));
            MatcherAssert.assertThat((Object)actualAdvertisementInfo.getUnavailableComponentIds(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expectedAdvertisementInfo.getUnavailableComponentIds())));
            MatcherAssert.assertThat((String)"diskImages differ", (Object)actualAdvertisementInfo.getDiskImages(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expectedAdvertisementInfo.getDiskImages())));
            if (expectedAdvertisementInfo.getSliverTypeInfo() != null) {
                MatcherAssert.assertThat((String)"sliverTypeInfo should not be null", (Object)actualAdvertisementInfo.getSliverTypeInfo(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
                MatcherAssert.assertThat((String)"sliverTypeInfo count differs", (Object)actualAdvertisementInfo.getSliverTypeInfo(), (Matcher)Matchers.hasSize((Matcher)Matchers.equalTo((Object)expectedAdvertisementInfo.getSliverTypeInfo().size())));
            }
            MatcherAssert.assertThat((String)"sliverTypeInfo differs", (Object)actualAdvertisementInfo.getSliverTypeInfo(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expectedAdvertisementInfo.getSliverTypeInfo())));
            MatcherAssert.assertThat((Object)actualAdvertisementInfo.getTimestamp(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expectedAdvertisementInfo.getTimestamp())));
            MatcherAssert.assertThat((Object)actualAdvertisementInfo.getRspec(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expectedAdvertisementInfo.getRspec())));
            MatcherAssert.assertThat((Object)actualAdvertisementInfo.getCounts(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expectedAdvertisementInfo.getCounts())));
            MatcherAssert.assertThat((Object)actualAdvertisementInfo.getHwCounts(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expectedAdvertisementInfo.getHwCounts())));
        }
        if (actual.getHealthInfo() != null) {
            ServerGlimpse.HealthInfo actualHealthInfo = actual.getHealthInfo();
            ServerGlimpse.HealthInfo expectedHealthInfo = expected.getHealthInfo();
            MatcherAssert.assertThat((Object)actualHealthInfo.getHealth(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expectedHealthInfo.getHealth())));
            MatcherAssert.assertThat((Object)actualHealthInfo.getHealthExplanation(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expectedHealthInfo.getHealthExplanation())));
            MatcherAssert.assertThat((Object)actualHealthInfo.getHealthExplanationFull(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expectedHealthInfo.getHealthExplanationFull())));
            MatcherAssert.assertThat((Object)actualHealthInfo.getTimestamp(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expectedHealthInfo.getTimestamp())));
            MatcherAssert.assertThat((Object)actualHealthInfo.getStatus(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expectedHealthInfo.getStatus())));
        }
        MatcherAssert.assertThat((Object)actual.getReputation(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expected.getReputation())));
        MatcherAssert.assertThat((Object)actual.getMaintenance(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expected.getMaintenance())));
    }

    public ServerGlimpse getByServerId(Integer serverId) {
        for (ServerGlimpseBuilder b : this.all) {
            if (b.getServerId() == null || !Objects.equals(b.getServerId(), serverId)) continue;
            return b.create();
        }
        return null;
    }

    public static ServerGlimpse getByServerId(Collection<ServerGlimpse> list, Integer serverId) {
        for (ServerGlimpse b : list) {
            if (b.getServerId() == null || !Objects.equals(b.getServerId(), serverId)) continue;
            return b;
        }
        return null;
    }

    public ServerGlimpse createExtra(boolean includeAdvertisement, boolean includeHealth, boolean includeReputation, boolean includeMaintenance) {
        Server server = (Server)this.serverTestCollection.getById(100);
        String tld = server.getUrnTld();
        Result resultC = (Result)this.resultTestCollection.getByIndex(4);
        Result resultD = (Result)this.resultTestCollection.getByIndex(5);
        assert (resultC != null);
        assert (resultD != null);
        ServerGlimpseBuilder builder = new ServerGlimpseBuilder();
        builder = new ServerGlimpseBuilder();
        builder.setServer(server);
        if (includeAdvertisement) {
            builder.setAdvertisementResult(resultC);
            builder.addComponentManagerId(server.getDefaultComponentManagerUrn());
            builder.addComponentDetails(new ServerGlimpse.AdvertisementInfo.ComponentDetails("urn:publicid:IDN+" + tld + "+node+available1", Arrays.asList("ehw1"), Boolean.valueOf(true)));
            builder.addComponentDetails(new ServerGlimpse.AdvertisementInfo.ComponentDetails("urn:publicid:IDN+" + tld + "+node+available2", Arrays.asList("ehw1", "ehw2"), Boolean.valueOf(true)));
            builder.addComponentDetails(new ServerGlimpse.AdvertisementInfo.ComponentDetails("urn:publicid:IDN+" + tld + "+node+available3", Arrays.asList(new String[0]), Boolean.valueOf(true)));
            builder.addComponentDetails(new ServerGlimpse.AdvertisementInfo.ComponentDetails("urn:publicid:IDN+" + tld + "+node+used1", Arrays.asList("ehw1b"), Boolean.valueOf(false)));
            builder.addComponentDetails(new ServerGlimpse.AdvertisementInfo.ComponentDetails("urn:publicid:IDN+" + tld + "+node+used2", Arrays.asList("ehw1b", "ehw2b", "ehw3b"), Boolean.valueOf(false)));
            builder.addComponentDetails(new ServerGlimpse.AdvertisementInfo.ComponentDetails("urn:publicid:IDN+" + tld + "+node+used3", null, Boolean.valueOf(false)));
            builder.addNoSliverHardwareType("specialEXTRA");
            builder.mergeSliverTypeInfo("raw-pcEXTRA", Arrays.asList("pcExtra"), null, "di1");
            builder.mergeDiskImage("urn:publicid:IDN+" + tld + "+image+img10", "http://" + tld + "/image/10", "desc10", "ver10", "os10", "raw-pcEXTRA");
            builder.mergeDiskImage("urn:publicid:IDN+" + tld + "+image+img20", "http://" + tld + "/image/20", "desc20", "ver20", "os20", Arrays.asList("raw-pcEXTRA"));
            builder.setCount(AdvertisementCounts.CountedObject.RAW_PC, Integer.valueOf(10), Integer.valueOf(5));
            builder.setCount(AdvertisementCounts.CountedObject.ANY, Integer.valueOf(10), Integer.valueOf(5));
            builder.setHwCount("pcgen2", AdvertisementCounts.CountScope.AVAILABLE, Integer.valueOf(5));
            builder.setHwCount("pcgen2", AdvertisementCounts.CountScope.ALL, Integer.valueOf(10));
            try {
                builder.setRspec(new URI("http://example.com/rspecs/" + server.getId() + "/advertisementEXTRA.rspec"));
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("should not occur", e);
            }
            builder.setAdvertisementTimestamp(TestClock.get().getOffsetSeconds(20L));
        }
        if (includeHealth) {
            builder.setHealth(Integer.valueOf(99));
            builder.setHealthExplanation("test");
            builder.setHealthExplanationFull("Just a test.");
            builder.setHealthResult(resultD);
            builder.setHealthStatus("WARNING");
            builder.setHealthTimestamp(TestClock.get().getOffsetSeconds(22L));
        }
        if (includeReputation) {
            builder.setReputation(Integer.valueOf(5));
        }
        if (includeMaintenance) {
            builder.addMaintenance(new MaintenanceInfo(TestClock.get().getOffsetMinutes(-60L), TestClock.get().getOffsetMinutes(30L), TestClock.get().getOffsetMinutes(40L), "Maintenance message of created Glimpse", Boolean.valueOf(false)));
        }
        return builder.create();
    }
}

