/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.test;

import be.iminds.ilabt.jfed.fedmon.util.Clock;
import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonWebApiServiceApplication;
import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonWebApiServiceConfiguration;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Location;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ServerBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Service;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ServiceBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Testbed;
import be.iminds.ilabt.jfed.fedmon.webapi.service.resource.SearchUriGenerator;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.FedmonTestPostgresDB;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.LinkedTestbedDataTestCollection;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.ServerTestCollection;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.TestbedTestCollection;
import be.iminds.ilabt.util.jsonld.JsonLdObjectsMetaData;
import be.iminds.ilabt.util.jsonld.UriTool;
import be.iminds.ilabt.util.jsonld.iface.JsonLdObjectWithId;
import io.dropwizard.testing.ConfigOverride;
import io.dropwizard.testing.junit.DropwizardAppRule;
import java.util.Arrays;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import org.glassfish.jersey.client.JerseyClientBuilder;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerIntegrationTest {
    private static final Logger LOG = LoggerFactory.getLogger(ServerIntegrationTest.class);
    @ClassRule
    public static final DropwizardAppRule<FedmonWebApiServiceConfiguration> RULE = new DropwizardAppRule(FedmonWebApiServiceApplication.class, "../fedmon-webapi-service-TESTING.yml", new ConfigOverride[0]);
    private static JsonLdObjectsMetaData jsonLdObjectsMetaData;
    private static TestbedTestCollection testbedTestCollection;
    private static ServerTestCollection serverTestCollection;
    private static LinkedTestbedDataTestCollection linkedTestbedDataTestCollection;
    private static FedmonTestPostgresDB testPostgresDB;
    Client client;

    @BeforeClass
    public static void setUp() throws Exception {
        ServerIntegrationTest.setUp(RULE);
    }

    public static void setUp(DropwizardAppRule<FedmonWebApiServiceConfiguration> RULE) throws Exception {
        jsonLdObjectsMetaData = JsonLdObjectsMetaData.getInstance((String)Testbed.class.getPackage().getName());
        testPostgresDB = new FedmonTestPostgresDB(RULE);
        testPostgresDB.recreateDB();
        testbedTestCollection = new TestbedTestCollection();
        serverTestCollection = new ServerTestCollection();
        linkedTestbedDataTestCollection = new LinkedTestbedDataTestCollection(false, -1, null);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        Clock.reset();
        assert (testPostgresDB != null);
        testPostgresDB.close();
        testPostgresDB = null;
    }

    @Before
    public void initClient() throws Exception {
        assert (RULE.getConfiguration() != null);
        assert (jsonLdObjectsMetaData != null);
        this.client = new JerseyClientBuilder().build();
        assert (this.client != null);
        assert (testPostgresDB != null);
        testPostgresDB.refillDB();
    }

    public Server createServersCall(Server server) throws Exception {
        WebTarget w = this.client.target(String.format("http://localhost:%d/server/", RULE.getLocalPort()));
        Entity entity = Entity.entity((Object)server, (MediaType)MediaType.APPLICATION_JSON_TYPE);
        Server res = (Server)w.request().post(entity, Server.class);
        return res;
    }

    public void deleteServerCall(Integer id) throws Exception {
        this.client.target(String.format("http://localhost:%d/server/%d", RULE.getLocalPort(), id)).request().delete();
    }

    public Server updateServerCall(Server updatedServer) throws Exception {
        assert (updatedServer != null);
        assert (updatedServer.getId() != null);
        assert (updatedServer.getTestbedId() != null);
        if (updatedServer.getTestbed() != null && !updatedServer.getTestbed().getServers().isEmpty()) {
            ServerBuilder s = new ServerBuilder(updatedServer);
            updatedServer = s.createMinimized(JsonLdObjectsMetaData.Minimization.FULL_WITH_MINIMAL_LINK_IDS);
        }
        Server res = (Server)this.client.target(String.format("http://localhost:%d/server/%d/", RULE.getLocalPort(), updatedServer.getId())).request().put(Entity.entity((Object)updatedServer, (MediaType)MediaType.APPLICATION_JSON_TYPE), Server.class);
        return res;
    }

    @Test
    public void testInsert() throws Exception {
        Testbed testbedA = (Testbed)testbedTestCollection.getByIndex(0);
        Server newServer = new ServerBuilder().setTestbed(testbedA).setAllowedCertificateAlias("certAliasNew").setCertificateChain("NewChain").setBaseUrl("http://new.example.com/").setUrnTld("new.example.com").setFlags(Arrays.asList("workaroundMustReconnectEachCall", "featureStitching")).setLocation(new Location("BE", Double.valueOf(0.2), Double.valueOf(0.3), "no address")).setName("New Server for test").setServerType("new").setDefaultScs(null).setDefaultUserAuth(null).setScs(null).setUserAuth(null).create();
        Server actualCreatedServer = this.createServersCall(newServer);
        System.out.println("Got inserted server: " + actualCreatedServer);
        System.out.flush();
        MatcherAssert.assertThat((String)"id of created server is null", (Object)((Integer)actualCreatedServer.getId()), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        Server expectedServer = ((ServerBuilder)new ServerBuilder(newServer).setId((Object)((Integer)actualCreatedServer.getId()))).create();
        MatcherAssert.assertThat((String)"URI of created server is null", (Object)actualCreatedServer.getUri(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        serverTestCollection.assertSameAndExpectActualHasUri((JsonLdObjectWithId)actualCreatedServer, (JsonLdObjectWithId)expectedServer, true);
        MatcherAssert.assertThat((Object)actualCreatedServer.getTestbed(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)((String)actualCreatedServer.getTestbed().getId()), (Matcher)Matchers.is((Object)((String)testbedA.getId())));
        Server lookedUpServer = this.doLookup((Integer)actualCreatedServer.getId());
        serverTestCollection.assertSameAndExpectActualHasUri((JsonLdObjectWithId)lookedUpServer, (JsonLdObjectWithId)expectedServer, true);
        MatcherAssert.assertThat((Object)lookedUpServer.getTestbed(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)((String)lookedUpServer.getTestbed().getId()), (Matcher)Matchers.is((Object)((String)testbedA.getId())));
    }

    @Test
    public void testInsertWithServices() throws Exception {
        assert (jsonLdObjectsMetaData != null);
        UriTool uriTool = jsonLdObjectsMetaData.makeUriTool("http://localhost:9000", (UriTool.DerivedUriGenerator)new SearchUriGenerator());
        assert (uriTool != null);
        testbedTestCollection.setUri(0, uriTool);
        Testbed testbedA = (Testbed)testbedTestCollection.getByIndex(0);
        ServiceBuilder newServiceA = new ServiceBuilder().setApi("Geni.AM").setApiVersion("3").setUrl("http://new.example.com/am/3/").setUrn("urn:publicid:IDN+new.example.com+authority+cm");
        ServiceBuilder newServiceB = new ServiceBuilder().setApi("Geni.SA").setApiVersion("2").setUrl("http://new.example.com/geni/sa/2/").setUrn("urn:publicid:IDN+new.example.com+authority+sa");
        Server newServer = new ServerBuilder().setTestbed(testbedA).setAllowedCertificateAlias("certAliasNew").setCertificateChain("NewChain").setBaseUrl("http://new.example.com/").setUrnTld("new.example.com").setFlags(Arrays.asList("workaroundMustReconnectEachCall", "featureStitching")).setLocation(new Location("BE", Double.valueOf(0.2), Double.valueOf(0.3), "no address")).setName("New Server for test").setServerType("new").setDefaultScs(null).setDefaultUserAuth(null).setScs(null).setUserAuth(null).setDefaultAMService(null).setServices(Arrays.asList(newServiceA.create(), newServiceB.create())).createMinimized(JsonLdObjectsMetaData.Minimization.FULL_EMBED_CHILDREN_LINK_PARENT);
        assert (JsonLdObjectsMetaData.Minimization.FULL_EMBED_CHILDREN_LINK_PARENT.serializeAsEmbeddedObject());
        assert (!JsonLdObjectsMetaData.Minimization.FULL_EMBED_CHILDREN_LINK_PARENT.getParentMinimization().serializeAsEmbeddedObject());
        assert (JsonLdObjectsMetaData.Minimization.FULL_EMBED_CHILDREN_LINK_PARENT.getChildrenMinimization().serializeAsEmbeddedObject());
        System.out.println("testInsertWithServices is creating server: " + newServer);
        Server actualCreatedServer = this.createServersCall(newServer);
        System.out.println("Got inserted server: " + actualCreatedServer);
        System.out.flush();
        MatcherAssert.assertThat((String)"id of created server is null", (Object)((Integer)actualCreatedServer.getId()), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        Server expectedServer = ((ServerBuilder)new ServerBuilder(newServer).setId((Object)((Integer)actualCreatedServer.getId()))).create();
        MatcherAssert.assertThat((String)"URI of created server is null", (Object)actualCreatedServer.getUri(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        serverTestCollection.assertSameAndExpectActualHasUri((JsonLdObjectWithId)actualCreatedServer, (JsonLdObjectWithId)expectedServer, true);
        MatcherAssert.assertThat((Object)actualCreatedServer.getTestbed(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)((String)actualCreatedServer.getTestbed().getId()), (Matcher)Matchers.is((Object)((String)testbedA.getId())));
        MatcherAssert.assertThat((Object)actualCreatedServer.getServices(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)actualCreatedServer.getServices().size(), (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat((Object)((Integer)((Service)actualCreatedServer.getServices().get(0)).getId()), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        Server lookedUpServer = this.doLookup((Integer)actualCreatedServer.getId());
        serverTestCollection.assertSameAndExpectActualHasUri((JsonLdObjectWithId)lookedUpServer, (JsonLdObjectWithId)expectedServer, true);
        MatcherAssert.assertThat((Object)lookedUpServer.getTestbed(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)((String)lookedUpServer.getTestbed().getId()), (Matcher)Matchers.is((Object)((String)testbedA.getId())));
    }

    @Test
    public void testUpdate() throws Exception {
        Server origServer = linkedTestbedDataTestCollection.getServerByIndex(0);
        MatcherAssert.assertThat((Object)origServer.getTestbed(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)origServer.getTestbedId(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        Server updatedCallServer = new ServerBuilder(origServer).setAllowedCertificateAlias("certAliasNew").setCertificateChain("NewChain").setBaseUrl("http://new.example.com/").setUrnTld("new.example.com").setFlags(Arrays.asList("workaroundMustReconnectEachCall", "featureStitching")).setLocation(new Location("BE", Double.valueOf(0.2), Double.valueOf(0.3), "no address")).setName("New Server for test").setServerType("new").setDefaultScs(null).setDefaultUserAuth(null).setScs(null).setUserAuth(null).setServices(null).create();
        MatcherAssert.assertThat((Object)updatedCallServer.getTestbed(), (Matcher)Matchers.is((Object)origServer.getTestbed()));
        MatcherAssert.assertThat((Object)updatedCallServer.getTestbed(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)updatedCallServer.getTestbedId(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)updatedCallServer.getServices(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        Server actualUpdatedServer = this.updateServerCall(updatedCallServer);
        System.out.println("Got updated server: " + actualUpdatedServer);
        System.out.flush();
        MatcherAssert.assertThat((String)"id of updated server is null", (Object)((Integer)actualUpdatedServer.getId()), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        Server expectedServer = ((ServerBuilder)new ServerBuilder(updatedCallServer).setId((Object)((Integer)actualUpdatedServer.getId()))).setServices(origServer.getServices()).create();
        MatcherAssert.assertThat((String)"URI of updated server is null", (Object)actualUpdatedServer.getUri(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        serverTestCollection.assertSameAndExpectActualHasUri((JsonLdObjectWithId)actualUpdatedServer, (JsonLdObjectWithId)expectedServer, true);
        if (origServer.getTestbed() != null) {
            MatcherAssert.assertThat((Object)actualUpdatedServer.getTestbed(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        }
        MatcherAssert.assertThat((Object)((String)actualUpdatedServer.getTestbed().getId()), (Matcher)Matchers.is((Object)((String)origServer.getTestbed().getId())));
        Server lookedUpServer = this.doLookup((Integer)actualUpdatedServer.getId());
        serverTestCollection.assertSameAndExpectActualHasUri((JsonLdObjectWithId)lookedUpServer, (JsonLdObjectWithId)expectedServer, true);
        MatcherAssert.assertThat((Object)((String)lookedUpServer.getTestbed().getId()), (Matcher)Matchers.is((Object)((String)origServer.getTestbed().getId())));
    }

    public void testLookup(Server expected, Integer id) throws Exception {
        Server actual = this.doLookup(id);
        this.checkLookup(expected, actual);
    }

    public Server doLookup(Integer id) throws Exception {
        assert (this.client != null);
        WebTarget query = this.client.target(String.format("http://localhost:%d/server/" + id, RULE.getLocalPort()));
        Server actual = (Server)query.request().get(Server.class);
        System.out.println("Got server: " + actual);
        return actual;
    }

    public void checkLookup(Server expected, Server actual) {
        System.out.println("Expecting server: " + expected);
        serverTestCollection.assertSameAndExpectActualHasUri((JsonLdObjectWithId)actual, (JsonLdObjectWithId)expected, true);
    }

    @Test
    public void lookup0() throws Exception {
        Server expected = linkedTestbedDataTestCollection.getServerByIndex(0);
        this.testLookup(expected, (Integer)expected.getId());
    }

    @Test
    public void lookup1() throws Exception {
        Server expected = linkedTestbedDataTestCollection.getServerByIndex(1);
        this.testLookup(expected, (Integer)expected.getId());
    }
}

