/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.test;

import be.iminds.ilabt.jfed.fedmon.spring_helpers.CronSequenceGenerator;
import be.iminds.ilabt.jfed.fedmon.util.Clock;
import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonWebApiServiceApplication;
import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonWebApiServiceConfiguration;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Admin;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.AdminBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Frequency;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Result;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ResultBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Task;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TaskBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestInstance;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestInstanceBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestInstanceStatistics;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestInstanceStatisticsBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.User;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.UserBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.AdminTestCollection;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.FedmonTestPostgresDB;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.FrequencyTestCollection;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.ServerTestCollection;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.TaskTestCollection;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.TestClock;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.TestInstancesStatisticsTestCollection;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.TestInstancesTestCollection;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.UserTestCollection;
import be.iminds.ilabt.util.jsonld.iface.JsonLdObjectWithId;
import be.iminds.ilabt.util.jsonld.impl.PrimaryIdObject;
import io.dropwizard.testing.ConfigOverride;
import io.dropwizard.testing.junit.DropwizardAppRule;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.TimeZone;
import java.util.stream.Collectors;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import org.glassfish.jersey.client.JerseyClientBuilder;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskIntegrationTest {
    private static final Logger LOG = LoggerFactory.getLogger(TaskIntegrationTest.class);
    @ClassRule
    public static final DropwizardAppRule<FedmonWebApiServiceConfiguration> RULE = new DropwizardAppRule(FedmonWebApiServiceApplication.class, "../fedmon-webapi-service-TESTING.yml", new ConfigOverride[0]);
    private static UserTestCollection userTestCollection;
    private static ServerTestCollection serverTestCollection;
    private static TaskTestCollection taskTestCollection;
    private static FrequencyTestCollection frequencyTestCollection;
    private static TestInstancesTestCollection testInstancesTestCollection;
    private static TestInstancesStatisticsTestCollection testInstancesStatisticsTestCollection;
    protected static Clock.DefaultTestTimeProvider timeProvider;
    Client client;
    TestInstance expectedCreateTaskTestInstance;
    protected static final String runningLog = "runlog";
    Result createdResult;

    @BeforeClass
    public static void setUp() throws Exception {
        TaskIntegrationTest.setUp(RULE);
    }

    public static void setUp(DropwizardAppRule<FedmonWebApiServiceConfiguration> RULE) throws Exception {
        timeProvider = new Clock.DefaultTestTimeProvider();
        Clock.set((Clock.CurrentTimeProvider)timeProvider);
        Clock.lockProvider();
        FedmonTestPostgresDB testPostgresDB = new FedmonTestPostgresDB(RULE);
        testPostgresDB.recreateDB();
        testPostgresDB.close();
        userTestCollection = new UserTestCollection();
        serverTestCollection = new ServerTestCollection();
        taskTestCollection = new TaskTestCollection();
        frequencyTestCollection = new FrequencyTestCollection();
        testInstancesTestCollection = new TestInstancesTestCollection();
        testInstancesStatisticsTestCollection = new TestInstancesStatisticsTestCollection();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        Clock.reset();
    }

    @Before
    public void initClient() throws Exception {
        this.client = new JerseyClientBuilder().build();
        timeProvider.setNowOffsetMinutes(0L);
        FedmonTestPostgresDB testPostgresDB = new FedmonTestPostgresDB(RULE);
        testPostgresDB.refillDB();
        testPostgresDB.close();
    }

    public List<Task> createTasksCall(Integer maxCount, String runInfo, String testDefName, Integer testInstanceId, String testVersionName) throws Exception {
        WebTarget w = this.client.target(String.format("http://localhost:%d/task/", RULE.getLocalPort()));
        if (maxCount != null) {
            w = w.queryParam("maxCount", new Object[]{"" + maxCount});
        }
        if (runInfo != null) {
            w = w.queryParam("runInfo", new Object[]{runInfo});
        }
        if (testDefName != null) {
            w = w.queryParam("testdefinitionname", new Object[]{testDefName});
        }
        if (testInstanceId != null) {
            w = w.queryParam("testinstanceid", new Object[]{testInstanceId});
        }
        if (testVersionName != null) {
            w = w.queryParam("testversionname", new Object[]{testVersionName});
        }
        List res = (List)w.request().post(null, (GenericType)new GenericType<List<Task>>(){});
        System.out.println("Received created tasks " + res.stream().map(PrimaryIdObject::getId).collect(Collectors.toList()) + " for testinstances: " + res.stream().map(Task::getTestInstanceId).collect(Collectors.toList()));
        return res;
    }

    public User modifyUserCall(User user) throws Exception {
        WebTarget w = this.client.target(String.format("http://localhost:%d/user/%s/", RULE.getLocalPort(), user.getId()));
        User res = (User)w.request().put(Entity.entity((Object)user, (MediaType)MediaType.APPLICATION_JSON_TYPE), User.class);
        return res;
    }

    public Admin getAdminCall() throws Exception {
        WebTarget w = this.client.target(String.format("http://localhost:%d/admin/", RULE.getLocalPort()));
        return (Admin)w.request().get(Admin.class);
    }

    public void modifyAdminCall(Admin admin) throws Exception {
        WebTarget w = this.client.target(String.format("http://localhost:%d/admin/", RULE.getLocalPort()));
        w.request().put(Entity.json((Object)admin));
    }

    public TestInstance modifyTestInstanceCall(TestInstance testInstance) throws Exception {
        WebTarget w = this.client.target(String.format("http://localhost:%d/testinstance/" + testInstance.getId(), RULE.getLocalPort()));
        Entity entity = Entity.entity((Object)testInstance, (MediaType)MediaType.APPLICATION_JSON_TYPE);
        TestInstance res = (TestInstance)w.request().put(entity, TestInstance.class);
        return res;
    }

    public List<Task> createStressStestTasksCall(int count, String runInfo, int testInstanceId) throws Exception {
        WebTarget w = this.client.target(String.format("http://localhost:%d/task/", RULE.getLocalPort()));
        w = w.queryParam("stresstestCount", new Object[]{"" + count});
        w = w.queryParam("testinstanceid", new Object[]{testInstanceId});
        if (runInfo != null) {
            w = w.queryParam("runInfo", new Object[]{runInfo});
        }
        List res = (List)w.request().post(null, (GenericType)new GenericType<List<Task>>(){});
        System.out.println("Received created tasks " + res.stream().map(PrimaryIdObject::getId).collect(Collectors.toList()) + " for testinstances: " + res.stream().map(Task::getTestInstanceId).collect(Collectors.toList()));
        return res;
    }

    public void deleteTaskCall(long id) throws Exception {
        this.client.target(String.format("http://localhost:%d/task/%d", RULE.getLocalPort(), id)).request().delete();
    }

    public void updateTaskCall(Task updatedTask) throws Exception {
        this.client.target(String.format("http://localhost:%d/task/%d/", RULE.getLocalPort(), updatedTask.getId())).request().put(Entity.entity((Object)updatedTask, (MediaType)MediaType.APPLICATION_JSON_TYPE));
    }

    public Long postResultCall(Result result) throws Exception {
        Result res;
        try {
            res = (Result)this.client.target(String.format("http://localhost:%d/result", RULE.getLocalPort())).request().post(Entity.entity((Object)result, (MediaType)MediaType.APPLICATION_JSON_TYPE), Result.class);
        }
        catch (Exception e) {
            LOG.error("Exception posting result", (Throwable)e);
            return null;
        }
        if (res == null) {
            return null;
        }
        return (Long)res.getId();
    }

    public Result getResultCall(Long resultId) throws Exception {
        return (Result)this.client.target(String.format("http://localhost:%d/result/%d", RULE.getLocalPort(), resultId)).request().get(Result.class);
    }

    public Task getTaskCall(Long taskId) throws Exception {
        return (Task)this.client.target(String.format("http://localhost:%d/task/%d", RULE.getLocalPort(), taskId)).request().get(Task.class);
    }

    public TestInstance getTestInstanceCall(int testInstanceId) throws Exception {
        return (TestInstance)this.client.target(String.format("http://localhost:%d/testinstance/%d", RULE.getLocalPort(), testInstanceId)).request().get(TestInstance.class);
    }

    public TestInstanceStatistics getTestInstanceStatisticsCall(int testInstanceId) throws Exception {
        return (TestInstanceStatistics)this.client.target(String.format("http://localhost:%d/testinstancestatistics/%d", RULE.getLocalPort(), testInstanceId)).request().get(TestInstanceStatistics.class);
    }

    public void getNoTasks() throws Exception {
        timeProvider.setNowOffset(TestClock.get().getBase());
        timeProvider.relativeNowOffsetMinutes(1L);
        assert (((Task)taskTestCollection.getById(1L)).getStart().before(Clock.nowDate()));
        assert (((Task)taskTestCollection.getById(1L)).getDeadline().after(Clock.nowDate()));
        List<Task> tasks = this.createTasksCall(2, "TaskIntegrationTest run no", "ping", null, null);
        System.out.println("Got tasks: " + tasks);
        System.out.flush();
        MatcherAssert.assertThat(tasks, (Matcher)Matchers.hasSize((int)0));
    }

    public void forceRemoveRunningTask() throws Exception {
        this.deleteTaskCall(1L);
    }

    public ActualAndExpectedTask getTask() throws Exception {
        this.expectedCreateTaskTestInstance = (TestInstance)testInstancesTestCollection.getById(9);
        String runInfo = "TaskIntegrationTest run";
        List<Task> tasks = this.createTasksCall(2, runInfo, "ping", null, null);
        System.out.println("Got tasks: " + tasks);
        MatcherAssert.assertThat(tasks, (Matcher)Matchers.hasSize((int)1));
        Task createdTask = tasks.get(0);
        MatcherAssert.assertThat((String)"test instance ID differs", (Object)createdTask.getTestInstanceId(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)((Integer)this.expectedCreateTaskTestInstance.getId()))));
        MatcherAssert.assertThat((Object)((Long)createdTask.getId()), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        Task expectedCreatedTask = ((TaskBuilder)new TaskBuilder().setId((Object)((Long)createdTask.getId()))).setTestInstance((Integer)this.expectedCreateTaskTestInstance.getId()).setStart(Clock.nowTimestamp()).setDeadline(new Timestamp(Clock.currentTimeMillis() + Task.CREATED_TASK_DEADLINE_MILLIS)).setRunInfo(runInfo).setState(Task.State.CREATED).create();
        taskTestCollection.assertSameAndExpectActualHasUri((JsonLdObjectWithId)createdTask, (JsonLdObjectWithId)expectedCreatedTask, true);
        return new ActualAndExpectedTask(createdTask, expectedCreatedTask);
    }

    public List<ActualAndExpectedTask> getStressTestTasks(int count) throws Exception {
        this.expectedCreateTaskTestInstance = (TestInstance)testInstancesTestCollection.getById(9);
        String runInfo = "TaskIntegrationTest run";
        List<Task> tasks = this.createStressStestTasksCall(count, runInfo, (Integer)this.expectedCreateTaskTestInstance.getId());
        System.out.println("Got tasks: " + tasks);
        MatcherAssert.assertThat(tasks, (Matcher)Matchers.hasSize((int)count));
        ArrayList<ActualAndExpectedTask> res = new ArrayList<ActualAndExpectedTask>();
        for (Task createdTask : tasks) {
            MatcherAssert.assertThat((String)"test instance ID differs", (Object)createdTask.getTestInstanceId(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)((Integer)this.expectedCreateTaskTestInstance.getId()))));
            MatcherAssert.assertThat((Object)((Long)createdTask.getId()), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            Task expectedCreatedTask = ((TaskBuilder)new TaskBuilder().setId((Object)((Long)createdTask.getId()))).setTestInstance((Integer)this.expectedCreateTaskTestInstance.getId()).setStart(Clock.nowTimestamp()).setDeadline(new Timestamp(Clock.currentTimeMillis() + Task.STRESSTEST_CREATED_TASK_DEADLINE_MILLIS)).setRunInfo(runInfo).setState(Task.State.CREATED).create();
            taskTestCollection.assertSameAndExpectActualHasUri((JsonLdObjectWithId)createdTask, (JsonLdObjectWithId)expectedCreatedTask, true);
            res.add(new ActualAndExpectedTask(createdTask, expectedCreatedTask));
        }
        return res;
    }

    public void testTaskCreated(Task createdTask, Task expectedCreatedTask) throws Exception {
        Task actualCreatedTask = this.getTaskCall((Long)createdTask.getId());
        System.out.println("Got runningTask: " + actualCreatedTask);
        taskTestCollection.assertSameAndExpectActualHasUri((JsonLdObjectWithId)actualCreatedTask, (JsonLdObjectWithId)expectedCreatedTask, true);
    }

    public Timestamp confirmTaskRunning(Task createdTask) throws Exception {
        Timestamp updatedDeadline = new Timestamp(createdTask.getStart().getTime() + 600000L);
        Task updatedTask = ((TaskBuilder)new TaskBuilder().setId((Object)((Long)createdTask.getId()))).setTestInstance(createdTask.getTestInstanceId()).setStart(createdTask.getStart()).setDeadline(updatedDeadline).setStop(createdTask.getStop()).setLog(runningLog).setResult(null, null).setRunInfo(createdTask.getRunInfo()).setState(Task.State.RUNNING).create();
        System.out.println("Starting task run: " + updatedTask);
        this.updateTaskCall(updatedTask);
        return updatedDeadline;
    }

    public Task testTaskRunning(Task createdTask, Task expectedCreatedTask, Timestamp updatedDeadline) throws Exception {
        Task runningTask = this.getTaskCall((Long)createdTask.getId());
        System.out.println("Got runningTask: " + runningTask);
        MatcherAssert.assertThat((Object)runningTask, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)runningTask.getState(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Task.State.RUNNING)));
        MatcherAssert.assertThat((Object)((Long)runningTask.getId()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)((Long)expectedCreatedTask.getId()))));
        MatcherAssert.assertThat((Object)runningTask.getRunInfo(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expectedCreatedTask.getRunInfo())));
        MatcherAssert.assertThat((Object)runningTask.getTestInstanceId(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expectedCreatedTask.getTestInstanceId())));
        MatcherAssert.assertThat((Object)runningTask.getResultId(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)runningTask.getLog(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)runningLog)));
        MatcherAssert.assertThat((Object)runningTask.getStop(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)runningTask.getStart(), (Matcher)Matchers.is((Object)expectedCreatedTask.getStart()));
        MatcherAssert.assertThat((Object)runningTask.getDeadline(), (Matcher)Matchers.is((Object)updatedDeadline));
        MatcherAssert.assertThat((Object)runningTask.isInActiveState(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)runningTask.isExpired(), (Matcher)Matchers.is((Object)false));
        return runningTask;
    }

    public void testTaskExpired(Task preExpireTask) throws Exception {
        Task expiredTask = this.getTaskCall((Long)preExpireTask.getId());
        System.out.println("Got expiredTask: " + expiredTask);
        MatcherAssert.assertThat((Object)expiredTask, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)expiredTask.getState(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Task.State.EXPIRED)));
        MatcherAssert.assertThat((Object)((Long)expiredTask.getId()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)((Long)preExpireTask.getId()))));
        MatcherAssert.assertThat((Object)expiredTask.getRunInfo(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)preExpireTask.getRunInfo())));
        MatcherAssert.assertThat((Object)expiredTask.getTestInstanceId(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)preExpireTask.getTestInstanceId())));
        MatcherAssert.assertThat((Object)expiredTask.getResultId(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)expiredTask.getLog(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)preExpireTask.getLog())));
        MatcherAssert.assertThat((Object)expiredTask.getStop(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)preExpireTask.getDeadline())));
        MatcherAssert.assertThat((Object)expiredTask.getStart(), (Matcher)Matchers.is((Object)preExpireTask.getStart()));
        MatcherAssert.assertThat((Object)expiredTask.getDeadline(), (Matcher)Matchers.is((Object)preExpireTask.getDeadline()));
        MatcherAssert.assertThat((Object)expiredTask.isInActiveState(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)expiredTask.isExpired(), (Matcher)Matchers.is((Object)true));
    }

    public void testTaskState(Task baseTask, Task.State expectedState) throws Exception {
        Task actualTask = this.getTaskCall((Long)baseTask.getId());
        System.out.println("Got Task: " + actualTask);
        MatcherAssert.assertThat((Object)actualTask, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)actualTask.getState(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expectedState)));
        MatcherAssert.assertThat((Object)((Long)actualTask.getId()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)((Long)baseTask.getId()))));
        MatcherAssert.assertThat((Object)actualTask.getRunInfo(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)baseTask.getRunInfo())));
        MatcherAssert.assertThat((Object)actualTask.getTestInstanceId(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)baseTask.getTestInstanceId())));
        MatcherAssert.assertThat((Object)actualTask.getLog(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)baseTask.getLog())));
        MatcherAssert.assertThat((Object)actualTask.getStart(), (Matcher)Matchers.is((Object)baseTask.getStart()));
        MatcherAssert.assertThat((Object)actualTask.getDeadline(), (Matcher)Matchers.is((Object)baseTask.getDeadline()));
        switch (expectedState) {
            case CREATED: 
            case CANCELLING: 
            case RUNNING: {
                MatcherAssert.assertThat((Object)actualTask.isInActiveState(), (Matcher)Matchers.is((Object)true));
                MatcherAssert.assertThat((Object)actualTask.isExpired(), (Matcher)Matchers.is((Object)false));
                MatcherAssert.assertThat((Object)actualTask.getStop(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
                MatcherAssert.assertThat((Object)actualTask.getResultId(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
                break;
            }
            case CANCELLED: 
            case FINISHED: {
                MatcherAssert.assertThat((Object)actualTask.isInActiveState(), (Matcher)Matchers.is((Object)false));
                MatcherAssert.assertThat((Object)actualTask.isExpired(), (Matcher)Matchers.is((Object)false));
                MatcherAssert.assertThat((String)(expectedState + " Task has no stop time set"), (Object)actualTask.getStop(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
                MatcherAssert.assertThat((Object)actualTask.getStop(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)baseTask.getStop())));
                MatcherAssert.assertThat((Object)actualTask.getResultId(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)baseTask.getResultId())));
                break;
            }
            case EXPIRED: {
                MatcherAssert.assertThat((Object)actualTask.isInActiveState(), (Matcher)Matchers.is((Object)false));
                MatcherAssert.assertThat((Object)actualTask.isExpired(), (Matcher)Matchers.is((Object)true));
                MatcherAssert.assertThat((Object)actualTask.getStop(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)baseTask.getDeadline())));
                MatcherAssert.assertThat((Object)actualTask.getResultId(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
                break;
            }
            default: {
                throw new RuntimeException("Unhandled case: " + expectedState);
            }
        }
    }

    public void otherCancelTask(Task preCancelTask) throws Exception {
        Task updatedTask = ((TaskBuilder)new TaskBuilder().setId((Object)((Long)preCancelTask.getId()))).setTestInstanceId(preCancelTask.getTestInstanceId()).setStart(preCancelTask.getStart()).setDeadline(preCancelTask.getDeadline()).setStop(preCancelTask.getStop()).setLog(preCancelTask.getLog()).setResult(preCancelTask.getResultId(), null).setRunInfo(preCancelTask.getRunInfo()).setState(Task.State.CANCELLING).create();
        System.out.println("Cancelling task run: " + updatedTask);
        this.updateTaskCall(updatedTask);
    }

    public void cancelTask(Task baseTask) throws Exception {
        Task updatedTask = ((TaskBuilder)new TaskBuilder().setId((Object)((Long)baseTask.getId()))).setTestInstanceId(baseTask.getTestInstanceId()).setStart(baseTask.getStart()).setDeadline(baseTask.getDeadline()).setStop(Clock.nowTimestamp()).setLog(baseTask.getLog()).setResult(null, null).setRunInfo(baseTask.getRunInfo()).setState(Task.State.CANCELLED).create();
        System.out.println("Cancel task run: " + updatedTask);
        this.updateTaskCall(updatedTask);
    }

    public Long postResult(TestInstance ti, Task createdTask, Timestamp resultTimestamp) throws Exception {
        Timestamp expire = new Timestamp(resultTimestamp.getTime() + 300000L);
        String logFile = "/fake/log/file/";
        String logUrl = "fake URL";
        String summary = "SUCCESS";
        HashMap<String, String> results = new HashMap<String, String>();
        results.put("detail1", "a");
        results.put("detail2", "ab");
        results.put("detail3", "abc");
        Result newResult = new ResultBuilder().setTask((Long)createdTask.getId(), null).setCreated(resultTimestamp).setExpire(expire).setLogFile(logFile).setLogUrl(logUrl).setSummary(summary).setResults(results).setTestInstanceId(createdTask.getTestInstanceId()).create();
        System.err.flush();
        System.out.println("Posting result: " + newResult);
        System.out.flush();
        Long resultId = this.postResultCall(newResult);
        System.out.println("Got resultId: " + resultId);
        return resultId;
    }

    public void testResultCreated(Task createdTask, Timestamp resultTimestamp, Long resultId) throws Exception {
        this.createdResult = this.getResultCall(resultId);
        System.out.println("Got createdResult: " + this.createdResult);
        MatcherAssert.assertThat((Object)this.createdResult, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)this.createdResult.getTestInstanceId(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)createdTask.getTestInstanceId())));
        MatcherAssert.assertThat((Object)((Long)this.createdResult.getId()), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)((Long)this.createdResult.getId()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)resultId)));
        MatcherAssert.assertThat((Object)this.createdResult.getSummary(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"SUCCESS")));
        MatcherAssert.assertThat((Object)this.createdResult.getCreated(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)resultTimestamp)));
        System.out.println("expectedCreateTaskTestInstance: " + this.expectedCreateTaskTestInstance);
        assert (this.expectedCreateTaskTestInstance.getParameters() != null);
        assert (this.expectedCreateTaskTestInstance.getParameters().get("server") != null);
        assert (this.expectedCreateTaskTestInstance.getServerIdParameter() != null);
        Server expectedResultServer = (Server)serverTestCollection.getById(this.expectedCreateTaskTestInstance.getServerIdParameter());
        assert (expectedResultServer != null);
        MatcherAssert.assertThat((Object)this.createdResult.getResults(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)this.createdResult.getResults().size(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)3)));
        MatcherAssert.assertThat(this.createdResult.getResults().get("detail2"), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"ab")));
    }

    public void testTaskFinished(Task baseTask, Result result, Task createdTask, Long resultId) throws Exception {
        assert (result.getId() != null);
        assert (((Long)result.getId()).longValue() == resultId.longValue()) : "result.getId()(" + result.getId() + ") != resultId(" + resultId + ")";
        Task doneTask = this.getTaskCall((Long)createdTask.getId());
        System.out.println("Got finished Task: " + doneTask);
        MatcherAssert.assertThat((Object)doneTask, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)doneTask.getState(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Task.State.FINISHED)));
        MatcherAssert.assertThat((Object)((Long)doneTask.getId()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)((Long)baseTask.getId()))));
        MatcherAssert.assertThat((Object)doneTask.getRunInfo(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)baseTask.getRunInfo())));
        MatcherAssert.assertThat((Object)doneTask.getTestInstanceId(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)baseTask.getTestInstanceId())));
        MatcherAssert.assertThat((Object)doneTask.getResultId(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)doneTask.getResultId(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)((Long)result.getId()))));
        MatcherAssert.assertThat((Object)doneTask.getLog(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)baseTask.getLog())));
        MatcherAssert.assertThat((Object)doneTask.getStart(), (Matcher)Matchers.is((Object)baseTask.getStart()));
        MatcherAssert.assertThat((Object)doneTask.getDeadline(), (Matcher)Matchers.is((Object)baseTask.getDeadline()));
        MatcherAssert.assertThat((Object)doneTask.getStop(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)result.getCreated())));
        MatcherAssert.assertThat((Object)doneTask.isInActiveState(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)doneTask.isExpired(), (Matcher)Matchers.is((Object)false));
    }

    public void testInstanceUpdated(Task createdTask) throws Exception {
        int testInstanceId = createdTask.getTestInstanceId();
        TestInstance updateTestInstance = this.getTestInstanceCall(testInstanceId);
        TestInstanceStatistics updateTestInstanceStatistics = this.getTestInstanceStatisticsCall(testInstanceId);
        MatcherAssert.assertThat((Object)updateTestInstanceStatistics, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        Timestamp nextRunTs = updateTestInstanceStatistics.getNextRun();
        Frequency freq = (Frequency)frequencyTestCollection.getById(updateTestInstance.getFrequencyId());
        assert (freq != null);
        assert (freq.getCron() != null);
        CronSequenceGenerator cronSequenceGenerator = new CronSequenceGenerator("0 " + freq.getCron(), TimeZone.getTimeZone("UTC"));
        Date nextSaturdayDate = cronSequenceGenerator.next(Clock.nowDate());
        Timestamp nextSaturdayTs = new Timestamp(nextSaturdayDate.getTime());
        MatcherAssert.assertThat((Object)nextRunTs, (Matcher)Matchers.equalTo((Object)nextSaturdayTs));
        MatcherAssert.assertThat((Object)this.createdResult.getExpire(), (Matcher)Matchers.greaterThan((Comparable)nextSaturdayTs));
        MatcherAssert.assertThat((Object)updateTestInstanceStatistics.getLastResultId(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)((Long)this.createdResult.getId()))));
        MatcherAssert.assertThat((Object)updateTestInstanceStatistics.getLastResultId("anyButCancelled"), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)((Long)this.createdResult.getId()))));
        MatcherAssert.assertThat((Object)updateTestInstanceStatistics.getLastRun(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)this.createdResult.getCreated())));
    }

    @Test
    public void testFindWhenOnlyExpired() throws Exception {
        Task task1 = (Task)taskTestCollection.getById(1L);
        timeProvider.setNowOffset(TestClock.get().getBase());
        timeProvider.relativeNowOffsetMinutes(1L);
        assert (Clock.nowDate().after(task1.getStart()));
        assert (Clock.nowDate().before(task1.getDeadline()));
        List<Task> tasks = this.createTasksCall(2, "TaskIntegrationTest run no", "ping", null, null);
        System.out.println("Got tasks: " + tasks);
        System.out.flush();
        MatcherAssert.assertThat(tasks, (Matcher)Matchers.hasSize((int)0));
        timeProvider.setNowOffset(task1.getDeadline());
        timeProvider.relativeNowOffsetMinutes(6L);
        assert (Clock.nowDate().after(task1.getStart()));
        assert (Clock.nowDate().after(task1.getDeadline()));
        assert (Clock.nowDate().after(testInstancesStatisticsTestCollection.getByTestInstanceId(task1.getTestInstanceId()).getNextRun()));
        tasks = this.createTasksCall(2, "TaskIntegrationTest run yes", "ping", null, null);
        System.out.println("Got tasks: " + tasks);
        System.out.flush();
        MatcherAssert.assertThat(tasks, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)tasks.get(0).getTestInstanceId(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)9)));
    }

    @Test
    public void testTaskNormal() throws Exception {
        this.getNoTasks();
        this.forceRemoveRunningTask();
        timeProvider.setNowOffsetMinutes(0L);
        ActualAndExpectedTask created = this.getTask();
        Task createdTask = created.actual;
        Task expectedCreatedTask = created.expected;
        timeProvider.setNowOffsetMillis(2000L);
        this.testTaskCreated(createdTask, expectedCreatedTask);
        Timestamp updatedDeadline = this.confirmTaskRunning(createdTask);
        Task runningTask = this.testTaskRunning(createdTask, expectedCreatedTask, updatedDeadline);
        timeProvider.setNowOffsetMinutes(1L);
        long now = Clock.currentTimeMillis();
        now -= now % 1000L;
        Timestamp resultTimestamp = new Timestamp(now);
        Long resultId = this.postResult(this.expectedCreateTaskTestInstance, createdTask, resultTimestamp);
        MatcherAssert.assertThat((Object)resultId, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        this.testResultCreated(createdTask, resultTimestamp, resultId);
        this.testTaskFinished(runningTask, this.createdResult, createdTask, resultId);
        this.testInstanceUpdated(createdTask);
        timeProvider.setNowOffsetMinutes(600L);
        this.testTaskFinished(runningTask, this.createdResult, createdTask, resultId);
    }

    @Test
    public void testTaskSelfNotTestFailed() throws Exception {
        this.getNoTasks();
        this.forceRemoveRunningTask();
        timeProvider.setNowOffsetMinutes(0L);
        User userA = (User)userTestCollection.getById("tester-a");
        MatcherAssert.assertThat((Object)userA, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        this.modifyUserCall(new UserBuilder(userA).setSelfTestFailed(Boolean.valueOf(false)).create());
        List<Task> tasks = this.createTasksCall(2, "TaskIntegrationTest run no", null, null, null);
        System.out.println("Got tasks: " + tasks);
        System.out.flush();
        MatcherAssert.assertThat(tasks, (Matcher)Matchers.hasSize((int)2));
    }

    @Test
    public void testTaskSelfTestFailed() throws Exception {
        this.getNoTasks();
        this.forceRemoveRunningTask();
        timeProvider.setNowOffsetMinutes(0L);
        User userA = (User)userTestCollection.getById("tester-a");
        MatcherAssert.assertThat((Object)userA, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        this.modifyUserCall(new UserBuilder(userA).setSelfTestFailed(Boolean.valueOf(true)).create());
        List<Task> tasks = this.createTasksCall(2, "TaskIntegrationTest run no", "ping", null, null);
        System.out.println("Got tasks: " + tasks);
        System.out.flush();
        MatcherAssert.assertThat(tasks, (Matcher)Matchers.hasSize((int)0));
    }

    @Test
    public void testTaskSelfTestFailed2() throws Exception {
        this.getNoTasks();
        this.forceRemoveRunningTask();
        timeProvider.setNowOffsetMinutes(0L);
        User userA = (User)userTestCollection.getById("tester-a");
        MatcherAssert.assertThat((Object)userA, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        this.modifyUserCall(new UserBuilder(userA).setSelfTestFailed(Boolean.valueOf(true)).create());
        List<Task> tasks = this.createTasksCall(2, "TaskIntegrationTest run no", null, null, null);
        System.out.println("Got tasks: " + tasks);
        System.out.flush();
        MatcherAssert.assertThat(tasks, (Matcher)Matchers.hasSize((int)1));
    }

    @Test
    public void testTaskAdminDisabledTests() throws Exception {
        this.getNoTasks();
        this.forceRemoveRunningTask();
        timeProvider.setNowOffsetMinutes(0L);
        Admin origAdmin = this.getAdminCall();
        Admin neededAdmin = new AdminBuilder(origAdmin).setDisableAllTests(Boolean.valueOf(true)).setDisableProductionTests(Boolean.valueOf(false)).create();
        this.modifyAdminCall(neededAdmin);
        Admin actualAdmin = this.getAdminCall();
        new AdminTestCollection().assertSameDetails(actualAdmin, neededAdmin);
        List<Task> tasks = this.createTasksCall(2, "TaskIntegrationTest run no", null, null, null);
        System.out.println("Got tasks: " + tasks);
        System.out.flush();
        MatcherAssert.assertThat(tasks, (Matcher)Matchers.hasSize((int)0));
    }

    @Test
    public void testTaskAdminDisabledProductionTestsRequestTest() throws Exception {
        this.getNoTasks();
        this.forceRemoveRunningTask();
        timeProvider.setNowOffsetMinutes(0L);
        Admin origAdmin = this.getAdminCall();
        Admin neededAdmin = new AdminBuilder(origAdmin).setDisableAllTests(Boolean.valueOf(false)).setDisableProductionTests(Boolean.valueOf(true)).create();
        this.modifyAdminCall(neededAdmin);
        Admin actualAdmin = this.getAdminCall();
        new AdminTestCollection().assertSameDetails(actualAdmin, neededAdmin);
        List<Task> tasks = this.createTasksCall(2, "TaskIntegrationTest run no", null, null, "test");
        System.out.println("Got tasks: " + tasks);
        System.out.flush();
        MatcherAssert.assertThat(tasks, (Matcher)Matchers.hasSize((int)1));
    }

    @Test
    public void testTaskAdminDisabledProductionTestsRequestProduction() throws Exception {
        this.getNoTasks();
        this.forceRemoveRunningTask();
        timeProvider.setNowOffsetMinutes(0L);
        Admin origAdmin = this.getAdminCall();
        Admin neededAdmin = new AdminBuilder(origAdmin).setDisableAllTests(Boolean.valueOf(false)).setDisableProductionTests(Boolean.valueOf(true)).create();
        this.modifyAdminCall(neededAdmin);
        Admin actualAdmin = this.getAdminCall();
        new AdminTestCollection().assertSameDetails(actualAdmin, neededAdmin);
        List<Task> tasks = this.createTasksCall(2, "TaskIntegrationTest run no", null, null, "prod");
        System.out.println("Got tasks: " + tasks);
        System.out.flush();
        MatcherAssert.assertThat(tasks, (Matcher)Matchers.hasSize((int)0));
    }

    @Test
    public void testTaskSelfTestFailedButImmune() throws Exception {
        this.getNoTasks();
        this.forceRemoveRunningTask();
        timeProvider.setNowOffsetMinutes(0L);
        User userA = (User)userTestCollection.getById("tester-a");
        MatcherAssert.assertThat((Object)userA, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        this.modifyUserCall(new UserBuilder(userA).setSelfTestFailed(Boolean.valueOf(true)).create());
        this.expectedCreateTaskTestInstance = (TestInstance)testInstancesTestCollection.getById(9);
        this.modifyTestInstanceCall(new TestInstanceBuilder(this.expectedCreateTaskTestInstance).setSelfTestImmune(Boolean.valueOf(true)).create());
        List<Task> tasks = this.createTasksCall(2, "TaskIntegrationTest run no", "ping", null, null);
        System.out.println("Got tasks: " + tasks);
        System.out.flush();
        MatcherAssert.assertThat(tasks, (Matcher)Matchers.hasSize((int)1));
    }

    @Test
    public void testStressTestTasksNormalSequential() throws Exception {
        this.getNoTasks();
        this.forceRemoveRunningTask();
        timeProvider.setNowOffsetMinutes(0L);
        List<ActualAndExpectedTask> createdTasks = this.getStressTestTasks(3);
        int count = 0;
        for (ActualAndExpectedTask created : createdTasks) {
            Task createdTask = created.actual;
            Task expectedCreatedTask = created.expected;
            timeProvider.setNowOffsetMillis(2000L + (long)count * 1000L);
            this.testTaskCreated(createdTask, expectedCreatedTask);
            Timestamp updatedDeadline = this.confirmTaskRunning(createdTask);
            Task runningTask = this.testTaskRunning(createdTask, expectedCreatedTask, updatedDeadline);
            timeProvider.setNowOffsetMillis(60000L + (long)count * 1000L);
            long now = Clock.currentTimeMillis();
            now -= now % 1000L;
            Timestamp resultTimestamp = new Timestamp(now);
            Long resultId = this.postResult(this.expectedCreateTaskTestInstance, createdTask, resultTimestamp);
            MatcherAssert.assertThat((Object)resultId, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            this.testResultCreated(createdTask, resultTimestamp, resultId);
            this.testTaskFinished(runningTask, this.createdResult, createdTask, resultId);
            this.testInstanceUpdated(createdTask);
            timeProvider.setNowOffsetMillis(36000000L + (long)count * 1000L);
            this.testTaskFinished(runningTask, this.createdResult, createdTask, resultId);
            ++count;
        }
    }

    @Test
    public void testStressTestTasksNormalParallel() throws Exception {
        Task runningTask;
        Timestamp updatedDeadline;
        Task expectedCreatedTask;
        Task createdTask;
        this.getNoTasks();
        this.forceRemoveRunningTask();
        timeProvider.setNowOffsetMinutes(0L);
        List<ActualAndExpectedTask> createdTasks = this.getStressTestTasks(3);
        int count = 0;
        for (ActualAndExpectedTask created : createdTasks) {
            createdTask = created.actual;
            expectedCreatedTask = created.expected;
            timeProvider.setNowOffsetMillis(2000L + (long)count * 1000L);
            this.testTaskCreated(createdTask, expectedCreatedTask);
            updatedDeadline = this.confirmTaskRunning(createdTask);
            runningTask = this.testTaskRunning(createdTask, expectedCreatedTask, updatedDeadline);
            ++count;
        }
        for (ActualAndExpectedTask created : createdTasks) {
            createdTask = created.actual;
            expectedCreatedTask = created.expected;
            timeProvider.setNowOffsetMillis(2000L + (long)count * 1000L);
            updatedDeadline = this.confirmTaskRunning(createdTask);
            runningTask = this.testTaskRunning(createdTask, expectedCreatedTask, updatedDeadline);
            timeProvider.setNowOffsetMillis(60000L + (long)count * 1000L);
            long now = Clock.currentTimeMillis();
            now -= now % 1000L;
            Timestamp resultTimestamp = new Timestamp(now);
            Long resultId = this.postResult(this.expectedCreateTaskTestInstance, createdTask, resultTimestamp);
            MatcherAssert.assertThat((Object)resultId, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            this.testResultCreated(createdTask, resultTimestamp, resultId);
            this.testTaskFinished(runningTask, this.createdResult, createdTask, resultId);
            this.testInstanceUpdated(createdTask);
            timeProvider.setNowOffsetMillis(36000000L + (long)count * 1000L);
            this.testTaskFinished(runningTask, this.createdResult, createdTask, resultId);
            ++count;
        }
    }

    @Test
    public void testTaskCreateExpired() throws Exception {
        this.getNoTasks();
        this.forceRemoveRunningTask();
        timeProvider.setNowOffsetMinutes(0L);
        ActualAndExpectedTask created = this.getTask();
        Task createdTask = created.actual;
        Task expectedCreatedTask = created.expected;
        timeProvider.setNowOffsetMillis(2000L);
        this.testTaskCreated(createdTask, expectedCreatedTask);
        timeProvider.setNowOffsetMinutes(6L);
        assert (createdTask.getDeadline().before(Clock.nowDate()));
        this.testTaskExpired(expectedCreatedTask);
        Timestamp updatedDeadline = this.confirmTaskRunning(createdTask);
        this.testTaskExpired(expectedCreatedTask);
        long now = Clock.currentTimeMillis();
        now -= now % 1000L;
        Timestamp resultTimestamp = new Timestamp(now);
        Long resultId = this.postResult(this.expectedCreateTaskTestInstance, createdTask, resultTimestamp);
        MatcherAssert.assertThat((Object)resultId, (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        this.testTaskExpired(expectedCreatedTask);
    }

    @Test
    public void testTaskRunningExpired() throws Exception {
        this.getNoTasks();
        this.forceRemoveRunningTask();
        timeProvider.setNowOffsetMinutes(0L);
        ActualAndExpectedTask created = this.getTask();
        Task createdTask = created.actual;
        Task expectedCreatedTask = created.expected;
        timeProvider.setNowOffsetMillis(2000L);
        this.testTaskCreated(createdTask, expectedCreatedTask);
        Timestamp updatedDeadline = this.confirmTaskRunning(createdTask);
        Task runningTask = this.testTaskRunning(createdTask, expectedCreatedTask, updatedDeadline);
        timeProvider.setNowOffsetMinutes(20L);
        this.testTaskExpired(runningTask);
        long now = Clock.currentTimeMillis();
        now -= now % 1000L;
        Timestamp resultTimestamp = new Timestamp(now);
        Long resultId = this.postResult(this.expectedCreateTaskTestInstance, createdTask, resultTimestamp);
        MatcherAssert.assertThat((Object)resultId, (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        this.testTaskExpired(runningTask);
    }

    @Test
    public void testTaskOtherCancelledThenPostResult() throws Exception {
        this.getNoTasks();
        this.forceRemoveRunningTask();
        timeProvider.setNowOffsetMinutes(0L);
        ActualAndExpectedTask created = this.getTask();
        Task createdTask = created.actual;
        Task expectedCreatedTask = created.expected;
        timeProvider.setNowOffsetMillis(2000L);
        this.testTaskCreated(createdTask, expectedCreatedTask);
        Timestamp updatedDeadline = this.confirmTaskRunning(createdTask);
        Task runningTask = this.testTaskRunning(createdTask, expectedCreatedTask, updatedDeadline);
        timeProvider.setNowOffsetMinutes(1L);
        this.otherCancelTask(runningTask);
        this.testTaskState(runningTask, Task.State.CANCELLING);
        timeProvider.setNowOffsetMinutes(2L);
        this.testTaskState(runningTask, Task.State.CANCELLING);
        long now = Clock.currentTimeMillis();
        now -= now % 1000L;
        Timestamp resultTimestamp = new Timestamp(now);
        Long resultId = this.postResult(this.expectedCreateTaskTestInstance, createdTask, resultTimestamp);
        MatcherAssert.assertThat((Object)resultId, (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        this.testTaskState(new TaskBuilder(runningTask).setStop(Clock.nowDate()).create(), Task.State.CANCELLED);
    }

    @Test
    public void testTaskOtherCancelledThenExpiresToCancelled() throws Exception {
        this.getNoTasks();
        this.forceRemoveRunningTask();
        timeProvider.setNowOffsetMinutes(0L);
        ActualAndExpectedTask created = this.getTask();
        Task createdTask = created.actual;
        Task expectedCreatedTask = created.expected;
        timeProvider.setNowOffsetMillis(2000L);
        this.testTaskCreated(createdTask, expectedCreatedTask);
        Timestamp updatedDeadline = this.confirmTaskRunning(createdTask);
        Task runningTask = this.testTaskRunning(createdTask, expectedCreatedTask, updatedDeadline);
        timeProvider.setNowOffsetMinutes(1L);
        this.otherCancelTask(runningTask);
        this.testTaskState(runningTask, Task.State.CANCELLING);
        timeProvider.setNowOffsetMinutes(20L);
        assert (runningTask.getDeadline().before(Clock.nowDate()));
        this.testTaskState(new TaskBuilder(runningTask).setStop(runningTask.getDeadline()).create(), Task.State.CANCELLED);
    }

    @Test
    public void testTaskOtherCancelledThenExpiresAndConfirmCancel() throws Exception {
        this.getNoTasks();
        this.forceRemoveRunningTask();
        timeProvider.setNowOffsetMinutes(0L);
        ActualAndExpectedTask created = this.getTask();
        Task createdTask = created.actual;
        Task expectedCreatedTask = created.expected;
        timeProvider.setNowOffsetMillis(2000L);
        this.testTaskCreated(createdTask, expectedCreatedTask);
        Timestamp updatedDeadline = this.confirmTaskRunning(createdTask);
        Task runningTask = this.testTaskRunning(createdTask, expectedCreatedTask, updatedDeadline);
        timeProvider.setNowOffsetMinutes(1L);
        this.otherCancelTask(runningTask);
        this.testTaskState(runningTask, Task.State.CANCELLING);
        timeProvider.setNowOffsetMinutes(20L);
        this.cancelTask(runningTask);
        this.testTaskState(new TaskBuilder(runningTask).setStop(runningTask.getDeadline()).create(), Task.State.CANCELLED);
    }

    @Test
    public void testTaskOtherCancelledThenExpiresAndPostResult() throws Exception {
        this.getNoTasks();
        this.forceRemoveRunningTask();
        timeProvider.setNowOffsetMinutes(0L);
        ActualAndExpectedTask created = this.getTask();
        Task createdTask = created.actual;
        Task expectedCreatedTask = created.expected;
        timeProvider.setNowOffsetMillis(2000L);
        this.testTaskCreated(createdTask, expectedCreatedTask);
        Timestamp updatedDeadline = this.confirmTaskRunning(createdTask);
        Task runningTask = this.testTaskRunning(createdTask, expectedCreatedTask, updatedDeadline);
        timeProvider.setNowOffsetMinutes(1L);
        this.otherCancelTask(runningTask);
        this.testTaskState(runningTask, Task.State.CANCELLING);
        timeProvider.setNowOffsetMinutes(20L);
        long now = Clock.currentTimeMillis();
        now -= now % 1000L;
        Timestamp resultTimestamp = new Timestamp(now);
        Long resultId = this.postResult(this.expectedCreateTaskTestInstance, createdTask, resultTimestamp);
        MatcherAssert.assertThat((Object)resultId, (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        this.testTaskState(new TaskBuilder(runningTask).setStop(runningTask.getDeadline()).create(), Task.State.CANCELLED);
    }

    @Test
    public void testTaskOtherCancelledThenConfirmCancel() throws Exception {
        this.getNoTasks();
        this.forceRemoveRunningTask();
        timeProvider.setNowOffsetMinutes(0L);
        ActualAndExpectedTask created = this.getTask();
        Task createdTask = created.actual;
        Task expectedCreatedTask = created.expected;
        timeProvider.setNowOffsetMillis(2000L);
        this.testTaskCreated(createdTask, expectedCreatedTask);
        Timestamp updatedDeadline = this.confirmTaskRunning(createdTask);
        Task runningTask = this.testTaskRunning(createdTask, expectedCreatedTask, updatedDeadline);
        timeProvider.setNowOffsetMinutes(1L);
        this.otherCancelTask(runningTask);
        this.testTaskState(runningTask, Task.State.CANCELLING);
        this.cancelTask(runningTask);
        this.testTaskState(new TaskBuilder(runningTask).setStop(Clock.nowDate()).create(), Task.State.CANCELLED);
    }

    @Test
    public void testTaskSelfCancelled() throws Exception {
        this.getNoTasks();
        this.forceRemoveRunningTask();
        timeProvider.setNowOffsetMinutes(0L);
        ActualAndExpectedTask created = this.getTask();
        Task createdTask = created.actual;
        Task expectedCreatedTask = created.expected;
        timeProvider.setNowOffsetMillis(2000L);
        this.testTaskCreated(createdTask, expectedCreatedTask);
        Timestamp updatedDeadline = this.confirmTaskRunning(createdTask);
        Task runningTask = this.testTaskRunning(createdTask, expectedCreatedTask, updatedDeadline);
        timeProvider.setNowOffsetMinutes(1L);
        assert (Clock.nowDate().after(runningTask.getStart())) : "now=" + Clock.nowTimestamp() + " start=" + runningTask.getStart() + " deadline=" + runningTask.getDeadline();
        assert (Clock.nowDate().before(runningTask.getDeadline()));
        this.cancelTask(runningTask);
        this.testTaskState(new TaskBuilder(runningTask).setStop(Clock.nowDate()).create(), Task.State.CANCELLED);
    }

    @Test
    public void testCreate2Tasks() throws Exception {
        this.getNoTasks();
        this.forceRemoveRunningTask();
        timeProvider.setNowOffsetMinutes(0L);
        TestInstance expectedCreateTaskTestInstance1 = (TestInstance)testInstancesTestCollection.getById(9);
        TestInstance expectedCreateTaskTestInstance2 = (TestInstance)testInstancesTestCollection.getById(10);
        String runInfo = "TaskIntegrationTest run";
        List<Task> tasks = this.createTasksCall(3, runInfo, "ping,anyGetVersion", null, null);
        System.out.println("Got tasks: " + tasks);
        MatcherAssert.assertThat(tasks, (Matcher)Matchers.hasSize((int)2));
        Task createdTask1 = tasks.get(0);
        Task createdTask2 = tasks.get(1);
        if (createdTask1.getTestInstanceId().equals(expectedCreateTaskTestInstance1.getId())) {
            MatcherAssert.assertThat((String)"test instance ID differs", (Object)createdTask1.getTestInstanceId(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)((Integer)expectedCreateTaskTestInstance1.getId()))));
            MatcherAssert.assertThat((String)"test instance ID differs", (Object)createdTask2.getTestInstanceId(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)((Integer)expectedCreateTaskTestInstance2.getId()))));
        } else {
            MatcherAssert.assertThat((String)"test instance ID differs", (Object)createdTask1.getTestInstanceId(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)((Integer)expectedCreateTaskTestInstance2.getId()))));
            MatcherAssert.assertThat((String)"test instance ID differs", (Object)createdTask2.getTestInstanceId(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)((Integer)expectedCreateTaskTestInstance1.getId()))));
        }
        MatcherAssert.assertThat((Object)((Long)createdTask1.getId()), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)((Long)createdTask2.getId()), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void testTaskFrequencyNever() throws Exception {
        timeProvider.setNowOffset(TestClock.get().getBase());
        timeProvider.relativeNowOffsetMinutes(1L);
        TestInstance testInstance = (TestInstance)testInstancesTestCollection.getById(13);
        assert (testInstance.getFrequencyId() == 3);
        List<Task> tasks = this.createTasksCall(20, "TaskIntegrationTest run never", null, (Integer)testInstance.getId(), null);
        System.out.println("Got tasks: " + tasks);
        System.out.flush();
        MatcherAssert.assertThat(tasks, (Matcher)Matchers.hasSize((int)0));
    }

    @Test
    public void testTaskDisabled() throws Exception {
        timeProvider.setNowOffset(TestClock.get().getBase());
        timeProvider.relativeNowOffsetMinutes(10L);
        TestInstance testInstance = (TestInstance)testInstancesTestCollection.getById(11);
        TestInstanceStatisticsBuilder testInstanceStatistics = testInstancesStatisticsTestCollection.getByTestInstanceId(11);
        assert (testInstance.isDisabled());
        assert (testInstanceStatistics.getNextRun().before(Clock.nowDate()));
        List<Task> tasks = this.createTasksCall(10, "TaskIntegrationTest run disabled", null, (Integer)testInstance.getId(), null);
        System.out.println("Got tasks: " + tasks);
        System.out.flush();
        MatcherAssert.assertThat(tasks, (Matcher)Matchers.hasSize((int)0));
    }

    @Test
    public void testTaskFrequencyNever12() throws Exception {
        timeProvider.setNowOffset(TestClock.get().getBase());
        timeProvider.relativeNowOffsetMinutes(10L);
        TestInstance testInstance = (TestInstance)testInstancesTestCollection.getById(12);
        TestInstanceStatisticsBuilder testInstanceStatistics = testInstancesStatisticsTestCollection.getByTestInstanceId(12);
        assert (testInstance.getFrequencyId() == 3);
        assert (testInstanceStatistics.getNextRun() == null || testInstanceStatistics.getNextRun().before(Clock.nowDate()));
        List<Task> tasks = this.createTasksCall(10, "TaskIntegrationTest run disabled", null, (Integer)testInstance.getId(), null);
        System.out.println("Got tasks: " + tasks);
        System.out.flush();
        MatcherAssert.assertThat(tasks, (Matcher)Matchers.hasSize((int)0));
    }

    public void testLookup(Task expected, long id) throws Exception {
        Task actual = this.doLookup(id);
        this.checkLookup(expected, actual);
    }

    public Task doLookup(long id) throws Exception {
        assert (this.client != null);
        WebTarget query = this.client.target(String.format("http://localhost:%d/task/" + id, RULE.getLocalPort()));
        Task actual = (Task)query.request().get(Task.class);
        System.out.println("Got task task: " + actual);
        return actual;
    }

    public void checkLookup(Task expected, Task actual) {
        taskTestCollection.assertSameAndExpectActualHasUri((JsonLdObjectWithId)actual, (JsonLdObjectWithId)expected, true);
    }

    @Test
    public void lookup0() throws Exception {
        Task expected = (Task)taskTestCollection.getByIndex(0);
        this.testLookup(expected, (Long)expected.getId());
    }

    @Test
    public void lookup1() throws Exception {
        Task expected = (Task)taskTestCollection.getByIndex(1);
        this.testLookup(expected, (Long)expected.getId());
    }

    @Test
    public void lookup2() throws Exception {
        Task expected = (Task)taskTestCollection.getByIndex(2);
        this.testLookup(expected, (Long)expected.getId());
    }

    @Test
    public void lookup3() throws Exception {
        Task expected = (Task)taskTestCollection.getByIndex(3);
        this.testLookup(expected, (Long)expected.getId());
    }

    protected static class ActualAndExpectedTask {
        public final Task actual;
        public final Task expected;

        public ActualAndExpectedTask(Task actual, Task expected) {
            this.actual = actual;
            this.expected = expected;
        }
    }
}

