/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.test;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestEmailConfig;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestEmailConfigBuilder;
import be.iminds.ilabt.util.jsonld.test.BasicObjectTestCollection;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;

public class TestEmailConfigTestCollection
extends BasicObjectTestCollection<TestEmailConfig, TestEmailConfigBuilder> {
    public TestEmailConfigTestCollection() {
        super(TestEmailConfig.class, TestEmailConfigBuilder.class);
        TestEmailConfigBuilder testEmailConfigBuilder = new TestEmailConfigBuilder().addAddress("test@example.com").addAddress("test2@example.com").addAltAddress("alt@example.com").setTrigger(TestEmailConfig.TestResultStatus.FAILURE, false, false, null, "Another Failure", "bad").setTrigger(TestEmailConfig.TestResultStatus.FAILURE, true, false, "0 9 * * 1", "A First Failure", "first bad").setTrigger(TestEmailConfig.TestResultStatus.WARNING, true, false, null, "Possible Problem", "warning\nwarning\nwarning\n").setTrigger(TestEmailConfig.TestResultStatus.SUCCESS, true, false, null, "All OK again", "good").setTrigger(TestEmailConfig.TestResultStatus.FAILURE, true, true, null, "Not failing anymore", "first non bad").setLimits(Integer.valueOf(1), Integer.valueOf(2));
        this.all.add(testEmailConfigBuilder);
        testEmailConfigBuilder = new TestEmailConfigBuilder().addAddress("test@example.com");
        this.all.add(testEmailConfigBuilder);
    }

    public void assertSameDetails(TestEmailConfig actual, TestEmailConfig expected) {
        MatcherAssert.assertThat((Object)actual.getAddresses(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expected.getAddresses())));
        MatcherAssert.assertThat((Object)actual.getAltAddresses(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expected.getAltAddresses())));
        MatcherAssert.assertThat((Object)(actual.getTriggers() == null ? 1 : 0), (Matcher)Matchers.is((Object)(expected.getTriggers() == null ? 1 : 0)));
        if (actual.getTriggers() != null && expected.getTriggers() != null) {
            MatcherAssert.assertThat((Object)actual.getTriggers(), (Matcher)Matchers.hasSize((int)expected.getTriggers().size()));
            for (TestEmailConfig.TestResultStatus status : TestEmailConfig.TestResultStatus.values()) {
                MatcherAssert.assertThat((Object)actual.getTrigger(status, true, false), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expected.getTrigger(status, true, false))));
                MatcherAssert.assertThat((Object)actual.getTrigger(status, false, false), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expected.getTrigger(status, false, false))));
                MatcherAssert.assertThat((Object)actual.getTrigger(status, true, true), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expected.getTrigger(status, true, true))));
                MatcherAssert.assertThat((Object)actual.getTrigger(status, false, true), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expected.getTrigger(status, false, true))));
            }
        }
    }
}

