/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.test;

import be.iminds.ilabt.jfed.fedmon.util.Clock;
import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonWebApiServiceApplication;
import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonWebApiServiceConfiguration;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Frequency;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestDefinition;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestDefinitionBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestInstance;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestInstanceBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Testbed;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.User;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.FedmonTestPostgresDB;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.FrequencyTestCollection;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.TestDefinitionsTestCollection;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.TestInstancesTestCollection;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.TestbedTestCollection;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.UserTestCollection;
import be.iminds.ilabt.util.jsonld.JsonLdObjectsMetaData;
import be.iminds.ilabt.util.jsonld.iface.JsonLdObjectWithId;
import be.iminds.ilabt.util.jsonld.impl.PrimaryIdObject;
import io.dropwizard.testing.ConfigOverride;
import io.dropwizard.testing.junit.DropwizardAppRule;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import org.glassfish.jersey.client.JerseyClient;
import org.glassfish.jersey.client.JerseyClientBuilder;
import org.glassfish.jersey.client.JerseyWebTarget;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

public class TestInstanceIntegrationTest {
    @ClassRule
    public static final DropwizardAppRule<FedmonWebApiServiceConfiguration> RULE = new DropwizardAppRule(FedmonWebApiServiceApplication.class, "../fedmon-webapi-service-TESTING.yml", new ConfigOverride[0]);
    protected static TestbedTestCollection testbedTestCollection;
    protected static TestInstancesTestCollection testInstancesTestCollection;
    protected static TestDefinitionsTestCollection testDefinitionsTestCollection;
    protected static FrequencyTestCollection frequencyTestCollection;
    protected static UserTestCollection userTestCollection;
    protected JerseyClient client;

    @BeforeClass
    public static void setUp() throws Exception {
        TestInstanceIntegrationTest.setUp(RULE);
    }

    public static void setUp(DropwizardAppRule<FedmonWebApiServiceConfiguration> RULE) throws Exception {
        Clock.set((Clock.CurrentTimeProvider)new Clock.DefaultTestTimeProvider());
        assert (RULE != null);
        Clock.set((Clock.CurrentTimeProvider)new Clock.DefaultTestTimeProvider());
        FedmonTestPostgresDB testPostgresDB = new FedmonTestPostgresDB(RULE);
        testPostgresDB.recreateDB();
        testPostgresDB.close();
        testInstancesTestCollection = new TestInstancesTestCollection();
        testDefinitionsTestCollection = new TestDefinitionsTestCollection();
        frequencyTestCollection = new FrequencyTestCollection();
        testbedTestCollection = new TestbedTestCollection();
        userTestCollection = new UserTestCollection();
    }

    public DropwizardAppRule<FedmonWebApiServiceConfiguration> getRule() {
        return RULE;
    }

    @AfterClass
    public static void tearDown() throws Exception {
        Clock.reset();
    }

    @Before
    public void beforeMethod() throws Exception {
        this.client = new JerseyClientBuilder().build();
        assert (this.client != null);
    }

    public void testSearch(List<TestInstance> expected, String versionNameArgString, String testInstanceNameArgString, String testDefinitionNameArgString, String testInstanceIdArgString, String testbedCategoryArgString, String testbedGeniNameArgString, String testbedNameArgString, String testbedUrnArgString, Boolean nextRunArg, Boolean hasActiveTasksArg, Boolean enabledArg, Boolean disabledArg) throws Exception {
        List<TestInstance> actual = this.doSearch(versionNameArgString, testInstanceNameArgString, testDefinitionNameArgString, testInstanceIdArgString, testbedCategoryArgString, testbedGeniNameArgString, testbedNameArgString, testbedUrnArgString, nextRunArg, hasActiveTasksArg, enabledArg, disabledArg);
        this.checkSearch(expected, actual);
    }

    public List<TestInstance> doSearch(String versionNameArgString, String testInstanceNameArgString, String testDefinitionNameArgString, String testInstanceIdArgString, String testbedCategoryArgString, String testbedGeniNameArgString, String testbedNameArgString, String testbedUrnArgString, Boolean nextRunArg, Boolean hasActiveTasksArg, Boolean enabledArg, Boolean disabledArg) throws Exception {
        assert (this.client != null);
        JerseyWebTarget query = this.client.target(String.format("http://localhost:%d/testinstance/", RULE.getLocalPort()));
        if (versionNameArgString != null) {
            query = query.queryParam("testversionname", new Object[]{versionNameArgString});
        }
        if (testInstanceNameArgString != null) {
            query = query.queryParam("testname", new Object[]{testInstanceNameArgString});
        }
        if (testDefinitionNameArgString != null) {
            query = query.queryParam("testdefinitionname", new Object[]{testDefinitionNameArgString});
        }
        if (testInstanceIdArgString != null) {
            query = query.queryParam("testinstanceid", new Object[]{testInstanceIdArgString});
        }
        if (testbedCategoryArgString != null) {
            query = query.queryParam("testbedcategory", new Object[]{testbedCategoryArgString});
        }
        if (testbedGeniNameArgString != null) {
            query = query.queryParam("geni_testbed", new Object[]{testbedGeniNameArgString});
        }
        if (testbedUrnArgString != null) {
            query = query.queryParam("testbed_urn", new Object[]{testbedUrnArgString});
        }
        if (testbedNameArgString != null) {
            query = query.queryParam("testbed", new Object[]{testbedNameArgString});
        }
        if (nextRunArg != null) {
            query = query.queryParam("nextrun", new Object[]{nextRunArg});
        }
        if (hasActiveTasksArg != null) {
            query = query.queryParam("activeTasks", new Object[]{hasActiveTasksArg});
        }
        if (enabledArg != null) {
            query = query.queryParam("enabled", new Object[]{enabledArg});
        }
        if (disabledArg != null) {
            query = query.queryParam("disabled", new Object[]{disabledArg});
        }
        List actual = (List)query.request().get((GenericType)new GenericType<List<TestInstance>>(){});
        System.out.println("Got " + actual.size() + " testInstances. Id's: " + actual.stream().map(PrimaryIdObject::getId).collect(Collectors.toList()));
        return actual;
    }

    public void checkSearch(List<TestInstance> expected, List<TestInstance> actual) {
        MatcherAssert.assertThat(actual, (Matcher)Matchers.hasSize((int)expected.size()));
        for (TestInstance ex : expected) {
            TestInstance ac = (TestInstance)testInstancesTestCollection.searchListById(actual, (Integer)ex.getId());
            MatcherAssert.assertThat((String)("Expected id " + ex.getId() + " not found in result"), (Object)ac, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            testInstancesTestCollection.assertSameAndExpectActualHasUri((JsonLdObjectWithId)ac, (JsonLdObjectWithId)ex, true);
        }
    }

    public void testLookup(TestInstance expected, int id) throws Exception {
        TestInstance actual = this.doLookup(id);
        this.checkLookup(expected, actual);
    }

    public TestInstance doLookup(int id) throws Exception {
        assert (this.client != null);
        JerseyWebTarget query = this.client.target(String.format("http://localhost:%d/testinstance/" + id, RULE.getLocalPort()));
        TestInstance actual = (TestInstance)query.request().get(TestInstance.class);
        System.out.println("Got result TestInstance: " + actual);
        return actual;
    }

    public void checkLookup(TestInstance expected, TestInstance actual) {
        testInstancesTestCollection.assertSameAndExpectActualHasUri((JsonLdObjectWithId)actual, (JsonLdObjectWithId)expected, true);
    }

    @Test
    public void lookup0() throws Exception {
        TestInstance expected = (TestInstance)testInstancesTestCollection.getByIndex(0);
        this.testLookup(expected, (Integer)expected.getId());
    }

    @Test
    public void lookup1() throws Exception {
        TestInstance expected = (TestInstance)testInstancesTestCollection.getByIndex(1);
        this.testLookup(expected, (Integer)expected.getId());
    }

    @Test
    public void lookup2() throws Exception {
        TestInstance expected = (TestInstance)testInstancesTestCollection.getByIndex(2);
        this.testLookup(expected, (Integer)expected.getId());
    }

    @Test
    public void lookup3() throws Exception {
        TestInstance expected = (TestInstance)testInstancesTestCollection.getByIndex(3);
        this.testLookup(expected, (Integer)expected.getId());
    }

    @Test
    public void lookup4() throws Exception {
        TestInstance expected = (TestInstance)testInstancesTestCollection.getByIndex(4);
        this.testLookup(expected, (Integer)expected.getId());
    }

    @Test
    public void lookup5() throws Exception {
        TestInstance expected = (TestInstance)testInstancesTestCollection.getByIndex(5);
        this.testLookup(expected, (Integer)expected.getId());
    }

    @Test
    public void search1() throws Exception {
        String versionNameArgString = null;
        String testInstanceNameArgString = null;
        String testDefinitionNameArgString = null;
        String testInstanceIdArgString = null;
        String testbedCategoryArgString = null;
        String testbedGeniNameArgString = null;
        String testbedNameArgString = null;
        String testbedUrnArgString = null;
        Boolean nextRunArg = null;
        Boolean hasActiveTasksArg = null;
        Boolean enabledArg = null;
        Boolean disabledArg = null;
        List<TestInstance> expected = testInstancesTestCollection.getAllNormal();
        this.testSearch(expected, versionNameArgString, testInstanceNameArgString, testDefinitionNameArgString, testInstanceIdArgString, testbedCategoryArgString, testbedGeniNameArgString, testbedNameArgString, testbedUrnArgString, nextRunArg, hasActiveTasksArg, enabledArg, disabledArg);
    }

    @Test
    public void search2() throws Exception {
        String versionNameArgString = "";
        String testInstanceNameArgString = "";
        String testDefinitionNameArgString = "";
        String testInstanceIdArgString = "";
        String testbedCategoryArgString = "";
        String testbedGeniNameArgString = "";
        String testbedNameArgString = null;
        String testbedUrnArgString = null;
        Boolean nextRunArg = null;
        Boolean hasActiveTasksArg = null;
        Boolean enabledArg = null;
        Boolean disabledArg = null;
        List<TestInstance> expected = testInstancesTestCollection.getAllNormal();
        this.testSearch(expected, versionNameArgString, testInstanceNameArgString, testDefinitionNameArgString, testInstanceIdArgString, testbedCategoryArgString, testbedGeniNameArgString, testbedNameArgString, testbedUrnArgString, nextRunArg, hasActiveTasksArg, enabledArg, disabledArg);
    }

    @Test
    public void search3() throws Exception {
        String versionNameArgString = null;
        String testInstanceNameArgString = null;
        String testDefinitionNameArgString = null;
        String testInstanceIdArgString = "9";
        String testbedCategoryArgString = null;
        String testbedGeniNameArgString = null;
        String testbedNameArgString = null;
        String testbedUrnArgString = null;
        Boolean nextRunArg = null;
        Boolean hasActiveTasksArg = null;
        Boolean enabledArg = null;
        Boolean disabledArg = null;
        List expected = testInstancesTestCollection.getByIds(new Integer[]{9});
        this.testSearch(expected, versionNameArgString, testInstanceNameArgString, testDefinitionNameArgString, testInstanceIdArgString, testbedCategoryArgString, testbedGeniNameArgString, testbedNameArgString, testbedUrnArgString, nextRunArg, hasActiveTasksArg, enabledArg, disabledArg);
    }

    @Test
    public void search4() throws Exception {
        String versionNameArgString = null;
        String testInstanceNameArgString = null;
        String testDefinitionNameArgString = null;
        String testInstanceIdArgString = "9,11";
        String testbedCategoryArgString = null;
        String testbedGeniNameArgString = null;
        String testbedNameArgString = null;
        String testbedUrnArgString = null;
        Boolean nextRunArg = null;
        Boolean hasActiveTasksArg = null;
        Boolean enabledArg = null;
        Boolean disabledArg = null;
        List expected = testInstancesTestCollection.getByIds(new Integer[]{9, 11});
        this.testSearch(expected, versionNameArgString, testInstanceNameArgString, testDefinitionNameArgString, testInstanceIdArgString, testbedCategoryArgString, testbedGeniNameArgString, testbedNameArgString, testbedUrnArgString, nextRunArg, hasActiveTasksArg, enabledArg, disabledArg);
    }

    @Test
    public void search5() throws Exception {
        String versionNameArgString = null;
        String testInstanceNameArgString = null;
        String testDefinitionNameArgString = "anyGetVersion";
        String testInstanceIdArgString = null;
        String testbedCategoryArgString = null;
        String testbedGeniNameArgString = null;
        String testbedNameArgString = null;
        String testbedUrnArgString = null;
        Boolean nextRunArg = null;
        Boolean hasActiveTasksArg = null;
        Boolean enabledArg = null;
        Boolean disabledArg = null;
        List expected = testInstancesTestCollection.getByIds(new Integer[]{10, 12, 13});
        this.testSearch(expected, versionNameArgString, testInstanceNameArgString, testDefinitionNameArgString, testInstanceIdArgString, testbedCategoryArgString, testbedGeniNameArgString, testbedNameArgString, testbedUrnArgString, nextRunArg, hasActiveTasksArg, enabledArg, disabledArg);
    }

    @Test
    public void search6() throws Exception {
        String versionNameArgString = null;
        String testInstanceNameArgString = null;
        String testDefinitionNameArgString = null;
        String testInstanceIdArgString = null;
        String testbedCategoryArgString = null;
        String testbedGeniNameArgString = null;
        String testbedNameArgString = null;
        String testbedUrnArgString = null;
        Boolean nextRunArg = null;
        Boolean hasActiveTasksArg = null;
        Boolean enabledArg = null;
        Boolean disabledArg = true;
        List expected = testInstancesTestCollection.getByIds(new Integer[]{11});
        this.testSearch(expected, versionNameArgString, testInstanceNameArgString, testDefinitionNameArgString, testInstanceIdArgString, testbedCategoryArgString, testbedGeniNameArgString, testbedNameArgString, testbedUrnArgString, nextRunArg, hasActiveTasksArg, enabledArg, disabledArg);
    }

    @Test
    public void search7() throws Exception {
        String versionNameArgString = null;
        String testInstanceNameArgString = null;
        String testDefinitionNameArgString = null;
        String testInstanceIdArgString = null;
        String testbedCategoryArgString = null;
        String testbedGeniNameArgString = null;
        String testbedNameArgString = "A";
        String testbedUrnArgString = null;
        Boolean nextRunArg = null;
        Boolean hasActiveTasksArg = null;
        Boolean enabledArg = null;
        Boolean disabledArg = null;
        List expected = testInstancesTestCollection.getByIds(new Integer[]{9, 12});
        this.testSearch(expected, versionNameArgString, testInstanceNameArgString, testDefinitionNameArgString, testInstanceIdArgString, testbedCategoryArgString, testbedGeniNameArgString, testbedNameArgString, testbedUrnArgString, nextRunArg, hasActiveTasksArg, enabledArg, disabledArg);
    }

    @Test
    public void search8() throws Exception {
        String versionNameArgString = "test";
        String testInstanceNameArgString = null;
        String testDefinitionNameArgString = null;
        String testInstanceIdArgString = null;
        String testbedCategoryArgString = null;
        String testbedGeniNameArgString = null;
        String testbedNameArgString = null;
        String testbedUrnArgString = null;
        Boolean nextRunArg = null;
        Boolean hasActiveTasksArg = null;
        Boolean enabledArg = null;
        Boolean disabledArg = null;
        List expected = testInstancesTestCollection.getByIds(new Integer[]{10, 11});
        this.testSearch(expected, versionNameArgString, testInstanceNameArgString, testDefinitionNameArgString, testInstanceIdArgString, testbedCategoryArgString, testbedGeniNameArgString, testbedNameArgString, testbedUrnArgString, nextRunArg, hasActiveTasksArg, enabledArg, disabledArg);
    }

    @Test
    public void search10() throws Exception {
        String versionNameArgString = null;
        String testInstanceNameArgString = null;
        String testDefinitionNameArgString = null;
        String testInstanceIdArgString = null;
        String testbedCategoryArgString = "oneAndTwo";
        String testbedGeniNameArgString = null;
        String testbedNameArgString = null;
        String testbedUrnArgString = null;
        Boolean nextRunArg = null;
        Boolean hasActiveTasksArg = null;
        Boolean enabledArg = null;
        Boolean disabledArg = null;
        List expected = testInstancesTestCollection.getByIds(new Integer[]{9, 10, 11, 12});
        this.testSearch(expected, versionNameArgString, testInstanceNameArgString, testDefinitionNameArgString, testInstanceIdArgString, testbedCategoryArgString, testbedGeniNameArgString, testbedNameArgString, testbedUrnArgString, nextRunArg, hasActiveTasksArg, enabledArg, disabledArg);
    }

    @Test
    public void search11() throws Exception {
        String versionNameArgString = null;
        String testInstanceNameArgString = null;
        String testDefinitionNameArgString = null;
        String testInstanceIdArgString = null;
        String testbedCategoryArgString = null;
        String testbedGeniNameArgString = "ex-b";
        String testbedNameArgString = null;
        String testbedUrnArgString = null;
        Boolean nextRunArg = null;
        Boolean hasActiveTasksArg = null;
        Boolean enabledArg = null;
        Boolean disabledArg = null;
        List expected = testInstancesTestCollection.getByIds(new Integer[]{10, 11});
        this.testSearch(expected, versionNameArgString, testInstanceNameArgString, testDefinitionNameArgString, testInstanceIdArgString, testbedCategoryArgString, testbedGeniNameArgString, testbedNameArgString, testbedUrnArgString, nextRunArg, hasActiveTasksArg, enabledArg, disabledArg);
    }

    @Test
    public void search12() throws Exception {
        String versionNameArgString = null;
        String testInstanceNameArgString = null;
        String testDefinitionNameArgString = null;
        String testInstanceIdArgString = null;
        String testbedCategoryArgString = null;
        String testbedGeniNameArgString = null;
        String testbedNameArgString = null;
        String testbedUrnArgString = null;
        Boolean nextRunArg = true;
        Boolean hasActiveTasksArg = null;
        Boolean enabledArg = null;
        Boolean disabledArg = null;
        List expected = testInstancesTestCollection.getByIds(new Integer[]{9, 10, 11, 12});
        this.testSearch(expected, versionNameArgString, testInstanceNameArgString, testDefinitionNameArgString, testInstanceIdArgString, testbedCategoryArgString, testbedGeniNameArgString, testbedNameArgString, testbedUrnArgString, nextRunArg, hasActiveTasksArg, enabledArg, disabledArg);
    }

    @Test
    public void search13() throws Exception {
        String versionNameArgString = "prod,test";
        String testInstanceNameArgString = null;
        String testDefinitionNameArgString = "anyGetVersion";
        String testInstanceIdArgString = null;
        String testbedCategoryArgString = "oneAndTwo";
        String testbedGeniNameArgString = "ex-b";
        String testbedNameArgString = "B";
        String testbedUrnArgString = null;
        Boolean nextRunArg = true;
        Boolean hasActiveTasksArg = null;
        Boolean enabledArg = true;
        Boolean disabledArg = false;
        List expected = testInstancesTestCollection.getByIds(new Integer[]{10});
        this.testSearch(expected, versionNameArgString, testInstanceNameArgString, testDefinitionNameArgString, testInstanceIdArgString, testbedCategoryArgString, testbedGeniNameArgString, testbedNameArgString, testbedUrnArgString, nextRunArg, hasActiveTasksArg, enabledArg, disabledArg);
    }

    @Test
    public void search14() throws Exception {
        String versionNameArgString = "prod,test";
        String testInstanceNameArgString = "pingA,pingB,getVersionA,getVersionB,getVersionC,pingC";
        String testDefinitionNameArgString = "anyGetVersion,ping";
        String testInstanceIdArgString = "9,10,11,12,13,14";
        String testbedCategoryArgString = "oneAndTwo,three,all,ALL";
        String testbedGeniNameArgString = "ex-b,ex-a,ex-c";
        String testbedNameArgString = "A,B,C";
        String testbedUrnArgString = null;
        Boolean nextRunArg = true;
        Boolean hasActiveTasksArg = null;
        Boolean enabledArg = null;
        Boolean disabledArg = null;
        List expected = testInstancesTestCollection.getByIds(new Integer[]{9, 10, 11, 12});
        this.testSearch(expected, versionNameArgString, testInstanceNameArgString, testDefinitionNameArgString, testInstanceIdArgString, testbedCategoryArgString, testbedGeniNameArgString, testbedNameArgString, testbedUrnArgString, nextRunArg, hasActiveTasksArg, enabledArg, disabledArg);
    }

    @Test
    public void search15() throws Exception {
        String versionNameArgString = "prod,test";
        String testInstanceNameArgString = "pingA,pingB,getVersionA,getVersionB,getVersionC,pingC";
        String testDefinitionNameArgString = "anyGetVersion,ping";
        String testInstanceIdArgString = "9,10,11,12,13,14";
        String testbedCategoryArgString = null;
        String testbedGeniNameArgString = null;
        String testbedNameArgString = "A,B,C";
        String testbedUrnArgString = null;
        Boolean nextRunArg = null;
        Boolean hasActiveTasksArg = null;
        Boolean enabledArg = null;
        Boolean disabledArg = null;
        List expected = testInstancesTestCollection.getByIds(new Integer[]{9, 10, 11, 12, 13, 14});
        this.testSearch(expected, versionNameArgString, testInstanceNameArgString, testDefinitionNameArgString, testInstanceIdArgString, testbedCategoryArgString, testbedGeniNameArgString, testbedNameArgString, testbedUrnArgString, nextRunArg, hasActiveTasksArg, enabledArg, disabledArg);
    }

    @Test
    public void search16() throws Exception {
        String versionNameArgString = null;
        String testInstanceNameArgString = null;
        String testDefinitionNameArgString = null;
        String testInstanceIdArgString = null;
        String testbedCategoryArgString = null;
        String testbedGeniNameArgString = null;
        String testbedNameArgString = null;
        String testbedUrnArgString = "urn:publicid:IDN+b.example.com+authority+cm";
        Boolean nextRunArg = null;
        Boolean hasActiveTasksArg = null;
        Boolean enabledArg = null;
        Boolean disabledArg = null;
        List expected = testInstancesTestCollection.getByIds(new Integer[]{10, 11});
        this.testSearch(expected, versionNameArgString, testInstanceNameArgString, testDefinitionNameArgString, testInstanceIdArgString, testbedCategoryArgString, testbedGeniNameArgString, testbedNameArgString, testbedUrnArgString, nextRunArg, hasActiveTasksArg, enabledArg, disabledArg);
    }

    @Test
    public void search17() throws Exception {
        String versionNameArgString = null;
        String testInstanceNameArgString = null;
        String testDefinitionNameArgString = null;
        String testInstanceIdArgString = null;
        String testbedCategoryArgString = null;
        String testbedGeniNameArgString = null;
        String testbedNameArgString = null;
        String testbedUrnArgString = "urn:publicid:IDN+b.example.com+authority+cm,urn:publicid:IDN+a.example.com+authority+cm";
        Boolean nextRunArg = null;
        Boolean hasActiveTasksArg = null;
        Boolean enabledArg = null;
        Boolean disabledArg = null;
        List expected = testInstancesTestCollection.getByIds(new Integer[]{9, 10, 11, 12});
        this.testSearch(expected, versionNameArgString, testInstanceNameArgString, testDefinitionNameArgString, testInstanceIdArgString, testbedCategoryArgString, testbedGeniNameArgString, testbedNameArgString, testbedUrnArgString, nextRunArg, hasActiveTasksArg, enabledArg, disabledArg);
    }

    @Test
    public void search18() throws Exception {
        String versionNameArgString = null;
        String testInstanceNameArgString = null;
        String testDefinitionNameArgString = null;
        String testInstanceIdArgString = null;
        String testbedCategoryArgString = null;
        String testbedGeniNameArgString = null;
        String testbedNameArgString = null;
        String testbedUrnArgString = null;
        Boolean nextRunArg = null;
        Boolean hasActiveTasksArg = true;
        Boolean enabledArg = null;
        Boolean disabledArg = null;
        List expected = testInstancesTestCollection.getByIds(new Integer[]{9, 10});
        this.testSearch(expected, versionNameArgString, testInstanceNameArgString, testDefinitionNameArgString, testInstanceIdArgString, testbedCategoryArgString, testbedGeniNameArgString, testbedNameArgString, testbedUrnArgString, nextRunArg, hasActiveTasksArg, enabledArg, disabledArg);
    }

    @Test
    public void search19() throws Exception {
        String versionNameArgString = null;
        String testInstanceNameArgString = null;
        String testDefinitionNameArgString = null;
        String testInstanceIdArgString = null;
        String testbedCategoryArgString = null;
        String testbedGeniNameArgString = null;
        String testbedNameArgString = null;
        String testbedUrnArgString = null;
        Boolean nextRunArg = null;
        Boolean hasActiveTasksArg = false;
        Boolean enabledArg = null;
        Boolean disabledArg = null;
        List expected = testInstancesTestCollection.getByIds(new Integer[]{11, 12, 13, 14});
        this.testSearch(expected, versionNameArgString, testInstanceNameArgString, testDefinitionNameArgString, testInstanceIdArgString, testbedCategoryArgString, testbedGeniNameArgString, testbedNameArgString, testbedUrnArgString, nextRunArg, hasActiveTasksArg, enabledArg, disabledArg);
    }

    public TestInstance createTestInstancesCall(TestInstance testInstance) throws Exception {
        JerseyWebTarget w = this.client.target(String.format("http://localhost:%d/testinstance/", RULE.getLocalPort()));
        Entity entity = Entity.entity((Object)testInstance, (MediaType)MediaType.APPLICATION_JSON_TYPE);
        TestInstance res = (TestInstance)w.request().post(entity, TestInstance.class);
        return res;
    }

    public TestInstance updateTestInstancesCall(TestInstance testInstance) throws Exception {
        JerseyWebTarget w = this.client.target(String.format("http://localhost:%d/testinstance/" + testInstance.getId(), RULE.getLocalPort()));
        Entity entity = Entity.entity((Object)testInstance, (MediaType)MediaType.APPLICATION_JSON_TYPE);
        TestInstance res = (TestInstance)w.request().put(entity, TestInstance.class);
        return res;
    }

    public void deleteTestInstance(TestInstance testInstance) throws Exception {
        JerseyWebTarget w = this.client.target(String.format("http://localhost:%d/testinstance/" + testInstance.getId(), RULE.getLocalPort()));
        w.request().delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInsert() throws Exception {
        TestDefinition testDefinitionGetVersion = (TestDefinition)testDefinitionsTestCollection.getByIndex(1);
        Frequency testFrequencyA = (Frequency)frequencyTestCollection.getByIndex(0);
        Testbed testbedA = (Testbed)testbedTestCollection.getByIndex(0);
        User userA = (User)userTestCollection.getByIndex(0);
        TestInstance newTestInstance = new TestInstanceBuilder().setTestDefinition(testDefinitionGetVersion).setTestVersion("test").setEnabled(Boolean.valueOf(true)).setFrequency(testFrequencyA).setName("New For Test").setServerParameter((Server)testbedA.getServers().get(0)).setUserParameter(userA).addParameter("am_version", "3").addParameter("context-file", "dummy context file").create();
        TestInstance actualCreatedTestInstance = this.createTestInstancesCall(newTestInstance);
        try {
            System.out.println("Got inserted testInstance: " + actualCreatedTestInstance);
            System.out.flush();
            MatcherAssert.assertThat((String)"id of created testInstance is null", (Object)((Integer)actualCreatedTestInstance.getId()), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            TestInstance expectedTestInstance = ((TestInstanceBuilder)new TestInstanceBuilder(newTestInstance).setId((Object)((Integer)actualCreatedTestInstance.getId()))).create();
            MatcherAssert.assertThat((String)"URI of created testInstance is null", (Object)actualCreatedTestInstance.getUri(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            testInstancesTestCollection.assertSameAndExpectActualHasUri((JsonLdObjectWithId)actualCreatedTestInstance, (JsonLdObjectWithId)expectedTestInstance, true);
            MatcherAssert.assertThat((Object)actualCreatedTestInstance.getTestDefinitionId(), (Matcher)Matchers.is((Object)((String)testDefinitionGetVersion.getId())));
            MatcherAssert.assertThat((Object)actualCreatedTestInstance.getServerParameter(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            MatcherAssert.assertThat((Object)((Integer)actualCreatedTestInstance.getServerParameter().getId()), (Matcher)Matchers.is((Object)((Integer)((Server)testbedA.getServers().get(0)).getId())));
            MatcherAssert.assertThat((Object)actualCreatedTestInstance.getUserParameter(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            MatcherAssert.assertThat((Object)((String)actualCreatedTestInstance.getUserParameter().getId()), (Matcher)Matchers.is((Object)((String)userA.getId())));
            TestInstance lookedUpTestInstance = this.doLookup((Integer)actualCreatedTestInstance.getId());
            testInstancesTestCollection.assertSameAndExpectActualHasUri((JsonLdObjectWithId)lookedUpTestInstance, (JsonLdObjectWithId)expectedTestInstance, true);
            MatcherAssert.assertThat((Object)lookedUpTestInstance.getTestDefinitionId(), (Matcher)Matchers.is((Object)((String)testDefinitionGetVersion.getId())));
            MatcherAssert.assertThat((Object)actualCreatedTestInstance.getServerParameter(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            MatcherAssert.assertThat((Object)((Integer)actualCreatedTestInstance.getServerParameter().getId()), (Matcher)Matchers.is((Object)((Integer)((Server)testbedA.getServers().get(0)).getId())));
            MatcherAssert.assertThat((Object)actualCreatedTestInstance.getUserParameter(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            MatcherAssert.assertThat((Object)((String)actualCreatedTestInstance.getUserParameter().getId()), (Matcher)Matchers.is((Object)((String)userA.getId())));
        }
        finally {
            this.deleteTestInstance(actualCreatedTestInstance);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpdate() throws Exception {
        Frequency frequency2 = (Frequency)frequencyTestCollection.getByIndex(1);
        TestDefinition getVersionTestDefinition = new TestDefinitionBuilder((TestDefinition)testDefinitionsTestCollection.getById("anyGetVersion")).createMinimized(JsonLdObjectsMetaData.Minimization.ID_ONLY);
        User failUser = (User)userTestCollection.getById("fail-b");
        assert (failUser != null);
        TestInstance origTestInstance = (TestInstance)testInstancesTestCollection.getByIndex(0);
        TestInstanceBuilder updatedTestInstanceBuilder = new TestInstanceBuilder(origTestInstance);
        updatedTestInstanceBuilder.setEnabled(Boolean.valueOf(origTestInstance.getEnabled() == false));
        updatedTestInstanceBuilder.setName(origTestInstance.getName() + "updated");
        updatedTestInstanceBuilder.setTestVersion(origTestInstance.getTestVersion() + "up");
        updatedTestInstanceBuilder.setFrequency(frequency2);
        updatedTestInstanceBuilder.setTestDefinition(getVersionTestDefinition);
        updatedTestInstanceBuilder.setServerParameter((Server)((Testbed)testbedTestCollection.getById("B")).getServers().get(0));
        updatedTestInstanceBuilder.setUserParameter(failUser);
        assert (updatedTestInstanceBuilder.getParameters().containsKey("user"));
        assert (Objects.equals(updatedTestInstanceBuilder.getUserParameter().getId(), failUser.getId()));
        HashMap<String, String> parameters = new HashMap<String, String>(origTestInstance.getParametersExceptServerAndUser());
        parameters.remove("use_proxy");
        parameters.put("alternative_test_class", "blah");
        updatedTestInstanceBuilder.setParametersExceptServerAndUser(parameters);
        assert (updatedTestInstanceBuilder.getParameters().containsKey("server"));
        assert (updatedTestInstanceBuilder.getParameters().containsKey("user"));
        assert (((String)updatedTestInstanceBuilder.getUserParameter().getId()).equals(failUser.getId()));
        assert (((Integer)updatedTestInstanceBuilder.getServerParameter().getId()).equals(((Server)((Testbed)testbedTestCollection.getById("B")).getServers().get(0)).getId()));
        TestInstance expectedUpdatedTestInstance = updatedTestInstanceBuilder.create();
        assert (expectedUpdatedTestInstance.getTestDefinitionId().equals(getVersionTestDefinition.getId())) : "expectedUpdatedTestInstance.getTestDefinitionId()=" + expectedUpdatedTestInstance.getTestDefinitionId();
        assert (expectedUpdatedTestInstance.getUserIdParameter() != null);
        assert (expectedUpdatedTestInstance.getServerIdParameter() != null);
        assert (expectedUpdatedTestInstance.getParameters().containsKey("server"));
        assert (expectedUpdatedTestInstance.getParameters().containsKey("user"));
        try {
            TestInstance actualUpdatedTestInstance = this.updateTestInstancesCall(expectedUpdatedTestInstance);
            System.out.println("Got updated testInstance: " + actualUpdatedTestInstance);
            System.out.flush();
            MatcherAssert.assertThat((String)"id of updated testInstance is null", (Object)((Integer)actualUpdatedTestInstance.getId()), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            MatcherAssert.assertThat((String)"URI of updated testInstance is null", (Object)actualUpdatedTestInstance.getUri(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            testInstancesTestCollection.assertSameAndExpectActualHasUri((JsonLdObjectWithId)actualUpdatedTestInstance, (JsonLdObjectWithId)expectedUpdatedTestInstance, true);
            MatcherAssert.assertThat((Object)actualUpdatedTestInstance.getTestDefinitionId(), (Matcher)Matchers.is((Object)expectedUpdatedTestInstance.getTestDefinitionId()));
            assert (expectedUpdatedTestInstance.getServerIdParameter() != null);
            MatcherAssert.assertThat((Object)actualUpdatedTestInstance.getServerParameter(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            MatcherAssert.assertThat((Object)((Integer)actualUpdatedTestInstance.getServerParameter().getId()), (Matcher)Matchers.is((Object)expectedUpdatedTestInstance.getServerIdParameter()));
            MatcherAssert.assertThat((Object)actualUpdatedTestInstance.getUserParameter(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            MatcherAssert.assertThat((Object)((String)actualUpdatedTestInstance.getUserParameter().getId()), (Matcher)Matchers.is((Object)expectedUpdatedTestInstance.getUserIdParameter()));
            TestInstance lookedUpTestInstance = this.doLookup((Integer)actualUpdatedTestInstance.getId());
            testInstancesTestCollection.assertSameAndExpectActualHasUri((JsonLdObjectWithId)lookedUpTestInstance, (JsonLdObjectWithId)expectedUpdatedTestInstance, true);
            MatcherAssert.assertThat((Object)lookedUpTestInstance.getTestDefinitionId(), (Matcher)Matchers.is((Object)expectedUpdatedTestInstance.getTestDefinitionId()));
            MatcherAssert.assertThat((Object)lookedUpTestInstance.getServerParameter(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            MatcherAssert.assertThat((Object)((Integer)lookedUpTestInstance.getServerParameter().getId()), (Matcher)Matchers.is((Object)expectedUpdatedTestInstance.getServerIdParameter()));
            MatcherAssert.assertThat((Object)lookedUpTestInstance.getUserParameter(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            MatcherAssert.assertThat((Object)((String)lookedUpTestInstance.getUserParameter().getId()), (Matcher)Matchers.is((Object)expectedUpdatedTestInstance.getUserIdParameter()));
        }
        finally {
            FedmonTestPostgresDB testPostgresDB = new FedmonTestPostgresDB(this.getRule());
            testPostgresDB.recreateDB();
            testPostgresDB.close();
        }
    }
}

