/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.test;

import be.iminds.ilabt.jfed.fedmon.util.Clock;
import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonWebApiServiceApplication;
import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonWebApiServiceConfiguration;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestInstanceStatistics;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestInstanceStatisticsBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.FedmonTestPostgresDB;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.FrequencyTestCollection;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.TestDefinitionsTestCollection;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.TestInstancesStatisticsTestCollection;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.TestInstancesTestCollection;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.TestbedTestCollection;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.UserTestCollection;
import be.iminds.ilabt.util.jsonld.iface.JsonLdObject;
import be.iminds.ilabt.util.jsonld.test.CommonTest;
import io.dropwizard.testing.ConfigOverride;
import io.dropwizard.testing.junit.DropwizardAppRule;
import java.sql.Timestamp;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import org.glassfish.jersey.client.JerseyClient;
import org.glassfish.jersey.client.JerseyClientBuilder;
import org.glassfish.jersey.client.JerseyWebTarget;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

public class TestInstanceStatisticsIntegrationTest {
    @ClassRule
    public static final DropwizardAppRule<FedmonWebApiServiceConfiguration> RULE = new DropwizardAppRule(FedmonWebApiServiceApplication.class, "../fedmon-webapi-service-TESTING.yml", new ConfigOverride[0]);
    protected static TestbedTestCollection testbedTestCollection;
    protected static TestInstancesTestCollection testInstancesTestCollection;
    protected static TestInstancesStatisticsTestCollection testInstancesStatisticsTestCollection;
    protected static TestDefinitionsTestCollection testDefinitionsTestCollection;
    protected static FrequencyTestCollection frequencyTestCollection;
    protected static UserTestCollection userTestCollection;
    protected JerseyClient client;
    protected static Clock.DefaultTestTimeProvider timeProvider;

    @BeforeClass
    public static void setUp() throws Exception {
        TestInstanceStatisticsIntegrationTest.setUp(RULE);
    }

    public static void setUp(DropwizardAppRule<FedmonWebApiServiceConfiguration> RULE) throws Exception {
        timeProvider = new Clock.DefaultTestTimeProvider();
        Clock.set((Clock.CurrentTimeProvider)timeProvider);
        assert (RULE != null);
        FedmonTestPostgresDB testPostgresDB = new FedmonTestPostgresDB(RULE);
        testPostgresDB.recreateDB();
        testPostgresDB.close();
        testInstancesTestCollection = new TestInstancesTestCollection();
        testInstancesStatisticsTestCollection = new TestInstancesStatisticsTestCollection();
        testDefinitionsTestCollection = new TestDefinitionsTestCollection();
        frequencyTestCollection = new FrequencyTestCollection();
        testbedTestCollection = new TestbedTestCollection();
        userTestCollection = new UserTestCollection();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        Clock.reset();
    }

    @Before
    public void beforeMethod() throws Exception {
        this.client = new JerseyClientBuilder().build();
        assert (this.client != null);
        timeProvider.setNowOffsetMinutes(0L);
    }

    public void testSearch(List<TestInstanceStatistics> expected, String versionNameArgString, String testInstanceNameArgString, String testDefinitionNameArgString, String testInstanceIdArgString, String testbedCategoryArgString, String testbedGeniNameArgString, String testbedNameArgString, String testbedUrnArgString, Boolean nextRunArg, Boolean hasActiveTasksArg, Boolean enabledArg, Boolean disabledArg) throws Exception {
        List<TestInstanceStatistics> actual = this.doSearch(versionNameArgString, testInstanceNameArgString, testDefinitionNameArgString, testInstanceIdArgString, testbedCategoryArgString, testbedGeniNameArgString, testbedNameArgString, testbedUrnArgString, nextRunArg, hasActiveTasksArg, enabledArg, disabledArg);
        this.checkSearch(expected, actual);
    }

    public List<TestInstanceStatistics> doSearch(String versionNameArgString, String testInstanceNameArgString, String testDefinitionNameArgString, String testInstanceIdArgString, String testbedCategoryArgString, String testbedGeniNameArgString, String testbedNameArgString, String testbedUrnArgString, Boolean nextRunArg, Boolean hasActiveTasksArg, Boolean enabledArg, Boolean disabledArg) throws Exception {
        assert (this.client != null);
        JerseyWebTarget query = this.client.target(String.format("http://localhost:%d/testinstancestatistics/", RULE.getLocalPort()));
        if (versionNameArgString != null) {
            query = query.queryParam("testversionname", new Object[]{versionNameArgString});
        }
        if (testInstanceNameArgString != null) {
            query = query.queryParam("testname", new Object[]{testInstanceNameArgString});
        }
        if (testDefinitionNameArgString != null) {
            query = query.queryParam("testdefinitionname", new Object[]{testDefinitionNameArgString});
        }
        if (testInstanceIdArgString != null) {
            query = query.queryParam("testinstanceid", new Object[]{testInstanceIdArgString});
        }
        if (testbedCategoryArgString != null) {
            query = query.queryParam("testbedcategory", new Object[]{testbedCategoryArgString});
        }
        if (testbedGeniNameArgString != null) {
            query = query.queryParam("geni_testbed", new Object[]{testbedGeniNameArgString});
        }
        if (testbedUrnArgString != null) {
            query = query.queryParam("testbed_urn", new Object[]{testbedUrnArgString});
        }
        if (testbedNameArgString != null) {
            query = query.queryParam("testbed", new Object[]{testbedNameArgString});
        }
        if (nextRunArg != null) {
            query = query.queryParam("nextrun", new Object[]{nextRunArg});
        }
        if (hasActiveTasksArg != null) {
            query = query.queryParam("activeTasks", new Object[]{hasActiveTasksArg});
        }
        if (enabledArg != null) {
            query = query.queryParam("enabled", new Object[]{enabledArg});
        }
        if (disabledArg != null) {
            query = query.queryParam("disabled", new Object[]{disabledArg});
        }
        System.out.println("Searching with URI " + query.getUri().toASCIIString());
        List actual = (List)query.request().get((GenericType)new GenericType<List<TestInstanceStatistics>>(){});
        System.out.println("Got " + actual.size() + " testInstanceStatistics. Id's: " + actual.stream().map(TestInstanceStatistics::getTestInstanceId).collect(Collectors.toList()));
        return actual;
    }

    public void checkSearch(List<TestInstanceStatistics> expected, List<TestInstanceStatistics> actual) {
        MatcherAssert.assertThat(actual, (Matcher)Matchers.hasSize((int)expected.size()));
        for (TestInstanceStatistics ex : expected) {
            TestInstanceStatistics ac = TestInstancesStatisticsTestCollection.searchListByTestInstanceId(actual, ex.getTestInstanceId());
            MatcherAssert.assertThat((String)("Expected id " + ex.getTestInstanceId() + " not found in result"), (Object)ac, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            testInstancesStatisticsTestCollection.assertSame((JsonLdObject)ac, (JsonLdObject)ex, CommonTest.ComparePrecision.FULL, CommonTest.ComparePrecision.ID_AND_REFS_ONLY);
            if (ex.getActiveTaskId() != null) {
                MatcherAssert.assertThat((Object)ac.getActiveTaskUri(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            }
            if (ex.getLastResultInfo("any") != null) {
                MatcherAssert.assertThat((Object)ac.getLastResultInfo("any").getResultUri(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            }
            if (ex.getLastResultInfo("anyButCancelled") == null) continue;
            MatcherAssert.assertThat((Object)ac.getLastResultInfo("anyButCancelled").getResultUri(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        }
    }

    public void testLookup(TestInstanceStatistics expected, int id) throws Exception {
        TestInstanceStatistics actual = this.doLookup(id);
        this.checkLookup(expected, actual);
    }

    public TestInstanceStatistics doLookup(int id) throws Exception {
        assert (this.client != null);
        JerseyWebTarget query = this.client.target(String.format("http://localhost:%d/testinstancestatistics/" + id, RULE.getLocalPort()));
        TestInstanceStatistics actual = (TestInstanceStatistics)query.request().get(TestInstanceStatistics.class);
        System.out.println("Got result TestInstance: " + actual);
        return actual;
    }

    public void checkLookup(TestInstanceStatistics expected, TestInstanceStatistics actual) {
        testInstancesStatisticsTestCollection.assertSame((JsonLdObject)actual, (JsonLdObject)expected, CommonTest.ComparePrecision.FULL, CommonTest.ComparePrecision.ID_AND_REFS_ONLY);
        if (expected.getActiveTaskId() != null) {
            MatcherAssert.assertThat((Object)actual.getActiveTaskUri(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        }
        if (expected.getLastResultInfo("any") != null) {
            MatcherAssert.assertThat((Object)actual.getLastResultInfo("any").getResultUri(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        }
        if (expected.getLastResultInfo("anyButCancelled") != null) {
            MatcherAssert.assertThat((Object)actual.getLastResultInfo("anyButCancelled").getResultUri(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        }
    }

    public TestInstanceStatistics doUpdateNextRun(int id, Timestamp nextRun) throws Exception {
        assert (this.client != null);
        JerseyWebTarget query = this.client.target(String.format("http://localhost:%d/testinstancestatistics/" + id, RULE.getLocalPort()));
        TestInstanceStatistics patch = new TestInstanceStatisticsBuilder().setNextRun(nextRun).create();
        TestInstanceStatistics actual = (TestInstanceStatistics)query.request().put(Entity.entity((Object)patch, (MediaType)MediaType.APPLICATION_JSON_TYPE), TestInstanceStatistics.class);
        System.out.println("Got result TestInstance: " + actual);
        return actual;
    }

    public void testUpdateRunNext(TestInstanceStatistics target, Timestamp nextRun) throws Exception {
        TestInstanceStatisticsBuilder expected = new TestInstanceStatisticsBuilder(target);
        expected.setNextRun(nextRun);
        TestInstanceStatistics patchRes = this.doUpdateNextRun(target.getTestInstanceId(), nextRun);
        this.checkLookup(expected.create(), patchRes);
        this.testLookup(expected.create(), target.getTestInstanceId());
    }

    @Test
    public void testUpdateRunNext0() throws Exception {
        TestInstanceStatistics target = (TestInstanceStatistics)testInstancesStatisticsTestCollection.getByIndex(0);
        timeProvider.setNowOffsetMinutes(-7L);
        Timestamp nextRun = Clock.nowTimestamp();
        this.testUpdateRunNext(target, nextRun);
        this.testUpdateRunNext(target, target.getNextRun());
    }

    @Test
    public void testUpdateRunNext1() throws Exception {
        TestInstanceStatistics target = (TestInstanceStatistics)testInstancesStatisticsTestCollection.getByIndex(0);
        timeProvider.setNowOffsetMinutes(-7L);
        Timestamp nextRun = Clock.nowTimestamp();
        timeProvider.relativeNowOffsetMinutes(1L);
        this.testUpdateRunNext(target, nextRun);
        this.testUpdateRunNext(target, target.getNextRun());
    }

    @Test
    public void testUpdateRunNext2() throws Exception {
        TestInstanceStatistics target = (TestInstanceStatistics)testInstancesStatisticsTestCollection.getByIndex(0);
        timeProvider.setNowOffsetMinutes(-7L);
        Timestamp nextRun = Clock.nowTimestamp();
        timeProvider.relativeNowOffsetMinutes(-1L);
        this.testUpdateRunNext(target, nextRun);
        this.testUpdateRunNext(target, target.getNextRun());
    }

    @Test
    public void testUpdateRunNext3() throws Exception {
        TestInstanceStatistics target = (TestInstanceStatistics)testInstancesStatisticsTestCollection.getByIndex(0);
        timeProvider.setNowOffsetMinutes(-7L);
        Timestamp nextRun = new Timestamp(Clock.currentTimeMillis() + 432000000L);
        this.testUpdateRunNext(target, nextRun);
        this.testUpdateRunNext(target, target.getNextRun());
    }

    @Test
    public void lookup0() throws Exception {
        TestInstanceStatistics expected = (TestInstanceStatistics)testInstancesStatisticsTestCollection.getByIndex(0);
        timeProvider.setNowOffsetMinutes(-7L);
        this.testLookup(expected, expected.getTestInstanceId());
    }

    @Test
    public void lookup0expired() throws Exception {
        TestInstanceStatisticsBuilder expected = new TestInstanceStatisticsBuilder((TestInstanceStatistics)testInstancesStatisticsTestCollection.getByIndex(0));
        expected.setActiveTask((Long)null);
        timeProvider.setNowOffsetMinutes(20L);
        this.testLookup(expected.create(), expected.getTestInstanceId());
    }

    @Test
    public void lookup1() throws Exception {
        TestInstanceStatistics expected = (TestInstanceStatistics)testInstancesStatisticsTestCollection.getByIndex(1);
        timeProvider.setNowOffsetMinutes(-7L);
        this.testLookup(expected, expected.getTestInstanceId());
    }

    @Test
    public void lookup1expired() throws Exception {
        TestInstanceStatisticsBuilder expected = new TestInstanceStatisticsBuilder((TestInstanceStatistics)testInstancesStatisticsTestCollection.getByIndex(1));
        expected.setActiveTask((Long)null);
        timeProvider.setNowOffsetMinutes(20L);
        this.testLookup(expected.create(), expected.getTestInstanceId());
    }

    @Test
    public void lookup2() throws Exception {
        TestInstanceStatistics expected = (TestInstanceStatistics)testInstancesStatisticsTestCollection.getByIndex(2);
        timeProvider.setNowOffsetMinutes(-7L);
        this.testLookup(expected, expected.getTestInstanceId());
    }

    @Test
    public void lookup3() throws Exception {
        TestInstanceStatistics expected = (TestInstanceStatistics)testInstancesStatisticsTestCollection.getByIndex(3);
        timeProvider.setNowOffsetMinutes(-7L);
        this.testLookup(expected, expected.getTestInstanceId());
    }

    @Test
    public void lookup4() throws Exception {
        TestInstanceStatistics expected = (TestInstanceStatistics)testInstancesStatisticsTestCollection.getByIndex(4);
        timeProvider.setNowOffsetMinutes(-7L);
        this.testLookup(expected, expected.getTestInstanceId());
    }

    @Test
    public void lookup5() throws Exception {
        TestInstanceStatistics expected = (TestInstanceStatistics)testInstancesStatisticsTestCollection.getByIndex(5);
        timeProvider.setNowOffsetMinutes(-7L);
        this.testLookup(expected, expected.getTestInstanceId());
    }

    @Test
    public void search1() throws Exception {
        String versionNameArgString = null;
        String testInstanceNameArgString = null;
        String testDefinitionNameArgString = null;
        String testInstanceIdArgString = null;
        String testbedCategoryArgString = null;
        String testbedGeniNameArgString = null;
        String testbedNameArgString = null;
        String testbedUrnArgString = null;
        Boolean nextRunArg = null;
        Boolean hasActiveTasksArg = null;
        Boolean enabledArg = null;
        Boolean disabledArg = null;
        timeProvider.setNowOffsetMinutes(-7L);
        List expected = testInstancesStatisticsTestCollection.getAll();
        this.testSearch(expected, versionNameArgString, testInstanceNameArgString, testDefinitionNameArgString, testInstanceIdArgString, testbedCategoryArgString, testbedGeniNameArgString, testbedNameArgString, testbedUrnArgString, nextRunArg, hasActiveTasksArg, enabledArg, disabledArg);
    }

    @Test
    public void search2() throws Exception {
        String versionNameArgString = "";
        String testInstanceNameArgString = "";
        String testDefinitionNameArgString = "";
        String testInstanceIdArgString = "";
        String testbedCategoryArgString = "";
        String testbedGeniNameArgString = "";
        String testbedNameArgString = null;
        String testbedUrnArgString = null;
        Boolean nextRunArg = null;
        Boolean hasActiveTasksArg = null;
        Boolean enabledArg = null;
        Boolean disabledArg = null;
        timeProvider.setNowOffsetMinutes(-7L);
        List expected = testInstancesStatisticsTestCollection.getAll();
        this.testSearch(expected, versionNameArgString, testInstanceNameArgString, testDefinitionNameArgString, testInstanceIdArgString, testbedCategoryArgString, testbedGeniNameArgString, testbedNameArgString, testbedUrnArgString, nextRunArg, hasActiveTasksArg, enabledArg, disabledArg);
    }

    @Test
    public void search3() throws Exception {
        String versionNameArgString = null;
        String testInstanceNameArgString = null;
        String testDefinitionNameArgString = null;
        String testInstanceIdArgString = "9";
        String testbedCategoryArgString = null;
        String testbedGeniNameArgString = null;
        String testbedNameArgString = null;
        String testbedUrnArgString = null;
        Boolean nextRunArg = null;
        Boolean hasActiveTasksArg = null;
        Boolean enabledArg = null;
        Boolean disabledArg = null;
        timeProvider.setNowOffsetMinutes(-7L);
        List<TestInstanceStatistics> expected = testInstancesStatisticsTestCollection.getByTestInstanceIds(9);
        this.testSearch(expected, versionNameArgString, testInstanceNameArgString, testDefinitionNameArgString, testInstanceIdArgString, testbedCategoryArgString, testbedGeniNameArgString, testbedNameArgString, testbedUrnArgString, nextRunArg, hasActiveTasksArg, enabledArg, disabledArg);
    }

    @Test
    public void search4() throws Exception {
        String versionNameArgString = null;
        String testInstanceNameArgString = null;
        String testDefinitionNameArgString = null;
        String testInstanceIdArgString = "9,11";
        String testbedCategoryArgString = null;
        String testbedGeniNameArgString = null;
        String testbedNameArgString = null;
        String testbedUrnArgString = null;
        Boolean nextRunArg = null;
        Boolean hasActiveTasksArg = null;
        Boolean enabledArg = null;
        Boolean disabledArg = null;
        timeProvider.setNowOffsetMinutes(-7L);
        List<TestInstanceStatistics> expected = testInstancesStatisticsTestCollection.getByTestInstanceIds(9, 11);
        this.testSearch(expected, versionNameArgString, testInstanceNameArgString, testDefinitionNameArgString, testInstanceIdArgString, testbedCategoryArgString, testbedGeniNameArgString, testbedNameArgString, testbedUrnArgString, nextRunArg, hasActiveTasksArg, enabledArg, disabledArg);
    }

    @Test
    public void search5() throws Exception {
        String versionNameArgString = null;
        String testInstanceNameArgString = null;
        String testDefinitionNameArgString = "anyGetVersion";
        String testInstanceIdArgString = null;
        String testbedCategoryArgString = null;
        String testbedGeniNameArgString = null;
        String testbedNameArgString = null;
        String testbedUrnArgString = null;
        Boolean nextRunArg = null;
        Boolean hasActiveTasksArg = null;
        Boolean enabledArg = null;
        Boolean disabledArg = null;
        timeProvider.setNowOffsetMinutes(-7L);
        List<TestInstanceStatistics> expected = testInstancesStatisticsTestCollection.getByTestInstanceIds(10, 12, 13);
        this.testSearch(expected, versionNameArgString, testInstanceNameArgString, testDefinitionNameArgString, testInstanceIdArgString, testbedCategoryArgString, testbedGeniNameArgString, testbedNameArgString, testbedUrnArgString, nextRunArg, hasActiveTasksArg, enabledArg, disabledArg);
    }

    @Test
    public void search6() throws Exception {
        String versionNameArgString = null;
        String testInstanceNameArgString = null;
        String testDefinitionNameArgString = null;
        String testInstanceIdArgString = null;
        String testbedCategoryArgString = null;
        String testbedGeniNameArgString = null;
        String testbedNameArgString = null;
        String testbedUrnArgString = null;
        Boolean nextRunArg = null;
        Boolean hasActiveTasksArg = null;
        Boolean enabledArg = null;
        Boolean disabledArg = true;
        timeProvider.setNowOffsetMinutes(-7L);
        List<TestInstanceStatistics> expected = testInstancesStatisticsTestCollection.getByTestInstanceIds(11);
        this.testSearch(expected, versionNameArgString, testInstanceNameArgString, testDefinitionNameArgString, testInstanceIdArgString, testbedCategoryArgString, testbedGeniNameArgString, testbedNameArgString, testbedUrnArgString, nextRunArg, hasActiveTasksArg, enabledArg, disabledArg);
    }

    @Test
    public void search7() throws Exception {
        String versionNameArgString = null;
        String testInstanceNameArgString = null;
        String testDefinitionNameArgString = null;
        String testInstanceIdArgString = null;
        String testbedCategoryArgString = null;
        String testbedGeniNameArgString = null;
        String testbedNameArgString = "A";
        String testbedUrnArgString = null;
        Boolean nextRunArg = null;
        Boolean hasActiveTasksArg = null;
        Boolean enabledArg = null;
        Boolean disabledArg = null;
        timeProvider.setNowOffsetMinutes(-7L);
        List<TestInstanceStatistics> expected = testInstancesStatisticsTestCollection.getByTestInstanceIds(9, 12);
        this.testSearch(expected, versionNameArgString, testInstanceNameArgString, testDefinitionNameArgString, testInstanceIdArgString, testbedCategoryArgString, testbedGeniNameArgString, testbedNameArgString, testbedUrnArgString, nextRunArg, hasActiveTasksArg, enabledArg, disabledArg);
    }

    @Test
    public void search8() throws Exception {
        String versionNameArgString = "test";
        String testInstanceNameArgString = null;
        String testDefinitionNameArgString = null;
        String testInstanceIdArgString = null;
        String testbedCategoryArgString = null;
        String testbedGeniNameArgString = null;
        String testbedNameArgString = null;
        String testbedUrnArgString = null;
        Boolean nextRunArg = null;
        Boolean hasActiveTasksArg = null;
        Boolean enabledArg = null;
        Boolean disabledArg = null;
        timeProvider.setNowOffsetMinutes(-7L);
        List<TestInstanceStatistics> expected = testInstancesStatisticsTestCollection.getByTestInstanceIds(10, 11);
        this.testSearch(expected, versionNameArgString, testInstanceNameArgString, testDefinitionNameArgString, testInstanceIdArgString, testbedCategoryArgString, testbedGeniNameArgString, testbedNameArgString, testbedUrnArgString, nextRunArg, hasActiveTasksArg, enabledArg, disabledArg);
    }

    @Test
    public void search10() throws Exception {
        String versionNameArgString = null;
        String testInstanceNameArgString = null;
        String testDefinitionNameArgString = null;
        String testInstanceIdArgString = null;
        String testbedCategoryArgString = "oneAndTwo";
        String testbedGeniNameArgString = null;
        String testbedNameArgString = null;
        String testbedUrnArgString = null;
        Boolean nextRunArg = null;
        Boolean hasActiveTasksArg = null;
        Boolean enabledArg = null;
        Boolean disabledArg = null;
        timeProvider.setNowOffsetMinutes(-7L);
        List<TestInstanceStatistics> expected = testInstancesStatisticsTestCollection.getByTestInstanceIds(9, 10, 11, 12);
        this.testSearch(expected, versionNameArgString, testInstanceNameArgString, testDefinitionNameArgString, testInstanceIdArgString, testbedCategoryArgString, testbedGeniNameArgString, testbedNameArgString, testbedUrnArgString, nextRunArg, hasActiveTasksArg, enabledArg, disabledArg);
    }

    @Test
    public void search11() throws Exception {
        String versionNameArgString = null;
        String testInstanceNameArgString = null;
        String testDefinitionNameArgString = null;
        String testInstanceIdArgString = null;
        String testbedCategoryArgString = null;
        String testbedGeniNameArgString = "ex-b";
        String testbedNameArgString = null;
        String testbedUrnArgString = null;
        Boolean nextRunArg = null;
        Boolean hasActiveTasksArg = null;
        Boolean enabledArg = null;
        Boolean disabledArg = null;
        timeProvider.setNowOffsetMinutes(-7L);
        List<TestInstanceStatistics> expected = testInstancesStatisticsTestCollection.getByTestInstanceIds(10, 11);
        this.testSearch(expected, versionNameArgString, testInstanceNameArgString, testDefinitionNameArgString, testInstanceIdArgString, testbedCategoryArgString, testbedGeniNameArgString, testbedNameArgString, testbedUrnArgString, nextRunArg, hasActiveTasksArg, enabledArg, disabledArg);
    }

    @Test
    public void search12() throws Exception {
        String versionNameArgString = null;
        String testInstanceNameArgString = null;
        String testDefinitionNameArgString = null;
        String testInstanceIdArgString = null;
        String testbedCategoryArgString = null;
        String testbedGeniNameArgString = null;
        String testbedNameArgString = null;
        String testbedUrnArgString = null;
        Boolean nextRunArg = true;
        Boolean hasActiveTasksArg = null;
        Boolean enabledArg = null;
        Boolean disabledArg = null;
        timeProvider.setNowOffsetMinutes(0L);
        List<TestInstanceStatistics> expected = testInstancesStatisticsTestCollection.getByTestInstanceIds(9, 10, 11, 12);
        TestInstanceStatisticsBuilder mod = new TestInstanceStatisticsBuilder(expected.get(0));
        mod.setActiveTask((Long)null);
        expected.set(0, mod.create());
        mod = new TestInstanceStatisticsBuilder(expected.get(1));
        mod.setActiveTask((Long)null);
        expected.set(1, mod.create());
        this.testSearch(expected, versionNameArgString, testInstanceNameArgString, testDefinitionNameArgString, testInstanceIdArgString, testbedCategoryArgString, testbedGeniNameArgString, testbedNameArgString, testbedUrnArgString, nextRunArg, hasActiveTasksArg, enabledArg, disabledArg);
    }

    @Test
    public void search13() throws Exception {
        String versionNameArgString = "prod,test";
        String testInstanceNameArgString = null;
        String testDefinitionNameArgString = "anyGetVersion";
        String testInstanceIdArgString = null;
        String testbedCategoryArgString = "oneAndTwo";
        String testbedGeniNameArgString = "ex-b";
        String testbedNameArgString = "B";
        String testbedUrnArgString = null;
        Boolean nextRunArg = true;
        Boolean hasActiveTasksArg = null;
        Boolean enabledArg = true;
        Boolean disabledArg = false;
        timeProvider.setNowOffsetMinutes(0L);
        List<TestInstanceStatistics> expected = testInstancesStatisticsTestCollection.getByTestInstanceIds(10);
        TestInstanceStatisticsBuilder mod = new TestInstanceStatisticsBuilder(expected.get(0));
        mod.setActiveTask((Long)null);
        expected.set(0, mod.create());
        this.testSearch(expected, versionNameArgString, testInstanceNameArgString, testDefinitionNameArgString, testInstanceIdArgString, testbedCategoryArgString, testbedGeniNameArgString, testbedNameArgString, testbedUrnArgString, nextRunArg, hasActiveTasksArg, enabledArg, disabledArg);
    }

    @Test
    public void search14() throws Exception {
        String versionNameArgString = "prod,test";
        String testInstanceNameArgString = "pingA,pingB,getVersionA,getVersionB,getVersionC,pingC";
        String testDefinitionNameArgString = "anyGetVersion,ping";
        String testInstanceIdArgString = "9,10,11,12,13,14";
        String testbedCategoryArgString = "oneAndTwo,three,all,ALL";
        String testbedGeniNameArgString = "ex-b,ex-a,ex-c";
        String testbedNameArgString = "A,B,C";
        String testbedUrnArgString = null;
        Boolean nextRunArg = true;
        Boolean hasActiveTasksArg = null;
        Boolean enabledArg = null;
        Boolean disabledArg = null;
        timeProvider.setNowOffsetMinutes(0L);
        List<TestInstanceStatistics> expected = testInstancesStatisticsTestCollection.getByTestInstanceIds(9, 10, 11, 12);
        TestInstanceStatisticsBuilder mod = new TestInstanceStatisticsBuilder(expected.get(0));
        mod.setActiveTask((Long)null);
        expected.set(0, mod.create());
        mod = new TestInstanceStatisticsBuilder(expected.get(1));
        mod.setActiveTask((Long)null);
        expected.set(1, mod.create());
        this.testSearch(expected, versionNameArgString, testInstanceNameArgString, testDefinitionNameArgString, testInstanceIdArgString, testbedCategoryArgString, testbedGeniNameArgString, testbedNameArgString, testbedUrnArgString, nextRunArg, hasActiveTasksArg, enabledArg, disabledArg);
    }

    @Test
    public void search15() throws Exception {
        String versionNameArgString = "prod,test";
        String testInstanceNameArgString = "pingA,pingB,getVersionA,getVersionB,getVersionC,pingC";
        String testDefinitionNameArgString = "anyGetVersion,ping";
        String testInstanceIdArgString = "9,10,11,12,13,14";
        String testbedCategoryArgString = null;
        String testbedGeniNameArgString = null;
        String testbedNameArgString = "A,B,C";
        String testbedUrnArgString = null;
        Boolean nextRunArg = null;
        Boolean hasActiveTasksArg = null;
        Boolean enabledArg = null;
        Boolean disabledArg = null;
        timeProvider.setNowOffsetMinutes(-7L);
        List<TestInstanceStatistics> expected = testInstancesStatisticsTestCollection.getByTestInstanceIds(9, 10, 11, 12, 13, 14);
        this.testSearch(expected, versionNameArgString, testInstanceNameArgString, testDefinitionNameArgString, testInstanceIdArgString, testbedCategoryArgString, testbedGeniNameArgString, testbedNameArgString, testbedUrnArgString, nextRunArg, hasActiveTasksArg, enabledArg, disabledArg);
    }

    @Test
    public void search16() throws Exception {
        String versionNameArgString = null;
        String testInstanceNameArgString = null;
        String testDefinitionNameArgString = null;
        String testInstanceIdArgString = null;
        String testbedCategoryArgString = null;
        String testbedGeniNameArgString = null;
        String testbedNameArgString = null;
        String testbedUrnArgString = "urn:publicid:IDN+b.example.com+authority+cm";
        Boolean nextRunArg = null;
        Boolean hasActiveTasksArg = null;
        Boolean enabledArg = null;
        Boolean disabledArg = null;
        timeProvider.setNowOffsetMinutes(-7L);
        List<TestInstanceStatistics> expected = testInstancesStatisticsTestCollection.getByTestInstanceIds(10, 11);
        this.testSearch(expected, versionNameArgString, testInstanceNameArgString, testDefinitionNameArgString, testInstanceIdArgString, testbedCategoryArgString, testbedGeniNameArgString, testbedNameArgString, testbedUrnArgString, nextRunArg, hasActiveTasksArg, enabledArg, disabledArg);
    }

    @Test
    public void search17() throws Exception {
        String versionNameArgString = null;
        String testInstanceNameArgString = null;
        String testDefinitionNameArgString = null;
        String testInstanceIdArgString = null;
        String testbedCategoryArgString = null;
        String testbedGeniNameArgString = null;
        String testbedNameArgString = null;
        String testbedUrnArgString = "urn:publicid:IDN+b.example.com+authority+cm,urn:publicid:IDN+a.example.com+authority+cm";
        Boolean nextRunArg = null;
        Boolean hasActiveTasksArg = null;
        Boolean enabledArg = null;
        Boolean disabledArg = null;
        timeProvider.setNowOffsetMinutes(-7L);
        List<TestInstanceStatistics> expected = testInstancesStatisticsTestCollection.getByTestInstanceIds(9, 10, 11, 12);
        this.testSearch(expected, versionNameArgString, testInstanceNameArgString, testDefinitionNameArgString, testInstanceIdArgString, testbedCategoryArgString, testbedGeniNameArgString, testbedNameArgString, testbedUrnArgString, nextRunArg, hasActiveTasksArg, enabledArg, disabledArg);
    }

    @Test
    public void search18() throws Exception {
        String versionNameArgString = null;
        String testInstanceNameArgString = null;
        String testDefinitionNameArgString = null;
        String testInstanceIdArgString = null;
        String testbedCategoryArgString = null;
        String testbedGeniNameArgString = null;
        String testbedNameArgString = null;
        String testbedUrnArgString = null;
        Boolean nextRunArg = null;
        Boolean hasActiveTasksArg = true;
        Boolean enabledArg = null;
        Boolean disabledArg = null;
        timeProvider.setNowOffsetMinutes(-7L);
        List<TestInstanceStatistics> expected = testInstancesStatisticsTestCollection.getByTestInstanceIds(9, 10);
        this.testSearch(expected, versionNameArgString, testInstanceNameArgString, testDefinitionNameArgString, testInstanceIdArgString, testbedCategoryArgString, testbedGeniNameArgString, testbedNameArgString, testbedUrnArgString, nextRunArg, hasActiveTasksArg, enabledArg, disabledArg);
    }

    @Test
    public void search19() throws Exception {
        String versionNameArgString = null;
        String testInstanceNameArgString = null;
        String testDefinitionNameArgString = null;
        String testInstanceIdArgString = null;
        String testbedCategoryArgString = null;
        String testbedGeniNameArgString = null;
        String testbedNameArgString = null;
        String testbedUrnArgString = null;
        Boolean nextRunArg = null;
        Boolean hasActiveTasksArg = false;
        Boolean enabledArg = null;
        Boolean disabledArg = null;
        timeProvider.setNowOffsetMinutes(-7L);
        List<TestInstanceStatistics> expected = testInstancesStatisticsTestCollection.getByTestInstanceIds(11, 12, 13, 14);
        this.testSearch(expected, versionNameArgString, testInstanceNameArgString, testDefinitionNameArgString, testInstanceIdArgString, testbedCategoryArgString, testbedGeniNameArgString, testbedNameArgString, testbedUrnArgString, nextRunArg, hasActiveTasksArg, enabledArg, disabledArg);
    }
}

