/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.test;

import be.iminds.ilabt.jfed.fedmon.util.Clock;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Result;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestInstanceStatistics;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestInstanceStatisticsBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.ResultTestCollection;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.TestClock;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.TestDefinitionsTestCollection;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.TestInstancesTestCollection;
import be.iminds.ilabt.jfed.util.common.RFC3339Util;
import be.iminds.ilabt.util.jsonld.JsonLdObjectsMetaData;
import be.iminds.ilabt.util.jsonld.test.BasicObjectTestCollection;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;

public class TestInstancesStatisticsTestCollection
extends BasicObjectTestCollection<TestInstanceStatistics, TestInstanceStatisticsBuilder> {
    private TestDefinitionsTestCollection testDefinitionsTestCollection = new TestDefinitionsTestCollection();
    private Map<Integer, TestInstanceStatisticsBuilder> testInstanceStatisticsByTestInstanceId = new HashMap<Integer, TestInstanceStatisticsBuilder>();

    public TestInstancesStatisticsTestCollection() {
        super(TestInstanceStatistics.class, TestInstanceStatisticsBuilder.class);
        Timestamp never;
        ResultTestCollection resultTestCollection = new ResultTestCollection(true);
        TestInstancesTestCollection testInstancesTestCollection = new TestInstancesTestCollection();
        Integer testInstanceId = 9;
        Timestamp lastRun = TestClock.get().getBase();
        Timestamp nextRun = TestClock.get().getOffsetMinutes(10L);
        Long lastResultId = 1L;
        Long lastResultIdExcludingCancelled = 1L;
        TestInstanceStatisticsBuilder testInstance1 = new TestInstanceStatisticsBuilder().setTestInstanceId(testInstanceId).setNextRun(nextRun).setLastRun(lastRun).setLastResultInfo("any", lastResultId, null, lastResultId == null ? null : ((Result)resultTestCollection.getById(lastResultId)).getCreated()).setLastResultInfo("anyButCancelled", lastResultIdExcludingCancelled, null, lastResultIdExcludingCancelled == null ? null : ((Result)resultTestCollection.getById(lastResultIdExcludingCancelled)).getCreated());
        testInstance1.setActiveTask(Long.valueOf(1L), null);
        Integer n = testInstanceId;
        testInstanceId = testInstanceId + 1;
        assert (testInstanceId == 10);
        lastRun = TestClock.get().getOffsetMinutes(-10L);
        nextRun = TestClock.get().getOffsetMinutes(-1L);
        lastResultId = 2L;
        lastResultIdExcludingCancelled = 2L;
        TestInstanceStatistics.RrdStatistics rrdStatistics = new TestInstanceStatisticsBuilder.RrdStatisticsBuilder().setDayTotal(6.0).setWeekTotal(2.0).setMonthTotal(15.0).setMetricName("failure").setUnit("times").create();
        TestInstanceStatisticsBuilder testInstance2 = new TestInstanceStatisticsBuilder().setTestInstanceId(testInstanceId).setLastResultInfo("any", lastResultId, null, lastResultId == null ? null : ((Result)resultTestCollection.getById(lastResultId)).getCreated()).setLastResultInfo("anyButCancelled", lastResultIdExcludingCancelled, null, lastResultIdExcludingCancelled == null ? null : ((Result)resultTestCollection.getById(lastResultIdExcludingCancelled)).getCreated()).setNextRun(nextRun).setLastRun(lastRun).setActiveTask(Long.valueOf(2L), null).setRrdStatistics(rrdStatistics).setSummation(new TestInstanceStatisticsBuilder.SummationBuilder().setYear(new TestInstanceStatistics.SummationDetail(50.0, 0.0, 40.0, 100.0, 99.0, 1.0)).setMonth(new TestInstanceStatistics.SummationDetail(55.0, 1.0, 44.0, 110.0, 110.0, 0.0)).setWeek(new TestInstanceStatistics.SummationDetail(5.0, 2.0, 4.0, 10.0, 100.0, 0.0)).setDay(new TestInstanceStatistics.SummationDetail(0.0, 3.0, 10.0, 20.0, 60.0, 5.0)).setUnit("times").create());
        Integer n2 = testInstanceId;
        testInstanceId = testInstanceId + 1;
        assert (testInstanceId == 11);
        nextRun = TestClock.get().getOffsetMinutes(-1L);
        lastRun = TestClock.get().getOffsetMinutes(-120L);
        lastResultId = 4L;
        lastResultIdExcludingCancelled = 3L;
        TestInstanceStatisticsBuilder testInstance3 = new TestInstanceStatisticsBuilder().setTestInstanceId(testInstanceId).setNextRun(nextRun).setLastRun(lastRun).setLastResultInfo("any", lastResultId, null, lastResultId == null ? null : ((Result)resultTestCollection.getById(lastResultId)).getCreated()).setLastResultInfo("anyButCancelled", lastResultIdExcludingCancelled, null, lastResultIdExcludingCancelled == null ? null : ((Result)resultTestCollection.getById(lastResultIdExcludingCancelled)).getCreated()).setActiveTask(null, null);
        Integer n3 = testInstanceId;
        testInstanceId = testInstanceId + 1;
        assert (testInstanceId == 12);
        nextRun = TestClock.get().getOffsetMinutes(-120L);
        lastRun = TestClock.get().getOffsetMinutes(-180L);
        lastResultId = 7L;
        lastResultIdExcludingCancelled = 7L;
        TestInstanceStatisticsBuilder testInstance4 = new TestInstanceStatisticsBuilder().setTestInstanceId(testInstanceId).setLastResultInfo("any", lastResultId, null, lastResultId == null ? null : ((Result)resultTestCollection.getById(lastResultId)).getCreated()).setLastResultInfo("anyButCancelled", lastResultIdExcludingCancelled, null, lastResultIdExcludingCancelled == null ? null : ((Result)resultTestCollection.getById(lastResultIdExcludingCancelled)).getCreated()).setNextRun(nextRun).setLastRun(lastRun).setActiveTask(null, null);
        try {
            never = new Timestamp(RFC3339Util.rfc3339StringToDate((String)"50000-01-01T00:00:00Z").getTime());
        }
        catch (ParseException e) {
            throw new RuntimeException("Unexpected parse error", e);
        }
        Integer e = testInstanceId;
        testInstanceId = testInstanceId + 1;
        assert (testInstanceId == 13);
        nextRun = never;
        lastRun = null;
        TestInstanceStatisticsBuilder testInstance5 = new TestInstanceStatisticsBuilder().setTestInstanceId(testInstanceId).setNextRun(nextRun).setLastRun(lastRun).setActiveTask(null, null);
        Integer n4 = testInstanceId;
        testInstanceId = testInstanceId + 1;
        assert (testInstanceId == 14);
        try {
            nextRun = never;
            lastRun = new Timestamp(RFC3339Util.rfc3339StringToDate((String)"2015-11-30T12:50:00+01:00").getTime());
        }
        catch (ParseException e2) {
            throw new RuntimeException("Unexpected parse error", e2);
        }
        TestInstanceStatisticsBuilder testInstance6 = new TestInstanceStatisticsBuilder().setTestInstanceId(testInstanceId).setNextRun(nextRun).setLastRun(lastRun).setActiveTask(null, null);
        this.all.addAll(Arrays.asList(testInstance1, testInstance2, testInstance3, testInstance4, testInstance5, testInstance6));
        for (TestInstanceStatisticsBuilder tis : this.all) {
            assert (tis.getTestInstanceId() != null);
            this.testInstanceStatisticsByTestInstanceId.put(tis.getTestInstanceId(), tis);
        }
        assert (testInstance1.getNextRun() != null);
        assert (testInstance2.getNextRun() != null);
        assert (testInstance3.getNextRun() != null);
        assert (testInstance4.getNextRun() != null);
        assert (testInstance5.getNextRun() != null);
        assert (testInstance6.getNextRun() != null);
    }

    public TestInstanceStatisticsBuilder getByTestInstanceId(Integer testInstanceId) {
        TestInstanceStatisticsBuilder res = this.testInstanceStatisticsByTestInstanceId.get(testInstanceId);
        assert (res != null) : "no TestInstanceStatisticsBuilder for testInstanceId=" + testInstanceId;
        return res;
    }

    public static TestInstanceStatisticsBuilder createTestInstanceStatisticsWithUris(TestInstanceStatistics orig, String uriStart) throws URISyntaxException {
        assert (!uriStart.endsWith("/"));
        assert (orig.getTestInstanceId() != null);
        TestInstanceStatisticsBuilder updated = new TestInstanceStatisticsBuilder(orig);
        updated.setUri(new URI(uriStart + "/testinstancestatistics/" + orig.getTestInstanceId()));
        for (TestInstanceStatistics.LastResultInfo lri : orig.getLastResultInfos()) {
            assert (lri.getResultId() != null);
            updated.setLastResultInfo(lri.getFilter(), lri.getResultId(), lri.getResultId() == null ? null : new URI(uriStart + "/result/" + lri.getResultId()), lri.getDate());
        }
        if (orig.getActiveTaskId() != null) {
            updated.setActiveTask(orig.getActiveTaskId(), new URI(uriStart + "/task/" + orig.getActiveTaskId()));
        }
        return updated;
    }

    public void assertSameDetails(TestInstanceStatistics actual, TestInstanceStatistics expected) {
        MatcherAssert.assertThat((String)"last_result infos differ", (Object)actual.getLastResultInfoByFilter(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expected.getLastResultInfoByFilter())));
        MatcherAssert.assertThat((String)"nextrun differs", (Object)actual.getNextRun(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expected.getNextRun())));
        MatcherAssert.assertThat((String)"lastrun differs", (Object)actual.getLastRun(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expected.getLastRun())));
        MatcherAssert.assertThat((String)"testStatistics differs", (Object)actual.getRrdStatistics(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expected.getRrdStatistics())));
        MatcherAssert.assertThat((String)"summation differs", (Object)actual.getSummation(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expected.getSummation())));
        MatcherAssert.assertThat((Object)actual.getClassName(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expected.getClassName())));
        MatcherAssert.assertThat((String)("activeTaskId differs at " + Clock.nowRFC3339()), (Object)actual.getActiveTaskId(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expected.getActiveTaskId())));
        MatcherAssert.assertThat((Object)actual.getLastResultId(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expected.getLastResultId())));
    }

    public List<TestInstanceStatistics> getByTestInstanceIds(Integer ... ids) {
        ArrayList<TestInstanceStatistics> res = new ArrayList<TestInstanceStatistics>();
        for (int i = 0; i < ids.length; ++i) {
            Integer id = ids[i];
            res.add(this.getByTestInstanceId(id).create());
        }
        return res;
    }

    public static TestInstanceStatistics searchListByTestInstanceId(List<TestInstanceStatistics> list, Integer testInstanceId) {
        for (TestInstanceStatistics i : list) {
            if (i.getTestInstanceId() != testInstanceId) continue;
            return i;
        }
        return null;
    }

    public JsonLdObjectsMetaData.Minimization getFixtureMinimization() {
        return JsonLdObjectsMetaData.Minimization.FULL_WITH_MINIMAL_LINK_IDS;
    }
}

