/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.test;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Frequency;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.FrequencyBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ServerBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestDefinition;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestDefinitionBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestEmailConfig;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestInstance;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestInstanceBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.User;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.UserBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.FrequencyTestCollection;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.ServerTestCollection;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.TestDefinitionsTestCollection;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.TestEmailConfigTestCollection;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.UserTestCollection;
import be.iminds.ilabt.util.jsonld.JsonLdObjectsMetaData;
import be.iminds.ilabt.util.jsonld.test.ObjectWithIdTestCollection;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;

public class TestInstancesTestCollection
extends ObjectWithIdTestCollection<Integer, TestInstance, TestInstanceBuilder> {
    private TestDefinitionsTestCollection testDefinitionsTestCollection = new TestDefinitionsTestCollection();
    private TestEmailConfigTestCollection testEmailConfigTestCollection = new TestEmailConfigTestCollection();
    private final List<TestInstanceBuilder> allNormal;

    public TestInstancesTestCollection() {
        super(Integer.class, TestInstance.class, TestInstanceBuilder.class);
        FrequencyTestCollection frequencyTestCollection = new FrequencyTestCollection();
        ServerTestCollection serverTestCollection = new ServerTestCollection();
        UserTestCollection userTestCollection = new UserTestCollection();
        Frequency frequency1 = (Frequency)frequencyTestCollection.getByIndex(0);
        Frequency frequency2 = (Frequency)frequencyTestCollection.getByIndex(1);
        Frequency frequency3 = (Frequency)frequencyTestCollection.getByIndex(2);
        TestDefinition pingTestDefinition = new TestDefinitionBuilder((TestDefinition)this.testDefinitionsTestCollection.getById("ping")).createMinimized(JsonLdObjectsMetaData.Minimization.ID_ONLY);
        TestDefinition getVersionTestDefinition = new TestDefinitionBuilder((TestDefinition)this.testDefinitionsTestCollection.getById("anyGetVersion")).createMinimized(JsonLdObjectsMetaData.Minimization.ID_ONLY);
        User testerUser = (User)userTestCollection.getById("tester-a");
        Integer id = 9;
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters = new HashMap();
        parameters.put("server", serverTestCollection.getById(99));
        parameters.put("user", testerUser);
        parameters.put("use_proxy", "true");
        TestInstanceBuilder testInstance1 = ((TestInstanceBuilder)new TestInstanceBuilder().setId((Object)id)).setName("pingA").setTestDefinition(pingTestDefinition).setTestVersion("prod").setEnabled(Boolean.valueOf(true)).setFrequency(frequency1).setParameters(parameters).setSelfTestImmune(Boolean.valueOf(false));
        Integer n = id;
        id = id + 1;
        assert (id == 10);
        parameters = new HashMap();
        parameters.put("server", serverTestCollection.getById(100));
        parameters.put("am_version", "2");
        parameters.put("list_test", Arrays.asList("blah", "blih", "bloh"));
        TestInstanceBuilder testInstance2 = ((TestInstanceBuilder)new TestInstanceBuilder().setId((Object)id)).setName("getVersionB").setTestDefinition(getVersionTestDefinition).setTestVersion("test").setEnabled(Boolean.valueOf(true)).setFrequency(frequency2).setParameters(parameters).setEmailParameter((TestEmailConfig)this.testEmailConfigTestCollection.getByIndex(0)).setSelfTestImmune(Boolean.valueOf(false));
        Integer n2 = id;
        id = id + 1;
        assert (id == 11);
        parameters = new HashMap();
        parameters.put("server", serverTestCollection.getById(100));
        TestInstanceBuilder testInstance3 = ((TestInstanceBuilder)new TestInstanceBuilder().setId((Object)id)).setName("pingB").setTestDefinition(pingTestDefinition).setTestVersion("test").setEnabled(Boolean.valueOf(false)).setFrequency(frequency1).setParameters(parameters).setSelfTestImmune(Boolean.valueOf(true));
        Integer n3 = id;
        id = id + 1;
        assert (id == 12);
        parameters = new HashMap();
        parameters.put("server", serverTestCollection.getById(99));
        TestInstanceBuilder testInstance4 = ((TestInstanceBuilder)new TestInstanceBuilder().setId((Object)id)).setName("getVersionA").setTestDefinition(getVersionTestDefinition).setTestVersion("prod").setEnabled(Boolean.valueOf(true)).setFrequency(frequency3).setParameters(parameters);
        Integer n4 = id;
        id = id + 1;
        assert (id == 13);
        parameters = new HashMap();
        parameters.put("server", serverTestCollection.getById(101));
        parameters.put("am_version", "3");
        parameters.put("alternative_test_class", "Test");
        parameters.put("context-file", "test context file content");
        assert (testerUser != null);
        parameters.put("user", testerUser);
        TestInstanceBuilder testInstance5 = ((TestInstanceBuilder)new TestInstanceBuilder().setId((Object)id)).setName("getVersionC").setTestDefinition(getVersionTestDefinition).setTestVersion("prod").setEnabled(Boolean.valueOf(true)).setFrequency(frequency3).setParameters(parameters);
        Integer n5 = id;
        id = id + 1;
        assert (id == 14);
        parameters = new HashMap();
        parameters.put("server", serverTestCollection.getById(101));
        TestInstanceBuilder testInstance6 = ((TestInstanceBuilder)new TestInstanceBuilder().setId((Object)id)).setName("pingC").setTestDefinition(pingTestDefinition).setTestVersion("prod").setEnabled(Boolean.valueOf(true)).setFrequency(frequency3).setParameters(parameters);
        TestInstanceBuilder testInstance1b = new TestInstanceBuilder(testInstance1.create()).setTestDefinition(new TestDefinitionBuilder(pingTestDefinition).createMinimized(JsonLdObjectsMetaData.Minimization.ID_ONLY)).setServerParameter(new ServerBuilder(testInstance1.getServerParameter()).createMinimized(JsonLdObjectsMetaData.Minimization.ID_ONLY)).setUserParameter(new UserBuilder(testInstance1.getUserParameter()).createMinimized(JsonLdObjectsMetaData.Minimization.ID_ONLY));
        this.all.addAll(Arrays.asList(testInstance1, testInstance2, testInstance3, testInstance4, testInstance5, testInstance6, testInstance1b));
        this.allNormal = Collections.unmodifiableList(Arrays.asList(testInstance1, testInstance2, testInstance3, testInstance4, testInstance5, testInstance6));
        MatcherAssert.assertThat((Object)testInstance1.getFrequency().isNever(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)testInstance2.getFrequency().isNever(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)testInstance3.getFrequency().isNever(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)testInstance4.getFrequency().isNever(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)testInstance5.getFrequency().isNever(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)testInstance6.getFrequency().isNever(), (Matcher)Matchers.is((Object)true));
    }

    public List<TestInstanceBuilder> getAllNormalBuilders() {
        return this.allNormal;
    }

    public List<TestInstance> getAllNormal() {
        return this.allNormal.stream().map(TestInstanceBuilder::create).collect(Collectors.toList());
    }

    public static TestInstanceBuilder createTestInstanceWithUris(TestInstance orig, String uriStart) throws URISyntaxException {
        assert (!uriStart.endsWith("/"));
        TestInstanceBuilder updated = new TestInstanceBuilder(orig);
        updated.setUri(new URI(uriStart + "/testinstance/" + orig.getId()));
        if (orig.getTestDefinitionId() != null) {
            updated.setTestDefinition(((TestDefinitionBuilder)((TestDefinitionBuilder)new TestDefinitionBuilder().setId((Object)orig.getTestDefinitionId())).setUri(new URI(uriStart + "/testdefinition/" + orig.getTestDefinitionId()))).createMinimized(JsonLdObjectsMetaData.Minimization.ID_ONLY));
        }
        if (orig.getFrequencyId() != null) {
            updated.setFrequency(((FrequencyBuilder)((FrequencyBuilder)new FrequencyBuilder().setId((Object)orig.getFrequencyId())).setUri(new URI(uriStart + "/frequency/" + orig.getFrequencyId()))).create());
        }
        if (orig.getServerParameter() != null) {
            ServerBuilder serverBuilder = new ServerBuilder(orig.getServerParameter());
            serverBuilder.setUri(new URI(uriStart + "/server/" + orig.getServerIdParameter()));
            updated.setServerParameter(serverBuilder.createMinimized(JsonLdObjectsMetaData.Minimization.ID_ONLY));
        }
        if (orig.getUserParameter() != null) {
            UserBuilder userBuilder = new UserBuilder(orig.getUserParameter());
            userBuilder.setUri(new URI(uriStart + "/user/" + orig.getUserIdParameter()));
            updated.setUserParameter(userBuilder.createMinimized(JsonLdObjectsMetaData.Minimization.ID_ONLY));
        }
        return updated;
    }

    public void assertSameExtraIds(TestInstance actual, TestInstance expected) {
    }

    public void assertSameDetails(TestInstance actual, TestInstance expected) {
        MatcherAssert.assertThat((Object)actual.getName(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expected.getName())));
        MatcherAssert.assertThat((Object)actual.getTestVersion(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expected.getTestVersion())));
        MatcherAssert.assertThat((Object)actual.getEnabled(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expected.getEnabled())));
        MatcherAssert.assertThat((Object)actual.getParameters(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)expected.getParameters(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((String)"parameters differ", (Object)actual.getParametersExceptServerAndUser(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expected.getParametersExceptServerAndUser())));
        MatcherAssert.assertThat((Object)actual.getClassName(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expected.getClassName())));
        MatcherAssert.assertThat((Object)actual.getTestDefinitionId(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expected.getTestDefinitionId())));
        MatcherAssert.assertThat((String)"frequency id differs", (Object)actual.getFrequencyId(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expected.getFrequencyId())));
        MatcherAssert.assertThat((String)"user id parameter differs", (Object)actual.getUserIdParameter(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expected.getUserIdParameter())));
        MatcherAssert.assertThat((String)"server id parameter differs", (Object)actual.getServerIdParameter(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expected.getServerIdParameter())));
    }

    public void assertSearchLinks(TestInstance actual) {
        MatcherAssert.assertThat((Object)actual.getResultsUri(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)actual.getResultsUri().toASCIIString(), (Matcher)Matchers.containsString((String)"/result"));
        MatcherAssert.assertThat((Object)actual.getResultsUri().toASCIIString(), (Matcher)Matchers.containsString((String)("testinstanceid=" + actual.getId())));
    }

    public JsonLdObjectsMetaData.Minimization getFixtureMinimization() {
        return JsonLdObjectsMetaData.Minimization.FULL_WITH_MINIMAL_LINK_IDS;
    }
}

