/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.test;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.F4FFederationStatus;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Federation;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.GDPRInfo;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.GDPRInfoBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Organisation;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.OrganisationBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ServerBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Testbed;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestbedBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestbedCategory;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.FederationTestCollection;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.OrganisationTestCollection;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.ProxyTestCollection;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.ServerTestCollection;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.TestbedCategoriesTestCollection;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import be.iminds.ilabt.jfed.util.common.RFC3339Util;
import be.iminds.ilabt.util.jsonld.JsonLdObjectsMetaData;
import be.iminds.ilabt.util.jsonld.iface.JsonLdObjectWithId;
import be.iminds.ilabt.util.jsonld.test.ObjectWithIdTestCollection;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;

public class TestbedTestCollection
extends ObjectWithIdTestCollection<String, Testbed, TestbedBuilder> {
    public TestbedTestCollection() {
        this(true);
    }

    public TestbedTestCollection(boolean linkWithOrganisations) {
        super(String.class, Testbed.class, TestbedBuilder.class);
        TestbedCategoriesTestCollection testbedCategoriesTestCollection = new TestbedCategoriesTestCollection();
        ProxyTestCollection proxyTestCollection = new ProxyTestCollection();
        ServerTestCollection serverTestCollection = new ServerTestCollection();
        OrganisationTestCollection organisationTestCollection = linkWithOrganisations ? new OrganisationTestCollection(false) : null;
        FederationTestCollection federationTestCollection = new FederationTestCollection(false);
        try {
            String name = "ping";
            String type = "ping";
            Long maxTestDurationMs = 120000L;
            List<TestbedCategory> categories = testbedCategoriesTestCollection.getByNames("oneAndTwo", "one");
            Server server99 = new ServerBuilder((Server)serverTestCollection.getById(99)).createMinimized(JsonLdObjectsMetaData.Minimization.ID_ONLY);
            Server server100 = new ServerBuilder((Server)serverTestCollection.getById(100)).createMinimized(JsonLdObjectsMetaData.Minimization.ID_ONLY);
            Server server101 = new ServerBuilder((Server)serverTestCollection.getById(101)).createMinimized(JsonLdObjectsMetaData.Minimization.ID_ONLY);
            TestbedBuilder testbedABuilder = ((TestbedBuilder)new TestbedBuilder().setId((Object)"A")).setLongName("Fake Testbed 1: A").setInterfaceUrl("http://www.example.com/a").setPingHost("www.a.example.com").setInfoUrl("http://www.example.com/doc/").setHelpUrl("http://www.example.com/help.html").setOtrsName("OTRS A").setDescription("Description of A").setGeniId("ex-a").setGeniHref(new URI("https://example.com/info/aggregate/ex-a")).setColor("red").setLogo("logoA").setAllowLinks(Boolean.valueOf(true)).setNodesLocationVisualisationCoordinatesUrl("yy").setNodesLocationVisualisationImageUrl("xx").setCategories(categories).setProxies(proxyTestCollection.getAll()).setDefaultComponentManagerUrn("urn:publicid:IDN+a.example.com+authority+cm").setServers(Arrays.asList(server99)).setDefaultServer(server99).setPrimaryContactEmails(Arrays.asList("prim1@example.com", "prim2@example.com")).setTechnicalContactEmails(Arrays.asList("tech1@example.com", "tech2@example.com")).setGdprContactEmails(Arrays.asList("gdpr1@example.com", "gdpr2@example.com")).setTestbedAdminUrns(Arrays.asList(GeniUrn.parse((String)"urn:publicid:IDN+a.example.com+user+mra"), GeniUrn.parse((String)"urn:publicid:IDN+a.example.com+user+admin"))).setSoftware(Arrays.asList("emulab", "gcf", "openstack")).setNotes("This is the primary fake test Testbed").setF4fFederationStatus(TestbedTestCollection.createDummyF4fFederationStatus()).setGdprInfo(TestbedTestCollection.createDummyGdprInfo()).setFederations(Arrays.asList((Federation)federationTestCollection.getById("fed1"), (Federation)federationTestCollection.getById("subfed1a")));
            if (linkWithOrganisations) {
                testbedABuilder = testbedABuilder.setOrganisation(new OrganisationBuilder((Organisation)organisationTestCollection.getById("iminds")).createMinimized(JsonLdObjectsMetaData.Minimization.ID_ONLY));
            }
            categories = testbedCategoriesTestCollection.getByNames("oneAndTwo");
            TestbedBuilder testbedBBuilder = ((TestbedBuilder)new TestbedBuilder().setId((Object)"B")).setLongName("Fake Testbed 2: B").setInterfaceUrl("https://www.example.com/b").setPingHost("www.b.example.com").setInfoUrl("http://www.example.com/doc/").setHelpUrl("http://www.example.com/gelp.html").setOtrsName("OTRS B").setDescription(null).setGeniId("ex-b").setColor("blue").setLogo("logoB").setAllowLinks(Boolean.valueOf(false)).setDefaultComponentManagerUrn("urn:publicid:IDN+b.example.com+authority+cm").setGeniHref(new URI("https://example.com/info/aggregate/ex-b")).setServers(Arrays.asList(server100)).setDefaultServer(server100).setCategories(categories).setTechnicalContactEmails(Arrays.asList("three@example.com", "four@example.com")).setFederations(Arrays.asList((Federation)federationTestCollection.getById("fed1")));
            if (linkWithOrganisations) {
                testbedBBuilder = testbedBBuilder.setOrganisation(new OrganisationBuilder((Organisation)organisationTestCollection.getById("testorg")).createMinimized(JsonLdObjectsMetaData.Minimization.ID_ONLY));
            }
            categories = new ArrayList<TestbedCategory>();
            TestbedBuilder testbedCBuilder = ((TestbedBuilder)new TestbedBuilder().setId((Object)"C")).setLongName("Fake Testbed 3: C").setInterfaceUrl("http://www.example.com:8080/c").setPingHost("10.216.69.137").setInfoUrl(null).setHelpUrl("http://www.example.com/helpc.html").setDefaultComponentManagerUrn("urn:publicid:IDN+c.example.com:cc+authority+cm").setAllowLinks(Boolean.valueOf(false)).setCategories(categories).setServers(Arrays.asList(server101)).setDefaultServer(server101).setFederations(Arrays.asList((Federation)federationTestCollection.getById("fed2")));
            if (linkWithOrganisations) {
                testbedCBuilder = testbedCBuilder.setOrganisation(new OrganisationBuilder((Organisation)organisationTestCollection.getById("iminds")).createMinimized(JsonLdObjectsMetaData.Minimization.ID_ONLY));
            }
            assert (testbedCBuilder.getServers().size() == 1);
            assert (testbedCBuilder.getServers().get(0) != null);
            this.all.addAll(Arrays.asList(testbedABuilder, testbedBBuilder, testbedCBuilder));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("creating Test Testbeds failed", e);
        }
    }

    private static F4FFederationStatus createDummyF4fFederationStatus() {
        try {
            return new F4FFederationStatus(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), "Fully federated", new Timestamp(RFC3339Util.rfc3339StringToDate((String)"2018-01-01T17:00:00Z").getTime()), "Notes on Federation details");
        }
        catch (ParseException e) {
            throw new RuntimeException("Should not happen", e);
        }
    }

    private static GDPRInfo createDummyGdprInfo() {
        return new GDPRInfoBuilder().setAcceptPeriodInDays(Integer.valueOf(300)).setGrpdUrl("http://example.com/gdpr").setAcceptSubject(GDPRInfo.AcceptSubject.SLICE).setVersion("2").create();
    }

    public void assertSameExtraIds(Testbed actual, Testbed expected) {
        MatcherAssert.assertThat((String)"geniId differs", (Object)actual.getGeniId(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expected.getGeniId())));
        MatcherAssert.assertThat((String)"defaultComponentManagerUrn differs", (Object)actual.getDefaultComponentManagerUrn(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expected.getDefaultComponentManagerUrn())));
    }

    public void assertSameDetails(Testbed actual, Testbed expected) {
        MatcherAssert.assertThat((Object)((String)actual.getId()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)((String)expected.getId()))));
        MatcherAssert.assertThat((Object)actual.getLongName(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expected.getLongName())));
        MatcherAssert.assertThat((String)"category IDs differ", (Object)actual.getCategoryIds(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expected.getCategoryIds())));
        MatcherAssert.assertThat((Object)actual.getDescription(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expected.getDescription())));
        MatcherAssert.assertThat((String)"geni href differs", (Object)actual.getGeniHref(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expected.getGeniHref())));
        MatcherAssert.assertThat((Object)actual.getHelpUrl(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expected.getHelpUrl())));
        MatcherAssert.assertThat((Object)actual.getInterfaceUrl(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expected.getInterfaceUrl())));
        MatcherAssert.assertThat((Object)actual.getInfoUrl(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expected.getInfoUrl())));
        MatcherAssert.assertThat((Object)actual.getLongName(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expected.getLongName())));
        MatcherAssert.assertThat((Object)actual.getOtrsName(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expected.getOtrsName())));
        MatcherAssert.assertThat((Object)actual.getPingHost(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expected.getPingHost())));
        MatcherAssert.assertThat((Object)actual.getAllowLinks(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expected.getAllowLinks())));
        MatcherAssert.assertThat((Object)actual.getNodesLocationVisualisationCoordinatesUrl(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expected.getNodesLocationVisualisationCoordinatesUrl())));
        MatcherAssert.assertThat((Object)actual.getNodesLocationVisualisationImageUrl(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expected.getNodesLocationVisualisationImageUrl())));
        MatcherAssert.assertThat((Object)actual.getColor(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expected.getColor())));
        MatcherAssert.assertThat((String)"technical contact emails differ", (Object)actual.getTechnicalContactEmails(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expected.getTechnicalContactEmails())));
        MatcherAssert.assertThat((String)"Primary contact emails differ", (Object)actual.getPrimaryContactEmails(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expected.getPrimaryContactEmails())));
        MatcherAssert.assertThat((String)"GDPR contact emails differ", (Object)actual.getGdprContactEmails(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expected.getGdprContactEmails())));
        MatcherAssert.assertThat((Object)actual.getTestbedAdminUrns(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expected.getTestbedAdminUrns())));
        MatcherAssert.assertThat((Object)actual.getSoftware(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expected.getSoftware())));
        MatcherAssert.assertThat((Object)actual.getNotes(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expected.getNotes())));
        MatcherAssert.assertThat((String)"F4fFederationStatus differs", (Object)actual.getF4fFederationStatus(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expected.getF4fFederationStatus())));
        MatcherAssert.assertThat((String)"gdprInfo differs", (Object)actual.getGdprInfo(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expected.getGdprInfo())));
    }

    public void assertSearchLinks(Testbed actual) {
        MatcherAssert.assertThat((Object)actual.getResultsUri(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)actual.getResultsUri().toASCIIString(), (Matcher)Matchers.containsString((String)"/result"));
        MatcherAssert.assertThat((Object)actual.getResultsUri().toASCIIString(), (Matcher)Matchers.containsString((String)("testbed=" + (String)actual.getId())));
        MatcherAssert.assertThat((Object)actual.getTestInstancesUri(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)actual.getTestInstancesUri().toASCIIString(), (Matcher)Matchers.containsString((String)"/testinstance"));
        MatcherAssert.assertThat((Object)actual.getTestInstancesUri().toASCIIString(), (Matcher)Matchers.containsString((String)("testbed=" + (String)actual.getId())));
    }

    public void assertSameButIgnoreUri(Testbed actualT, Testbed expectedT) {
        super.assertSameButIgnoreUri((JsonLdObjectWithId)actualT, (JsonLdObjectWithId)expectedT);
    }

    public void assertSameButIgnoreUri(TestbedBuilder actualBuilder, Testbed expectedT) {
        MatcherAssert.assertThat((Object)actualBuilder, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        super.assertSameButIgnoreUri((JsonLdObjectWithId)actualBuilder.create(), (JsonLdObjectWithId)expectedT);
    }
}

