/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.DurationDeserializer;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.Duration;
import javax.annotation.Nullable;

class SafeDurationDeserializer
extends StdScalarDeserializer<Duration> {
    private static final BigDecimal MAX_DURATION = new BigDecimal(Long.MAX_VALUE);
    private static final BigDecimal MIN_DURATION = new BigDecimal(Long.MIN_VALUE);

    SafeDurationDeserializer() {
        super(Duration.class);
    }

    @Nullable
    public Duration deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        BigDecimal value;
        if (parser.getCurrentTokenId() == 8 && ((value = parser.getDecimalValue()).compareTo(MAX_DURATION) > 0 || value.compareTo(MIN_DURATION) < 0)) {
            throw new IllegalArgumentException("Value is out of range of Duration");
        }
        return DurationDeserializer.INSTANCE.deserialize(parser, context);
    }
}

