/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.util.jsonld.test;

import be.iminds.ilabt.util.jsonld.JsonLdObjectsMetaData;
import be.iminds.ilabt.util.jsonld.UriTool;
import be.iminds.ilabt.util.jsonld.iface.JsonLdObject;
import be.iminds.ilabt.util.jsonld.iface.JsonLdObjectBuilder;
import be.iminds.ilabt.util.jsonld.iface.JsonLdObjectWithId;
import be.iminds.ilabt.util.jsonld.iface.JsonLdObjectWithUri;
import be.iminds.ilabt.util.jsonld.test.CommonTest;
import be.iminds.ilabt.util.jsonld.test.TestCollectionIndex;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BasicObjectTestCollection<T extends JsonLdObject, B extends JsonLdObjectBuilder<T>> {
    private static final Logger LOG = LoggerFactory.getLogger(BasicObjectTestCollection.class);
    protected List<B> all;
    protected Class<T> objectClass;
    protected Class<B> builderClass;

    public BasicObjectTestCollection(@NotNull Class<T> objectClass, @NotNull Class<B> builderClass) {
        assert (objectClass != null);
        assert (builderClass != null);
        this.all = new ArrayList<B>();
        this.objectClass = objectClass;
        this.builderClass = builderClass;
    }

    public void setUri(int index, UriTool uriTool) throws URISyntaxException {
        assert (uriTool != null);
        JsonLdObjectBuilder orig = (JsonLdObjectBuilder)this.all.get(index);
        JsonLdObjectBuilder updated = uriTool.setUriRecursive(orig, false);
        this.all.set(index, updated);
    }

    public Class<B> getBuilderClass() {
        return this.builderClass;
    }

    public Class<T> getObjectClass() {
        return this.objectClass;
    }

    public T getByIndex(int index) {
        return (T)((JsonLdObjectBuilder)this.all.get(index)).create();
    }

    public List<T> getByIndexes(int ... indexes) {
        ArrayList<JsonLdObject> res = new ArrayList<JsonLdObject>();
        for (int i = 0; i < indexes.length; ++i) {
            int index = indexes[i];
            res.add(((JsonLdObjectBuilder)this.all.get(index)).create());
        }
        return res;
    }

    public B getBuilderByIndex(int index) {
        return (B)((JsonLdObjectBuilder)this.all.get(index));
    }

    public String getFixtureByIndex(int index) {
        String objectPath = this.objectClass.getSimpleName().toLowerCase();
        assert (objectPath != null);
        assert (!objectPath.trim().isEmpty());
        return "fixtures/" + objectPath + "-" + index + ".json";
    }

    public List<T> getAll() {
        ArrayList<JsonLdObject> res = new ArrayList<JsonLdObject>();
        for (JsonLdObjectBuilder t : this.all) {
            res.add(t.create());
        }
        return res;
    }

    public List<B> getAllBuilders() {
        return Collections.unmodifiableList(this.all);
    }

    public int getSize() {
        return this.all.size();
    }

    public abstract void assertSameDetails(T var1, T var2);

    protected JsonLdObjectsMetaData.ReferenceAccessorHelper objectToReferenceAccessorHelper(JsonLdObject object) {
        JsonLdObjectBuilder builder = JsonLdObjectsMetaData.createBuilderCopy((JsonLdObject)object);
        JsonLdObjectsMetaData.ReferenceAccessorHelper builderAccessors = new JsonLdObjectsMetaData.ReferenceAccessorHelper(this.builderClass, builder);
        return builderAccessors;
    }

    public void assertSame(T actual, T expected, CommonTest.ComparePrecision base, @Nullable CommonTest.ComparePrecision references) {
        block18: {
            block17: {
                assert (base != null);
                if (base.mustIgnore()) {
                    return;
                }
                assert (expected != null);
                MatcherAssert.assertThat(actual, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
                if (base.mustCompareDetails()) {
                    this.assertSameDetails(actual, expected);
                }
                if (references != null) break block17;
                JsonLdObjectsMetaData.ReferenceAccessorHelper actualReferenceAccessorHelper = this.objectToReferenceAccessorHelper((JsonLdObject)actual);
                Collection rids = actualReferenceAccessorHelper.getReferenceIds();
                for (JsonLdObjectsMetaData.ReferenceAccessorHelper.ReferenceId rid : rids) {
                    if (actualReferenceAccessorHelper.isList(rid)) {
                        Collection referenceList = actualReferenceAccessorHelper.getCollection(rid);
                        MatcherAssert.assertThat((Object)referenceList, (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
                        continue;
                    }
                    JsonLdObjectWithUri referenceObject = actualReferenceAccessorHelper.get(rid);
                    MatcherAssert.assertThat((Object)referenceObject, (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
                }
                break block18;
            }
            if (references.mustIgnore()) break block18;
            JsonLdObjectsMetaData.ReferenceAccessorHelper actualReferenceAccessorHelper = this.objectToReferenceAccessorHelper((JsonLdObject)actual);
            JsonLdObjectsMetaData.ReferenceAccessorHelper expectedReferenceAccessorHelper = this.objectToReferenceAccessorHelper((JsonLdObject)expected);
            int referenceIdCount = actualReferenceAccessorHelper.getReferenceIds().size();
            MatcherAssert.assertThat((Object)referenceIdCount, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expectedReferenceAccessorHelper.getReferenceIds().size())));
            ArrayList actualReferenceIds = new ArrayList(actualReferenceAccessorHelper.getReferenceIds());
            for (int i = 0; i < referenceIdCount; ++i) {
                BasicObjectTestCollection referenceTestObjectCollection;
                Class referenceClass;
                JsonLdObjectsMetaData.ReferenceAccessorHelper.ReferenceId actualRefId = (JsonLdObjectsMetaData.ReferenceAccessorHelper.ReferenceId)actualReferenceIds.get(i);
                JsonLdObjectsMetaData.ReferenceAccessorHelper.ReferenceId expectedRefId = expectedReferenceAccessorHelper.getReferenceIdByReferenceId(actualRefId);
                MatcherAssert.assertThat((String)"assumption error in test framework", (Object)expectedRefId, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
                if (actualReferenceAccessorHelper.hasAnyAccessorCallback(actualRefId)) {
                    LOG.warn("BEWARE: There is accessor based callback in " + actualRefId + " for class " + actual.getClass().getName() + ". This cannot be compared automatically! So this assertSame call will ignore this!");
                    continue;
                }
                if (actualReferenceAccessorHelper.isList(actualRefId)) {
                    referenceClass = actualRefId.getObjectClass();
                    Collection expectedReferenceList = expectedReferenceAccessorHelper.getCollection(expectedRefId);
                    Collection actualReferenceList = actualReferenceAccessorHelper.getCollection(actualRefId);
                    referenceTestObjectCollection = TestCollectionIndex.get().getCollectionByObjectClass(referenceClass);
                    if (expectedReferenceList == null) {
                        MatcherAssert.assertThat((String)("reference list was not null for " + actual.getClassName() + "." + actualRefId), (Object)actualReferenceList, (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
                        continue;
                    }
                    MatcherAssert.assertThat((String)("reference list was null for " + actual.getClassName() + "." + actualRefId), (Object)actualReferenceList, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
                    MatcherAssert.assertThat((String)("reference list size differs for " + actual.getClassName() + "." + actualRefId), (Object)actualReferenceList, (Matcher)Matchers.hasSize((int)expectedReferenceList.size()));
                    for (JsonLdObjectWithUri expectedReference : expectedReferenceList) {
                        JsonLdObjectWithId expectedReferenceWithId;
                        boolean hasId = expectedReference instanceof JsonLdObjectWithId;
                        JsonLdObjectWithId jsonLdObjectWithId = expectedReferenceWithId = hasId ? (JsonLdObjectWithId)expectedReference : null;
                        if (hasId && expectedReferenceWithId.getId() == null) {
                            LOG.warn("Not comparing reference list content, because expected reference list has no IDs");
                            continue;
                        }
                        JsonLdObjectWithUri actualReference = null;
                        for (JsonLdObjectWithUri curActualReference : actualReferenceList) {
                            JsonLdObjectWithId curActualReferenceWithId;
                            JsonLdObjectWithId jsonLdObjectWithId2 = curActualReferenceWithId = hasId ? (JsonLdObjectWithId)curActualReference : null;
                            if (hasId) {
                                MatcherAssert.assertThat((String)("reference list had null actual id for " + actual.getClassName() + "." + actualRefId), (Object)curActualReferenceWithId.getId(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
                            }
                            if (hasId) {
                                if (!curActualReferenceWithId.getId().equals(expectedReferenceWithId.getId())) continue;
                                MatcherAssert.assertThat((String)("Duplicate object in reference List for " + actual.getClassName() + "." + actualRefId), actualReference, (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
                                actualReference = curActualReference;
                                continue;
                            }
                            if (curActualReference.getUri() == null || expectedReference.getUri() == null || !curActualReference.getUri().equals(expectedReference.getUri())) continue;
                            MatcherAssert.assertThat((String)("Duplicate object in reference List for " + actual.getClassName() + "." + actualRefId), (Object)actualReference, (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
                            actualReference = curActualReference;
                        }
                        MatcherAssert.assertThat((String)("expected to find " + referenceClass.getSimpleName() + " " + (expectedReferenceWithId == null ? "" : expectedReferenceWithId.getId()) + " in list, but did not find it"), actualReference, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
                        referenceTestObjectCollection.assertSame(actualReference, expectedReference, new CommonTest.ComparePrecision(true, references.mustCompareExtraIds(), references.mustExpectActualHasUri(), references.mustExpectActualHasSearchLinks(), references.mustCompareDetails()), CommonTest.ComparePrecision.IGNORE_COMPLETELY);
                    }
                    continue;
                }
                referenceClass = actualRefId.getObjectClass();
                JsonLdObjectWithUri expectedReferenceObject = expectedReferenceAccessorHelper.get(expectedRefId);
                JsonLdObjectWithUri actualReferenceObject = actualReferenceAccessorHelper.get(actualRefId);
                referenceTestObjectCollection = TestCollectionIndex.get().getCollectionByObjectClass(referenceClass);
                if (expectedReferenceObject == null) {
                    MatcherAssert.assertThat((String)("reference was NOT null as expected for " + actual.getClassName() + "." + actualRefId), (Object)actualReferenceObject, (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
                    continue;
                }
                MatcherAssert.assertThat((String)("reference was null for " + actual.getClassName() + "." + actualRefId), (Object)actualReferenceObject, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
                if (JsonLdObjectWithId.class.isAssignableFrom(referenceClass)) {
                    JsonLdObjectWithId expectedReferenceObjectWithId = (JsonLdObjectWithId)expectedReferenceObject;
                    JsonLdObjectWithId actualReferenceObjectWithId = (JsonLdObjectWithId)actualReferenceObject;
                    MatcherAssert.assertThat((String)("reference id wrong for " + actual.getClassName() + "." + actualRefId), (Object)actualReferenceObjectWithId.getId(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expectedReferenceObjectWithId.getId())));
                    continue;
                }
                MatcherAssert.assertThat((String)("reference uri wrong for " + actual.getClassName() + "." + actualRefId), (Object)actualReferenceObject.getUri(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expectedReferenceObject.getUri())));
            }
        }
    }

    public String toString() {
        return "" + this.objectClass.getSimpleName() + " test objects";
    }

    public JsonLdObjectsMetaData.Minimization getFixtureMinimization() {
        return JsonLdObjectsMetaData.Minimization.FULL_EMBEDDING_PARENT_AND_CHILDREN;
    }
}

