/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.util.jsonld.test;

import be.iminds.ilabt.util.jsonld.impl.PrimaryIdObject;
import be.iminds.ilabt.util.jsonld.test.BasicObjectTestCollection;
import be.iminds.ilabt.util.jsonld.test.TestCollectionIndex;
import java.net.URI;
import javax.annotation.Nullable;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;

public class CommonTest {
    public static void assertUriPathEndsWith(URI uri, String end) {
        assert (!end.endsWith("/"));
        String path = uri.getPath();
        MatcherAssert.assertThat((String)"actual has no URI", (Object)path, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        if (path.endsWith("/")) {
            MatcherAssert.assertThat((String)"actual URI does not end as expected", (Object)path, (Matcher)Matchers.endsWith((String)(end + "/")));
        } else {
            MatcherAssert.assertThat((String)"actual URI does not end as expected", (Object)path, (Matcher)Matchers.endsWith((String)end));
        }
    }

    public static void assertUriPathEndsWith(URI uri, String resourceName, Object id) {
        MatcherAssert.assertThat((String)"URI was null", (Object)uri, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        assert (!resourceName.contains("/"));
        String path = uri.getPath();
        MatcherAssert.assertThat((String)"actual has no URI", (Object)path, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        String end = id == null ? "/" + resourceName : "/" + resourceName + "/" + id;
        if (path.endsWith("/")) {
            MatcherAssert.assertThat((String)"actual URI does not end as expected", (Object)path, (Matcher)Matchers.endsWith((String)(end + "/")));
        } else {
            MatcherAssert.assertThat((String)"actual URI does not end as expected", (Object)path, (Matcher)Matchers.endsWith((String)end));
        }
    }

    public static <T extends PrimaryIdObject> void assertSame(Class<T> clazz, T actual, T expected, ComparePrecision base, @Nullable ComparePrecision references) {
        BasicObjectTestCollection toc = TestCollectionIndex.get().getCollectionByObjectClass(clazz);
        toc.assertSame(actual, expected, base, references);
    }

    public static class ComparePrecision {
        public static final ComparePrecision FULL = new ComparePrecision(true, true, true, true, true);
        public static final ComparePrecision IGNORE_URI = new ComparePrecision(true, true, false, false, true);
        public static final ComparePrecision IGNORE_SEARCH = new ComparePrecision(true, true, true, false, true);
        public static final ComparePrecision ID_ONLY = new ComparePrecision(true, true, false, false, false);
        public static final ComparePrecision ID_AND_URI_ONLY = new ComparePrecision(true, true, true, false, false);
        public static final ComparePrecision ID_AND_REFS_ONLY = new ComparePrecision(true, true, true, true, false);
        public static final ComparePrecision MINIMAL_ID_ONLY = new ComparePrecision(true, false, false, false, false);
        public static final ComparePrecision MINIMAL_ID_AND_URI_ONLY = new ComparePrecision(true, false, true, false, false);
        public static final ComparePrecision MINIMAL_ID_AND_REFS_ONLY = new ComparePrecision(true, false, true, true, false);
        public static final ComparePrecision IGNORE_COMPLETELY = new ComparePrecision(false, false, false, false, false);
        private final boolean compareId;
        private final boolean compareExtraIds;
        private final boolean compareDetails;
        private final boolean expectActualHasUri;
        private final boolean expectActualHasSearchLinks;

        ComparePrecision(boolean compareId, boolean compareExtraIds, boolean expectActualHasUri, boolean expectActualHasSearchLinks, boolean compareDetails) {
            this.compareId = compareId;
            this.compareExtraIds = compareExtraIds;
            this.compareDetails = compareDetails;
            this.expectActualHasUri = expectActualHasUri;
            this.expectActualHasSearchLinks = expectActualHasSearchLinks;
            if (!compareId) {
                assert (!compareDetails);
                assert (!expectActualHasUri);
                assert (!expectActualHasSearchLinks);
            }
        }

        public boolean mustIgnore() {
            return !this.compareId;
        }

        public boolean mustCompareExtraIds() {
            return this.compareExtraIds;
        }

        public boolean mustCompareDetails() {
            return this.compareDetails;
        }

        public boolean mustExpectActualHasUri() {
            return this.expectActualHasUri;
        }

        public boolean mustExpectActualHasSearchLinks() {
            return this.expectActualHasSearchLinks;
        }
    }
}

