/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.util.jsonld.test;

import be.iminds.ilabt.util.jsonld.JsonLdObjectsMetaData;
import be.iminds.ilabt.util.jsonld.UriTool;
import be.iminds.ilabt.util.jsonld.iface.JsonLdObjectBuilder;
import be.iminds.ilabt.util.jsonld.iface.JsonLdObjectWithId;
import be.iminds.ilabt.util.jsonld.iface.JsonLdObjectWithIdBuilder;
import be.iminds.ilabt.util.jsonld.iface.JsonLdObjectWithUri;
import be.iminds.ilabt.util.jsonld.iface.JsonLdObjectWithUriBuilder;
import be.iminds.ilabt.util.jsonld.test.BasicObjectTestCollection;
import be.iminds.ilabt.util.jsonld.test.CommonTest;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ObjectWithIdTestCollection<I, T extends JsonLdObjectWithId<I> & JsonLdObjectWithUri, B extends JsonLdObjectWithIdBuilder<I, T> & JsonLdObjectWithUriBuilder<T>>
extends BasicObjectTestCollection<T, B> {
    private static final Logger LOG = LoggerFactory.getLogger(ObjectWithIdTestCollection.class);
    private Class<I> idClass;
    private JsonLdObjectsMetaData jsonLdObjectsMetaData;

    public ObjectWithIdTestCollection(@Nonnull Class<I> idClass, @Nonnull Class<T> objectClass, @Nonnull Class<B> builderClass) {
        super(objectClass, builderClass);
        this.all = new ArrayList();
        this.idClass = idClass;
        this.jsonLdObjectsMetaData = JsonLdObjectsMetaData.getInstance((String)objectClass.getPackage().getName());
    }

    protected void link() {
    }

    public Class<I> getIdClass() {
        return this.idClass;
    }

    @Override
    public void setUri(int index, UriTool uriTool) throws URISyntaxException {
        assert (uriTool != null);
        String objectPath = JsonLdObjectsMetaData.getUrlObjectName((Class)this.objectClass);
        assert (objectPath != null);
        assert (!objectPath.trim().isEmpty());
        JsonLdObjectWithIdBuilder origBuilder = (JsonLdObjectWithIdBuilder)this.all.get(index);
        JsonLdObjectWithIdBuilder updated = (JsonLdObjectWithIdBuilder)uriTool.setUriRecursive((JsonLdObjectBuilder)origBuilder, false);
        this.all.set(index, updated);
    }

    @Override
    public String getFixtureByIndex(int index) {
        String objectPath = JsonLdObjectsMetaData.getUrlObjectName((Class)this.objectClass);
        assert (objectPath != null);
        assert (!objectPath.trim().isEmpty());
        return "fixtures/" + objectPath + "-" + index + ".json";
    }

    public T getById(I id) {
        this.link();
        for (JsonLdObjectWithIdBuilder t : this.all) {
            if (t.getId() == null || !t.getId().equals(id)) continue;
            return (T)t.create();
        }
        return null;
    }

    public B getBuilderById(I id) {
        this.link();
        for (JsonLdObjectWithIdBuilder t : this.all) {
            if (t.getId() == null || !t.getId().equals(id)) continue;
            return (B)t;
        }
        return null;
    }

    public T searchListById(List<T> list, I id) {
        this.link();
        for (JsonLdObjectWithId t : list) {
            if (!t.getId().equals(id)) continue;
            return (T)t;
        }
        return null;
    }

    public B searchBuilderListById(List<B> list, I id) {
        this.link();
        for (JsonLdObjectWithIdBuilder b : list) {
            if (!b.getId().equals(id)) continue;
            return (B)b;
        }
        return null;
    }

    public List<T> getByIds(I ... ids) {
        this.link();
        ArrayList<T> res = new ArrayList<T>();
        for (int i = 0; i < ids.length; ++i) {
            I id = ids[i];
            res.add(this.getById(id));
        }
        return res;
    }

    public List<B> getBuildersByIds(I ... ids) {
        this.link();
        ArrayList<B> res = new ArrayList<B>();
        for (int i = 0; i < ids.length; ++i) {
            I id = ids[i];
            res.add(this.getBuilderById(id));
        }
        return res;
    }

    public abstract void assertSameExtraIds(T var1, T var2);

    @Override
    public abstract void assertSameDetails(T var1, T var2);

    public abstract void assertSearchLinks(T var1);

    @Override
    public void assertSame(T actual, T expected, CommonTest.ComparePrecision base, @Nullable CommonTest.ComparePrecision references) {
        assert (base != null);
        if (base.mustIgnore()) {
            return;
        }
        MatcherAssert.assertThat(expected, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat(actual, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        super.assertSame(actual, expected, base, references);
        assert (expected != null);
        MatcherAssert.assertThat(actual, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        boolean isSingleton = this.jsonLdObjectsMetaData.isSingleton(expected);
        if (!isSingleton) {
            if (expected.getId() != null) {
                assert (expected.getId() != null);
                MatcherAssert.assertThat((Object)actual.getId(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expected.getId())));
            }
            if (base.mustCompareExtraIds()) {
                this.assertSameExtraIds(actual, expected);
            }
        }
        if (base.mustExpectActualHasUri()) {
            String objectPath = JsonLdObjectsMetaData.getUrlObjectName((Class)this.objectClass);
            assert (objectPath != null);
            assert (!objectPath.trim().isEmpty());
            if (!isSingleton) {
                CommonTest.assertUriPathEndsWith(((JsonLdObjectWithUri)actual).getUri(), objectPath, actual.getId());
            } else {
                CommonTest.assertUriPathEndsWith(((JsonLdObjectWithUri)actual).getUri(), objectPath, null);
            }
        }
        if (base.mustExpectActualHasSearchLinks()) {
            this.assertSearchLinks(actual);
        }
    }

    public void assertSameAndExpectActualHasUri(T actualT, T expectedT) {
        this.assertSameAndExpectActualHasUri(actualT, expectedT, true);
    }

    public void assertSameAndExpectActualHasUri(T actualT, T expectedT, boolean actualMustHaveSearchLinks) {
        this.assertSame(actualT, expectedT, new CommonTest.ComparePrecision(true, true, true, actualMustHaveSearchLinks, true), CommonTest.ComparePrecision.ID_ONLY);
    }

    public void assertSameButIgnoreUri(T actualT, T expectedT) {
        this.assertSame(actualT, expectedT, new CommonTest.ComparePrecision(true, true, false, false, true), CommonTest.ComparePrecision.ID_ONLY);
    }

    @Override
    public String toString() {
        return "" + this.objectClass.getSimpleName() + " test objects";
    }
}

