/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.util.jsonld.test;

import be.iminds.ilabt.util.jsonld.iface.JsonLdObject;
import be.iminds.ilabt.util.jsonld.iface.JsonLdObjectWithId;
import be.iminds.ilabt.util.jsonld.test.BasicObjectTestCollection;
import be.iminds.ilabt.util.jsonld.test.ObjectWithIdTestCollection;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfoList;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class TestCollectionIndex {
    private static TestCollectionIndex instance;
    private final Map<Class, Class<? extends BasicObjectTestCollection>> basicTestCollections = new HashMap<Class, Class<? extends BasicObjectTestCollection>>();
    private final Map<Class, Class<? extends ObjectWithIdTestCollection>> objectWithIdTestCollections = new HashMap<Class, Class<? extends ObjectWithIdTestCollection>>();

    public static TestCollectionIndex get() {
        if (instance == null) {
            instance = new TestCollectionIndex();
        }
        return instance;
    }

    private TestCollectionIndex() {
        ClassGraph classGraph = new ClassGraph();
        ClassInfoList scannedBasicObjectTestCollection = classGraph.enableClassInfo().scan().getSubclasses(BasicObjectTestCollection.class.getName());
        Set nonAbstractBasicObjectTestCollections = scannedBasicObjectTestCollection.stream().map(classInfo -> {
            try {
                return Class.forName(classInfo.getName());
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                return null;
            }
        }).filter(Objects::nonNull).filter(c -> !c.isInterface()).filter(c -> !Modifier.isAbstract(c.getModifiers())).collect(Collectors.toSet());
        for (Class clazz : nonAbstractBasicObjectTestCollections) {
            ParameterizedType parameterizedType = (ParameterizedType)clazz.getGenericSuperclass();
            Type[] typeArguments = parameterizedType.getActualTypeArguments();
            int genericTypeIndex = ObjectWithIdTestCollection.class.isAssignableFrom(clazz) ? 1 : 0;
            Class typeArgument = (Class)typeArguments[genericTypeIndex];
            assert (JsonLdObject.class.isAssignableFrom(typeArgument)) : "Class \"" + typeArgument.getName() + "\" is does not extend JsonLdObject";
            this.registerBasicObjectTestCollection(typeArgument, clazz);
            if (!ObjectWithIdTestCollection.class.isAssignableFrom(clazz)) continue;
            assert (JsonLdObjectWithId.class.isAssignableFrom(typeArgument)) : "Class \"" + typeArgument.getName() + "\" is does not extend JsonLdObjectWithId";
            this.registerObjectWithIdTestCollection(typeArgument, clazz);
        }
    }

    private void registerBasicObjectTestCollection(Class<? extends JsonLdObject> objectClass, Class<? extends BasicObjectTestCollection> testCollectionClass) {
        this.basicTestCollections.put(objectClass, testCollectionClass);
    }

    private void registerObjectWithIdTestCollection(Class<? extends JsonLdObjectWithId> objectClass, Class<? extends ObjectWithIdTestCollection> testCollectionClass) {
        this.objectWithIdTestCollections.put(objectClass, testCollectionClass);
    }

    public List<Class<? extends BasicObjectTestCollection>> getAllTestCollectionClasses() {
        ArrayList<Class<? extends BasicObjectTestCollection>> res = new ArrayList<Class<? extends BasicObjectTestCollection>>(this.basicTestCollections.size() + this.objectWithIdTestCollections.size());
        res.addAll(this.basicTestCollections.values());
        res.addAll(this.objectWithIdTestCollections.values());
        return res;
    }

    public List<Class<? extends ObjectWithIdTestCollection>> getObjectWithIdTestCollectionClasses() {
        ArrayList<Class<? extends ObjectWithIdTestCollection>> res = new ArrayList<Class<? extends ObjectWithIdTestCollection>>(this.objectWithIdTestCollections.size());
        res.addAll(this.objectWithIdTestCollections.values());
        return res;
    }

    public List<BasicObjectTestCollection> getAllTestCollections() {
        List<Class<? extends BasicObjectTestCollection>> classes = this.getAllTestCollectionClasses();
        ArrayList<BasicObjectTestCollection> res = new ArrayList<BasicObjectTestCollection>(classes.size());
        for (Class<? extends BasicObjectTestCollection> clazz : classes) {
            try {
                res.add(clazz.newInstance());
            }
            catch (InstantiationException e) {
                throw new RuntimeException("TestCollection must have constructor without parameters.", e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("TestCollection must have public constructor without parameters.", e);
            }
        }
        return res;
    }

    public List<ObjectWithIdTestCollection> getObjectWithIdTestCollections() {
        List<Class<? extends ObjectWithIdTestCollection>> classes = this.getObjectWithIdTestCollectionClasses();
        ArrayList<ObjectWithIdTestCollection> res = new ArrayList<ObjectWithIdTestCollection>(classes.size());
        for (Class<? extends ObjectWithIdTestCollection> clazz : classes) {
            try {
                res.add(clazz.newInstance());
            }
            catch (InstantiationException e) {
                throw new RuntimeException("TestCollection must have constructor without parameters.", e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("TestCollection must have public constructor without parameters.", e);
            }
        }
        return res;
    }

    public BasicObjectTestCollection getCollectionByObjectClass(@Nonnull Class<? extends JsonLdObject> objectClass) {
        try {
            Class<? extends BasicObjectTestCollection> res = this.basicTestCollections.get(objectClass);
            if (res != null) {
                return res.newInstance();
            }
            res = this.objectWithIdTestCollections.get(objectClass);
            if (res != null) {
                return res.newInstance();
            }
        }
        catch (InstantiationException e) {
            throw new RuntimeException("TestCollection must have constructor without parameters.", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("TestCollection must have public constructor without parameters.", e);
        }
        throw new RuntimeException("No BasicObjectTestCollection or ObjectWithIdTestCollection registered for " + objectClass.getName());
    }

    public ObjectWithIdTestCollection getCollectionByObjectWithIdTestCollectionClass(@Nonnull Class<? extends JsonLdObjectWithId> objectClass) {
        try {
            Class<? extends ObjectWithIdTestCollection> res = this.objectWithIdTestCollections.get(objectClass);
            if (res != null) {
                return res.newInstance();
            }
        }
        catch (InstantiationException e) {
            throw new RuntimeException("TestCollection must have constructor without parameters.", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("TestCollection must have public constructor without parameters.", e);
        }
        throw new RuntimeException("No ObjectWithIdTestCollection registered for " + objectClass.getName());
    }
}

