/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jersey.validation;

import com.google.common.collect.ImmutableList;
import io.dropwizard.jersey.validation.JerseyViolationException;
import io.dropwizard.validation.ConstraintViolations;
import io.dropwizard.validation.Validated;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.Validator;
import javax.validation.executable.ExecutableValidator;
import javax.validation.groups.Default;
import javax.validation.metadata.BeanDescriptor;
import javax.ws.rs.WebApplicationException;
import org.glassfish.jersey.server.internal.inject.ConfiguredValidator;
import org.glassfish.jersey.server.model.Invocable;
import org.glassfish.jersey.server.model.Parameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DropwizardConfiguredValidator
implements ConfiguredValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger(DropwizardConfiguredValidator.class);
    private final Validator validator;

    public DropwizardConfiguredValidator(Validator validator) {
        this.validator = Objects.requireNonNull(validator);
    }

    public void validateResourceAndInputParams(Object resource, Invocable invocable, Object[] objects) throws ConstraintViolationException {
        Class[] groups = this.getGroup(invocable);
        HashSet<ConstraintViolation<Object>> violations = new HashSet<ConstraintViolation<Object>>();
        BeanDescriptor beanDescriptor = this.getConstraintsForClass(resource.getClass());
        if (beanDescriptor.isBeanConstrained()) {
            violations.addAll(this.validate(resource, groups));
        }
        violations.addAll(this.forExecutables().validateParameters(resource, invocable.getHandlingMethod(), objects, groups));
        if (!violations.isEmpty()) {
            throw new JerseyViolationException(violations, invocable);
        }
    }

    private Class<?>[] getGroup(Invocable invocable) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Parameter parameter : invocable.getParameters()) {
            if (!parameter.isAnnotationPresent(Validated.class)) continue;
            builder.add((Object)((Validated)parameter.getAnnotation(Validated.class)).value());
        }
        ImmutableList groups = builder.build();
        switch (groups.size()) {
            case 0: {
                return new Class[]{Default.class};
            }
            case 1: {
                return (Class[])groups.get(0);
            }
        }
        for (int i = 0; i < groups.size(); ++i) {
            for (int j = i; j < groups.size(); ++j) {
                if (Arrays.deepEquals((Object[])groups.get(i), (Object[])groups.get(j))) continue;
                throw new WebApplicationException("Parameters must have the same validation groups in " + invocable.getHandlingMethod().getName(), 500);
            }
        }
        return (Class[])groups.get(0);
    }

    public void validateResult(Object resource, Invocable invocable, Object returnValue) throws ConstraintViolationException {
        Class[] groups = invocable.getHandlingMethod().isAnnotationPresent(Validated.class) ? invocable.getHandlingMethod().getAnnotation(Validated.class).value() : new Class[]{Default.class};
        Set violations = this.forExecutables().validateReturnValue(resource, invocable.getHandlingMethod(), returnValue, groups);
        if (!violations.isEmpty()) {
            LOGGER.trace("Response validation failed: {}", (Object)ConstraintViolations.copyOf((Set)violations));
            throw new JerseyViolationException(violations, invocable);
        }
    }

    public <T> Set<ConstraintViolation<T>> validate(T t, Class<?> ... classes) {
        return this.validator.validate(t, (Class[])classes);
    }

    public <T> Set<ConstraintViolation<T>> validateProperty(T t, String s, Class<?> ... classes) {
        return this.validator.validateProperty(t, s, (Class[])classes);
    }

    public <T> Set<ConstraintViolation<T>> validateValue(Class<T> aClass, String s, Object o, Class<?> ... classes) {
        return this.validator.validateValue(aClass, s, o, (Class[])classes);
    }

    public BeanDescriptor getConstraintsForClass(Class<?> aClass) {
        return this.validator.getConstraintsForClass(aClass);
    }

    public <T> T unwrap(Class<T> aClass) {
        return (T)this.validator.unwrap(aClass);
    }

    public ExecutableValidator forExecutables() {
        return this.validator.forExecutables();
    }
}

